# 鱼答答 - AI 答题应用平台

> 作者：程序员鱼皮
>
> [鱼皮原创项目教程系列](https://yuyuanweb.feishu.cn/wiki/SePYwTc9tipQiCktw7Uc7kujnCd)



## 一、项目介绍

鱼答答是一款基于 Vue 3 + Spring Boot + Redis + ChatGLM + RxJava + SSE 的 **AI 答题应用平台。**

用户可以基于 AI 快速制作并发布答题应用，支持检索、分享、在线答题并基于 AI 得到回答总结；管理员可以集中管理和审核应用。

什么是答题应用？

我相信很多同学都做过 MBTI 性格测试，相当于一份试卷里有很多道题目，大家根据题目选择选项，最终提交答案并得到性格分析结果。

在本项目中，鱼皮不仅会带大家实现一个类似 `MBTI 性格测评的答题小程序`。

还会再上升一个层次，开发 `答题应用平台`，所有人都可以在平台上制作发布自己的答题应用，畅玩别人的答题应用。

比如，你可以创建一个 “小黑子测试应用”，出几道题目，让大家测试下自己是否是小黑子？

![img](https://pic.yupi.icu/1/1713962349992-3910c162-9a14-4aa7-9cdc-ce3c621a1386-20240507222110791.png)



这还不够！鱼皮还会带大家实战最流行的 AI 应用开发，打造 `AI 答题应用平台`。用户可以基于 AI 快速创建答题应用、并基于 AI 分析总结用户的答案。

![img](https://pic.yupi.icu/1/1713961698234-1fdc8ae6-7a0d-448c-b18c-8ed9c3ba8536-20240507222110844.png)



在这个项目中，鱼皮还会带大家用 AI 工具 `CodeGeeX 智能编程助手` 提高开发效率，是不是已经迫不及待了呢？ 



### 项目三大阶段

该项目选题新颖、业务真实完整，为了帮大家循序渐进地学习，鱼皮将项目设计为三个阶段：

1）第一阶段，开发本地的 `MBTI 性格测试小程序`。带大家熟悉答题应用的开发流程，实战跨端小程序开发。

2）第二阶段，上升一个层次，开发 `答题应用平台`。用户可以通过上传题目和自定义打分规则，创建答题应用，供其他用户使用。该阶段涉及前后端全栈项目从 0 到 1 的开发。

3）第三阶段，让 AI 为平台赋能，做一个 `AI 智能答题应用平台`。用户只需设定主题，就能通过 AI 生成题目、用 AI 分析用户答案，极大降低创建答题应用的成本。



## 二、项目优势

### 1、为什么要带做这样一个项目？

1）**业务真实新颖**：别人做答题应用，你做 AI 应用平台。需求实用价值更高，可以扩展出很多新奇有趣的热门应用。

2）**技术主流新颖**：基于企业主流前后端技术实现，再结合当下最热门的 AI 技术，比传统项目更有亮点。

3）**能学到东西**：不再是增删改查的项目，而是包含了大量的实际业务场景、系统设计优化、企业级解决方案。

4）**教程资料少**：市面上虽然有 AI 应用平台，但几乎没有从 0 到 1 的实战教程，鱼皮将提供细致入微的讲解。

5）**增加竞争力**：区别于各种管理平台项目，本项目涉及响应式编程、分库分表、设计模式、性能及稳定性优化的实战，给你的简历增加竞争力。



### 2、项目收获

鱼皮给大家讲的都是 **通用的项目开发方法和架构设计套路**，从这个项目中你可以学到：

- 如何拆解复杂业务，从 0 开始设计实现系统？
- 如何快速开发小程序、响应式网站和后端项目？
- 如何巧用 JSON 实现复杂评分策略？
- 如何巧妙利用设计模式来优化代码？
- 如何利用 AI 工具 `CodeGeeX 智能编程助手` 提高开发效率？
- 如何利用 SSE 技术实时推送通知？
- 如何利用 Redis + Caffeine + 分布式锁实现稳定高效的缓存？
- 如何使用 RxJava 多线程提升服务性能？
- 如何实现业务的幂等性保证？
- 如何运用分库分表优化系统？



此外，还能学会很多作图、思考问题、对比方案的方法，提升排查问题、自主解决 Bug 的能力。



### 3、鱼皮系列项目优势

鱼皮原创项目系列以 **实战** 为主，用 **全程直播** 的方式，**从 0 到 1** 带大家学习技术知识，并立即实践运用到项目中，做到学以致用。

此外，还提供如下服务：

- 详细的直播笔记
- 完整的项目源码
- 答疑解惑
- 专属项目交流群
- ⭐️ 现成的简历写法（直接写满简历）
- ⭐️ 项目的扩展思路（拉开和其他人的差距）
- ⭐️ 项目相关面试题、题解和真实面经（提前准备，面试不懵逼）
- ⭐️ 前端 + Java 后端万用项目模板（快速创建项目）



比起看网上的教程学习，鱼皮项目系列的优势：

> 从学知识 => 实践项目 => 复习笔记 => 项目答疑 => 简历写法 => 面试题解的一条龙服务

从需求分析、技术选型、项目设计、项目初始化、Demo 编写、前后端开发实现、项目优化、部署上线等，每个环节我都 **从理论到实践** 给大家讲的明明白白、每个细节都不放过！

| 对比维度 | 跟学鱼皮项目                                                 | 自学网上免费项目                                             | ⭐️ 鱼皮项目优势               |
| -------- | ------------------------------------------------------------ | ------------------------------------------------------------ | ---------------------------- |
| 项目选题 | ✅ 选题新颖，刻意避开网上热门项目                             | 传统项目场景（博客、商城、管理系统）                         | 增加区分度，提高简历通过率   |
| 学习人数 | ✅ 少，不容易撞车                                             | 百万以上，烂大街                                             | 增加区分度，提高简历通过率   |
| 教学方式 | ✅ 全程直播，带你敲每一行代码、带你踩坑和解决 Bug，不漏过每一个细节 | 录制课程，视频虽然看起来简短、一帆风顺，但你遇到错误无从下手 | 降低学习门槛，减少学习时长   |
| 直播笔记 | ✅ 详细的官方笔记 + 精选学员优质笔记                          | 有笔记，但未经筛选                                           | 学到更多知识细节             |
| 视频内容 | ✅ 项目教程 + 经验分享                                        | 项目教程                                                     | 学到更多编程经验             |
| 项目源码 | ✅ 完整源码仓库 + 每章的提交记录 + 定期更新                   | 只有代码包、不更新                                           | 节省时间，避免踩坑           |
| 项目答疑 | ✅ 各项目交流群 + 答疑解惑 + 常见问题整理                     | 无免费的答疑服务，遇到问题自行解决                           | 节省时间                     |
| 简历写法 | ✅ 现成的简历写法                                             | 无                                                           | 节省时间、提高简历通过率     |
| 项目扩展 | ✅ 给出扩展思路 + 学员作品共享                                | 无                                                           | 开拓思路、拉开和其他人的差距 |
| 项目面试 | ✅ 项目相关面试题、题解和真实面经                             | 无                                                           | 提前准备，面试不懵逼         |



编程导航已有 **10 多套项目教程！**每个项目的学习重点不同，几乎全都是前端 + 后端的 **全栈项目** 。

详细请见：https://yuyuanweb.feishu.cn/wiki/SePYwTc9tipQiCktw7Uc7kujnCd



### 加入项目学习

欢迎 [点此加入编程导航](https://yuyuanweb.feishu.cn/wiki/SDtMwjR1DituVpkz5MLc3fZLnzb) ，学习大量优质原创项目，享受更多原创资料，开启你的编程起飞之旅~



## 三、核心业务流程

如下图：

![](https://pic.yupi.icu/1/yuque_diagram%20(1).jpg)



时序图：

![img](https://pic.yupi.icu/1/1714045657446-df879936-070e-4528-9025-b7ca7f680910.jpeg)



## 四、项目功能梳理

### 小程序

- 在线答题



### 平台

- 用户模块

- - 注册
  - 登录
  - 管理用户 - 增删改查（仅管理员可用）

- 应用模块

- - 创建应用（名称、描述、上传图片、应用类型）
  - 修改应用（用户）
  - 审核发布和下架应用（管理员）
  - 管理应用 - 增删改查（管理员）
  - 应用分享（扫码查看）

- 题目模块

- - 创建题目（名称、选项）
  - 修改题目
  - 删除题目
  - AI 生成题目

- 评分模块

- - 多种评分策略
  - 创建评分结果
  - 题目得分设置

- 回答模块

- - 提交选择
  - 回答记录
  - AI 分析总结回答

- 统计分析模块

- - 应用评分结果分析



## 技术选型

### 开发工具

- 前端 IDE：JetBrains WebStorm
- 后端 IDE：JetBrains IDEA
- [CodeGeeX 智能编程助手](https://codegeex.cn/)



### 前端

#### Web 网页开发

- Vue 3 
- Vue-CLI 脚手架
- Pinia 状态管理
- Axios 请求库
- Arco Design 组件库
- 前端工程化：ESLint + Prettier + TypeScript
- 富文本编辑器
- QRCode.js 二维码生成
- ⭐️ OpenAPI 前端代码生成



#### 小程序开发

- React
- Taro 跨端开发框架
- Taro UI 组件库



### 后端

- Java Spring Boot 开发框架（万用后端模板）
- 存储层：MySQL 数据库 + Redis 缓存 + 腾讯云 COS 对象存储
- MyBatis-Plus 及 MyBatis X 自动生成
- Redission 分布式锁
- Caffeine 本地缓存
- ⭐️ 基于 ChatGLM 大模型实现 AI 能力
- ⭐️ RxJava 响应式框架 + 多线程 / 线程池实战 
- ⭐️ Shardingsphere 分库分表 + 分布式 ID 雪花算法
- ⭐️ SSE 服务端推送
- ⭐️ 多种设计模式
- ⭐️ 多角度项目优化：性能、稳定性、幂等性优化等



## 架构设计

![](https://pic.yupi.icu/1/1714039839444-2a32cd7e-6a9b-4b06-98b1-e22af6ef7574-20240507222443038.png)



### 加入项目学习

欢迎 [点此加入编程导航](https://yuyuanweb.feishu.cn/wiki/SDtMwjR1DituVpkz5MLc3fZLnzb) ，学习大量优质原创项目，享受更多原创资料，开启你的编程起飞之旅~
