# 鱼皮前端万用模板

> 作者：[程序员鱼皮](https://github.com/liyupi)
> 仅分享于 [编程导航知识星球](https://yupi.icu)

基于 React + Ant Design 的项目初始模板，整合了常用框架和主流业务的示例代码。

只需 1 分钟 即可完成网站的基础前端！！！大家还可以在此基础上快速开发自己的项目。

[TOC]

## 模板特点

### 主流框架 & 特性

+ Ant Design Pro 6.0.0
+ React 18.2.0
+ node 至少 16 版本及以上
+ antd 5.2.2
+ Type Script
+ 动态路由
+ Eslint
+ Prettier

### Ant Design Pro 架构

#### Umi

+ Node.js 前端开发基础环境
+ webpack 前端必学必会的打包工具
+ react-router 路由库
+ proxy 反向代理工具
+ dva 轻量级的应用框架
+ fabric 严格但是不严苛的 lint 规则集（eslint、stylelint、prettier)
+ Type Script 带类型的 JavaScript

#### Ant Design 前端组件库

#### Ant Design Chart 简单好用的React 图表库

#### ProComponents 模板组件

+ ProLayout - 提供开箱即用的菜单和面包屑功能
+ ProForm - 表单模板组件，预设常见布局和行为
+ ProTable - 表格模板组件，抽象网格请求和单元格样式
+ ProCard - 提供卡片切分以及栅格布局能力

#### umi 插件

+ 内置布局
+ 国际化
+ 权限
+ 数据流

### 业务特性

+ 栅格布局（可自定义，可适应）
+ 简单权限管理 
+ 全局初始数据（ getInitialState )
+ 默认使用 less 作为样式语言
+ OpenAPI 自动生成后端请求代码
+ 统一错误处理

## 业务功能

+ 提供 OpenAPI 后端接口自动生成
+ 用户登录、用户注册
+ 管理员修改用户、新建用户、查询用户、删除用户
+ 动态路由展示（权限管理）

## 快速上手

1）先启动后端的万用模板

2）使用命令生成后端请求代码

3）将标题和 logo 等切换为个人

4）测试业务功能

具体万用模板教程：[前端万用模板使用教程 (yuque.com)](https://bcdh.yuque.com/staff-wpxfif/resource/rnv6shm2l57rsx6x) 

