/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.filter;

import com.alibaba.otter.canal.connector.core.filter.RegexFunction;
import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.runtime.type.AviatorFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class AviaterRegexFilter {
    private static final String SPLIT = ",";
    private static final String PATTERN_SPLIT = "|";
    private static final String FILTER_EXPRESSION = "regex(pattern,target)";
    private static final RegexFunction regexFunction = new RegexFunction();
    private final Expression exp = AviatorEvaluator.compile((String)"regex(pattern,target)", (boolean)true);
    private static final Comparator<String> COMPARATOR;
    private final String pattern;
    private final boolean defaultEmptyValue;

    public AviaterRegexFilter(String pattern) {
        this(pattern, true);
    }

    public AviaterRegexFilter(String pattern, boolean defaultEmptyValue) {
        this.defaultEmptyValue = defaultEmptyValue;
        List<String> list = null;
        if (StringUtils.isEmpty((String)pattern)) {
            list = new ArrayList<String>();
        } else {
            String[] ss = StringUtils.split((String)pattern, (String)SPLIT);
            list = Arrays.asList(ss);
        }
        list.sort(COMPARATOR);
        list = this.completionPattern(list);
        this.pattern = StringUtils.join(list, (String)PATTERN_SPLIT);
    }

    public boolean filter(String filtered) {
        if (StringUtils.isEmpty((String)this.pattern)) {
            return this.defaultEmptyValue;
        }
        if (StringUtils.isEmpty((String)filtered)) {
            return this.defaultEmptyValue;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("pattern", this.pattern);
        env.put("target", filtered.toLowerCase());
        return (Boolean)this.exp.execute(env);
    }

    private List<String> completionPattern(List<String> patterns) {
        ArrayList<String> result = new ArrayList<String>();
        for (String pattern : patterns) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("^");
            stringBuffer.append(pattern);
            stringBuffer.append("$");
            result.add(stringBuffer.toString());
        }
        return result;
    }

    public String toString() {
        return this.pattern;
    }

    static {
        AviatorEvaluator.addFunction((AviatorFunction)regexFunction);
        COMPARATOR = new StringComparator();
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String str1, String str2) {
            return Integer.compare(str2.length(), str1.length());
        }
    }
}

