/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.core.producer;

import com.alibaba.otter.canal.common.utils.ExecutorTemplate;
import com.alibaba.otter.canal.connector.core.filter.AviaterRegexFilter;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.FlatMessage;
import com.alibaba.otter.canal.protocol.Message;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.MigrateMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang.StringUtils;

public class MQMessageUtils {
    private static Map<String, List<PartitionData>> partitionDatas = MigrateMap.makeComputingMap((CacheBuilder)CacheBuilder.newBuilder().softValues(), pkHashConfigs -> {
        String[] pkHashConfigArray;
        ArrayList<PartitionData> datas = new ArrayList<PartitionData>();
        for (String pkHashConfig : pkHashConfigArray = StringUtils.split((String)StringUtils.replace((String)pkHashConfigs, (String)",", (String)";"), (String)";")) {
            PartitionData data = new PartitionData();
            int i = pkHashConfig.lastIndexOf(":");
            if (i > 0) {
                String pkStr = pkHashConfig.substring(i + 1);
                if (pkStr.equalsIgnoreCase("$pk$")) {
                    data.hashMode.autoPkHash = true;
                } else {
                    data.hashMode.pkNames = Lists.newArrayList((Object[])StringUtils.split((String)pkStr, (char)'^'));
                }
                pkHashConfig = pkHashConfig.substring(0, i);
            } else {
                data.hashMode.tableHash = true;
            }
            if (!MQMessageUtils.isWildCard(pkHashConfig)) {
                data.simpleName = pkHashConfig;
            } else {
                data.regexFilter = new AviaterRegexFilter(pkHashConfig);
            }
            datas.add(data);
        }
        return datas;
    });
    private static Map<String, List<DynamicTopicData>> dynamicTopicDatas = MigrateMap.makeComputingMap((CacheBuilder)CacheBuilder.newBuilder().softValues(), pkHashConfigs -> {
        String[] dynamicTopicArray;
        ArrayList<DynamicTopicData> datas = new ArrayList<DynamicTopicData>();
        for (String dynamicTopic : dynamicTopicArray = StringUtils.split((String)StringUtils.replace((String)pkHashConfigs, (String)",", (String)";"), (String)";")) {
            DynamicTopicData data = new DynamicTopicData();
            if (!MQMessageUtils.isWildCard(dynamicTopic)) {
                data.simpleName = dynamicTopic;
            } else if (dynamicTopic.contains("\\.")) {
                data.tableRegexFilter = new AviaterRegexFilter(dynamicTopic);
            } else {
                data.schemaRegexFilter = new AviaterRegexFilter(dynamicTopic);
            }
            datas.add(data);
        }
        return datas;
    });
    private static Map<String, List<TopicPartitionData>> topicPartitionDatas = MigrateMap.makeComputingMap((CacheBuilder)CacheBuilder.newBuilder().softValues(), tPConfigs -> {
        String[] tPArray;
        ArrayList<TopicPartitionData> datas = new ArrayList<TopicPartitionData>();
        for (String tPConfig : tPArray = StringUtils.split((String)StringUtils.replace((String)tPConfigs, (String)",", (String)";"), (String)";")) {
            TopicPartitionData data = new TopicPartitionData();
            int i = tPConfig.lastIndexOf(":");
            if (i <= 0) continue;
            String tStr = tPConfig.substring(0, i);
            String pStr = tPConfig.substring(i + 1);
            if (!MQMessageUtils.isWildCard(tStr)) {
                data.simpleName = tStr;
            } else {
                data.regexFilter = new AviaterRegexFilter(tStr);
            }
            if (!StringUtils.isEmpty((String)pStr) && StringUtils.isNumeric((String)pStr)) {
                data.partitionNum = Integer.valueOf(pStr);
            }
            datas.add(data);
        }
        return datas;
    });

    public static Map<String, Message> messageTopics(Message message, String defaultTopic, String dynamicTopicConfigs) {
        ArrayList<CanalEntry.Entry> entries;
        if (message.isRaw()) {
            List rawEntries = message.getRawEntries();
            entries = new ArrayList<CanalEntry.Entry>(rawEntries.size());
            for (ByteString byteString : rawEntries) {
                CanalEntry.Entry entry;
                try {
                    entry = CanalEntry.Entry.parseFrom((ByteString)byteString);
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
                entries.add(entry);
            }
        } else {
            entries = message.getEntries();
        }
        HashMap<String, Message> messages = new HashMap<String, Message>();
        for (CanalEntry.Entry entry : entries) {
            if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) continue;
            String schemaName = entry.getHeader().getSchemaName();
            String tableName = entry.getHeader().getTableName();
            if (StringUtils.isEmpty((String)schemaName) || StringUtils.isEmpty((String)tableName)) {
                MQMessageUtils.put2MapMessage(messages, message.getId(), defaultTopic, entry);
                continue;
            }
            Set<String> topics = MQMessageUtils.matchTopics(schemaName + "." + tableName, dynamicTopicConfigs);
            if (topics != null) {
                for (String topic : topics) {
                    MQMessageUtils.put2MapMessage(messages, message.getId(), topic, entry);
                }
                continue;
            }
            topics = MQMessageUtils.matchTopics(schemaName, dynamicTopicConfigs);
            if (topics != null) {
                for (String topic : topics) {
                    MQMessageUtils.put2MapMessage(messages, message.getId(), topic, entry);
                }
                continue;
            }
            MQMessageUtils.put2MapMessage(messages, message.getId(), defaultTopic, entry);
        }
        return messages;
    }

    public static EntryRowData[] buildMessageData(Message message, ThreadPoolExecutor executor) {
        ExecutorTemplate template = new ExecutorTemplate(executor);
        if (message.isRaw()) {
            List rawEntries = message.getRawEntries();
            EntryRowData[] datas = new EntryRowData[rawEntries.size()];
            int i = 0;
            for (ByteString byteString : rawEntries) {
                int index = i++;
                template.submit(() -> {
                    try {
                        CanalEntry.Entry entry = CanalEntry.Entry.parseFrom((ByteString)byteString);
                        CanalEntry.RowChange rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
                        datas[index] = new EntryRowData();
                        datas[index].entry = entry;
                        datas[index].rowChange = rowChange;
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            template.waitForResult();
            return datas;
        }
        EntryRowData[] datas = new EntryRowData[message.getEntries().size()];
        int i = 0;
        for (CanalEntry.Entry entry : message.getEntries()) {
            int index = i++;
            template.submit(() -> {
                try {
                    CanalEntry.RowChange rowChange = CanalEntry.RowChange.parseFrom((ByteString)entry.getStoreValue());
                    datas[index] = new EntryRowData();
                    datas[index].entry = entry;
                    datas[index].rowChange = rowChange;
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        template.waitForResult();
        return datas;
    }

    public static Message[] messagePartition(EntryRowData[] datas, long id, Integer partitionsNum, String pkHashConfigs, boolean databaseHash) {
        if (partitionsNum == null) {
            partitionsNum = 1;
        }
        Message[] partitionMessages = new Message[partitionsNum.intValue()];
        List[] partitionEntries = new List[partitionsNum.intValue()];
        for (int i = 0; i < partitionsNum; ++i) {
            partitionEntries[i] = Collections.synchronizedList(new ArrayList());
        }
        for (EntryRowData data : datas) {
            CanalEntry.Entry entry = data.entry;
            CanalEntry.RowChange rowChange = data.rowChange;
            if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) continue;
            if (rowChange.getIsDdl()) {
                partitionEntries[0].add(entry);
                continue;
            }
            if (rowChange.getRowDatasList() != null && !rowChange.getRowDatasList().isEmpty()) {
                String database = entry.getHeader().getSchemaName();
                String table = entry.getHeader().getTableName();
                HashMode hashMode = MQMessageUtils.getPartitionHashColumns(database + "." + table, pkHashConfigs);
                if (hashMode == null) {
                    partitionEntries[0].add(entry);
                    continue;
                }
                if (hashMode.tableHash) {
                    int hashCode = table.hashCode();
                    int pkHash = Math.abs(hashCode) % partitionsNum;
                    pkHash = Math.abs(pkHash);
                    partitionEntries[pkHash].add(entry);
                    continue;
                }
                CanalEntry.Entry.Builder builder = CanalEntry.Entry.newBuilder((CanalEntry.Entry)entry);
                CanalEntry.RowChange.Builder rowChangeBuilder = CanalEntry.RowChange.newBuilder((CanalEntry.RowChange)rowChange);
                for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                    int hashCode = 0;
                    if (databaseHash) {
                        hashCode = database.hashCode();
                    }
                    CanalEntry.EventType eventType = rowChange.getEventType();
                    List columns = null;
                    columns = eventType == CanalEntry.EventType.DELETE ? rowData.getBeforeColumnsList() : rowData.getAfterColumnsList();
                    if (hashMode.autoPkHash) {
                        for (CanalEntry.Column column : columns) {
                            if (!column.getIsKey()) continue;
                            hashCode ^= column.getValue().hashCode();
                        }
                    } else {
                        for (CanalEntry.Column column : columns) {
                            if (!MQMessageUtils.checkPkNamesHasContain(hashMode.pkNames, column.getName())) continue;
                            hashCode ^= column.getValue().hashCode();
                        }
                    }
                    int pkHash = Math.abs(hashCode) % partitionsNum;
                    pkHash = Math.abs(pkHash);
                    rowChangeBuilder.clearRowDatas();
                    rowChangeBuilder.addRowDatas(rowData);
                    builder.clearStoreValue();
                    builder.setStoreValue(rowChangeBuilder.build().toByteString());
                    partitionEntries[pkHash].add(builder.build());
                }
                continue;
            }
            partitionEntries[0].add(entry);
        }
        for (int i = 0; i < partitionsNum; ++i) {
            List entriesTmp = partitionEntries[i];
            if (entriesTmp.isEmpty()) continue;
            partitionMessages[i] = new Message(id, entriesTmp);
        }
        return partitionMessages;
    }

    public static List<FlatMessage> messageConverter(EntryRowData[] datas, long id) {
        ArrayList<FlatMessage> flatMessages = new ArrayList<FlatMessage>();
        for (EntryRowData entryRowData : datas) {
            CanalEntry.Entry entry = entryRowData.entry;
            CanalEntry.RowChange rowChange = entryRowData.rowChange;
            if (entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONBEGIN || entry.getEntryType() == CanalEntry.EntryType.TRANSACTIONEND) continue;
            CanalEntry.EventType eventType = rowChange.getEventType();
            FlatMessage flatMessage = new FlatMessage(id);
            flatMessages.add(flatMessage);
            flatMessage.setDatabase(entry.getHeader().getSchemaName());
            flatMessage.setTable(entry.getHeader().getTableName());
            flatMessage.setIsDdl(Boolean.valueOf(rowChange.getIsDdl()));
            flatMessage.setType(eventType.toString());
            flatMessage.setEs(Long.valueOf(entry.getHeader().getExecuteTime()));
            flatMessage.setTs(Long.valueOf(System.currentTimeMillis()));
            flatMessage.setSql(rowChange.getSql());
            if (rowChange.getIsDdl()) continue;
            LinkedHashMap<String, Integer> sqlType = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, String> mysqlType = new LinkedHashMap<String, String>();
            ArrayList data = new ArrayList();
            ArrayList old = new ArrayList();
            HashSet<String> updateSet = new HashSet<String>();
            boolean hasInitPkNames = false;
            for (CanalEntry.RowData rowData : rowChange.getRowDatasList()) {
                if (eventType != CanalEntry.EventType.INSERT && eventType != CanalEntry.EventType.UPDATE && eventType != CanalEntry.EventType.DELETE) continue;
                LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
                List columns = eventType == CanalEntry.EventType.DELETE ? rowData.getBeforeColumnsList() : rowData.getAfterColumnsList();
                for (CanalEntry.Column column : columns) {
                    if (!hasInitPkNames && column.getIsKey()) {
                        flatMessage.addPkName(column.getName());
                    }
                    sqlType.put(column.getName(), column.getSqlType());
                    mysqlType.put(column.getName(), column.getMysqlType());
                    if (column.getIsNull()) {
                        row.put(column.getName(), null);
                    } else {
                        row.put(column.getName(), column.getValue());
                    }
                    if (!column.getUpdated()) continue;
                    updateSet.add(column.getName());
                }
                hasInitPkNames = true;
                if (!row.isEmpty()) {
                    data.add(row);
                }
                if (eventType != CanalEntry.EventType.UPDATE) continue;
                LinkedHashMap<String, String> rowOld = new LinkedHashMap<String, String>();
                for (CanalEntry.Column column : rowData.getBeforeColumnsList()) {
                    if (!updateSet.contains(column.getName())) continue;
                    if (column.getIsNull()) {
                        rowOld.put(column.getName(), null);
                        continue;
                    }
                    rowOld.put(column.getName(), column.getValue());
                }
                if (rowOld.isEmpty()) continue;
                old.add(rowOld);
            }
            if (!sqlType.isEmpty()) {
                flatMessage.setSqlType(sqlType);
            }
            if (!mysqlType.isEmpty()) {
                flatMessage.setMysqlType(mysqlType);
            }
            if (!data.isEmpty()) {
                flatMessage.setData(data);
            }
            if (old.isEmpty()) continue;
            flatMessage.setOld(old);
        }
        return flatMessages;
    }

    public static FlatMessage[] messagePartition(FlatMessage flatMessage, Integer partitionsNum, String pkHashConfigs, boolean databaseHash) {
        if (partitionsNum == null) {
            partitionsNum = 1;
        }
        FlatMessage[] partitionMessages = new FlatMessage[partitionsNum.intValue()];
        if (flatMessage.getIsDdl().booleanValue()) {
            partitionMessages[0] = flatMessage;
        } else if (flatMessage.getData() != null && !flatMessage.getData().isEmpty()) {
            String database = flatMessage.getDatabase();
            String table = flatMessage.getTable();
            HashMode hashMode = MQMessageUtils.getPartitionHashColumns(database + "." + table, pkHashConfigs);
            if (hashMode == null) {
                partitionMessages[0] = flatMessage;
            } else if (hashMode.tableHash) {
                int hashCode = table.hashCode();
                int pkHash = Math.abs(hashCode) % partitionsNum;
                pkHash = Math.abs(pkHash);
                partitionMessages[pkHash] = flatMessage;
            } else {
                List pkNames = hashMode.pkNames;
                if (hashMode.autoPkHash) {
                    pkNames = flatMessage.getPkNames();
                }
                int idx = 0;
                for (Map row : flatMessage.getData()) {
                    ArrayList<Map> data;
                    int hashCode = 0;
                    if (databaseHash) {
                        hashCode = database.hashCode();
                    }
                    if (pkNames != null) {
                        for (String pkName : pkNames) {
                            String value = (String)row.get(pkName);
                            if (value == null) {
                                value = "";
                            }
                            hashCode ^= value.hashCode();
                        }
                    }
                    int pkHash = Math.abs(hashCode) % partitionsNum;
                    FlatMessage flatMessageTmp = partitionMessages[pkHash = Math.abs(pkHash)];
                    if (flatMessageTmp == null) {
                        partitionMessages[pkHash] = flatMessageTmp = new FlatMessage(flatMessage.getId());
                        flatMessageTmp.setDatabase(flatMessage.getDatabase());
                        flatMessageTmp.setTable(flatMessage.getTable());
                        flatMessageTmp.setIsDdl(flatMessage.getIsDdl());
                        flatMessageTmp.setType(flatMessage.getType());
                        flatMessageTmp.setSql(flatMessage.getSql());
                        flatMessageTmp.setSqlType(flatMessage.getSqlType());
                        flatMessageTmp.setMysqlType(flatMessage.getMysqlType());
                        flatMessageTmp.setEs(flatMessage.getEs());
                        flatMessageTmp.setTs(flatMessage.getTs());
                        flatMessageTmp.setPkNames(flatMessage.getPkNames());
                    }
                    if ((data = flatMessageTmp.getData()) == null) {
                        data = new ArrayList<Map>();
                        flatMessageTmp.setData(data);
                    }
                    data.add(row);
                    if (flatMessage.getOld() != null && !flatMessage.getOld().isEmpty()) {
                        ArrayList<Map> old = flatMessageTmp.getOld();
                        if (old == null) {
                            old = new ArrayList<Map>();
                            flatMessageTmp.setOld(old);
                        }
                        old.add((Map)flatMessage.getOld().get(idx));
                    }
                    ++idx;
                }
            }
        } else {
            partitionMessages[0] = flatMessage;
        }
        return partitionMessages;
    }

    public static HashMode getPartitionHashColumns(String name, String pkHashConfigs) {
        if (StringUtils.isEmpty((String)pkHashConfigs)) {
            return null;
        }
        List<PartitionData> datas = partitionDatas.get(pkHashConfigs);
        for (PartitionData data : datas) {
            if (!(data.simpleName != null ? data.simpleName.equalsIgnoreCase(name) : data.regexFilter.filter(name))) continue;
            return data.hashMode;
        }
        return null;
    }

    private static Set<String> matchTopics(String name, String dynamicTopicConfigs) {
        String[] router = StringUtils.split((String)StringUtils.replace((String)dynamicTopicConfigs, (String)",", (String)";"), (String)";");
        HashSet<String> topics = new HashSet<String>();
        for (String item : router) {
            int i = item.indexOf(":");
            if (i > -1) {
                String topic = item.substring(0, i).trim();
                String topicConfigs = item.substring(i + 1).trim();
                if (!MQMessageUtils.matchDynamicTopic(name, topicConfigs)) continue;
                topics.add(topic);
                break;
            }
            if (!MQMessageUtils.matchDynamicTopic(name, item)) continue;
            topics.add(name.toLowerCase());
            break;
        }
        return topics.isEmpty() ? null : topics;
    }

    public static boolean matchDynamicTopic(String name, String dynamicTopicConfigs) {
        if (StringUtils.isEmpty((String)dynamicTopicConfigs)) {
            return false;
        }
        boolean res = false;
        List<DynamicTopicData> datas = dynamicTopicDatas.get(dynamicTopicConfigs);
        for (DynamicTopicData data : datas) {
            if (data.simpleName != null) {
                if (!data.simpleName.equalsIgnoreCase(name)) continue;
                res = true;
                break;
            }
            if (name.contains(".")) {
                if (data.tableRegexFilter == null || !data.tableRegexFilter.filter(name)) continue;
                res = true;
                break;
            }
            if (data.schemaRegexFilter == null || !data.schemaRegexFilter.filter(name)) continue;
            res = true;
            break;
        }
        return res;
    }

    public static boolean checkPkNamesHasContain(List<String> pkNames, String name) {
        for (String pkName : pkNames) {
            if (!pkName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static Integer parseDynamicTopicPartition(String name, String tPConfigs) {
        if (!StringUtils.isEmpty((String)tPConfigs)) {
            List<TopicPartitionData> datas = topicPartitionDatas.get(tPConfigs);
            for (TopicPartitionData data : datas) {
                if (!(data.simpleName != null ? data.simpleName.equalsIgnoreCase(name) : data.regexFilter.filter(name))) continue;
                return data.partitionNum;
            }
        }
        return null;
    }

    private static boolean isWildCard(String value) {
        return StringUtils.containsAny((String)value, (char[])new char[]{'*', '?', '+', '|', '(', ')', '{', '}', '[', ']', '\\', '$', '^'});
    }

    private static void put2MapMessage(Map<String, Message> messageMap, Long messageId, String topicName, CanalEntry.Entry entry) {
        Message message = messageMap.get(topicName);
        if (message == null) {
            message = new Message(messageId.longValue(), new ArrayList());
            messageMap.put(topicName, message);
        }
        message.getEntries().add(entry);
    }

    public static class EntryRowData {
        public CanalEntry.Entry entry;
        public CanalEntry.RowChange rowChange;
    }

    public static class TopicPartitionData {
        public String simpleName;
        public AviaterRegexFilter regexFilter;
        public Integer partitionNum;
    }

    public static class DynamicTopicData {
        public String simpleName;
        public AviaterRegexFilter schemaRegexFilter;
        public AviaterRegexFilter tableRegexFilter;
    }

    public static class HashMode {
        public boolean autoPkHash = false;
        public boolean tableHash = false;
        public List<String> pkNames = new ArrayList<String>();
    }

    public static class PartitionData {
        public String simpleName;
        public AviaterRegexFilter regexFilter;
        public HashMode hashMode = new HashMode();
    }
}

