/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.rocketmq.consumer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.otter.canal.connector.core.consumer.CommonMessage;
import com.alibaba.otter.canal.connector.core.spi.CanalMsgConsumer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.CanalMessageSerializerUtil;
import com.alibaba.otter.canal.connector.core.util.MessageUtil;
import com.alibaba.otter.canal.connector.rocketmq.consumer.ConsumerBatchMessage;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeOrderlyStatus;
import org.apache.rocketmq.client.consumer.rebalance.AllocateMessageQueueAveragely;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(value="rocketmq")
public class CanalRocketMQConsumer
implements CanalMsgConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CanalRocketMQConsumer.class);
    private static final String CLOUD_ACCESS_CHANNEL = "cloud";
    private String nameServer;
    private String topic;
    private String groupName;
    private DefaultMQPushConsumer rocketMQConsumer;
    private BlockingQueue<ConsumerBatchMessage<CommonMessage>> messageBlockingQueue;
    private int batchSize = -1;
    private long batchProcessTimeout = 60000L;
    private boolean flatMessage;
    private volatile ConsumerBatchMessage<CommonMessage> lastGetBatchMessage = null;
    private String accessKey;
    private String secretKey;
    private String customizedTraceTopic;
    private boolean enableMessageTrace = false;
    private String accessChannel;
    private String namespace;
    private String filter = "*";

    public void init(Properties properties, String topic, String groupName) {
        String subscribeFilter;
        this.topic = topic;
        this.groupName = groupName;
        this.flatMessage = (Boolean)properties.get("canal.mq.flatMessage");
        this.messageBlockingQueue = new LinkedBlockingQueue<ConsumerBatchMessage<CommonMessage>>(1024);
        this.accessKey = properties.getProperty("canal.aliyun.accessKey");
        this.secretKey = properties.getProperty("canal.aliyun.secretKey");
        String enableMessageTrace = properties.getProperty("rocketmq.enable.message.trace");
        if (StringUtils.isNotEmpty((String)enableMessageTrace)) {
            this.enableMessageTrace = Boolean.parseBoolean(enableMessageTrace);
        }
        this.customizedTraceTopic = properties.getProperty("rocketmq.customized.trace.topic");
        this.accessChannel = properties.getProperty("rocketmq.access.channel");
        this.namespace = properties.getProperty("rocketmq.namespace");
        this.nameServer = properties.getProperty("rocketmq.namesrv.addr");
        String batchSize = properties.getProperty("rocketmq.batch.size");
        if (StringUtils.isNotEmpty((String)batchSize)) {
            this.batchSize = Integer.parseInt(batchSize);
        }
        if (StringUtils.isNotEmpty((String)(subscribeFilter = properties.getProperty("rocketmq.subscribe.filter")))) {
            this.filter = subscribeFilter;
        }
    }

    public void connect() {
        AclClientRPCHook rpcHook = null;
        if (null != this.accessKey && this.accessKey.length() > 0 && null != this.secretKey && this.secretKey.length() > 0) {
            SessionCredentials sessionCredentials = new SessionCredentials();
            sessionCredentials.setAccessKey(this.accessKey);
            sessionCredentials.setSecretKey(this.secretKey);
            rpcHook = new AclClientRPCHook(sessionCredentials);
        }
        this.rocketMQConsumer = new DefaultMQPushConsumer(this.groupName, rpcHook, new AllocateMessageQueueAveragely(), this.enableMessageTrace, this.customizedTraceTopic);
        this.rocketMQConsumer.setVipChannelEnabled(false);
        if (CLOUD_ACCESS_CHANNEL.equals(this.accessChannel)) {
            this.rocketMQConsumer.setAccessChannel(AccessChannel.CLOUD);
        }
        if (!StringUtils.isEmpty((String)this.namespace)) {
            this.rocketMQConsumer.setNamespace(this.namespace);
        }
        if (!StringUtils.isBlank((String)this.nameServer)) {
            this.rocketMQConsumer.setNamesrvAddr(this.nameServer);
        }
        if (this.batchSize != -1) {
            this.rocketMQConsumer.setConsumeMessageBatchMaxSize(this.batchSize);
        }
        try {
            if (this.rocketMQConsumer == null) {
                this.connect();
            }
            this.rocketMQConsumer.subscribe(this.topic, this.filter);
            this.rocketMQConsumer.registerMessageListener((messageExts, context) -> {
                context.setAutoCommit(true);
                boolean isSuccess = this.process(messageExts);
                if (isSuccess) {
                    return ConsumeOrderlyStatus.SUCCESS;
                }
                return ConsumeOrderlyStatus.SUSPEND_CURRENT_QUEUE_A_MOMENT;
            });
            this.rocketMQConsumer.start();
        }
        catch (MQClientException ex) {
            logger.error("Start RocketMQ consumer error", (Throwable)ex);
        }
    }

    private boolean process(List<MessageExt> messageExts) {
        boolean isCompleted;
        if (logger.isDebugEnabled()) {
            logger.debug("Get Message: {}", messageExts);
        }
        ArrayList<CommonMessage> messageList = new ArrayList<CommonMessage>();
        for (MessageExt messageExt : messageExts) {
            byte[] data = messageExt.getBody();
            if (data != null) {
                try {
                    if (!this.flatMessage) {
                        Message message = CanalMessageSerializerUtil.deserializer((byte[])data);
                        messageList.addAll(MessageUtil.convert((Message)message));
                        continue;
                    }
                    CommonMessage commonMessage = (CommonMessage)JSON.parseObject((byte[])data, CommonMessage.class);
                    messageList.add(commonMessage);
                    continue;
                }
                catch (Exception ex) {
                    logger.error("Add message error", (Throwable)ex);
                    throw new CanalClientException((Throwable)ex);
                }
            }
            logger.warn("Received message data is null");
        }
        ConsumerBatchMessage batchMessage = new ConsumerBatchMessage(messageList);
        try {
            this.messageBlockingQueue.put(batchMessage);
        }
        catch (InterruptedException e) {
            logger.error("Put message to queue error", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            isCompleted = batchMessage.waitFinish(this.batchProcessTimeout);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted when waiting messages to be finished.", (Throwable)e);
            throw new RuntimeException(e);
        }
        boolean isSuccess = batchMessage.isSuccess();
        return isCompleted && isSuccess;
    }

    public List<CommonMessage> getMessage(Long timeout, TimeUnit unit) {
        try {
            if (this.lastGetBatchMessage != null) {
                throw new CanalClientException("mq get/ack not support concurrent & async ack");
            }
            ConsumerBatchMessage<CommonMessage> batchMessage = this.messageBlockingQueue.poll(timeout, unit);
            if (batchMessage != null) {
                this.lastGetBatchMessage = batchMessage;
                return batchMessage.getData();
            }
        }
        catch (InterruptedException ex) {
            logger.warn("Get message timeout", (Throwable)ex);
            throw new CanalClientException("Failed to fetch the data after: " + timeout);
        }
        return null;
    }

    public void rollback() {
        try {
            if (this.lastGetBatchMessage != null) {
                this.lastGetBatchMessage.fail();
            }
        }
        finally {
            this.lastGetBatchMessage = null;
        }
    }

    public void ack() {
        try {
            if (this.lastGetBatchMessage != null) {
                this.lastGetBatchMessage.ack();
            }
        }
        catch (Throwable e) {
            if (this.lastGetBatchMessage != null) {
                this.lastGetBatchMessage.fail();
            }
        }
        finally {
            this.lastGetBatchMessage = null;
        }
    }

    public void disconnect() {
        this.rocketMQConsumer.unsubscribe(this.topic);
        this.rocketMQConsumer.shutdown();
    }
}

