/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.rocketmq.producer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.common.utils.ExecutorTemplate;
import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.alibaba.otter.canal.common.utils.PropertiesUtils;
import com.alibaba.otter.canal.connector.core.producer.AbstractMQProducer;
import com.alibaba.otter.canal.connector.core.producer.MQDestination;
import com.alibaba.otter.canal.connector.core.producer.MQMessageUtils;
import com.alibaba.otter.canal.connector.core.spi.CanalMQProducer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.Callback;
import com.alibaba.otter.canal.connector.core.util.CanalMessageSerializerUtil;
import com.alibaba.otter.canal.connector.rocketmq.config.RocketMQProducerConfig;
import com.alibaba.otter.canal.protocol.FlatMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.rocketmq.acl.common.AclClientRPCHook;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.impl.producer.TopicPublishInfo;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(value="rocketmq")
public class CanalRocketMQProducer
extends AbstractMQProducer
implements CanalMQProducer {
    private static final Logger logger = LoggerFactory.getLogger(CanalRocketMQProducer.class);
    private DefaultMQProducer defaultMQProducer;
    private static final String CLOUD_ACCESS_CHANNEL = "cloud";
    protected ThreadPoolExecutor sendPartitionExecutor;

    public void init(Properties properties) {
        RocketMQProducerConfig rocketMQProperties = new RocketMQProducerConfig();
        this.mqProperties = rocketMQProperties;
        super.init(properties);
        this.loadRocketMQProperties(properties);
        AclClientRPCHook rpcHook = null;
        if (this.mqProperties.getAliyunAccessKey().length() > 0 && this.mqProperties.getAliyunSecretKey().length() > 0) {
            SessionCredentials sessionCredentials = new SessionCredentials();
            sessionCredentials.setAccessKey(this.mqProperties.getAliyunAccessKey());
            sessionCredentials.setSecretKey(this.mqProperties.getAliyunSecretKey());
            rpcHook = new AclClientRPCHook(sessionCredentials);
        }
        this.defaultMQProducer = new DefaultMQProducer(rocketMQProperties.getProducerGroup(), rpcHook, rocketMQProperties.isEnableMessageTrace(), rocketMQProperties.getCustomizedTraceTopic());
        if (CLOUD_ACCESS_CHANNEL.equals(rocketMQProperties.getAccessChannel())) {
            this.defaultMQProducer.setAccessChannel(AccessChannel.CLOUD);
        }
        if (!StringUtils.isEmpty((String)rocketMQProperties.getNamespace())) {
            this.defaultMQProducer.setNamespace(rocketMQProperties.getNamespace());
        }
        this.defaultMQProducer.setNamesrvAddr(rocketMQProperties.getNamesrvAddr());
        this.defaultMQProducer.setRetryTimesWhenSendFailed(rocketMQProperties.getRetryTimesWhenSendFailed());
        this.defaultMQProducer.setVipChannelEnabled(rocketMQProperties.isVipChannelEnabled());
        logger.info("##Start RocketMQ producer##");
        try {
            this.defaultMQProducer.start();
        }
        catch (MQClientException ex) {
            throw new CanalException("Start RocketMQ producer error", (Throwable)ex);
        }
        int parallelPartitionSendThreadSize = this.mqProperties.getParallelSendThreadSize();
        this.sendPartitionExecutor = new ThreadPoolExecutor(parallelPartitionSendThreadSize, parallelPartitionSendThreadSize, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(parallelPartitionSendThreadSize * 2), (ThreadFactory)new NamedThreadFactory("MQ-Parallel-Sender-Partition"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void loadRocketMQProperties(Properties properties) {
        String tag;
        String vipChannelEnabled;
        String retry;
        String namesrvAddr;
        String namespace;
        String customizedTraceTopic;
        String enableMessageTrace;
        RocketMQProducerConfig rocketMQProperties = (RocketMQProducerConfig)this.mqProperties;
        this.doMoreCompatibleConvert("canal.mq.servers", "rocketmq.namesrv.addr", properties);
        this.doMoreCompatibleConvert("canal.mq.producerGroup", "rocketmq.producer.group", properties);
        this.doMoreCompatibleConvert("canal.mq.namespace", "rocketmq.namespace", properties);
        this.doMoreCompatibleConvert("canal.mq.retries", "rocketmq.retry.times.when.send.failed", properties);
        String producerGroup = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.producer.group");
        if (!StringUtils.isEmpty((String)producerGroup)) {
            rocketMQProperties.setProducerGroup(producerGroup);
        }
        if (!StringUtils.isEmpty((String)(enableMessageTrace = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.enable.message.trace")))) {
            rocketMQProperties.setEnableMessageTrace(Boolean.parseBoolean(enableMessageTrace));
        }
        if (!StringUtils.isEmpty((String)(customizedTraceTopic = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.customized.trace.topic")))) {
            rocketMQProperties.setCustomizedTraceTopic(customizedTraceTopic);
        }
        if (!StringUtils.isEmpty((String)(namespace = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.namespace")))) {
            rocketMQProperties.setNamespace(namespace);
        }
        if (!StringUtils.isEmpty((String)(namesrvAddr = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.namesrv.addr")))) {
            rocketMQProperties.setNamesrvAddr(namesrvAddr);
        }
        if (!StringUtils.isEmpty((String)(retry = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.retry.times.when.send.failed")))) {
            rocketMQProperties.setRetryTimesWhenSendFailed(Integer.parseInt(retry));
        }
        if (!StringUtils.isEmpty((String)(vipChannelEnabled = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.vip.channel.enabled")))) {
            rocketMQProperties.setVipChannelEnabled(Boolean.parseBoolean(vipChannelEnabled));
        }
        if (!StringUtils.isEmpty((String)(tag = PropertiesUtils.getProperty((Properties)properties, (String)"rocketmq.tag")))) {
            rocketMQProperties.setTag(tag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MQDestination destination, com.alibaba.otter.canal.protocol.Message message, Callback callback) {
        ExecutorTemplate template = new ExecutorTemplate(this.sendExecutor);
        try {
            if (!StringUtils.isEmpty((String)destination.getDynamicTopic())) {
                Map messageMap = MQMessageUtils.messageTopics((com.alibaba.otter.canal.protocol.Message)message, (String)destination.getTopic(), (String)destination.getDynamicTopic());
                for (Map.Entry entry : messageMap.entrySet()) {
                    String topicName = ((String)entry.getKey()).replace('.', '_');
                    com.alibaba.otter.canal.protocol.Message messageSub = (com.alibaba.otter.canal.protocol.Message)entry.getValue();
                    template.submit(() -> {
                        try {
                            this.send(destination, topicName, messageSub);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                template.waitForResult();
            } else {
                this.send(destination, destination.getTopic(), message);
            }
            callback.commit();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            callback.rollback();
        }
        finally {
            template.clear();
        }
    }

    public void send(MQDestination destination, String topicName, com.alibaba.otter.canal.protocol.Message message) {
        Integer partitionNum = MQMessageUtils.parseDynamicTopicPartition((String)topicName, (String)destination.getDynamicTopicPartitionNum());
        if (partitionNum == null) {
            partitionNum = this.getTopicDynamicQueuesSize(destination.getEnableDynamicQueuePartition(), topicName);
        }
        if (partitionNum == null) {
            partitionNum = destination.getPartitionsNum();
        }
        if (!this.mqProperties.isFlatMessage()) {
            if (destination.getPartitionHash() != null && !destination.getPartitionHash().isEmpty()) {
                MQMessageUtils.EntryRowData[] datas = MQMessageUtils.buildMessageData((com.alibaba.otter.canal.protocol.Message)message, (ThreadPoolExecutor)this.buildExecutor);
                com.alibaba.otter.canal.protocol.Message[] messages = MQMessageUtils.messagePartition((MQMessageUtils.EntryRowData[])datas, (long)message.getId(), (Integer)partitionNum, (String)destination.getPartitionHash(), (boolean)this.mqProperties.isDatabaseHash());
                int length = messages.length;
                ExecutorTemplate template = new ExecutorTemplate(this.sendPartitionExecutor);
                for (int i = 0; i < length; ++i) {
                    com.alibaba.otter.canal.protocol.Message dataPartition = messages[i];
                    if (dataPartition == null) continue;
                    int index = i;
                    template.submit(() -> {
                        Message data = new Message(topicName, ((RocketMQProducerConfig)this.mqProperties).getTag(), CanalMessageSerializerUtil.serializer((com.alibaba.otter.canal.protocol.Message)dataPartition, (boolean)this.mqProperties.isFilterTransactionEntry()));
                        this.sendMessage(data, index);
                    });
                }
                template.waitForResult();
            } else {
                int partition = destination.getPartition() != null ? destination.getPartition() : 0;
                Message data = new Message(topicName, ((RocketMQProducerConfig)this.mqProperties).getTag(), CanalMessageSerializerUtil.serializer((com.alibaba.otter.canal.protocol.Message)message, (boolean)this.mqProperties.isFilterTransactionEntry()));
                this.sendMessage(data, partition);
            }
        } else {
            MQMessageUtils.EntryRowData[] datas = MQMessageUtils.buildMessageData((com.alibaba.otter.canal.protocol.Message)message, (ThreadPoolExecutor)this.buildExecutor);
            List flatMessages = MQMessageUtils.messageConverter((MQMessageUtils.EntryRowData[])datas, (long)message.getId());
            if (destination.getPartitionHash() != null && !destination.getPartitionHash().isEmpty()) {
                ArrayList partitionFlatMessages = new ArrayList();
                for (int i = 0; i < partitionNum; ++i) {
                    partitionFlatMessages.add(new ArrayList());
                }
                for (FlatMessage flatMessage2 : flatMessages) {
                    FlatMessage[] partitionFlatMessage = MQMessageUtils.messagePartition((FlatMessage)flatMessage2, (Integer)partitionNum, (String)destination.getPartitionHash(), (boolean)this.mqProperties.isDatabaseHash());
                    int length = partitionFlatMessage.length;
                    for (int i = 0; i < length; ++i) {
                        if (partitionFlatMessage[i] == null) continue;
                        ((List)partitionFlatMessages.get(i)).add(partitionFlatMessage[i]);
                    }
                }
                ExecutorTemplate template = new ExecutorTemplate(this.sendPartitionExecutor);
                for (int i = 0; i < partitionFlatMessages.size(); ++i) {
                    List flatMessagePart = (List)partitionFlatMessages.get(i);
                    if (flatMessagePart == null || flatMessagePart.size() <= 0) continue;
                    int index = i;
                    template.submit(() -> {
                        List<Message> messages = flatMessagePart.stream().map(flatMessage -> new Message(topicName, ((RocketMQProducerConfig)this.mqProperties).getTag(), JSON.toJSONBytes((Object)flatMessage, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls}))).collect(Collectors.toList());
                        this.sendMessage(messages, index);
                    });
                }
                template.waitForResult();
            } else {
                int partition = destination.getPartition() != null ? destination.getPartition() : 0;
                List<Message> messages = flatMessages.stream().map(flatMessage -> new Message(topicName, ((RocketMQProducerConfig)this.mqProperties).getTag(), JSON.toJSONBytes((Object)flatMessage, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls}))).collect(Collectors.toList());
                this.sendMessage(messages, partition);
            }
        }
    }

    private void sendMessage(Message message, int partition) {
        try {
            SendResult sendResult = this.defaultMQProducer.send(message, (List<MessageQueue> mqs, Message msg, Object arg) -> {
                if (partition >= mqs.size()) {
                    return (MessageQueue)mqs.get(partition % mqs.size());
                }
                return (MessageQueue)mqs.get(partition);
            }, null);
            if (logger.isDebugEnabled()) {
                logger.debug("Send Message Result: {}", (Object)sendResult);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendMessage(List<Message> messages, int partition) {
        if (messages.isEmpty()) {
            return;
        }
        DefaultMQProducerImpl innerProducer = this.defaultMQProducer.getDefaultMQProducerImpl();
        TopicPublishInfo topicInfo = (TopicPublishInfo)innerProducer.getTopicPublishInfoTable().get(messages.get(0).getTopic());
        if (topicInfo == null) {
            for (Message message : messages) {
                this.sendMessage(message, partition);
            }
            return;
        } else {
            List<MessageQueue> queues = topicInfo.getMessageQueueList();
            int size = queues.size();
            if (size <= 0) {
                for (Message message : messages) {
                    this.sendMessage(message, partition);
                }
                return;
            } else {
                MessageQueue queue = partition >= size ? queues.get(partition % size) : queues.get(partition);
                try {
                    SendResult sendResult = this.defaultMQProducer.send(messages, queue);
                    if (!logger.isDebugEnabled()) return;
                    logger.debug("Send Message Result: {}", (Object)sendResult);
                    return;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void stop() {
        logger.info("## Stop RocketMQ producer##");
        this.defaultMQProducer.shutdown();
        if (this.sendPartitionExecutor != null) {
            this.sendPartitionExecutor.shutdownNow();
        }
        super.stop();
    }

    private Integer getTopicDynamicQueuesSize(Boolean enable, String topicName) {
        if (enable != null && enable.booleanValue()) {
            topicName = this.defaultMQProducer.withNamespace(topicName);
            DefaultMQProducerImpl innerProducer = this.defaultMQProducer.getDefaultMQProducerImpl();
            TopicPublishInfo topicInfo = (TopicPublishInfo)innerProducer.getTopicPublishInfoTable().get(topicName);
            if (topicInfo == null) {
                return null;
            }
            return topicInfo.getMessageQueueList().size();
        }
        return null;
    }
}

