/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import java.lang.reflect.Field;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.SessionCredentials;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class AclClientRPCHook
implements RPCHook {
    private final SessionCredentials sessionCredentials;
    protected ConcurrentHashMap<Class<? extends CommandCustomHeader>, Field[]> fieldCache = new ConcurrentHashMap();

    public AclClientRPCHook(SessionCredentials sessionCredentials) {
        this.sessionCredentials = sessionCredentials;
    }

    @Override
    public void doBeforeRequest(String remoteAddr, RemotingCommand request) {
        byte[] total = AclUtils.combineRequestContent(request, this.parseRequestContent(request, this.sessionCredentials.getAccessKey(), this.sessionCredentials.getSecurityToken()));
        String signature = AclUtils.calSignature(total, this.sessionCredentials.getSecretKey());
        request.addExtField("Signature", signature);
        request.addExtField("AccessKey", this.sessionCredentials.getAccessKey());
        if (this.sessionCredentials.getSecurityToken() != null) {
            request.addExtField("SecurityToken", this.sessionCredentials.getSecurityToken());
        }
    }

    @Override
    public void doAfterResponse(String remoteAddr, RemotingCommand request, RemotingCommand response) {
    }

    protected SortedMap<String, String> parseRequestContent(RemotingCommand request, String ak, String securityToken) {
        CommandCustomHeader header = request.readCustomHeader();
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("AccessKey", ak);
        if (securityToken != null) {
            map.put("SecurityToken", securityToken);
        }
        try {
            if (null != header) {
                Field[] fields = this.fieldCache.get(header.getClass());
                if (null == fields) {
                    for (Field field : fields = header.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                    }
                    Field[] tmp = this.fieldCache.putIfAbsent(header.getClass(), fields);
                    if (null != tmp) {
                        fields = tmp;
                    }
                }
                for (Field field : fields) {
                    Object value = field.get(header);
                    if (null == value || field.isSynthetic()) continue;
                    map.put(field.getName(), value.toString());
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException("incompatible exception.", e);
        }
    }

    public SessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }
}

