/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.packets;

import com.alibaba.otter.canal.parse.driver.mysql.utils.ByteHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class UUIDSet {
    public UUID SID;
    public List<Interval> intervals;

    public byte[] encode() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(this.SID.getMostSignificantBits());
        bb.putLong(this.SID.getLeastSignificantBits());
        out.write(bb.array());
        ByteHelper.writeUnsignedInt64LittleEndian(this.intervals.size(), out);
        for (Interval interval : this.intervals) {
            ByteHelper.writeUnsignedInt64LittleEndian(interval.start, out);
            ByteHelper.writeUnsignedInt64LittleEndian(interval.stop, out);
        }
        return out.toByteArray();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        UUIDSet us = (UUIDSet)o;
        Collections.sort(this.intervals);
        Collections.sort(us.intervals);
        return this.SID.equals(us.SID) && this.intervals.equals(us.intervals);
    }

    public static UUIDSet parse(String str) {
        String[] ss = str.split(":");
        if (ss.length < 2) {
            throw new RuntimeException(String.format("parseUUIDSet failed due to wrong format: %s", str));
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (int i = 1; i < ss.length; ++i) {
            intervals.add(UUIDSet.parseInterval(ss[i]));
        }
        UUIDSet uuidSet = new UUIDSet();
        uuidSet.SID = UUID.fromString(ss[0]);
        uuidSet.intervals = UUIDSet.combine(intervals);
        return uuidSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.SID.toString());
        for (Interval interval : this.intervals) {
            if (interval.start == interval.stop - 1L) {
                sb.append(":");
                sb.append(interval.start);
                continue;
            }
            sb.append(":");
            sb.append(interval.start);
            sb.append("-");
            sb.append(interval.stop - 1L);
        }
        return sb.toString();
    }

    public static Interval parseInterval(String str) {
        String[] ss = str.split("-");
        Interval interval = new Interval();
        switch (ss.length) {
            case 1: {
                interval.start = Long.parseLong(ss[0]);
                interval.stop = interval.start + 1L;
                break;
            }
            case 2: {
                interval.start = Long.parseLong(ss[0]);
                interval.stop = Long.parseLong(ss[1]) + 1L;
                break;
            }
            default: {
                throw new RuntimeException(String.format("parseInterval failed due to wrong format: %s", str));
            }
        }
        return interval;
    }

    public static List<Interval> combine(List<Interval> intervals) {
        ArrayList<Interval> combined = new ArrayList<Interval>();
        Collections.sort(intervals);
        int len = intervals.size();
        for (int i = 0; i < len; ++i) {
            int j;
            combined.add(intervals.get(i));
            for (j = i + 1; j < len && intervals.get((int)i).stop >= intervals.get((int)j).start; ++j) {
                if (intervals.get((int)i).stop >= intervals.get((int)j).stop) continue;
                intervals.get((int)i).stop = intervals.get((int)j).stop;
            }
            i = j - 1;
        }
        return combined;
    }

    public static class Interval
    implements Comparable<Interval> {
        public long start;
        public long stop;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Interval interval = (Interval)o;
            if (this.start != interval.start) {
                return false;
            }
            return this.stop == interval.stop;
        }

        public int hashCode() {
            int result = (int)(this.start ^ this.start >>> 32);
            result = 31 * result + (int)(this.stop ^ this.stop >>> 32);
            return result;
        }

        @Override
        public int compareTo(Interval o) {
            if (this.equals(o)) {
                return 1;
            }
            return Long.compare(this.start, o.start);
        }
    }
}

