/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderBaseModule;
import com.alibaba.fastjson2.reader.TypeConverts;
import java.math.BigDecimal;
import java.util.Map;
import java.util.function.Function;

final class ObjectReaderImplBigDecimal
extends ObjectReaderBaseModule.PrimitiveImpl {
    private Function converter = new TypeConverts.ToBigDecimal();
    static final ObjectReaderImplBigDecimal INSTANCE = new ObjectReaderImplBigDecimal();

    ObjectReaderImplBigDecimal() {
    }

    @Override
    public Class getObjectClass() {
        return BigDecimal.class;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, long features) {
        return jsonReader.readBigDecimal();
    }

    @Override
    public Object readObject(JSONReader jsonReader, long features) {
        return jsonReader.readBigDecimal();
    }

    @Override
    public Object createInstance(Map map, long features) {
        Object value = map.get("value");
        if (value == null) {
            value = map.get("$numberDecimal");
        }
        if (!(value instanceof BigDecimal)) {
            value = this.converter.apply(value);
        }
        return value;
    }
}

