/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.schema.ValidateResult;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

final class EnumSchema
extends JSONSchema {
    Set<Object> items;

    EnumSchema(Object[] items) {
        super(null, null);
        this.items = new LinkedHashSet<Object>(items.length);
        for (Object item : items) {
            if (item instanceof BigDecimal) {
                item = ((BigDecimal)item).stripTrailingZeros();
            }
            this.items.add(item);
        }
    }

    @Override
    public JSONSchema.Type getType() {
        return JSONSchema.Type.Enum;
    }

    @Override
    public ValidateResult validate(Object value) {
        long longValue;
        if (value instanceof BigDecimal && ((BigDecimal)(value = ((BigDecimal)value).stripTrailingZeros())).compareTo(BigDecimal.valueOf(longValue = ((BigDecimal)value).longValue())) == 0) {
            value = longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue;
        }
        if (!this.items.contains(value)) {
            if (value == null) {
                return FAIL_INPUT_NULL;
            }
            return new ValidateResult(false, "expect type %s, but %s", new Object[]{JSONSchema.Type.Enum, value.getClass()});
        }
        return SUCCESS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumSchema that = (EnumSchema)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description);
    }
}

