/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.schema;

import com.alibaba.fastjson2.schema.FormatValidator;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;

final class TimeValidator
implements FormatValidator {
    static final TimeValidator INSTANCE = new TimeValidator();

    TimeValidator() {
    }

    @Override
    public boolean isValid(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.length() != 8 || str.charAt(2) != ':' || str.charAt(5) != ':') {
            try {
                LocalTime.parse(str);
                return true;
            }
            catch (DateTimeParseException ignored) {
                return false;
            }
        }
        char h0 = str.charAt(0);
        char h1 = str.charAt(1);
        char m0 = str.charAt(3);
        char m1 = str.charAt(4);
        char s0 = str.charAt(6);
        char s1 = str.charAt(7);
        if (h0 >= '0' && h0 <= '2' && h1 >= '0' && h1 <= '9' && m0 >= '0' && m0 <= '6' && m1 >= '0' && m0 <= '9' && s0 >= '0' && s0 <= '6' && s1 >= '0' && s0 <= '9') {
            int hh = (h0 - 48) * 10 + (h1 - 48);
            if (hh > 24) {
                return false;
            }
            int mm = (m0 - 48) * 10 + (m1 - 48);
            if (mm > 60) {
                return false;
            }
            int ss = (s0 - 48) * 10 + (s1 - 48);
            return ss <= 61;
        }
        return false;
    }
}

