/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

abstract class FieldWriterDate<T>
extends FieldWriterImpl<T> {
    volatile byte[] cacheFormat19UTF8;
    static AtomicReferenceFieldUpdater<FieldWriterDate, byte[]> CACHE_UTF8_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldWriterDate.class, byte[].class, "cacheFormat19UTF8");
    volatile char[] cacheFormat19UTF16;
    static AtomicReferenceFieldUpdater<FieldWriterDate, char[]> CACHE_UTF16_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FieldWriterDate.class, char[].class, "cacheFormat19UTF16");
    protected DateTimeFormatter formatter;
    final boolean formatMillis;
    final boolean formatISO8601;
    final boolean formatyyyyMMddhhmmss19;
    final boolean formatUnixTime;
    protected ObjectWriter dateWriter;

    protected FieldWriterDate(String fieldName, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass) {
        super(fieldName, ordinal, features, format, label, fieldType, fieldClass);
        boolean formatMillis = false;
        boolean formatISO8601 = false;
        boolean formatUnixTime = false;
        boolean formatyyyyMMddhhmmss19 = false;
        if (format != null) {
            switch (format) {
                case "millis": {
                    formatMillis = true;
                    break;
                }
                case "iso8601": {
                    formatISO8601 = true;
                    break;
                }
                case "unixtime": {
                    formatUnixTime = true;
                    break;
                }
                case "yyyy-MM-ddTHH:mm:ss": {
                    formatyyyyMMddhhmmss19 = true;
                    break;
                }
            }
        }
        this.formatMillis = formatMillis;
        this.formatISO8601 = formatISO8601;
        this.formatUnixTime = formatUnixTime;
        this.formatyyyyMMddhhmmss19 = formatyyyyMMddhhmmss19;
    }

    @Override
    public boolean isDateFormatMillis() {
        return this.formatMillis;
    }

    @Override
    public boolean isDateFormatISO8601() {
        return this.formatISO8601;
    }

    public DateTimeFormatter getFormatter() {
        if (!(this.formatter != null || this.format == null || this.formatMillis || this.formatISO8601 || this.formatUnixTime)) {
            this.formatter = DateTimeFormatter.ofPattern(this.format);
        }
        return this.formatter;
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (valueClass == this.fieldClass) {
            if (this.dateWriter == null) {
                if (this.format == null) {
                    this.dateWriter = ObjectWriterImplDate.INSTANCE;
                    return this.dateWriter;
                }
                this.dateWriter = new ObjectWriterImplDate(this.format);
                return this.dateWriter;
            }
            return this.dateWriter;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeDate(JSONWriter jsonWriter, long timeMillis) {
        String dateFormat;
        if (jsonWriter.isJSONB()) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeMillis(timeMillis);
            return;
        }
        int SECONDS_PER_DAY = 86400;
        JSONWriter.Context ctx = jsonWriter.getContext();
        if (this.formatUnixTime || this.format == null && ctx.isDateFormatUnixTime()) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt64(timeMillis / 1000L);
            return;
        }
        if (this.formatMillis || this.format == null && ctx.isDateFormatMillis()) {
            this.writeFieldName(jsonWriter);
            jsonWriter.writeInt64(timeMillis);
            return;
        }
        ZoneId zoneId = ctx.getZoneId();
        String string = dateFormat = this.format != null ? this.format : ctx.getDateFormat();
        if (dateFormat == null) {
            int off;
            long yearEst;
            long doyEst;
            Instant instant = Instant.ofEpochMilli(timeMillis);
            long epochSecond = instant.getEpochSecond();
            ZoneOffset offset = zoneId.getRules().getOffset(instant);
            long localSecond = epochSecond + (long)offset.getTotalSeconds();
            long localEpochDay = Math.floorDiv(localSecond, 86400L);
            int secsOfDay = (int)Math.floorMod(localSecond, 86400L);
            int DAYS_PER_CYCLE = 146097;
            long DAYS_0000_TO_1970 = 719528L;
            long zeroDay = localEpochDay + 719528L;
            long adjust = 0L;
            if ((zeroDay -= 60L) < 0L) {
                long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
                adjust = adjustCycles * 400L;
                zeroDay += -adjustCycles * 146097L;
            }
            if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
                doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
            }
            yearEst += adjust;
            int marchDoy0 = (int)doyEst;
            int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
            int month = (marchMonth0 + 2) % 12 + 1;
            int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
            int year = ChronoField.YEAR.checkValidIntValue(yearEst += (long)(marchMonth0 / 10));
            int MINUTES_PER_HOUR = 60;
            int SECONDS_PER_MINUTE = 60;
            int SECONDS_PER_HOUR = 3600;
            long secondOfDay = secsOfDay;
            ChronoField.SECOND_OF_DAY.checkValidValue(secondOfDay);
            int hours = (int)(secondOfDay / 3600L);
            int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
            int hour = hours;
            int minute = minutes;
            int second = (int)(secondOfDay -= (long)(minutes * 60));
            int millis = instant.getNano() / 1000000;
            if (millis != 0) {
                int offsetSeconds = ctx.getZoneId().getRules().getOffset(instant).getTotalSeconds();
                this.writeFieldName(jsonWriter);
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, millis, offsetSeconds);
                return;
            }
            if (jsonWriter.isUTF8()) {
                byte[] bytes = CACHE_UTF8_UPDATER.getAndSet(this, null);
                if (bytes == null) {
                    bytes = Arrays.copyOfRange(this.nameWithColonUTF8, 0, this.nameWithColonUTF8.length + 21);
                    off = this.nameWithColonUTF8.length;
                    bytes[off++] = 34;
                    bytes[off += 4] = 45;
                    bytes[off += 3] = 45;
                    bytes[off += 3] = 32;
                    bytes[off += 3] = 58;
                    bytes[off += 3] = 58;
                    bytes[off += 3] = 34;
                }
                off = this.nameWithColonUTF8.length + 1;
                bytes[off] = (byte)(year / 1000 + 48);
                bytes[off + 1] = (byte)(year / 100 % 10 + 48);
                bytes[off + 2] = (byte)(year / 10 % 10 + 48);
                bytes[off + 3] = (byte)(year % 10 + 48);
                bytes[off + 5] = (byte)(month / 10 + 48);
                bytes[off + 6] = (byte)(month % 10 + 48);
                bytes[off + 8] = (byte)(dayOfMonth / 10 + 48);
                bytes[off + 9] = (byte)(dayOfMonth % 10 + 48);
                bytes[off + 11] = (byte)(hour / 10 + 48);
                bytes[off + 12] = (byte)(hour % 10 + 48);
                bytes[off + 14] = (byte)(minute / 10 + 48);
                bytes[off + 15] = (byte)(minute % 10 + 48);
                bytes[off + 17] = (byte)(second / 10 + 48);
                bytes[off + 18] = (byte)(second % 10 + 48);
                try {
                    jsonWriter.writeNameRaw(bytes);
                }
                finally {
                    CACHE_UTF8_UPDATER.set(this, bytes);
                }
                return;
            }
            if (jsonWriter.isUTF16()) {
                char[] chars = CACHE_UTF16_UPDATER.getAndSet(this, null);
                if (chars == null) {
                    chars = Arrays.copyOfRange(this.nameWithColonUTF16, 0, this.nameWithColonUTF16.length + 21);
                    off = this.nameWithColonUTF16.length;
                    chars[off++] = 34;
                    chars[off += 4] = 45;
                    chars[off += 3] = 45;
                    chars[off += 3] = 32;
                    chars[off += 3] = 58;
                    chars[off += 3] = 58;
                    chars[off += 3] = 34;
                }
                off = this.nameWithColonUTF16.length + 1;
                chars[off] = (char)(year / 1000 + 48);
                chars[off + 1] = (char)(year / 100 % 10 + 48);
                chars[off + 2] = (char)(year / 10 % 10 + 48);
                chars[off + 3] = (char)(year % 10 + 48);
                chars[off + 5] = (char)(month / 10 + 48);
                chars[off + 6] = (char)(month % 10 + 48);
                chars[off + 8] = (char)(dayOfMonth / 10 + 48);
                chars[off + 9] = (char)(dayOfMonth % 10 + 48);
                chars[off + 11] = (char)(hour / 10 + 48);
                chars[off + 12] = (char)(hour % 10 + 48);
                chars[off + 14] = (char)(minute / 10 + 48);
                chars[off + 15] = (char)(minute % 10 + 48);
                chars[off + 17] = (char)(second / 10 + 48);
                chars[off + 18] = (char)(second % 10 + 48);
                try {
                    jsonWriter.writeNameRaw(chars);
                }
                finally {
                    CACHE_UTF16_UPDATER.set(this, chars);
                }
                return;
            }
            this.writeFieldName(jsonWriter);
            jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
        } else {
            this.writeFieldName(jsonWriter);
            ZonedDateTime zdt = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timeMillis), zoneId);
            if (this.formatISO8601 || ctx.isDateFormatISO8601()) {
                int year = zdt.getYear();
                int month = zdt.getMonthValue();
                int dayOfMonth = zdt.getDayOfMonth();
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                int millis = zdt.getNano() / 1000000;
                int offsetSeconds = zdt.getOffset().getTotalSeconds();
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, millis, offsetSeconds);
                return;
            }
            if (this.formatyyyyMMddhhmmss19 || ctx.isFormatyyyyMMddhhmmss19()) {
                int year = zdt.getYear();
                int month = zdt.getMonthValue();
                int dayOfMonth = zdt.getDayOfMonth();
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
                return;
            }
            DateTimeFormatter formatter = this.getFormatter();
            if (formatter == null) {
                formatter = ctx.getDateFormatter();
            }
            String str = formatter.format(zdt);
            jsonWriter.writeString(str);
        }
    }
}

