/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.internal.asm.ASMUtils;
import com.alibaba.fastjson2.internal.asm.ClassWriter;
import com.alibaba.fastjson2.internal.asm.Label;
import com.alibaba.fastjson2.internal.asm.MethodWriter;
import com.alibaba.fastjson2.modules.ObjectWriterAnnotationProcessor;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.DynamicClassLoader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.FIeldWriterEnumField;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.FieldWriterBigDecimalField;
import com.alibaba.fastjson2.writer.FieldWriterBigIntField;
import com.alibaba.fastjson2.writer.FieldWriterBooleanField;
import com.alibaba.fastjson2.writer.FieldWriterCharValField;
import com.alibaba.fastjson2.writer.FieldWriterDateField;
import com.alibaba.fastjson2.writer.FieldWriterDoubleValField;
import com.alibaba.fastjson2.writer.FieldWriterFloatValField;
import com.alibaba.fastjson2.writer.FieldWriterInt16Field;
import com.alibaba.fastjson2.writer.FieldWriterInt16ValField;
import com.alibaba.fastjson2.writer.FieldWriterInt32Field;
import com.alibaba.fastjson2.writer.FieldWriterInt32Val;
import com.alibaba.fastjson2.writer.FieldWriterInt32ValUF;
import com.alibaba.fastjson2.writer.FieldWriterInt64Field;
import com.alibaba.fastjson2.writer.FieldWriterInt64ValField;
import com.alibaba.fastjson2.writer.FieldWriterInt8Field;
import com.alibaba.fastjson2.writer.FieldWriterInt8ValField;
import com.alibaba.fastjson2.writer.FieldWriterList;
import com.alibaba.fastjson2.writer.FieldWriterListField;
import com.alibaba.fastjson2.writer.FieldWriterMillisField;
import com.alibaba.fastjson2.writer.FieldWriterObject;
import com.alibaba.fastjson2.writer.FieldWriterObjectArrayField;
import com.alibaba.fastjson2.writer.FieldWriterObjectArrayMethod;
import com.alibaba.fastjson2.writer.FieldWriterObjectField;
import com.alibaba.fastjson2.writer.FieldWriterObjectFieldUF;
import com.alibaba.fastjson2.writer.FieldWriterStringField;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterCreatorASMUtils;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class ObjectWriterCreatorASM
extends ObjectWriterCreator {
    public static final ObjectWriterCreatorASM INSTANCE = new ObjectWriterCreatorASM();
    protected static final AtomicLong seed = new AtomicLong();
    protected final DynamicClassLoader classLoader;
    static final String TYPE_COLLECTION = ASMUtils.type(Collection.class);
    static final String TYPE_OBJECT_WRITER = ASMUtils.type(ObjectWriter.class);
    static final String TYPE_JSON_WRITER = ASMUtils.type(JSONWriter.class);
    static final String TYPE_JSONB = ASMUtils.type(JSONB.class);
    static final String TYPE_FIELD_WRITER = ASMUtils.type(FieldWriter.class);
    static final String TYPE_CONTEXT = ASMUtils.type(JSONWriter.Context.class);
    static final String TYPE_OBJECT_WRITER_ADAPTER = ASMUtils.type(ObjectWriterAdapter.class);
    static final String[] INTERFACES = new String[]{TYPE_OBJECT_WRITER};
    static final String DESC_OBJECT_WRITER = ASMUtils.desc(ObjectWriter.class);
    static final String DESC_JSON_WRITER = ASMUtils.desc(JSONWriter.class);
    static final String DESC_FIELD_WRITER = ASMUtils.desc(FieldWriter.class);
    static final String DESC_FIELD_WRITER_ARRAY = ASMUtils.desc(FieldWriter[].class);
    static final String METHOD_DESC_WRITE_VALUE = "(" + DESC_JSON_WRITER + "Ljava/lang/Object;)V";
    static final String METHOD_DESC_WRITE = "(" + DESC_JSON_WRITER + "Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;J)V";
    static final String METHOD_DESC_WRITE_FIELD_NAME = "(" + DESC_JSON_WRITER + ")V";
    static final String METHOD_DESC_WRITE_OBJECT = "(" + DESC_JSON_WRITER + "Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/reflect/Type;J)V";
    static final String METHOD_DESC_WRITE_J = "(" + DESC_JSON_WRITER + "J)V";
    static final String METHOD_DESC_WRITE_DATE_WITH_FIELD_NAME = "(" + DESC_JSON_WRITER + "Z" + ASMUtils.desc(Date.class) + ")V";
    static final String METHOD_DESC_WRITE_Z = "(" + DESC_JSON_WRITER + "Z)V";
    static final String METHOD_DESC_WRITE_ZARRAY = "(" + DESC_JSON_WRITER + "[Z)V";
    static final String METHOD_DESC_WRITE_FARRAY = "(" + DESC_JSON_WRITER + "[F)V";
    static final String METHOD_DESC_WRITE_DARRAY = "(" + DESC_JSON_WRITER + "[D)V";
    static final String METHOD_DESC_WRITE_I = "(" + DESC_JSON_WRITER + "I)V";
    static final String METHOD_DESC_WRITE_SArray = "(" + DESC_JSON_WRITER + "[S)V";
    static final String METHOD_DESC_WRITE_BArray = "(" + DESC_JSON_WRITER + "[B)V";
    static final String METHOD_DESC_WRITE_CArray = "(" + DESC_JSON_WRITER + "[C)V";
    static final String METHOD_DESC_WRITE_ENUM = "(" + DESC_JSON_WRITER + "Ljava/lang/Enum;)V";
    static final String METHOD_DESC_WRITE_LIST = "(" + DESC_JSON_WRITER + "ZLjava/util/List;)V";
    static final String METHOD_DESC_FIELD_WRITE_OBJECT = "(" + DESC_JSON_WRITER + "Ljava/lang/Object;)Z";
    static final String METHOD_DESC_GET_OBJECT_WRITER = "(" + DESC_JSON_WRITER + "Ljava/lang/Class;)" + DESC_OBJECT_WRITER;
    static final String METHOD_DESC_GET_ITEM_WRITER = "(" + DESC_JSON_WRITER + "Ljava/lang/reflect/Type;)" + DESC_OBJECT_WRITER;
    static final String METHOD_DESC_WRITE_TYPE_INFO = "(" + DESC_JSON_WRITER + ")Z";
    static final String METHOD_DESC_HAS_FILTER = "(" + DESC_JSON_WRITER + ")Z";
    static final String METHOD_DESC_GET_CONTEXT = "()" + ASMUtils.desc(JSONWriter.Context.class);
    static final String METHOD_DESC_SET_PATH = "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/String;";
    static final String METHOD_DESC_SET_PATH_I = "(ILjava/lang/Object;)Ljava/lang/String;";
    static final String METHOD_DESC_WRITE_REFERENCE = "(Ljava/lang/String;)V";
    static final String METHOD_DESC_WRITE_CLASS_INFO = "(" + DESC_JSON_WRITER + ")V";
    static final int THIS = 0;
    static final int JSON_WRITER = 1;
    static final String NOT_WRITE_DEFAULT_VALUE = "WRITE_DEFAULT_VALUE";
    static final String WRITE_NULLS = "WRITE_NULLS";
    static final String CONTEXT_FEATURES = "CONTEXT_FEATURES";
    static String[] fieldWriterCache = new String[1024];

    static String fieldWriter(int i) {
        String fieldName = fieldWriterCache[i];
        if (fieldName != null) {
            return fieldName;
        }
        String base = "fw";
        int size = IOUtils.stringSize(i);
        char[] chars = new char[base.length() + size];
        base.getChars(0, base.length(), chars, 0);
        IOUtils.getChars(i, chars.length, chars);
        ObjectWriterCreatorASM.fieldWriterCache[i] = fieldName = new String(chars);
        return fieldName;
    }

    public ObjectWriterCreatorASM() {
        this.classLoader = new DynamicClassLoader();
    }

    public ObjectWriterCreatorASM(ClassLoader classLoader) {
        this.classLoader = new DynamicClassLoader(classLoader);
    }

    @Override
    public ObjectWriter createObjectWriter(Class objectClass, long features, List<ObjectWriterModule> modules) {
        String classNameType;
        String classNameFull;
        ArrayList<FieldWriter> fieldWriters;
        TreeMap<String, FieldWriter> fieldWriterMap;
        boolean fieldBased;
        int modifiers = objectClass.getModifiers();
        boolean externalClass = this.classLoader.isExternalClass(objectClass);
        boolean publicClass = Modifier.isPublic(modifiers);
        if (!(publicClass && !externalClass || JDKUtils.UNSAFE_SUPPORT)) {
            return super.createObjectWriter(objectClass, features, modules);
        }
        BeanInfo beanInfo = new BeanInfo();
        for (ObjectWriterModule module : modules) {
            ObjectWriterAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
            if (annotationProcessor == null) continue;
            annotationProcessor.getBeanInfo(beanInfo, objectClass);
        }
        if (beanInfo.serializer != null && ObjectWriter.class.isAssignableFrom(beanInfo.serializer)) {
            try {
                return (ObjectWriter)beanInfo.serializer.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException("create serializer error", e);
            }
        }
        long writerFeatures = features | beanInfo.writerFeatures;
        boolean bl = fieldBased = (writerFeatures & JSONWriter.Feature.FieldBased.mask) != 0L;
        if (fieldBased && (objectClass.isInterface() || objectClass.isInterface())) {
            fieldBased = false;
        }
        if (fieldBased && JDKUtils.JVM_VERSION >= 11 && Throwable.class.isAssignableFrom(objectClass)) {
            return super.createObjectWriter(objectClass, features, modules);
        }
        boolean record = BeanUtils.isRecord(objectClass);
        if (fieldBased && !record) {
            fieldWriterMap = new TreeMap();
            FieldInfo fieldInfo = new FieldInfo();
            BeanUtils.declaredFields(objectClass, field -> {
                if (Modifier.isTransient(field.getModifiers())) {
                    return;
                }
                fieldInfo.init();
                FieldWriter fieldWriter = this.creteFieldWriter(objectClass, writerFeatures, modules, beanInfo, fieldInfo, (Field)field);
                if (fieldWriter != null) {
                    fieldWriterMap.put(fieldWriter.getFieldName(), fieldWriter);
                }
            });
            fieldWriters = new ArrayList<FieldWriter>(fieldWriterMap.values());
        } else {
            fieldWriterMap = new TreeMap<String, FieldWriter>();
            Iterator fieldWriterList = new ArrayList<FieldWriter>();
            boolean fieldWritersCreated = false;
            for (ObjectWriterModule module : modules) {
                if (!module.createFieldWriters(this, objectClass, (List<FieldWriter>)((Object)fieldWriterList))) continue;
                fieldWritersCreated = true;
                break;
            }
            if (fieldWritersCreated) {
                Iterator<ObjectWriterModule> iterator = fieldWriterList.iterator();
                while (iterator.hasNext()) {
                    FieldWriter fieldWriter = (FieldWriter)((Object)iterator.next());
                    Method method2 = fieldWriter.getMethod();
                    if (method2 == null) {
                        return super.createObjectWriter(objectClass, writerFeatures, modules);
                    }
                    fieldWriterMap.putIfAbsent(fieldWriter.getFieldName(), fieldWriter);
                }
            } else {
                FieldInfo fieldInfo = new FieldInfo();
                if (!record) {
                    BeanUtils.fields(objectClass, field -> {
                        fieldInfo.init();
                        FieldWriter fieldWriter = this.creteFieldWriter(objectClass, writerFeatures, modules, beanInfo, fieldInfo, (Field)field);
                        if (fieldWriter != null) {
                            fieldWriterMap.putIfAbsent(fieldWriter.getFieldName(), fieldWriter);
                        }
                    });
                }
                BeanUtils.getters(objectClass, method -> {
                    FieldWriter fieldWriter;
                    FieldWriter origin;
                    fieldInfo.init();
                    fieldInfo.features |= writerFeatures;
                    for (ObjectWriterModule module : modules) {
                        ObjectWriterAnnotationProcessor annotationProcessor = module.getAnnotationProcessor();
                        if (annotationProcessor == null) continue;
                        annotationProcessor.getFieldInfo(beanInfo, fieldInfo, objectClass, (Method)method);
                    }
                    if (fieldInfo.ignore) {
                        return;
                    }
                    String fieldName = fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty() ? (record ? method.getName() : BeanUtils.getterName(method.getName(), beanInfo.namingStrategy)) : fieldInfo.fieldName;
                    if (beanInfo.orders != null) {
                        boolean match = false;
                        for (int i = 0; i < beanInfo.orders.length; ++i) {
                            if (!fieldName.equals(beanInfo.orders[i])) continue;
                            fieldInfo.ordinal = i;
                            match = true;
                        }
                        if (!match && fieldInfo.ordinal == 0) {
                            fieldInfo.ordinal = beanInfo.orders.length;
                        }
                    }
                    if (beanInfo.includes != null && beanInfo.includes.length > 0) {
                        boolean match = false;
                        for (String include : beanInfo.includes) {
                            if (!include.equals(fieldName)) continue;
                            match = true;
                            break;
                        }
                        if (!match) {
                            return;
                        }
                    }
                    method.setAccessible(true);
                    ObjectWriter writeUsingWriter = null;
                    if (fieldInfo.writeUsing != null) {
                        try {
                            writeUsingWriter = (ObjectWriter)fieldInfo.writeUsing.newInstance();
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new JSONException("create writeUsing Writer error", e);
                        }
                    }
                    if (writeUsingWriter == null && fieldInfo.fieldClassMixIn) {
                        writeUsingWriter = ObjectWriterBaseModule.VoidObjectWriter.INSTANCE;
                    }
                    if ((origin = fieldWriterMap.putIfAbsent(fieldName, fieldWriter = this.createFieldWriter(objectClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.label, (Method)method, writeUsingWriter))) != null && origin.compareTo(fieldWriter) > 0) {
                        fieldWriterMap.put(fieldName, fieldWriter);
                    }
                });
            }
            fieldWriters = new ArrayList(fieldWriterMap.values());
        }
        this.handleIgnores(beanInfo, fieldWriters);
        Collections.sort(fieldWriters);
        boolean match = true;
        if (fieldWriters.size() >= 100 || Throwable.class.isAssignableFrom(objectClass)) {
            match = false;
        }
        if (!publicClass || externalClass) {
            for (FieldWriter fieldWriter : fieldWriters) {
                if (fieldWriter.getMethod() == null) continue;
                match = false;
                break;
            }
        }
        for (FieldWriter fieldWriter : fieldWriters) {
            if (fieldWriter.getInitWriter() == null && (fieldWriter.getFeatures() & 0x1000000000000L) == 0L && (fieldWriter.getFeatures() & 0x4000000000000L) == 0L) continue;
            match = false;
            break;
        }
        if (!match) {
            return super.createObjectWriter(objectClass, writerFeatures, modules);
        }
        ClassWriter cw = new ClassWriter();
        String className = "ObjectWriter_" + seed.incrementAndGet();
        Package pkg = ObjectWriterCreatorASM.class.getPackage();
        if (pkg != null) {
            String packageName = pkg.getName();
            int packageNameLength = packageName.length();
            int charsLength = packageNameLength + 1 + className.length();
            char[] chars = new char[charsLength];
            packageName.getChars(0, packageName.length(), chars, 0);
            chars[packageNameLength] = 46;
            className.getChars(0, className.length(), chars, packageNameLength + 1);
            classNameFull = new String(chars);
            chars[packageNameLength] = 47;
            for (int i = 0; i < packageNameLength; ++i) {
                if (chars[i] != '.') continue;
                chars[i] = 47;
            }
            classNameType = new String(chars);
        } else {
            classNameType = className;
            classNameFull = className;
        }
        cw.visit(52, 49, classNameType, TYPE_OBJECT_WRITER_ADAPTER, INTERFACES);
        this.genFields(fieldWriters, cw);
        this.genMethodInit(fieldWriters, cw, classNameType);
        this.genGetFieldReader(fieldWriters, cw, classNameType, new ObjectWriterAdapter(objectClass, null, null, features, fieldWriters));
        this.genMethodWriteJSONB(objectClass, fieldWriters, cw, classNameType, writerFeatures);
        if ((writerFeatures & JSONWriter.Feature.BeanToArray.mask) != 0L) {
            this.genMethodWriteArrayMapping("write", objectClass, writerFeatures, fieldWriters, cw, classNameType);
        } else {
            this.genMethodWrite(objectClass, fieldWriters, cw, classNameType, writerFeatures);
        }
        this.genMethodWriteArrayMappingJSONB(objectClass, writerFeatures, fieldWriters, cw, classNameType, writerFeatures);
        this.genMethodWriteArrayMapping("writeArrayMapping", objectClass, writerFeatures, fieldWriters, cw, classNameType);
        byte[] code = cw.toByteArray();
        Class<?> deserClass = this.classLoader.defineClassPublic(classNameFull, code, 0, code.length);
        try {
            Constructor<?> constructor = deserClass.getConstructor(Class.class, String.class, String.class, Long.TYPE, List.class);
            return (ObjectWriter)constructor.newInstance(objectClass, beanInfo.typeKey, beanInfo.typeName, writerFeatures, fieldWriters);
        }
        catch (Throwable e) {
            throw new JSONException("create objectWriter error, objectType " + objectClass, e);
        }
    }

    private void genMethodWrite(Class objectType, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, long objectFeatures) {
        MethodWriter mw = cw.visitMethod(1, "write", METHOD_DESC_WRITE);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        int COMMA = 7;
        Label json_ = new Label();
        Label jsonb_ = new Label();
        Label notSuper_ = new Label();
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isIgnoreErrorGetter", "()Z", false);
        mw.visitJumpInsn(153, notSuper_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(22, 5);
        mw.visitMethodInsn(183, TYPE_OBJECT_WRITER_ADAPTER, "write", METHOD_DESC_WRITE_OBJECT, false);
        mw.visitInsn(177);
        mw.visitLabel(notSuper_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isJSONB", "()Z", false);
        mw.visitJumpInsn(153, json_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isBeanToArray", "()Z", false);
        mw.visitJumpInsn(153, jsonb_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(22, 5);
        mw.visitMethodInsn(182, classNameType, "writeArrayMappingJSONB", METHOD_DESC_WRITE_OBJECT, false);
        mw.visitInsn(177);
        mw.visitLabel(jsonb_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(22, 5);
        mw.visitMethodInsn(182, classNameType, "writeJSONB", METHOD_DESC_WRITE_OBJECT, false);
        mw.visitInsn(177);
        mw.visitLabel(json_);
        Label checkFilter_ = new Label();
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isBeanToArray", "()Z", false);
        mw.visitJumpInsn(153, checkFilter_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(22, 5);
        mw.visitMethodInsn(182, classNameType, "writeArrayMapping", METHOD_DESC_WRITE_OBJECT, false);
        mw.visitInsn(177);
        mw.visitLabel(checkFilter_);
        Label object_ = new Label();
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, "hasFilter", METHOD_DESC_HAS_FILTER, true);
        mw.visitJumpInsn(153, object_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(22, 5);
        mw.visitMethodInsn(182, classNameType, "writeWithFilter", METHOD_DESC_WRITE_OBJECT, false);
        mw.visitInsn(177);
        mw.visitLabel(object_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "startObject", "()V", false);
        mw.visitInsn(4);
        mw.visitVarInsn(54, 7);
        Label writeFields_ = new Label();
        if ((objectFeatures & JSONWriter.Feature.WriteClassName.mask) == 0L) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 2);
            mw.visitVarInsn(25, 4);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isWriteTypeInfo", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Z", false);
            mw.visitJumpInsn(153, writeFields_);
        }
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, "writeTypeInfo", METHOD_DESC_WRITE_TYPE_INFO, true);
        mw.visitInsn(4);
        mw.visitInsn(130);
        mw.visitVarInsn(54, 7);
        mw.visitLabel(writeFields_);
        MethodWriterContext mwc = new MethodWriterContext(objectType, objectFeatures, classNameType, mw, 8, false);
        mwc.genVariantsMethodBefore();
        for (int i = 0; i < fieldWriters.size(); ++i) {
            FieldWriter fieldWriter = fieldWriters.get(i);
            this.gwFieldValue(mwc, fieldWriter, 2, i);
        }
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "endObject", "()V", false);
        mw.visitInsn(177);
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
        mw.visitEnd();
    }

    private void genMethodWriteJSONB(Class objectType, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, long objectFeatures) {
        MethodWriter mw = cw.visitMethod(1, "writeJSONB", METHOD_DESC_WRITE);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        MethodWriterContext mwc = new MethodWriterContext(objectType, objectFeatures, classNameType, mw, 7, true);
        int entryCnt = fieldWriters.size();
        Label notWriteType = new Label();
        if ((objectFeatures & JSONWriter.Feature.WriteClassName.mask) == 0L) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 2);
            mw.visitVarInsn(25, 4);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isWriteTypeInfo", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Z", false);
            mw.visitJumpInsn(153, notWriteType);
        }
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, classNameType, "writeClassInfo", METHOD_DESC_WRITE_CLASS_INFO, false);
        mw.visitLabel(notWriteType);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "startObject", "()V", false);
        mwc.genVariantsMethodBefore();
        for (int i = 0; i < fieldWriters.size(); ++i) {
            FieldWriter fieldWriter = fieldWriters.get(i);
            this.gwFieldValueJSONB(mwc, fieldWriter, 2, i);
        }
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "endObject", "()V", false);
        mw.visitInsn(177);
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
        mw.visitEnd();
    }

    private void genMethodWriteArrayMappingJSONB(Class objectType, long objectFeatures, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, long features) {
        MethodWriter mw = cw.visitMethod(1, "writeArrayMappingJSONB", METHOD_DESC_WRITE);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        int size = fieldWriters.size();
        mw.visitVarInsn(25, 1);
        if (size >= 128) {
            mw.visitIntInsn(17, size);
        } else {
            mw.visitIntInsn(16, size);
        }
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "startArray", "(I)V", false);
        MethodWriterContext mwc = new MethodWriterContext(objectType, objectFeatures, classNameType, mw, 7, true);
        mwc.genVariantsMethodBefore();
        for (int i = 0; i < size; ++i) {
            this.gwValueJSONB(mwc, fieldWriters.get(i), 2, i, false);
        }
        mw.visitInsn(177);
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
        mw.visitEnd();
    }

    private void gwValueJSONB(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean table) {
        boolean beanToArray;
        long features = fieldWriter.getFeatures() | mwc.objectFeatures;
        Class fieldClass = fieldWriter.getFieldClass();
        boolean bl = beanToArray = (features & JSONWriter.Feature.BeanToArray.mask) != 0L || table;
        if (fieldClass == Boolean.TYPE || fieldClass == boolean[].class || fieldClass == Character.TYPE || fieldClass == char[].class || fieldClass == Byte.TYPE || fieldClass == byte[].class || fieldClass == Short.TYPE || fieldClass == short[].class || fieldClass == Integer.TYPE || fieldClass == int[].class || fieldClass == Long.TYPE || fieldClass == long[].class || fieldClass == Float.TYPE || fieldClass == float[].class || fieldClass == Double.TYPE || fieldClass == double[].class || fieldClass == String.class || fieldClass.isEnum()) {
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == Date.class) {
            this.gwDate(mwc, fieldWriter, OBJECT, i);
        } else if (fieldWriter instanceof FieldWriterList) {
            this.gwListJSONB(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass.isArray()) {
            this.gwObjectA(mwc, fieldWriter, OBJECT, i);
        } else {
            this.gwObjectJSONB(fieldWriter, OBJECT, mwc, i, beanToArray);
        }
    }

    private void gwObjectJSONB(FieldWriter fieldWriter, int OBJECT, MethodWriterContext mwc, int i, boolean beanToArray) {
        boolean refDetection;
        Class fieldClass = fieldWriter.getFieldClass();
        String fieldName = fieldWriter.getFieldName();
        String classNameType = mwc.classNameType;
        MethodWriter mw = mwc.mw;
        int FIELD_VALUE = mwc.var(fieldClass);
        int REF_PATH = mwc.var("REF_PATH");
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNull", "()V", false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(notNull_);
        boolean bl = refDetection = !ObjectWriterProvider.isNotReferenceDetect(fieldClass);
        if (refDetection) {
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "()Z", false);
            mw.visitJumpInsn(153, endDetect_);
            mw.visitVarInsn(25, OBJECT);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitJumpInsn(166, refSetPath_);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn("..");
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitJumpInsn(167, endIfNull_);
            mw.visitLabel(refSetPath_);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn(fieldName);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "setPath", METHOD_DESC_SET_PATH, false);
            mw.visitInsn(89);
            mw.visitVarInsn(58, REF_PATH);
            mw.visitJumpInsn(198, endDetect_);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, REF_PATH);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
            mw.visitJumpInsn(167, endIfNull_);
            mw.visitLabel(endDetect_);
        }
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "getObjectWriter", METHOD_DESC_GET_OBJECT_WRITER, true);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitLdcInsn(fieldName);
        mwc.loadFieldType(i, fieldWriter.getFieldType());
        mw.visitLdcInsn(fieldWriter.getFeatures());
        mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, beanToArray ? "writeJSONB" : "writeArrayMappingJSONB", METHOD_DESC_WRITE_OBJECT, true);
        if (refDetection) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwListJSONB(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type fieldType = fieldWriter.getFieldType();
        Class fieldClass = fieldWriter.getFieldClass();
        String fieldName = fieldWriter.getFieldName();
        String classNameType = mwc.classNameType;
        MethodWriter mw = mwc.mw;
        int LIST = mwc.var(fieldClass);
        int REF_PATH = mwc.var("REF_PATH");
        boolean listStr = false;
        Class<?> itemClass = null;
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 1) {
            Type itemType = actualTypeArguments[0];
            itemClass = TypeUtils.getMapping(itemType);
            listStr = itemType == String.class;
        }
        Label endIfListNull_ = new Label();
        Label listNotNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, LIST);
        mw.visitJumpInsn(199, listNotNull_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNull", "()V", false);
        mw.visitJumpInsn(167, endIfListNull_);
        mw.visitLabel(listNotNull_);
        Label endDetect_ = new Label();
        Label refSetPath_ = new Label();
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "()Z", false);
        mw.visitJumpInsn(153, endDetect_);
        mw.visitVarInsn(25, OBJECT);
        mw.visitVarInsn(25, LIST);
        mw.visitJumpInsn(166, refSetPath_);
        mw.visitVarInsn(25, 1);
        mw.visitLdcInsn("..");
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
        mw.visitJumpInsn(167, endIfListNull_);
        mw.visitLabel(refSetPath_);
        mw.visitVarInsn(25, 1);
        mw.visitLdcInsn(fieldName);
        mw.visitVarInsn(25, LIST);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "setPath", METHOD_DESC_SET_PATH, false);
        mw.visitInsn(89);
        mw.visitVarInsn(58, REF_PATH);
        mw.visitJumpInsn(198, endDetect_);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, REF_PATH);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, LIST);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
        mw.visitJumpInsn(167, endIfListNull_);
        mw.visitLabel(endDetect_);
        int ITEM_CLASS = mwc.var(Class.class);
        int PREVIOUS_CLASS = mwc.var("ITEM_CLASS");
        int ITEM_OBJECT_WRITER = mwc.var("ITEM_OBJECT_WRITER");
        if (!listStr) {
            mw.visitInsn(1);
            mw.visitInsn(89);
            mw.visitVarInsn(58, PREVIOUS_CLASS);
            mw.visitVarInsn(58, ITEM_OBJECT_WRITER);
        }
        if (listStr) {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitInsn(3);
            mw.visitVarInsn(25, LIST);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeListStr", METHOD_DESC_WRITE_LIST, true);
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitInsn(3);
            mw.visitVarInsn(25, LIST);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeList", METHOD_DESC_WRITE_LIST, true);
        }
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, LIST);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
        mw.visitLabel(endIfListNull_);
    }

    private void gwDate(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitInsn(3);
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeDate", METHOD_DESC_WRITE_DATE_WITH_FIELD_NAME, true);
    }

    private void gwValue(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT) {
        String methodDesc;
        String methodName;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        mw.visitVarInsn(25, 1);
        this.genGetObject(mwc, fieldWriter, OBJECT);
        if (fieldClass == Boolean.TYPE) {
            methodName = "writeBool";
            methodDesc = "(Z)V";
        } else if (fieldClass == Character.TYPE) {
            methodName = "writeString";
            methodDesc = "(C)V";
        } else if (fieldClass == Byte.TYPE) {
            methodName = "writeInt32";
            methodDesc = "(I)V";
        } else if (fieldClass == Short.TYPE) {
            methodName = "writeInt32";
            methodDesc = "(I)V";
        } else if (fieldClass == Integer.TYPE) {
            methodName = "writeInt32";
            methodDesc = "(I)V";
        } else if (fieldClass == Long.TYPE) {
            methodName = "writeInt64";
            methodDesc = "(J)V";
        } else if (fieldClass == Float.TYPE) {
            methodName = "writeFloat";
            methodDesc = "(F)V";
        } else if (fieldClass == Double.TYPE) {
            methodName = "writeDouble";
            methodDesc = "(D)V";
        } else if (fieldClass == boolean[].class) {
            methodName = "writeBool";
            methodDesc = "([Z)V";
        } else if (fieldClass == char[].class) {
            methodName = "writeString";
            methodDesc = "([C)V";
        } else if (fieldClass == byte[].class) {
            methodName = "writeBinary";
            methodDesc = "([B)V";
        } else if (fieldClass == short[].class) {
            methodName = "writeInt16";
            methodDesc = "([S)V";
        } else if (fieldClass == int[].class) {
            methodName = "writeInt32";
            methodDesc = "([I)V";
        } else if (fieldClass == long[].class) {
            methodName = "writeInt64";
            methodDesc = "([J)V";
        } else if (fieldClass == float[].class) {
            methodName = "writeFloat";
            methodDesc = "([F)V";
        } else if (fieldClass == double[].class) {
            methodName = "writeDouble";
            methodDesc = "([D)V";
        } else if (fieldClass == String.class) {
            methodName = "writeString";
            methodDesc = METHOD_DESC_WRITE_REFERENCE;
        } else if (Enum.class.isAssignableFrom(fieldClass)) {
            methodName = "writeEnum";
            methodDesc = "(Ljava/lang/Enum;)V";
        } else {
            throw new UnsupportedOperationException();
        }
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, methodName, methodDesc, false);
    }

    private void gwObjectA(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, OBJECT);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeValue", METHOD_DESC_WRITE_VALUE, true);
    }

    private void genMethodWriteArrayMapping(String methodName, Class objectType, long objectFeatures, List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType) {
        MethodWriter mw = cw.visitMethod(1, methodName, METHOD_DESC_WRITE);
        int OBJECT = 2;
        int FIELD_NAME = 3;
        int FIELD_TYPE = 4;
        int FIELD_FEATURES = 5;
        Label jsonb_ = new Label();
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isJSONB", "()Z", false);
        mw.visitJumpInsn(153, jsonb_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(22, 5);
        mw.visitMethodInsn(182, classNameType, "writeArrayMappingJSONB", METHOD_DESC_WRITE_OBJECT, false);
        mw.visitInsn(177);
        mw.visitLabel(jsonb_);
        Label object_ = new Label();
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, "hasFilter", METHOD_DESC_HAS_FILTER, true);
        mw.visitJumpInsn(153, object_);
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(25, 4);
        mw.visitVarInsn(22, 5);
        mw.visitMethodInsn(183, TYPE_OBJECT_WRITER_ADAPTER, methodName, METHOD_DESC_WRITE, false);
        mw.visitInsn(177);
        mw.visitLabel(object_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "startArray", "()V", false);
        MethodWriterContext mwc = new MethodWriterContext(objectType, objectFeatures, classNameType, mw, 7, false);
        for (int i = 0; i < fieldWriters.size(); ++i) {
            if (i != 0) {
                mw.visitVarInsn(25, 1);
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeComma", "()V", false);
            }
            this.gwFieldValueArrayMapping(fieldWriters.get(i), mwc, 2, i);
        }
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "endArray", "()V", false);
        mw.visitInsn(177);
        mw.visitMaxs(mwc.maxVariant + 1, mwc.maxVariant + 1);
        mw.visitEnd();
    }

    private void gwFieldValueArrayMapping(FieldWriter fieldWriter, MethodWriterContext mwc, int OBJECT, int i) {
        Class objectType = mwc.objectClass;
        Class fieldClass = fieldWriter.getFieldClass();
        String TYPE_OBJECT = ASMUtils.type(objectType);
        if (fieldClass == Boolean.TYPE || fieldClass == boolean[].class || fieldClass == Character.TYPE || fieldClass == char[].class || fieldClass == Byte.TYPE || fieldClass == byte[].class || fieldClass == Short.TYPE || fieldClass == short[].class || fieldClass == Integer.TYPE || fieldClass == int[].class || fieldClass == Long.TYPE || fieldClass == long[].class || fieldClass == Float.TYPE || fieldClass == float[].class || fieldClass == Double.TYPE || fieldClass == double[].class || fieldClass == String.class || fieldClass.isEnum()) {
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == Date.class) {
            this.gwDate(mwc, fieldWriter, OBJECT, i);
        } else if (fieldWriter instanceof FieldWriterList) {
            this.gwList(mwc, OBJECT, i, fieldWriter, TYPE_OBJECT);
        } else {
            this.gwObject(mwc, OBJECT, i, fieldWriter, TYPE_OBJECT);
        }
    }

    private void gwObject(MethodWriterContext mwc, int OBJECT, int i, FieldWriter fieldWriter, String TYPE_OBJECT) {
        boolean refDetection;
        Class fieldClass = fieldWriter.getFieldClass();
        String fieldName = fieldWriter.getFieldName();
        MethodWriter mw = mwc.mw;
        int FIELD_VALUE = mwc.var(fieldClass);
        int REF_PATH = mwc.var("REF_PATH");
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNull", "()V", false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(notNull_);
        boolean bl = refDetection = !ObjectWriterProvider.isNotReferenceDetect(fieldClass);
        if (refDetection) {
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "()Z", false);
            mw.visitJumpInsn(153, endDetect_);
            mw.visitVarInsn(25, OBJECT);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitJumpInsn(166, refSetPath_);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn("..");
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitJumpInsn(167, endIfNull_);
            mw.visitLabel(refSetPath_);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn(fieldName);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "setPath", METHOD_DESC_SET_PATH, false);
            mw.visitInsn(89);
            mw.visitVarInsn(58, REF_PATH);
            mw.visitJumpInsn(198, endDetect_);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, REF_PATH);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
            mw.visitJumpInsn(167, endIfNull_);
            mw.visitLabel(endDetect_);
        }
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "getObjectWriter", METHOD_DESC_GET_OBJECT_WRITER, true);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitLdcInsn(fieldWriter.getFieldName());
        mwc.loadFieldType(i, fieldWriter.getFieldType());
        mw.visitLdcInsn(fieldWriter.getFeatures());
        mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, "write", METHOD_DESC_WRITE_OBJECT, true);
        if (refDetection) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwList(MethodWriterContext mwc, int OBJECT, int i, FieldWriter fieldWriter, String TYPE_OBJECT) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        Type fieldType = fieldWriter.getFieldType();
        Class fieldClass = fieldWriter.getFieldClass();
        int LIST = mwc.var(fieldClass);
        MethodWriter mw = mwc.mw;
        boolean listStr = false;
        Class<?> itemClass = null;
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldType).getActualTypeArguments()).length == 1) {
            Type itemType = actualTypeArguments[0];
            itemClass = TypeUtils.getMapping(itemType);
            listStr = itemType == String.class;
        }
        Label endIfListNull_ = new Label();
        Label listNotNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, LIST);
        mw.visitJumpInsn(199, listNotNull_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNull", "()V", false);
        mw.visitJumpInsn(167, endIfListNull_);
        mw.visitLabel(listNotNull_);
        int LIST_SIZE = mwc.var("LIST_SIZE");
        int J = mwc.var("J");
        int ITEM_CLASS = mwc.var(Class.class);
        int PREVIOUS_CLASS = mwc.var("PREVIOUS_CLASS");
        int ITEM_OBJECT_WRITER = mwc.var("ITEM_OBJECT_WRITER");
        if (!listStr) {
            mw.visitInsn(1);
            mw.visitInsn(89);
            mw.visitVarInsn(58, PREVIOUS_CLASS);
            mw.visitVarInsn(58, ITEM_OBJECT_WRITER);
        }
        mw.visitVarInsn(25, LIST);
        mw.visitMethodInsn(185, "java/util/List", "size", "()I", true);
        mw.visitVarInsn(54, LIST_SIZE);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "startArray", "()V", false);
        Label for_start_j_ = new Label();
        Label for_end_j_ = new Label();
        Label for_inc_j_ = new Label();
        Label notFirst_ = new Label();
        mw.visitInsn(3);
        mw.visitVarInsn(54, J);
        mw.visitLabel(for_start_j_);
        mw.visitVarInsn(21, J);
        mw.visitVarInsn(21, LIST_SIZE);
        mw.visitJumpInsn(162, for_end_j_);
        mw.visitVarInsn(21, J);
        mw.visitJumpInsn(153, notFirst_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeComma", "()V", false);
        mw.visitLabel(notFirst_);
        if (listStr) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, LIST);
            mw.visitVarInsn(21, J);
            mw.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
            mw.visitTypeInsn(192, "java/lang/String");
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeString", METHOD_DESC_WRITE_REFERENCE, false);
        } else {
            int ITEM = mwc.var(itemClass);
            Label notNull_ = new Label();
            Label classEQ_ = new Label();
            mw.visitVarInsn(25, LIST);
            mw.visitVarInsn(21, J);
            mw.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
            mw.visitInsn(89);
            mw.visitVarInsn(58, ITEM);
            mw.visitJumpInsn(199, notNull_);
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNull", "()V", false);
            mw.visitJumpInsn(167, for_inc_j_);
            mw.visitLabel(notNull_);
            mw.visitVarInsn(25, ITEM);
            mw.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            mw.visitInsn(89);
            mw.visitVarInsn(58, ITEM_CLASS);
            mw.visitVarInsn(25, PREVIOUS_CLASS);
            mw.visitJumpInsn(165, classEQ_);
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, ITEM_CLASS);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "getItemWriter", METHOD_DESC_GET_ITEM_WRITER, true);
            mw.visitVarInsn(58, ITEM_OBJECT_WRITER);
            mw.visitVarInsn(25, ITEM_CLASS);
            mw.visitVarInsn(58, PREVIOUS_CLASS);
            mw.visitLabel(classEQ_);
            mw.visitVarInsn(25, ITEM_OBJECT_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, ITEM);
            mw.visitVarInsn(21, J);
            mw.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;", false);
            mwc.loadFieldType(i, fieldType);
            mw.visitLdcInsn(fieldWriter.getFeatures());
            mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, "write", METHOD_DESC_WRITE_OBJECT, true);
        }
        mw.visitLabel(for_inc_j_);
        mw.visitIincInsn(J, 1);
        mw.visitJumpInsn(167, for_start_j_);
        mw.visitLabel(for_end_j_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "endArray", "()V", false);
        mw.visitLabel(endIfListNull_);
    }

    private void gwFieldValue(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        if (fieldClass == Boolean.TYPE) {
            this.gwFieldValueBooleanV(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == boolean[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Character.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == char[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Byte.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == byte[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Short.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == short[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Integer.TYPE) {
            this.gwFieldValueInt32V(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == int[].class) {
            this.gwFieldValueIntVA(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == Long.TYPE) {
            this.gwFieldValueInt64V(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == long[].class) {
            this.gwFieldValueInt64VA(mwc, fieldWriter, OBJECT, i, false);
        } else if (fieldClass == Float.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == float[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Double.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == double[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Integer.class) {
            this.gwInt32(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Long.class) {
            this.gwInt64(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == String.class) {
            this.gwFieldValueString(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass.isEnum() && BeanUtils.getEnumValueField(fieldClass) == null && !(fieldWriter instanceof FieldWriterObject)) {
            this.gwFieldValueEnum(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Date.class) {
            this.gwFieldValueDate(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == List.class) {
            this.gwFieldValueList(mwc, fieldWriter, OBJECT, i);
        } else {
            this.gwFieldValueObject(mwc, fieldWriter, OBJECT, i);
        }
    }

    private void gwFieldValueEnum(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        Class fieldClass = fieldWriter.getFieldClass();
        MethodWriter mw = mwc.mw;
        int FIELD_VALUE = mwc.var(fieldClass);
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        Label null_ = new Label();
        Label notNull_ = new Label();
        mw.visitJumpInsn(198, null_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeEnum", METHOD_DESC_WRITE_ENUM, true);
        mw.visitJumpInsn(167, notNull_);
        mw.visitLabel(null_);
        mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
        mw.visitJumpInsn(153, notNull_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNull", "()V", false);
        mw.visitLabel(notNull_);
    }

    private void gwFieldValueObject(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        Class fieldClass = fieldWriter.getFieldClass();
        Type fieldType = fieldWriter.getFieldType();
        String fieldName = fieldWriter.getFieldName();
        boolean refDetection = !ObjectWriterProvider.isNotReferenceDetect(fieldClass);
        int FIELD_VALUE = mwc.var(fieldClass);
        Integer REF_PATH = null;
        if (refDetection) {
            REF_PATH = mwc.var("REF_PATH");
        }
        long features = fieldWriter.getFeatures() | mwc.objectFeatures;
        MethodWriter mw = mwc.mw;
        Label null_ = new Label();
        Label notNull_ = new Label();
        if (fieldWriter.unwrapped()) {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, OBJECT);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "write", METHOD_DESC_FIELD_WRITE_OBJECT, true);
            mw.visitInsn(87);
            mw.visitJumpInsn(167, notNull_);
        }
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(198, null_);
        if (!fieldWriter.isFieldClassSerializable()) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isIgnoreNoneSerializable", "()Z", false);
            mw.visitJumpInsn(154, notNull_);
        }
        if (refDetection) {
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            int REF_DETECT = mwc.var("REF_DETECT");
            mw.visitVarInsn(25, 1);
            if (fieldClass == Object.class) {
                mw.visitVarInsn(25, FIELD_VALUE);
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "(Ljava/lang/Object;)Z", false);
            } else {
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "()Z", false);
            }
            mw.visitInsn(89);
            mw.visitVarInsn(54, REF_DETECT);
            mw.visitJumpInsn(153, endDetect_);
            mw.visitVarInsn(25, OBJECT);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitJumpInsn(166, refSetPath_);
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn("..");
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitJumpInsn(167, notNull_);
            mw.visitLabel(refSetPath_);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn(fieldName);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "setPath", METHOD_DESC_SET_PATH, false);
            mw.visitInsn(89);
            mw.visitVarInsn(58, REF_PATH);
            mw.visitJumpInsn(198, endDetect_);
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, REF_PATH);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
            mw.visitJumpInsn(167, notNull_);
            mw.visitLabel(endDetect_);
        }
        if (Object[].class.isAssignableFrom(fieldClass)) {
            Label notWriteEmptyArrayEnd_ = new Label();
            mwc.genIsEnabled(JSONWriter.Feature.NotWriteEmptyArray.mask, notWriteEmptyArrayEnd_);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitTypeInsn(192, "[Ljava/lang/Object;");
            mw.visitInsn(190);
            mw.visitJumpInsn(154, notWriteEmptyArrayEnd_);
            mw.visitJumpInsn(167, notNull_);
            mw.visitLabel(notWriteEmptyArrayEnd_);
        }
        this.gwFieldName(mwc, i);
        if (fieldClass == BigDecimal.class) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            if (features == 0L) {
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeDecimal", "(Ljava/math/BigDecimal;)V", false);
            } else {
                mw.visitLdcInsn(features);
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeDecimal", "(Ljava/math/BigDecimal;J)V", false);
            }
        } else if (fieldClass == BigInteger.class) {
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            if (features == 0L) {
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeBigInt", "(Ljava/math/BigInteger;)V", false);
            } else {
                mw.visitLdcInsn(features);
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeBigInt", "(Ljava/math/BigInteger;J)V", false);
            }
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "getObjectWriter", METHOD_DESC_GET_OBJECT_WRITER, true);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitLdcInsn(fieldName);
            mwc.loadFieldType(i, fieldType);
            mw.visitLdcInsn(features);
            mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, (features & JSONWriter.Feature.BeanToArray.mask) != 0L ? "writeArrayMapping" : "write", METHOD_DESC_WRITE_OBJECT, true);
        }
        mw.visitJumpInsn(167, notNull_);
        if (refDetection) {
            int REF_DETECT = mwc.var("REF_DETECT");
            Label endDetect_ = new Label();
            mw.visitVarInsn(21, REF_DETECT);
            mw.visitJumpInsn(153, endDetect_);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
            mw.visitLabel(endDetect_);
        }
        mw.visitLabel(null_);
        if ((features & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            long nullFeatures = JSONWriter.Feature.WriteNulls.mask;
            if (fieldClass == AtomicLongArray.class || fieldClass == AtomicIntegerArray.class || Collection.class.isAssignableFrom(fieldClass) || fieldClass.isArray()) {
                nullFeatures |= JSONWriter.Feature.WriteNullListAsEmpty.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            } else if (Number.class.isAssignableFrom(fieldClass)) {
                nullFeatures |= JSONWriter.Feature.WriteNullNumberAsZero.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            } else if (fieldClass == Boolean.class) {
                nullFeatures |= JSONWriter.Feature.WriteNullBooleanAsFalse.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            } else if (fieldClass == String.class) {
                nullFeatures |= JSONWriter.Feature.WriteNullStringAsEmpty.mask;
                nullFeatures |= JSONWriter.Feature.NullAsDefaultValue.mask;
            }
            mwc.genIsEnabled(nullFeatures, notNull_);
        }
        this.gwFieldName(mwc, i);
        String WRITE_NULL_METHOD = fieldClass == AtomicLongArray.class || fieldClass == AtomicIntegerArray.class || Collection.class.isAssignableFrom(fieldClass) || fieldClass.isArray() ? "writeArrayNull" : (Number.class.isAssignableFrom(fieldClass) ? "writeNumberNull" : (fieldClass == Boolean.class ? "writeBooleanNull" : (fieldClass == String.class ? "writeStringNull" : "writeNull")));
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, WRITE_NULL_METHOD, "()V", false);
        mw.visitLabel(notNull_);
    }

    private void gwFieldValueList(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        Type fieldType = fieldWriter.getFieldType();
        Class fieldClass = fieldWriter.getFieldClass();
        String fieldName = fieldWriter.getFieldName();
        MethodWriter mw = mwc.mw;
        int LIST = mwc.var(fieldClass);
        int REF_PATH = mwc.var("REF_PATH");
        boolean listStr = false;
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldType;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            listStr = actualTypeArguments.length == 1 && actualTypeArguments[0] == String.class;
        }
        int FIELD_VALUE = mwc.var(fieldClass);
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        Label null_ = new Label();
        Label notNull_ = new Label();
        mw.visitJumpInsn(198, null_);
        Label endDetect_ = new Label();
        Label refSetPath_ = new Label();
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "()Z", false);
        mw.visitJumpInsn(153, endDetect_);
        mw.visitVarInsn(25, OBJECT);
        mw.visitVarInsn(25, LIST);
        mw.visitJumpInsn(166, refSetPath_);
        mw.visitVarInsn(25, 1);
        mw.visitLdcInsn("..");
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
        mw.visitJumpInsn(167, notNull_);
        mw.visitLabel(refSetPath_);
        mw.visitVarInsn(25, 1);
        mw.visitLdcInsn(fieldName);
        mw.visitVarInsn(25, LIST);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "setPath", METHOD_DESC_SET_PATH, false);
        mw.visitInsn(89);
        mw.visitVarInsn(58, REF_PATH);
        mw.visitJumpInsn(198, endDetect_);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, REF_PATH);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, LIST);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
        mw.visitJumpInsn(167, notNull_);
        mw.visitLabel(endDetect_);
        Label notWriteEmptyArrayEnd_ = new Label();
        mwc.genIsEnabled(JSONWriter.Feature.NotWriteEmptyArray.mask, notWriteEmptyArrayEnd_);
        mw.visitVarInsn(25, LIST);
        mw.visitMethodInsn(185, "java/util/Collection", "isEmpty", "()Z", true);
        mw.visitJumpInsn(153, notWriteEmptyArrayEnd_);
        mw.visitJumpInsn(167, notNull_);
        mw.visitLabel(notWriteEmptyArrayEnd_);
        if (listStr) {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitInsn(4);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeListStr", METHOD_DESC_WRITE_LIST, true);
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitInsn(4);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeList", METHOD_DESC_WRITE_LIST, true);
        }
        mw.visitJumpInsn(167, notNull_);
        mw.visitLabel(null_);
        mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
        mw.visitJumpInsn(153, notNull_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeArrayNull", "()V", false);
        mw.visitLabel(notNull_);
    }

    private void gwFieldValueJSONB(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        Class objectType = mwc.objectClass;
        Class fieldClass = fieldWriter.getFieldClass();
        if (fieldClass == Boolean.TYPE) {
            this.gwFieldValueBooleanV(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == boolean[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Character.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == char[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Byte.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == byte[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Short.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == short[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Integer.TYPE) {
            this.gwFieldValueInt32V(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == int[].class) {
            this.gwFieldValueIntVA(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == Long.TYPE) {
            this.gwFieldValueInt64V(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == long[].class) {
            this.gwFieldValueInt64VA(mwc, fieldWriter, OBJECT, i, true);
        } else if (fieldClass == Float.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == float[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Double.TYPE) {
            this.gwFieldName(mwc, i);
            this.gwValue(mwc, fieldWriter, OBJECT);
        } else if (fieldClass == double[].class) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Integer.class) {
            this.gwInt32(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Long.class) {
            this.gwInt64(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == String.class) {
            this.gwFieldValueString(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass.isEnum()) {
            this.gwFieldValueArray(mwc, fieldWriter, OBJECT, i);
        } else if (fieldClass == Date.class) {
            this.gwFieldValueDate(mwc, fieldWriter, OBJECT, i);
        } else {
            this.gwFieldValueObjectJSONB(mwc, fieldWriter, OBJECT, i);
        }
    }

    private void gwInt32(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean jsonb = mwc.jsonb;
        String classNameType = mwc.classNameType;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
        mw.visitJumpInsn(154, writeNullValue_);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(writeNullValue_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNumberNull", "()V", false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(notNull_);
        if (jsonb) {
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeInt32", "(I)V", false);
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeInt32", METHOD_DESC_WRITE_I, true);
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwInt64(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean jsonb = mwc.jsonb;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
        mw.visitJumpInsn(154, writeNullValue_);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(writeNullValue_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNumberNull", "()V", false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(notNull_);
        if (jsonb) {
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeInt64", "(J)V", false);
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeInt64", METHOD_DESC_WRITE_J, true);
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueObjectJSONB(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        String fieldName = fieldWriter.getFieldName();
        boolean refDetection = !ObjectWriterProvider.isNotReferenceDetect(fieldClass);
        int FIELD_VALUE = mwc.var(fieldClass);
        Integer REF_PATH = null;
        if (refDetection) {
            REF_PATH = mwc.var("REF_PATH");
        }
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(198, endIfNull_);
        if (!fieldWriter.isFieldClassSerializable()) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isIgnoreNoneSerializable", "()Z", false);
            mw.visitJumpInsn(154, endIfNull_);
        }
        if (refDetection) {
            Label endDetect_ = new Label();
            Label refSetPath_ = new Label();
            int REF_DETECT = mwc.var("REF_DETECT");
            mw.visitVarInsn(25, 1);
            if (fieldClass == Object.class) {
                mw.visitVarInsn(25, FIELD_VALUE);
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "(Ljava/lang/Object;)Z", false);
            } else {
                mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isRefDetect", "()Z", false);
            }
            mw.visitInsn(89);
            mw.visitVarInsn(54, REF_DETECT);
            mw.visitJumpInsn(153, endDetect_);
            mw.visitVarInsn(25, OBJECT);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitJumpInsn(166, refSetPath_);
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn("..");
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitJumpInsn(167, endIfNull_);
            mw.visitLabel(refSetPath_);
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn(fieldName);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "setPath", METHOD_DESC_SET_PATH, false);
            mw.visitInsn(89);
            mw.visitVarInsn(58, REF_PATH);
            mw.visitJumpInsn(198, endDetect_);
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, REF_PATH);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeReference", METHOD_DESC_WRITE_REFERENCE, false);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
            mw.visitJumpInsn(167, endIfNull_);
            mw.visitLabel(endDetect_);
        }
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "getObjectWriter", METHOD_DESC_GET_OBJECT_WRITER, true);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitLdcInsn(fieldName);
        mwc.loadFieldType(i, fieldWriter.getFieldType());
        mw.visitLdcInsn(fieldWriter.getFeatures());
        mw.visitMethodInsn(185, TYPE_OBJECT_WRITER, "writeJSONB", METHOD_DESC_WRITE_OBJECT, true);
        if (refDetection) {
            int REF_DETECT = mwc.var("REF_DETECT");
            Label endDetect_ = new Label();
            mw.visitVarInsn(21, REF_DETECT);
            mw.visitJumpInsn(153, endDetect_);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "popPath", "(Ljava/lang/Object;)V", false);
            mw.visitLabel(endDetect_);
        }
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueDate(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean jsonb = mwc.jsonb;
        MethodWriter mw = mwc.mw;
        Type fieldType = fieldWriter.getFieldType();
        Class fieldClass = fieldWriter.getFieldClass();
        Member member = fieldWriter.getFieldOrMethod();
        String fieldName = fieldWriter.getFieldName();
        String format = fieldWriter.getFormat();
        Label null_ = new Label();
        Label writeNull_ = new Label();
        Label endIfNull_ = new Label();
        int FIELD_VALUE = mwc.var(fieldClass);
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(198, null_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitMethodInsn(182, "java/util/Date", "getTime", "()J", false);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeDate", METHOD_DESC_WRITE_J, true);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(null_);
        mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
        mw.visitJumpInsn(154, writeNull_);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(writeNull_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeNull", "()V", false);
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueArray(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        String methodDesc;
        String methodName;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        if (fieldClass == char[].class) {
            methodName = "writeString";
            methodDesc = METHOD_DESC_WRITE_CArray;
        } else if (fieldClass == boolean[].class) {
            methodName = "writeBool";
            methodDesc = METHOD_DESC_WRITE_ZARRAY;
        } else if (fieldClass == byte[].class) {
            methodName = "writeBinary";
            methodDesc = METHOD_DESC_WRITE_BArray;
        } else if (fieldClass == short[].class) {
            methodName = "writeInt16";
            methodDesc = METHOD_DESC_WRITE_SArray;
        } else if (fieldClass == float[].class) {
            methodName = "writeFloat";
            methodDesc = METHOD_DESC_WRITE_FARRAY;
        } else if (fieldClass == double[].class) {
            methodName = "writeDouble";
            methodDesc = METHOD_DESC_WRITE_DARRAY;
        } else if (fieldClass.isEnum()) {
            methodName = "writeEnumJSONB";
            methodDesc = METHOD_DESC_WRITE_ENUM;
        } else {
            throw new UnsupportedOperationException();
        }
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, mwc.classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, methodName, methodDesc, true);
    }

    private void gwFieldName(MethodWriterContext mwc, int i) {
        MethodWriter mw = mwc.mw;
        String classNameType = mwc.classNameType;
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeFieldName", METHOD_DESC_WRITE_FIELD_NAME, true);
    }

    private void gwFieldValueInt64VA(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
        mw.visitJumpInsn(154, writeNullValue_);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(writeNullValue_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeArrayNull", "()V", false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(notNull_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeInt64", "([J)V", false);
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueInt64V(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        String format = fieldWriter.getFormat();
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(Long.TYPE);
        int WRITE_DEFAULT_VALUE = mwc.var(NOT_WRITE_DEFAULT_VALUE);
        Label notDefaultValue_ = new Label();
        Label endWriteValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(92);
        mw.visitVarInsn(55, FIELD_VALUE);
        mw.visitInsn(9);
        mw.visitInsn(148);
        mw.visitJumpInsn(154, notDefaultValue_);
        mw.visitVarInsn(21, WRITE_DEFAULT_VALUE);
        mw.visitJumpInsn(153, notDefaultValue_);
        mw.visitJumpInsn(167, endWriteValue_);
        mw.visitLabel(notDefaultValue_);
        if (jsonb) {
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(22, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeInt64", "(J)V", false);
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(22, FIELD_VALUE);
            if ("iso8601".equals(format)) {
                mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeDate", METHOD_DESC_WRITE_J, true);
            } else {
                mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeInt64", METHOD_DESC_WRITE_J, true);
            }
        }
        mw.visitLabel(endWriteValue_);
    }

    void gwFieldValueIntVA(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        int FIELD_VALUE = mwc.var(fieldClass);
        Label endIfNull_ = new Label();
        Label notNull_ = new Label();
        Label writeNullValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(199, notNull_);
        mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
        mw.visitJumpInsn(154, writeNullValue_);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(writeNullValue_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeArrayNull", "()V", false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(notNull_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeInt32", "([I)V", false);
        mw.visitLabel(endIfNull_);
    }

    private void gwFieldValueInt32V(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        String format = fieldWriter.getFormat();
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(Integer.TYPE);
        Integer WRITE_DEFAULT_VALUE = mwc.var(NOT_WRITE_DEFAULT_VALUE);
        Label notDefaultValue_ = new Label();
        Label endWriteValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(54, FIELD_VALUE);
        mw.visitJumpInsn(154, notDefaultValue_);
        mw.visitVarInsn(21, WRITE_DEFAULT_VALUE);
        mw.visitJumpInsn(153, notDefaultValue_);
        mw.visitJumpInsn(167, endWriteValue_);
        mw.visitLabel(notDefaultValue_);
        if ("string".equals(format)) {
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(21, FIELD_VALUE);
            mw.visitMethodInsn(184, "java/lang/Integer", "toString", "(I)Ljava/lang/String;", false);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeString", METHOD_DESC_WRITE_REFERENCE, false);
        } else if (jsonb) {
            this.gwFieldName(mwc, i);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(21, FIELD_VALUE);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeInt32", "(I)V", false);
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(21, FIELD_VALUE);
            mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeInt32", METHOD_DESC_WRITE_I, true);
        }
        mw.visitLabel(endWriteValue_);
    }

    private void gwFieldValueBooleanV(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i, boolean jsonb) {
        MethodWriter mw = mwc.mw;
        String classNameType = mwc.classNameType;
        int FIELD_VALUE = mwc.var(Boolean.TYPE);
        int WRITE_DEFAULT_VALUE = mwc.var(NOT_WRITE_DEFAULT_VALUE);
        Label notDefaultValue_ = new Label();
        Label endWriteValue_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(54, FIELD_VALUE);
        mw.visitJumpInsn(154, notDefaultValue_);
        mw.visitVarInsn(21, WRITE_DEFAULT_VALUE);
        mw.visitJumpInsn(153, notDefaultValue_);
        mw.visitJumpInsn(167, endWriteValue_);
        mw.visitLabel(notDefaultValue_);
        mw.visitVarInsn(25, 0);
        mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(21, FIELD_VALUE);
        mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "writeBool", METHOD_DESC_WRITE_Z, true);
        mw.visitLabel(endWriteValue_);
    }

    private void gwFieldValueString(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT, int i) {
        boolean jsonb = mwc.jsonb;
        long features = fieldWriter.getFeatures() | mwc.objectFeatures;
        MethodWriter mw = mwc.mw;
        Class fieldClass = fieldWriter.getFieldClass();
        String format = fieldWriter.getFormat();
        int FIELD_VALUE = mwc.var(fieldClass);
        Label null_ = new Label();
        Label endIfNull_ = new Label();
        this.genGetObject(mwc, fieldWriter, OBJECT);
        mw.visitInsn(89);
        mw.visitVarInsn(58, FIELD_VALUE);
        mw.visitJumpInsn(198, null_);
        this.gwFieldName(mwc, i);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, FIELD_VALUE);
        if ("trim".equals(format)) {
            mw.visitMethodInsn(182, "java/lang/String", "trim", "()Ljava/lang/String;", false);
        }
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, jsonb && "symbol".equals(format) ? "writeSymbol" : "writeString", METHOD_DESC_WRITE_REFERENCE, false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(null_);
        Label writeNullValue_ = new Label();
        Label writeNull_ = new Label();
        long defaultValueMask = JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask | JSONWriter.Feature.WriteNullBooleanAsFalse.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask;
        if ((features & (JSONWriter.Feature.WriteNulls.mask | defaultValueMask)) == 0L) {
            mw.visitVarInsn(21, mwc.var(WRITE_NULLS));
            mw.visitJumpInsn(154, writeNull_);
            mw.visitJumpInsn(167, endIfNull_);
        }
        mw.visitLabel(writeNull_);
        this.gwFieldName(mwc, i);
        if ((features & defaultValueMask) == 0L) {
            long mask = JSONWriter.Feature.NullAsDefaultValue.mask;
            if (fieldClass == String.class) {
                mask |= JSONWriter.Feature.WriteNullStringAsEmpty.mask;
            } else if (fieldClass == Boolean.class) {
                mask |= JSONWriter.Feature.WriteNullBooleanAsFalse.mask;
            } else if (Number.class.isAssignableFrom(fieldClass)) {
                mask |= JSONWriter.Feature.WriteNullNumberAsZero.mask;
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                mask |= JSONWriter.Feature.WriteNullListAsEmpty.mask;
            }
            mw.visitVarInsn(25, 1);
            mw.visitLdcInsn(mask);
            mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isEnabled", "(J)Z", false);
            mw.visitJumpInsn(153, writeNullValue_);
        }
        mw.visitVarInsn(25, 1);
        mw.visitLdcInsn("");
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeString", METHOD_DESC_WRITE_REFERENCE, false);
        mw.visitJumpInsn(167, endIfNull_);
        mw.visitLabel(writeNullValue_);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(182, TYPE_JSON_WRITER, "writeStringNull", "()V", false);
        mw.visitLabel(endIfNull_);
    }

    private void genMethodInit(List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType) {
        MethodWriter mw = cw.visitMethod(1, "<init>", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;JLjava/util/List;)V");
        mw.visitVarInsn(25, 0);
        mw.visitVarInsn(25, 1);
        mw.visitVarInsn(25, 2);
        mw.visitVarInsn(25, 3);
        mw.visitVarInsn(22, 4);
        mw.visitVarInsn(25, 6);
        mw.visitMethodInsn(183, TYPE_OBJECT_WRITER_ADAPTER, "<init>", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;JLjava/util/List;)V", false);
        for (int i = 0; i < fieldWriters.size(); ++i) {
            Type fieldType = fieldWriters.get(i).getFieldType();
            mw.visitVarInsn(25, 0);
            mw.visitInsn(89);
            mw.visitFieldInsn(180, TYPE_OBJECT_WRITER_ADAPTER, "fieldWriterArray", DESC_FIELD_WRITER_ARRAY);
            switch (i) {
                case 0: {
                    mw.visitInsn(3);
                    break;
                }
                case 1: {
                    mw.visitInsn(4);
                    break;
                }
                case 2: {
                    mw.visitInsn(5);
                    break;
                }
                case 3: {
                    mw.visitInsn(6);
                    break;
                }
                case 4: {
                    mw.visitInsn(7);
                    break;
                }
                case 5: {
                    mw.visitInsn(8);
                    break;
                }
                default: {
                    if (i >= 128) {
                        mw.visitIntInsn(17, i);
                        break;
                    }
                    mw.visitIntInsn(16, i);
                }
            }
            mw.visitInsn(50);
            mw.visitTypeInsn(192, TYPE_FIELD_WRITER);
            mw.visitFieldInsn(181, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
        }
        mw.visitInsn(177);
        mw.visitMaxs(7, 7);
        mw.visitEnd();
    }

    private void genFields(List<FieldWriter> fieldWriters, ClassWriter cw) {
        for (int i = 0; i < fieldWriters.size(); ++i) {
            cw.visitField(1, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER).visitEnd();
        }
    }

    @Override
    public <T> FieldWriter<T> createFieldWriter(String fieldName, int ordinal, long features, String format, String label, Field field, ObjectWriter initObjectWriter) {
        Member enumValueField;
        Class<?> declaringClass = field.getDeclaringClass();
        if (!declaringClass.getName().startsWith("java.lang")) {
            field.setAccessible(true);
        }
        Class<Object> fieldClass = field.getType();
        Class fieldType = field.getGenericType();
        if (initObjectWriter != null) {
            if (fieldClass == Byte.TYPE) {
                fieldClass = Byte.class;
                fieldType = Byte.class;
            } else if (fieldClass == Short.TYPE) {
                fieldClass = Short.class;
                fieldType = Short.class;
            } else if (fieldClass == Integer.TYPE) {
                fieldClass = Integer.class;
                fieldType = Integer.class;
            } else if (fieldClass == Long.TYPE) {
                fieldClass = Long.class;
                fieldType = Long.class;
            } else if (fieldClass == Float.TYPE) {
                fieldClass = Float.class;
                fieldType = Float.class;
            } else if (fieldClass == Double.TYPE) {
                fieldClass = Double.class;
                fieldType = Double.class;
            } else if (fieldClass == Boolean.TYPE) {
                fieldClass = Boolean.class;
                fieldType = Boolean.class;
            }
            FieldWriterObjectField objImp = new FieldWriterObjectField(fieldName, ordinal, features, format, label, (Type)((Object)fieldType), fieldClass, field);
            objImp.initValueClass = fieldClass;
            if (initObjectWriter != ObjectWriterBaseModule.VoidObjectWriter.INSTANCE) {
                objImp.initObjectWriter = initObjectWriter;
            }
            return objImp;
        }
        if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            return new FieldWriterBooleanField(fieldName, ordinal, features, format, label, field, fieldClass);
        }
        if (fieldClass == Byte.TYPE) {
            return new FieldWriterInt8ValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Short.TYPE) {
            return new FieldWriterInt16ValField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Integer.TYPE) {
            if (JDKUtils.UNSAFE_SUPPORT) {
                return new FieldWriterInt32ValUF(fieldName, ordinal, features, format, label, field);
            }
            return new FieldWriterInt32Val(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Long.TYPE) {
            if (format == null || format.isEmpty()) {
                return new FieldWriterInt64ValField(fieldName, ordinal, features, format, label, field);
            }
            return new FieldWriterMillisField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Float.TYPE) {
            return new FieldWriterFloatValField(fieldName, ordinal, format, label, field);
        }
        if (fieldClass == Double.TYPE) {
            return new FieldWriterDoubleValField(fieldName, ordinal, format, label, field);
        }
        if (fieldClass == Character.TYPE) {
            return new FieldWriterCharValField(fieldName, ordinal, format, label, field);
        }
        if (fieldClass == Integer.class) {
            return new FieldWriterInt32Field(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Long.class) {
            return new FieldWriterInt64Field(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Short.class) {
            return new FieldWriterInt16Field(fieldName, ordinal, features, format, label, field, fieldClass);
        }
        if (fieldClass == Byte.class) {
            return new FieldWriterInt8Field(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldWriterBigIntField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldWriterBigDecimalField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == Date.class) {
            if (format != null && (format = format.trim()).isEmpty()) {
                format = null;
            }
            return new FieldWriterDateField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass == String.class) {
            return new FieldWriterStringField(fieldName, ordinal, features, format, label, field);
        }
        if (fieldClass.isEnum() && (enumValueField = BeanUtils.getEnumValueField(fieldClass)) == null) {
            return new FIeldWriterEnumField(fieldName, ordinal, features, format, label, fieldClass, field);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            Type itemType = null;
            if (fieldType instanceof ParameterizedType) {
                itemType = ((ParameterizedType)((Object)fieldType)).getActualTypeArguments()[0];
            }
            return new FieldWriterListField(fieldName, itemType, ordinal, features, format, label, (Type)((Object)fieldType), fieldClass, field);
        }
        if (fieldClass.isArray()) {
            boolean base64;
            Class<?> itemClass = fieldClass.getComponentType();
            if (declaringClass == Throwable.class && "stackTrace".equals(fieldName)) {
                try {
                    Method method = Throwable.class.getMethod("getStackTrace", new Class[0]);
                    return new FieldWriterObjectArrayMethod(fieldName, itemClass, ordinal, features, format, label, (Type)((Object)fieldType), fieldClass, method);
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
            }
            boolean bl = base64 = fieldClass == byte[].class && "base64".equals(format);
            if (!base64) {
                return new FieldWriterObjectArrayField(fieldName, itemClass, ordinal, features, format, label, (Type)((Object)fieldType), fieldClass, field);
            }
        }
        return new FieldWriterObjectFieldUF(fieldName, ordinal, features, format, label, field.getGenericType(), fieldClass, field);
    }

    void genGetObject(MethodWriterContext mwc, FieldWriter fieldWriter, int OBJECT) {
        String methodDes;
        String methodName;
        MethodWriter mw = mwc.mw;
        Class objectClass = mwc.objectClass;
        String TYPE_OBJECT = ASMUtils.type(objectClass);
        Class fieldClass = fieldWriter.getFieldClass();
        Member member = fieldWriter.getFieldOrMethod();
        if (member instanceof Method) {
            mw.visitVarInsn(25, OBJECT);
            mw.visitTypeInsn(192, TYPE_OBJECT);
            mw.visitMethodInsn(182, TYPE_OBJECT, member.getName(), "()" + ASMUtils.desc(fieldClass), false);
            return;
        }
        if (Modifier.isPublic(objectClass.getModifiers()) && Modifier.isPublic(member.getModifiers()) && !this.classLoader.isExternalClass(objectClass)) {
            mw.visitVarInsn(25, OBJECT);
            mw.visitTypeInsn(192, TYPE_OBJECT);
            mw.visitFieldInsn(180, TYPE_OBJECT, member.getName(), ASMUtils.desc(fieldClass));
            return;
        }
        Field field = (Field)member;
        String castToType = null;
        if (fieldClass == Integer.TYPE) {
            methodName = "getInt";
            methodDes = "(Ljava/lang/Object;J)I";
        } else if (fieldClass == Long.TYPE) {
            methodName = "getLong";
            methodDes = "(Ljava/lang/Object;J)J";
        } else if (fieldClass == Float.TYPE) {
            methodName = "getFloat";
            methodDes = "(Ljava/lang/Object;J)F";
        } else if (fieldClass == Double.TYPE) {
            methodName = "getDouble";
            methodDes = "(Ljava/lang/Object;J)D";
        } else if (fieldClass == Character.TYPE) {
            methodName = "getChar";
            methodDes = "(Ljava/lang/Object;J)C";
        } else if (fieldClass == Byte.TYPE) {
            methodName = "getByte";
            methodDes = "(Ljava/lang/Object;J)B";
        } else if (fieldClass == Short.TYPE) {
            methodName = "getShort";
            methodDes = "(Ljava/lang/Object;J)S";
        } else if (fieldClass == Boolean.TYPE) {
            methodName = "getBoolean";
            methodDes = "(Ljava/lang/Object;J)Z";
        } else {
            methodName = "getObject";
            methodDes = "(Ljava/lang/Object;J)Ljava/lang/Object;";
            if (fieldClass.isEnum()) {
                castToType = "java/lang/Enum";
            } else if (ObjectWriterProvider.isPrimitiveOrEnum(fieldClass)) {
                castToType = ASMUtils.type(fieldClass);
            } else if (fieldClass.isArray() && ObjectWriterProvider.isPrimitiveOrEnum(fieldClass.getComponentType())) {
                castToType = ASMUtils.type(fieldClass);
            } else if (Map.class.isAssignableFrom(fieldClass)) {
                castToType = "java/util/Map";
            } else if (List.class.isAssignableFrom(fieldClass)) {
                castToType = "java/util/List";
            } else if (Collection.class.isAssignableFrom(fieldClass)) {
                castToType = "java/util/Collection";
            }
        }
        mw.visitFieldInsn(178, ObjectWriterCreatorASMUtils.TYPE_UNSAFE_UTILS, "UNSAFE", "Lsun/misc/Unsafe;");
        mw.visitVarInsn(25, OBJECT);
        mw.visitLdcInsn(UnsafeUtils.objectFieldOffset(field));
        mw.visitMethodInsn(182, "sun/misc/Unsafe", methodName, methodDes, false);
        if (castToType != null) {
            mw.visitTypeInsn(192, castToType);
        }
    }

    private void genGetFieldReader(List<FieldWriter> fieldWriters, ClassWriter cw, String classNameType, ObjectWriterAdapter objectReaderAdapter) {
        MethodWriter mw = cw.visitMethod(1, "getFieldWriter", "(J)" + DESC_FIELD_WRITER);
        boolean HASH_CODE_64 = true;
        int HASH_CODE_32 = 3;
        Label rtnlt = new Label();
        if (fieldWriters.size() <= 6) {
            for (int i = 0; i < fieldWriters.size(); ++i) {
                Label next_ = new Label();
                Label get_ = new Label();
                String fieldName = fieldWriters.get(i).getFieldName();
                long hashCode64 = Fnv.hashCode64(fieldName);
                mw.visitVarInsn(22, 1);
                mw.visitLdcInsn(hashCode64);
                mw.visitInsn(148);
                mw.visitJumpInsn(154, next_);
                mw.visitLabel(get_);
                mw.visitVarInsn(25, 0);
                mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(i), DESC_FIELD_WRITER);
                mw.visitJumpInsn(167, rtnlt);
                mw.visitLabel(next_);
            }
            mw.visitInsn(1);
            mw.visitInsn(176);
        } else {
            int i;
            TreeMap<Integer, ArrayList<Long>> map = new TreeMap<Integer, ArrayList<Long>>();
            for (int i2 = 0; i2 < objectReaderAdapter.hashCodes.length; ++i2) {
                long hashCode64 = objectReaderAdapter.hashCodes[i2];
                int hashCode32 = (int)(hashCode64 ^ hashCode64 >>> 32);
                ArrayList<Long> hashCode64List = (ArrayList<Long>)map.get(hashCode32);
                if (hashCode64List == null) {
                    hashCode64List = new ArrayList<Long>();
                    map.put(hashCode32, hashCode64List);
                }
                hashCode64List.add(hashCode64);
            }
            int[] hashCode32Keys = new int[map.size()];
            int off = 0;
            for (Integer key : map.keySet()) {
                hashCode32Keys[off++] = key;
            }
            Arrays.sort(hashCode32Keys);
            mw.visitVarInsn(22, 1);
            mw.visitVarInsn(22, 1);
            mw.visitVarInsn(16, 32);
            mw.visitInsn(125);
            mw.visitInsn(131);
            mw.visitInsn(136);
            mw.visitVarInsn(54, 3);
            Label dflt = new Label();
            Label[] labels = new Label[hashCode32Keys.length];
            for (i = 0; i < labels.length; ++i) {
                labels[i] = new Label();
            }
            mw.visitVarInsn(21, 3);
            mw.visitLookupSwitchInsn(dflt, hashCode32Keys, labels);
            for (i = 0; i < labels.length; ++i) {
                mw.visitLabel(labels[i]);
                int hashCode32 = hashCode32Keys[i];
                List hashCode64Array = (List)map.get(hashCode32);
                for (int j = 0; j < hashCode64Array.size(); ++j) {
                    long hashCode64 = (Long)hashCode64Array.get(j);
                    mw.visitVarInsn(22, 1);
                    mw.visitLdcInsn(hashCode64);
                    mw.visitInsn(148);
                    mw.visitJumpInsn(154, dflt);
                    int m = Arrays.binarySearch(objectReaderAdapter.hashCodes, hashCode64);
                    short index = objectReaderAdapter.mapping[m];
                    mw.visitVarInsn(25, 0);
                    mw.visitFieldInsn(180, classNameType, ObjectWriterCreatorASM.fieldWriter(index), DESC_FIELD_WRITER);
                    mw.visitJumpInsn(167, rtnlt);
                }
                mw.visitJumpInsn(167, dflt);
            }
            mw.visitLabel(dflt);
            mw.visitInsn(1);
            mw.visitInsn(176);
        }
        mw.visitLabel(rtnlt);
        mw.visitInsn(176);
        mw.visitMaxs(5, 5);
        mw.visitEnd();
    }

    static class MethodWriterContext {
        final Class objectClass;
        final long objectFeatures;
        final String classNameType;
        final MethodWriter mw;
        final Map<Object, Integer> variants = new LinkedHashMap<Object, Integer>();
        final boolean jsonb;
        int maxVariant;

        public MethodWriterContext(Class objectClass, long objectFeatures, String classNameType, MethodWriter mw, int maxVariant, boolean jsonb) {
            this.objectClass = objectClass;
            this.objectFeatures = objectFeatures;
            this.classNameType = classNameType;
            this.mw = mw;
            this.jsonb = jsonb;
            this.maxVariant = maxVariant;
        }

        int var(Object key) {
            Integer var = this.variants.get(key);
            if (var == null) {
                var = this.maxVariant;
                this.variants.put(key, var);
                this.maxVariant = key == Long.TYPE || key == Double.TYPE ? (this.maxVariant += 2) : ++this.maxVariant;
            }
            return var;
        }

        int var2(Object key) {
            Integer var = this.variants.get(key);
            if (var == null) {
                var = this.maxVariant;
                this.variants.put(key, var);
                this.maxVariant += 2;
            }
            return var;
        }

        void genVariantsMethodBefore() {
            Label notDefault_ = new Label();
            Label end_ = new Label();
            this.mw.visitVarInsn(25, 1);
            this.mw.visitMethodInsn(182, TYPE_JSON_WRITER, "isNotWriteDefaultValue", "()Z", false);
            this.mw.visitInsn(89);
            this.mw.visitVarInsn(54, this.var(ObjectWriterCreatorASM.NOT_WRITE_DEFAULT_VALUE));
            this.mw.visitJumpInsn(153, notDefault_);
            this.mw.visitInsn(3);
            this.mw.visitVarInsn(54, this.var(ObjectWriterCreatorASM.WRITE_NULLS));
            this.mw.visitInsn(9);
            this.mw.visitVarInsn(55, this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitJumpInsn(167, end_);
            this.mw.visitLabel(notDefault_);
            this.mw.visitVarInsn(25, 1);
            this.mw.visitMethodInsn(182, TYPE_JSON_WRITER, "getFeatures", "()J", false);
            this.mw.visitVarInsn(55, this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            long features = JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullBooleanAsFalse.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask | JSONWriter.Feature.WriteNullNumberAsZero.mask | JSONWriter.Feature.WriteNullListAsEmpty.mask;
            this.genIsEnabled(features);
            this.mw.visitVarInsn(54, this.var(ObjectWriterCreatorASM.WRITE_NULLS));
            this.mw.visitLabel(end_);
        }

        void genIsEnabled(long features, Label label) {
            this.mw.visitVarInsn(22, this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitLdcInsn(features);
            this.mw.visitInsn(127);
            this.mw.visitInsn(9);
            this.mw.visitInsn(148);
            this.mw.visitJumpInsn(153, label);
        }

        void genIsEnabled(long features) {
            Label L1 = new Label();
            Label L2 = new Label();
            this.mw.visitVarInsn(22, this.var2(ObjectWriterCreatorASM.CONTEXT_FEATURES));
            this.mw.visitLdcInsn(features);
            this.mw.visitInsn(127);
            this.mw.visitInsn(9);
            this.mw.visitInsn(148);
            this.mw.visitJumpInsn(153, L1);
            this.mw.visitInsn(4);
            this.mw.visitJumpInsn(167, L2);
            this.mw.visitLabel(L1);
            this.mw.visitInsn(3);
            this.mw.visitLabel(L2);
        }

        private void loadFieldType(int fieldIndex, Type fieldType) {
            if (fieldType instanceof Class && fieldType.getTypeName().startsWith("java")) {
                this.mw.visitLdcInsn((Class)fieldType);
                return;
            }
            this.mw.visitVarInsn(25, 0);
            this.mw.visitFieldInsn(180, this.classNameType, ObjectWriterCreatorASM.fieldWriter(fieldIndex), DESC_FIELD_WRITER);
            this.mw.visitMethodInsn(185, TYPE_FIELD_WRITER, "getFieldType", "()Ljava/lang/reflect/Type;", true);
        }
    }
}

