/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.function.ToByteFunction;
import com.alibaba.fastjson2.function.ToCharFunction;
import com.alibaba.fastjson2.function.ToFloatFunction;
import com.alibaba.fastjson2.function.ToShortFunction;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.FieldWriterBoolValFunc;
import com.alibaba.fastjson2.writer.FieldWriterBooleanFunc;
import com.alibaba.fastjson2.writer.FieldWriterCharValFunc;
import com.alibaba.fastjson2.writer.FieldWriterDoubleValueFunc;
import com.alibaba.fastjson2.writer.FieldWriterFloatValueFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt16ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt32ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt64ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterInt8ValFunc;
import com.alibaba.fastjson2.writer.FieldWriterMillisFunc;
import com.alibaba.fastjson2.writer.FieldWriterObjectMethod;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class ObjectWriterCreatorLambda
extends ObjectWriterCreator {
    public static ObjectWriterCreatorLambda INSTANCE = new ObjectWriterCreatorLambda();
    private static Map<Class, LambdaInfo> fieldReaderMapping = new HashMap<Class, LambdaInfo>();
    private static Map<Class, MethodType> methodTypeMapping = new HashMap<Class, MethodType>();
    private static MethodType METHODTYPE_FUNCTION = MethodType.methodType(Function.class);

    static boolean isExternalClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            return false;
        }
        for (ClassLoader current = ObjectWriterCreatorLambda.class.getClassLoader(); current != null; current = current.getParent()) {
            if (current != classLoader) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> FieldWriter<T> createFieldWriter(Class<T> objectClass, String fieldName, int ordinal, long features, String format, String label, Method method, ObjectWriter initObjectWriter) {
        int modifiers = objectClass.getModifiers();
        if (!Modifier.isPublic(modifiers) || ObjectWriterCreatorLambda.isExternalClass(objectClass)) {
            return super.createFieldWriter(objectClass, fieldName, ordinal, features, format, label, method, initObjectWriter);
        }
        if (initObjectWriter != null) {
            Class<?> fieldClass = method.getReturnType();
            Type fieldType = method.getGenericReturnType();
            FieldWriterObjectMethod objMethod = new FieldWriterObjectMethod(fieldName, ordinal, features, format, label, fieldType, fieldClass, method);
            objMethod.initValueClass = fieldClass;
            if (initObjectWriter != ObjectWriterBaseModule.VoidObjectWriter.INSTANCE) {
                objMethod.initObjectWriter = initObjectWriter;
            }
            return objMethod;
        }
        Class<?> returnClass = method.getReturnType();
        Type returnType = method.getGenericReturnType();
        Object lambda = ObjectWriterCreatorLambda.lambdaSetter(objectClass, returnClass, method);
        if (returnClass == Integer.TYPE) {
            return new FieldWriterInt32ValFunc(fieldName, ordinal, features, format, label, method, (ToIntFunction)lambda);
        }
        if (returnClass == Long.TYPE) {
            if (format == null || format.isEmpty()) {
                return new FieldWriterInt64ValFunc(fieldName, ordinal, features, format, label, method, (ToLongFunction)lambda);
            }
            return new FieldWriterMillisFunc(fieldName, ordinal, features, format, label, method, (ToLongFunction)lambda);
        }
        if (returnClass == Boolean.TYPE) {
            return new FieldWriterBoolValFunc(fieldName, ordinal, features, format, label, method, (Predicate)lambda);
        }
        if (returnClass == Boolean.class) {
            return new FieldWriterBooleanFunc(fieldName, ordinal, features, format, label, method, (Function)lambda);
        }
        if (returnClass == Short.TYPE) {
            return new FieldWriterInt16ValFunc(fieldName, ordinal, features, format, label, method, (ToShortFunction)lambda);
        }
        if (returnClass == Byte.TYPE) {
            return new FieldWriterInt8ValFunc(fieldName, ordinal, features, format, label, method, (ToByteFunction)lambda);
        }
        if (returnClass == Float.TYPE) {
            return new FieldWriterFloatValueFunc(fieldName, ordinal, features, format, label, method, (ToFloatFunction)lambda);
        }
        if (returnClass == Double.TYPE) {
            return new FieldWriterDoubleValueFunc(fieldName, ordinal, features, format, label, method, (ToDoubleFunction)lambda);
        }
        if (returnClass == Character.TYPE) {
            return new FieldWriterCharValFunc(fieldName, ordinal, features, format, label, method, (ToCharFunction)lambda);
        }
        Function function = (Function)lambda;
        return this.createFieldWriter(objectClass, fieldName, ordinal, features, format, label, returnType, returnClass, method, function);
    }

    static Object lambdaSetter(Class objectType, Class fieldClass, Method method) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        LambdaInfo buildInfo = fieldReaderMapping.get(fieldClass);
        if (buildInfo == null) {
            buildInfo = new LambdaInfo(Function.class, "apply");
        }
        MethodType invokedType = methodTypeMapping.getOrDefault(fieldClass, METHODTYPE_FUNCTION);
        try {
            MethodHandle target = lookup.findVirtual(objectType, method.getName(), MethodType.methodType(fieldClass));
            MethodType func = target.type();
            CallSite callSite = LambdaMetafactory.metafactory(lookup, buildInfo.methodName, invokedType, func.erase(), target, func);
            return callSite.getTarget().invoke();
        }
        catch (Throwable e) {
            throw new JSONException("create fieldLambdaGetter error, method : " + method, e);
        }
    }

    static {
        fieldReaderMapping.put(Boolean.TYPE, new LambdaInfo(Predicate.class, "test"));
        fieldReaderMapping.put(Character.TYPE, new LambdaInfo(ToCharFunction.class, "applyAsChar"));
        fieldReaderMapping.put(Byte.TYPE, new LambdaInfo(ToByteFunction.class, "applyAsByte"));
        fieldReaderMapping.put(Short.TYPE, new LambdaInfo(ToShortFunction.class, "applyAsShort"));
        fieldReaderMapping.put(Integer.TYPE, new LambdaInfo(ToIntFunction.class, "applyAsInt"));
        fieldReaderMapping.put(Long.TYPE, new LambdaInfo(ToLongFunction.class, "applyAsLong"));
        fieldReaderMapping.put(Float.TYPE, new LambdaInfo(ToFloatFunction.class, "applyAsFloat"));
        fieldReaderMapping.put(Double.TYPE, new LambdaInfo(ToDoubleFunction.class, "applyAsDouble"));
        fieldReaderMapping.forEach((k, v) -> methodTypeMapping.put((Class)k, MethodType.methodType(v.supplierClass)));
    }

    static class LambdaInfo {
        final Class supplierClass;
        final String methodName;

        LambdaInfo(Class supplierClass, String methodName) {
            this.supplierClass = supplierClass;
            this.methodName = methodName;
        }
    }
}

