/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.prometheus;

import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.prometheus.CanalInstanceExports;
import com.alibaba.otter.canal.prometheus.impl.PrometheusClientInstanceProfiler;
import com.alibaba.otter.canal.server.netty.CanalServerWithNettyProfiler;
import com.alibaba.otter.canal.server.netty.ClientInstanceProfiler;
import com.alibaba.otter.canal.spi.CanalMetricsService;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusService
implements CanalMetricsService {
    private static final Logger logger = LoggerFactory.getLogger(PrometheusService.class);
    private final CanalInstanceExports instanceExports = CanalInstanceExports.instance();
    private volatile boolean running = false;
    private int port;
    private HTTPServer server;
    private final ClientInstanceProfiler clientProfiler = PrometheusClientInstanceProfiler.instance();

    private PrometheusService() {
    }

    public static PrometheusService getInstance() {
        return SingletonHolder.SINGLETON;
    }

    public void initialize() {
        try {
            logger.info("Start prometheus HTTPServer on port {}.", (Object)this.port);
            this.server = new HTTPServer(this.port);
        }
        catch (IOException e) {
            logger.warn("Unable to start prometheus HTTPServer.", (Throwable)e);
            return;
        }
        try {
            DefaultExports.initialize();
            this.instanceExports.initialize();
            if (!this.clientProfiler.isStart()) {
                this.clientProfiler.start();
            }
            CanalServerWithNettyProfiler.profiler().setInstanceProfiler(this.clientProfiler);
        }
        catch (Throwable t) {
            logger.warn("Unable to initialize server exports.", t);
        }
        this.running = true;
    }

    public void terminate() {
        this.running = false;
        try {
            this.instanceExports.terminate();
            if (this.clientProfiler.isStart()) {
                this.clientProfiler.stop();
            }
            CanalServerWithNettyProfiler.profiler().setInstanceProfiler(CanalServerWithNettyProfiler.NOP);
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Throwable t) {
            logger.warn("Something happened while terminating.", t);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void register(CanalInstance instance) {
        if (instance.isStart()) {
            logger.warn("Cannot register metrics for destination {} that is running.", (Object)instance.getDestination());
            return;
        }
        try {
            this.instanceExports.register(instance);
        }
        catch (Throwable t) {
            logger.warn("Unable to register instance exports for {}.", (Object)instance.getDestination(), (Object)t);
        }
        logger.info("Register metrics for destination {}.", (Object)instance.getDestination());
    }

    public void unregister(CanalInstance instance) {
        if (instance.isStart()) {
            logger.warn("Try unregister metrics after destination {} is stopped.", (Object)instance.getDestination());
        }
        try {
            this.instanceExports.unregister(instance);
        }
        catch (Throwable t) {
            logger.warn("Unable to unregister instance exports for {}.", (Object)instance.getDestination(), (Object)t);
        }
        logger.info("Unregister metrics for destination {}.", (Object)instance.getDestination());
    }

    public void setServerPort(int port) {
        this.port = port;
    }

    private static class SingletonHolder {
        private static final PrometheusService SINGLETON = new PrometheusService();

        private SingletonHolder() {
        }
    }
}

