/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.prometheus.impl;

import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.prometheus.CanalInstanceExports;
import com.alibaba.otter.canal.prometheus.InstanceRegistry;
import com.alibaba.otter.canal.prometheus.impl.PrometheusCanalEventDownStreamHandler;
import com.alibaba.otter.canal.prometheus.impl.SinkCollector;
import com.alibaba.otter.canal.sink.CanalEventDownStreamHandler;
import com.alibaba.otter.canal.sink.CanalEventSink;
import com.alibaba.otter.canal.sink.entry.EntryEventSink;
import com.google.common.base.Preconditions;
import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryCollector
extends Collector
implements InstanceRegistry {
    private static final Logger logger = LoggerFactory.getLogger(SinkCollector.class);
    private static final String DELAY = "canal_instance_traffic_delay";
    private static final String TRANSACTION = "canal_instance_transactions";
    private static final String DELAY_HELP = "Traffic delay of canal instance in milliseconds";
    private static final String TRANSACTION_HELP = "Transactions counter of canal instance";
    private final ConcurrentMap<String, EntryMetricsHolder> instances = new ConcurrentHashMap<String, EntryMetricsHolder>();

    private EntryCollector() {
    }

    public static EntryCollector instance() {
        return SingletonHolder.SINGLETON;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        GaugeMetricFamily delay = new GaugeMetricFamily(DELAY, DELAY_HELP, CanalInstanceExports.DEST_LABELS_LIST);
        CounterMetricFamily transactions = new CounterMetricFamily(TRANSACTION, TRANSACTION_HELP, CanalInstanceExports.DEST_LABELS_LIST);
        for (EntryMetricsHolder emh : this.instances.values()) {
            long latest;
            long now = System.currentTimeMillis();
            long d = now >= (latest = emh.latestExecTime.get()) ? now - latest : 0L;
            delay.addMetric(emh.destLabelValues, (double)d);
            transactions.addMetric(emh.destLabelValues, emh.transactionCounter.doubleValue());
        }
        mfs.add((Collector.MetricFamilySamples)delay);
        mfs.add((Collector.MetricFamilySamples)transactions);
        return mfs;
    }

    @Override
    public void register(CanalInstance instance) {
        String destination = instance.getDestination();
        EntryMetricsHolder holder = new EntryMetricsHolder();
        holder.destLabelValues = Collections.singletonList(destination);
        CanalEventSink sink = instance.getEventSink();
        if (!(sink instanceof EntryEventSink)) {
            throw new IllegalArgumentException("CanalEventSink must be EntryEventSink");
        }
        EntryEventSink entrySink = (EntryEventSink)sink;
        PrometheusCanalEventDownStreamHandler handler = this.assembleHandler(entrySink);
        holder.latestExecTime = handler.getLatestExecuteTime();
        holder.transactionCounter = handler.getTransactionCounter();
        Preconditions.checkNotNull((Object)holder.latestExecTime);
        Preconditions.checkNotNull((Object)holder.transactionCounter);
        EntryMetricsHolder old = this.instances.put(destination, holder);
        if (old != null) {
            logger.warn("Remove stale EntryCollector for instance {}.", (Object)destination);
        }
    }

    @Override
    public void unregister(CanalInstance instance) {
        String destination = instance.getDestination();
        CanalEventSink sink = instance.getEventSink();
        if (!(sink instanceof EntryEventSink)) {
            throw new IllegalArgumentException("CanalEventSink must be EntryEventSink");
        }
        this.unloadHandler((EntryEventSink)sink);
        this.instances.remove(destination);
    }

    private PrometheusCanalEventDownStreamHandler assembleHandler(EntryEventSink entrySink) {
        PrometheusCanalEventDownStreamHandler ph = new PrometheusCanalEventDownStreamHandler();
        List handlers = entrySink.getHandlers();
        for (CanalEventDownStreamHandler handler : handlers) {
            if (!(handler instanceof PrometheusCanalEventDownStreamHandler)) continue;
            throw new IllegalStateException("PrometheusCanalEventDownStreamHandler already exists in handlers.");
        }
        entrySink.addHandler((CanalEventDownStreamHandler)ph, 0);
        return ph;
    }

    private void unloadHandler(EntryEventSink entrySink) {
        int i;
        List handlers = entrySink.getHandlers();
        for (i = 0; i < handlers.size() && !(handlers.get(i) instanceof PrometheusCanalEventDownStreamHandler); ++i) {
        }
        entrySink.removeHandler(i);
        handlers = entrySink.getHandlers();
        for (CanalEventDownStreamHandler handler : handlers) {
            if (!(handler instanceof PrometheusCanalEventDownStreamHandler)) continue;
            throw new IllegalStateException("Multiple prometheusCanalEventDownStreamHandler exists in handlers.");
        }
    }

    private static class EntryMetricsHolder {
        private AtomicLong latestExecTime;
        private AtomicLong transactionCounter;
        private List<String> destLabelValues;

        private EntryMetricsHolder() {
        }
    }

    private static class SingletonHolder {
        private static final EntryCollector SINGLETON = new EntryCollector();

        private SingletonHolder() {
        }
    }
}

