/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.prometheus.impl;

import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.instance.spring.CanalInstanceWithSpring;
import com.alibaba.otter.canal.meta.CanalMetaManager;
import com.alibaba.otter.canal.prometheus.CanalInstanceExports;
import com.alibaba.otter.canal.prometheus.InstanceRegistry;
import com.google.common.base.Preconditions;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaCollector
extends Collector
implements InstanceRegistry {
    private static final List<String> INFO_LABELS_LIST = Arrays.asList("destination", "mode");
    private static final Logger logger = LoggerFactory.getLogger(MetaCollector.class);
    private static final String INSTANCE = "canal_instance";
    private static final String INSTANCE_HELP = "Canal instance";
    private static final String SUBSCRIPTION = "canal_instance_subscriptions";
    private static final String SUBSCRIPTION_HELP = "Canal instance subscriptions";
    private final ConcurrentMap<String, MetaMetricsHolder> instances = new ConcurrentHashMap<String, MetaMetricsHolder>();

    private MetaCollector() {
    }

    public static MetaCollector instance() {
        return SingletonHolder.SINGLETON;
    }

    public List<Collector.MetricFamilySamples> collect() {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        GaugeMetricFamily instanceInfo = new GaugeMetricFamily(INSTANCE, INSTANCE_HELP, INFO_LABELS_LIST);
        GaugeMetricFamily subsInfo = new GaugeMetricFamily(SUBSCRIPTION, SUBSCRIPTION_HELP, CanalInstanceExports.DEST_LABELS_LIST);
        for (Map.Entry nme : this.instances.entrySet()) {
            String destination = (String)nme.getKey();
            MetaMetricsHolder nmh = (MetaMetricsHolder)nme.getValue();
            instanceInfo.addMetric(nmh.infoLabelValues, 1.0);
            List subs = nmh.metaManager.listAllSubscribeInfo(destination);
            int count = subs == null ? 0 : subs.size();
            subsInfo.addMetric(nmh.destLabelValues, (double)count);
        }
        mfs.add((Collector.MetricFamilySamples)instanceInfo);
        mfs.add((Collector.MetricFamilySamples)subsInfo);
        return mfs;
    }

    @Override
    public void register(CanalInstance instance) {
        String destination = instance.getDestination();
        MetaMetricsHolder holder = new MetaMetricsHolder();
        String mode = instance instanceof CanalInstanceWithSpring ? "spring" : "manager";
        holder.infoLabelValues = Arrays.asList(destination, mode);
        holder.destLabelValues = Collections.singletonList(destination);
        holder.metaManager = instance.getMetaManager();
        Preconditions.checkNotNull((Object)holder.metaManager);
        MetaMetricsHolder old = this.instances.put(destination, holder);
        if (old != null) {
            logger.warn("Remove stale MetaCollector for instance {}.", (Object)destination);
        }
    }

    @Override
    public void unregister(CanalInstance instance) {
        String destination = instance.getDestination();
        this.instances.remove(destination);
    }

    private static class MetaMetricsHolder {
        private List<String> infoLabelValues;
        private List<String> destLabelValues;
        private CanalMetaManager metaManager;

        private MetaMetricsHolder() {
        }
    }

    private static class SingletonHolder {
        private static final MetaCollector SINGLETON = new MetaCollector();

        private SingletonHolder() {
        }
    }
}

