/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.prometheus.impl;

import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.sink.AbstractCanalEventDownStreamHandler;
import com.alibaba.otter.canal.store.model.Event;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class PrometheusCanalEventDownStreamHandler
extends AbstractCanalEventDownStreamHandler<List<Event>> {
    private final AtomicLong latestExecuteTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicLong transactionCounter = new AtomicLong(0L);

    public List<Event> before(List<Event> events) {
        long localExecTime = 0L;
        if (events != null && !events.isEmpty()) {
            for (Event e : events) {
                CanalEntry.EntryType type = e.getEntryType();
                if (type == null) continue;
                switch (type) {
                    case TRANSACTIONBEGIN: {
                        long exec = e.getExecuteTime();
                        if (exec <= 0L) break;
                        localExecTime = exec;
                        break;
                    }
                    case ROWDATA: {
                        long exec = e.getExecuteTime();
                        if (exec <= 0L) break;
                        localExecTime = exec;
                        break;
                    }
                    case TRANSACTIONEND: {
                        long exec = e.getExecuteTime();
                        if (exec > 0L) {
                            localExecTime = exec;
                        }
                        this.transactionCounter.incrementAndGet();
                        break;
                    }
                    case HEARTBEAT: {
                        CanalEntry.EventType eventType = e.getEventType();
                        if (eventType != CanalEntry.EventType.MHEARTBEAT) break;
                        localExecTime = System.currentTimeMillis();
                        break;
                    }
                }
            }
            if (localExecTime > 0L) {
                this.latestExecuteTime.set(localExecTime);
            }
        }
        return events;
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public AtomicLong getLatestExecuteTime() {
        return this.latestExecuteTime;
    }

    public AtomicLong getTransactionCounter() {
        return this.transactionCounter;
    }
}

