/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.deployer;

import com.alibaba.otter.canal.common.utils.AddressUtils;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.alibaba.otter.canal.common.zookeeper.ZookeeperPathUtils;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningData;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningListener;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningMonitor;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningMonitors;
import com.alibaba.otter.canal.deployer.CanalConstants;
import com.alibaba.otter.canal.deployer.InstanceConfig;
import com.alibaba.otter.canal.deployer.monitor.InstanceAction;
import com.alibaba.otter.canal.deployer.monitor.InstanceConfigMonitor;
import com.alibaba.otter.canal.deployer.monitor.ManagerInstanceConfigMonitor;
import com.alibaba.otter.canal.deployer.monitor.SpringInstanceConfigMonitor;
import com.alibaba.otter.canal.instance.core.CanalInstanceGenerator;
import com.alibaba.otter.canal.instance.manager.PlainCanalInstanceGenerator;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanalConfigClient;
import com.alibaba.otter.canal.instance.spring.SpringCanalInstanceGenerator;
import com.alibaba.otter.canal.server.CanalMQStarter;
import com.alibaba.otter.canal.server.embedded.CanalServerWithEmbedded;
import com.alibaba.otter.canal.server.exception.CanalServerException;
import com.alibaba.otter.canal.server.netty.CanalServerWithNetty;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MigrateMap;
import java.util.Map;
import java.util.Properties;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CanalController {
    private static final Logger logger = LoggerFactory.getLogger(CanalController.class);
    private String ip;
    private String registerIp;
    private int port;
    private int adminPort;
    private Map<String, InstanceConfig> instanceConfigs;
    private InstanceConfig globalInstanceConfig;
    private Map<String, PlainCanalConfigClient> managerClients = MigrateMap.makeComputingMap(this::getManagerClient);
    private boolean autoScan = true;
    private InstanceAction defaultAction;
    private Map<InstanceConfig.InstanceMode, InstanceConfigMonitor> instanceConfigMonitors;
    private CanalServerWithEmbedded embededCanalServer;
    private CanalServerWithNetty canalServer;
    private CanalInstanceGenerator instanceGenerator;
    private ZkClientx zkclientx;
    private CanalMQStarter canalMQStarter;
    private String adminUser;
    private String adminPasswd;

    public CanalController() {
        this(System.getProperties());
    }

    public CanalController(final Properties properties) {
        String zkServers;
        this.globalInstanceConfig = this.initGlobalConfig(properties);
        this.instanceConfigs = new MapMaker().makeMap();
        this.initInstanceConfig(properties);
        String socketChannel = CanalController.getProperty(properties, "canal.socketChannel");
        if (StringUtils.isNotEmpty((String)socketChannel)) {
            System.setProperty("canal.socketChannel", socketChannel);
        }
        String accesskey = CanalController.getProperty(properties, "canal.instance.rds.accesskey");
        String secretkey = CanalController.getProperty(properties, "canal.instance.rds.secretkey");
        if (StringUtils.isNotEmpty((String)accesskey)) {
            System.setProperty("canal.aliyun.accessKey", accesskey);
        }
        if (StringUtils.isNotEmpty((String)secretkey)) {
            System.setProperty("canal.aliyun.secretKey", secretkey);
        }
        this.ip = CanalController.getProperty(properties, "canal.ip");
        this.registerIp = CanalController.getProperty(properties, "canal.register.ip");
        this.port = Integer.valueOf(CanalController.getProperty(properties, "canal.port", "11111"));
        this.adminPort = Integer.valueOf(CanalController.getProperty(properties, "canal.admin.port", "11110"));
        this.embededCanalServer = CanalServerWithEmbedded.instance();
        this.embededCanalServer.setCanalInstanceGenerator(this.instanceGenerator);
        int metricsPort = Integer.valueOf(CanalController.getProperty(properties, "canal.metrics.pull.port", "11112"));
        this.embededCanalServer.setMetricsPort(metricsPort);
        this.adminUser = CanalController.getProperty(properties, "canal.admin.user");
        this.adminPasswd = CanalController.getProperty(properties, "canal.admin.passwd");
        this.embededCanalServer.setUser(CanalController.getProperty(properties, "canal.user"));
        this.embededCanalServer.setPasswd(CanalController.getProperty(properties, "canal.passwd"));
        String canalWithoutNetty = CanalController.getProperty(properties, "canal.withoutNetty");
        if (canalWithoutNetty == null || "false".equals(canalWithoutNetty)) {
            this.canalServer = CanalServerWithNetty.instance();
            this.canalServer.setIp(this.ip);
            this.canalServer.setPort(this.port);
        }
        if (StringUtils.isEmpty((String)this.ip) && StringUtils.isEmpty((String)this.registerIp)) {
            this.ip = this.registerIp = AddressUtils.getHostIp();
        }
        if (StringUtils.isEmpty((String)this.ip)) {
            this.ip = AddressUtils.getHostIp();
        }
        if (StringUtils.isEmpty((String)this.registerIp)) {
            this.registerIp = this.ip;
        }
        if (StringUtils.isNotEmpty((String)(zkServers = CanalController.getProperty(properties, "canal.zkServers")))) {
            this.zkclientx = ZkClientx.getZkClient((String)zkServers);
            this.zkclientx.createPersistent("/otter/canal/destinations", true);
            this.zkclientx.createPersistent("/otter/canal/cluster", true);
        }
        ServerRunningData serverData = new ServerRunningData(this.registerIp + ":" + this.port);
        ServerRunningMonitors.setServerData((ServerRunningData)serverData);
        ServerRunningMonitors.setRunningMonitors((Map)MigrateMap.makeComputingMap(destination -> {
            ServerRunningMonitor runningMonitor = new ServerRunningMonitor(serverData);
            runningMonitor.setDestination(destination);
            runningMonitor.setListener(new ServerRunningListener((String)destination){
                final /* synthetic */ String val$destination;
                {
                    this.val$destination = string;
                }

                public void processActiveEnter() {
                    try {
                        MDC.put((String)"destination", (String)String.valueOf(this.val$destination));
                        CanalController.this.embededCanalServer.start(this.val$destination);
                        if (CanalController.this.canalMQStarter != null) {
                            CanalController.this.canalMQStarter.startDestination(this.val$destination);
                        }
                    }
                    finally {
                        MDC.remove((String)"destination");
                    }
                }

                public void processActiveExit() {
                    try {
                        MDC.put((String)"destination", (String)String.valueOf(this.val$destination));
                        if (CanalController.this.canalMQStarter != null) {
                            CanalController.this.canalMQStarter.stopDestination(this.val$destination);
                        }
                        CanalController.this.embededCanalServer.stop(this.val$destination);
                    }
                    finally {
                        MDC.remove((String)"destination");
                    }
                }

                public void processStart() {
                    try {
                        if (CanalController.this.zkclientx != null) {
                            final String path = ZookeeperPathUtils.getDestinationClusterNode((String)this.val$destination, (String)(CanalController.this.registerIp + ":" + CanalController.this.port));
                            CanalController.this.initCid(path);
                            CanalController.this.zkclientx.subscribeStateChanges(new IZkStateListener(){

                                public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
                                }

                                public void handleNewSession() throws Exception {
                                    CanalController.this.initCid(path);
                                }

                                public void handleSessionEstablishmentError(Throwable error) throws Exception {
                                    logger.error("failed to connect to zookeeper", error);
                                }
                            });
                        }
                    }
                    finally {
                        MDC.remove((String)"destination");
                    }
                }

                public void processStop() {
                    try {
                        MDC.put((String)"destination", (String)String.valueOf(this.val$destination));
                        if (CanalController.this.zkclientx != null) {
                            String path = ZookeeperPathUtils.getDestinationClusterNode((String)this.val$destination, (String)(CanalController.this.registerIp + ":" + CanalController.this.port));
                            CanalController.this.releaseCid(path);
                        }
                    }
                    finally {
                        MDC.remove((String)"destination");
                    }
                }
            });
            if (this.zkclientx != null) {
                runningMonitor.setZkClient(this.zkclientx);
            }
            runningMonitor.init();
            return runningMonitor;
        }));
        this.autoScan = BooleanUtils.toBoolean((String)CanalController.getProperty(properties, "canal.auto.scan"));
        if (this.autoScan) {
            this.defaultAction = new InstanceAction(){

                @Override
                public void start(String destination) {
                    InstanceConfig config = (InstanceConfig)CanalController.this.instanceConfigs.get(destination);
                    if (config == null) {
                        config = CanalController.this.parseInstanceConfig(properties, destination);
                        CanalController.this.instanceConfigs.put(destination, config);
                    }
                    if (!CanalController.this.embededCanalServer.isStart(destination)) {
                        ServerRunningMonitor runningMonitor = ServerRunningMonitors.getRunningMonitor((String)destination);
                        if (!config.getLazy().booleanValue() && !runningMonitor.isStart()) {
                            runningMonitor.start();
                        }
                    }
                    logger.info("auto notify start {} successful.", (Object)destination);
                }

                @Override
                public void stop(String destination) {
                    InstanceConfig config = (InstanceConfig)CanalController.this.instanceConfigs.remove(destination);
                    if (config != null) {
                        CanalController.this.embededCanalServer.stop(destination);
                        ServerRunningMonitor runningMonitor = ServerRunningMonitors.getRunningMonitor((String)destination);
                        if (runningMonitor.isStart()) {
                            runningMonitor.stop();
                        }
                    }
                    logger.info("auto notify stop {} successful.", (Object)destination);
                }

                @Override
                public void reload(String destination) {
                    this.stop(destination);
                    this.start(destination);
                    logger.info("auto notify reload {} successful.", (Object)destination);
                }

                @Override
                public void release(String destination) {
                    boolean release;
                    ServerRunningMonitor runningMonitor;
                    InstanceConfig config = (InstanceConfig)CanalController.this.instanceConfigs.get(destination);
                    if (config != null && (runningMonitor = ServerRunningMonitors.getRunningMonitor((String)destination)).isStart() && !(release = runningMonitor.release())) {
                        ManagerInstanceConfigMonitor monitor;
                        Map<String, InstanceAction> instanceActions;
                        CanalController.this.instanceConfigs.remove(destination);
                        runningMonitor.stop();
                        if (CanalController.this.instanceConfigMonitors.containsKey((Object)InstanceConfig.InstanceMode.MANAGER) && (instanceActions = (monitor = (ManagerInstanceConfigMonitor)CanalController.this.instanceConfigMonitors.get((Object)InstanceConfig.InstanceMode.MANAGER)).getActions()).containsKey(destination)) {
                            monitor.release(destination);
                        }
                    }
                    logger.info("auto notify release {} successful.", (Object)destination);
                }
            };
            this.instanceConfigMonitors = MigrateMap.makeComputingMap(mode -> {
                int scanInterval = Integer.valueOf(CanalController.getProperty(properties, "canal.auto.scan.interval", "5"));
                if (mode.isSpring()) {
                    SpringInstanceConfigMonitor monitor = new SpringInstanceConfigMonitor();
                    monitor.setScanIntervalInSecond(scanInterval);
                    monitor.setDefaultAction(this.defaultAction);
                    String rootDir = CanalController.getProperty(properties, "canal.conf.dir");
                    if (StringUtils.isEmpty((String)rootDir)) {
                        rootDir = "../conf";
                    }
                    if (StringUtils.equals((String)"otter-canal", (String)System.getProperty("appName"))) {
                        monitor.setRootConf(rootDir);
                    } else {
                        monitor.setRootConf("src/main/resources/");
                    }
                    return monitor;
                }
                if (mode.isManager()) {
                    ManagerInstanceConfigMonitor monitor = new ManagerInstanceConfigMonitor();
                    monitor.setScanIntervalInSecond(scanInterval);
                    monitor.setDefaultAction(this.defaultAction);
                    String managerAddress = CanalController.getProperty(properties, "canal.admin.manager");
                    monitor.setConfigClient(this.getManagerClient(managerAddress));
                    return monitor;
                }
                throw new UnsupportedOperationException("unknow mode :" + (Object)mode + " for monitor");
            });
        }
    }

    private InstanceConfig initGlobalConfig(Properties properties) {
        String springXml;
        String managerAddress;
        String adminManagerAddress = CanalController.getProperty(properties, "canal.admin.manager");
        InstanceConfig globalConfig = new InstanceConfig();
        String modeStr = CanalController.getProperty(properties, CanalConstants.getInstanceModeKey("global"));
        if (StringUtils.isNotEmpty((String)adminManagerAddress)) {
            globalConfig.setMode(InstanceConfig.InstanceMode.MANAGER);
        } else if (StringUtils.isNotEmpty((String)modeStr)) {
            globalConfig.setMode(InstanceConfig.InstanceMode.valueOf(StringUtils.upperCase((String)modeStr)));
        }
        String lazyStr = CanalController.getProperty(properties, CanalConstants.getInstancLazyKey("global"));
        if (StringUtils.isNotEmpty((String)lazyStr)) {
            globalConfig.setLazy(Boolean.valueOf(lazyStr));
        }
        if (StringUtils.isNotEmpty((String)(managerAddress = CanalController.getProperty(properties, CanalConstants.getInstanceManagerAddressKey("global"))))) {
            if (StringUtils.equals((String)managerAddress, (String)"${canal.admin.manager}")) {
                managerAddress = adminManagerAddress;
            }
            globalConfig.setManagerAddress(managerAddress);
        }
        if (StringUtils.isNotEmpty((String)(springXml = CanalController.getProperty(properties, CanalConstants.getInstancSpringXmlKey("global"))))) {
            globalConfig.setSpringXml(springXml);
        }
        this.instanceGenerator = destination -> {
            InstanceConfig config = this.instanceConfigs.get(destination);
            if (config == null) {
                throw new CanalServerException("can't find destination:" + destination);
            }
            if (config.getMode().isManager()) {
                PlainCanalInstanceGenerator instanceGenerator = new PlainCanalInstanceGenerator(properties);
                instanceGenerator.setCanalConfigClient(this.managerClients.get(config.getManagerAddress()));
                instanceGenerator.setSpringXml(config.getSpringXml());
                return instanceGenerator.generate(destination);
            }
            if (config.getMode().isSpring()) {
                SpringCanalInstanceGenerator instanceGenerator = new SpringCanalInstanceGenerator();
                instanceGenerator.setSpringXml(config.getSpringXml());
                return instanceGenerator.generate(destination);
            }
            throw new UnsupportedOperationException("unknow mode :" + (Object)((Object)config.getMode()));
        };
        return globalConfig;
    }

    private PlainCanalConfigClient getManagerClient(String managerAddress) {
        return new PlainCanalConfigClient(managerAddress, this.adminUser, this.adminPasswd, this.registerIp, this.adminPort);
    }

    private void initInstanceConfig(Properties properties) {
        String[] destinations;
        String destinationStr = CanalController.getProperty(properties, "canal.destinations");
        for (String destination : destinations = StringUtils.split((String)destinationStr, (String)",")) {
            InstanceConfig config = this.parseInstanceConfig(properties, destination);
            InstanceConfig oldConfig = this.instanceConfigs.put(destination, config);
            if (oldConfig == null) continue;
            logger.warn("destination:{} old config:{} has replace by new config:{}", new Object[]{destination, oldConfig, config});
        }
    }

    private InstanceConfig parseInstanceConfig(Properties properties, String destination) {
        String springXml;
        String managerAddress;
        String adminManagerAddress = CanalController.getProperty(properties, "canal.admin.manager");
        InstanceConfig config = new InstanceConfig(this.globalInstanceConfig);
        String modeStr = CanalController.getProperty(properties, CanalConstants.getInstanceModeKey(destination));
        if (StringUtils.isNotEmpty((String)adminManagerAddress)) {
            config.setMode(InstanceConfig.InstanceMode.MANAGER);
        } else if (StringUtils.isNotEmpty((String)modeStr)) {
            config.setMode(InstanceConfig.InstanceMode.valueOf(StringUtils.upperCase((String)modeStr)));
        }
        String lazyStr = CanalController.getProperty(properties, CanalConstants.getInstancLazyKey(destination));
        if (!StringUtils.isEmpty((String)lazyStr)) {
            config.setLazy(Boolean.valueOf(lazyStr));
        }
        if (config.getMode().isManager() && StringUtils.isNotEmpty((String)(managerAddress = CanalController.getProperty(properties, CanalConstants.getInstanceManagerAddressKey(destination))))) {
            if (StringUtils.equals((String)managerAddress, (String)"${canal.admin.manager}")) {
                managerAddress = adminManagerAddress;
            }
            config.setManagerAddress(managerAddress);
        }
        if (StringUtils.isNotEmpty((String)(springXml = CanalController.getProperty(properties, CanalConstants.getInstancSpringXmlKey(destination))))) {
            config.setSpringXml(springXml);
        }
        return config;
    }

    public static String getProperty(Properties properties, String key, String defaultValue) {
        String value = CanalController.getProperty(properties, key);
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public static String getProperty(Properties properties, String key) {
        String value = System.getProperty(key = StringUtils.trim((String)key));
        if (value == null) {
            value = System.getenv(key);
        }
        if (value == null) {
            value = properties.getProperty(key);
        }
        return StringUtils.trim((String)value);
    }

    public void start() throws Throwable {
        logger.info("## start the canal server[{}({}):{}]", new Object[]{this.ip, this.registerIp, this.port});
        final String path = ZookeeperPathUtils.getCanalClusterNode((String)(this.registerIp + ":" + this.port));
        this.initCid(path);
        if (this.zkclientx != null) {
            this.zkclientx.subscribeStateChanges(new IZkStateListener(){

                public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
                }

                public void handleNewSession() throws Exception {
                    CanalController.this.initCid(path);
                }

                public void handleSessionEstablishmentError(Throwable error) throws Exception {
                    logger.error("failed to connect to zookeeper", error);
                }
            });
        }
        this.embededCanalServer.start();
        for (Map.Entry<String, InstanceConfig> entry : this.instanceConfigs.entrySet()) {
            String destination = entry.getKey();
            InstanceConfig config = entry.getValue();
            if (!this.embededCanalServer.isStart(destination)) {
                ServerRunningMonitor runningMonitor = ServerRunningMonitors.getRunningMonitor((String)destination);
                if (!config.getLazy().booleanValue() && !runningMonitor.isStart()) {
                    runningMonitor.start();
                }
            }
            if (!this.autoScan) continue;
            this.instanceConfigMonitors.get((Object)config.getMode()).register(destination, this.defaultAction);
        }
        if (this.autoScan) {
            this.instanceConfigMonitors.get((Object)this.globalInstanceConfig.getMode()).start();
            for (InstanceConfigMonitor monitor : this.instanceConfigMonitors.values()) {
                if (monitor.isStart()) continue;
                monitor.start();
            }
        }
        if (this.canalServer != null) {
            this.canalServer.start();
        }
    }

    public void stop() throws Throwable {
        if (this.canalServer != null) {
            this.canalServer.stop();
        }
        if (this.autoScan) {
            for (InstanceConfigMonitor monitor : this.instanceConfigMonitors.values()) {
                if (!monitor.isStart()) continue;
                monitor.stop();
            }
        }
        for (ServerRunningMonitor runningMonitor : ServerRunningMonitors.getRunningMonitors().values()) {
            if (!runningMonitor.isStart()) continue;
            runningMonitor.stop();
        }
        this.releaseCid(ZookeeperPathUtils.getCanalClusterNode((String)(this.registerIp + ":" + this.port)));
        logger.info("## stop the canal server[{}({}):{}]", new Object[]{this.ip, this.registerIp, this.port});
        if (this.zkclientx != null) {
            this.zkclientx.close();
        }
        if (this.instanceConfigs != null) {
            this.instanceConfigs.clear();
        }
        if (this.managerClients != null) {
            this.managerClients.clear();
        }
        if (this.instanceConfigMonitors != null) {
            this.instanceConfigMonitors.clear();
        }
        ZkClientx.clearClients();
    }

    private void initCid(String path) {
        if (this.zkclientx != null) {
            try {
                this.zkclientx.createEphemeral(path);
            }
            catch (ZkNoNodeException e) {
                String parentDir = path.substring(0, path.lastIndexOf(47));
                this.zkclientx.createPersistent(parentDir, true);
                this.zkclientx.createEphemeral(path);
            }
            catch (ZkNodeExistsException zkNodeExistsException) {
                // empty catch block
            }
        }
    }

    private void releaseCid(String path) {
        if (this.zkclientx != null) {
            this.zkclientx.delete(path);
        }
    }

    public CanalMQStarter getCanalMQStarter() {
        return this.canalMQStarter;
    }

    public void setCanalMQStarter(CanalMQStarter canalMQStarter) {
        this.canalMQStarter = canalMQStarter;
    }

    public Map<InstanceConfig.InstanceMode, InstanceConfigMonitor> getInstanceConfigMonitors() {
        return this.instanceConfigMonitors;
    }

    public Map<String, InstanceConfig> getInstanceConfigs() {
        return this.instanceConfigs;
    }
}

