/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.deployer;

import com.alibaba.otter.canal.common.utils.AddressUtils;
import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.alibaba.otter.canal.deployer.CanalController;
import com.alibaba.otter.canal.deployer.CanalStarter;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanal;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanalConfigClient;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalLauncher {
    private static final String CLASSPATH_URL_PREFIX = "classpath:";
    private static final Logger logger = LoggerFactory.getLogger(CanalLauncher.class);
    public static final CountDownLatch runningLatch = new CountDownLatch(1);
    private static ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("canal-server-scan"));

    public static void main(String[] args) {
        try {
            logger.info("## set default uncaught exception handler");
            CanalLauncher.setGlobalUncaughtExceptionHandler();
            System.setProperty("rocketmq.client.logUseSlf4j", "true");
            logger.info("## load canal configurations");
            String conf = System.getProperty("canal.conf", "classpath:canal.properties");
            final Properties properties = new Properties();
            if (conf.startsWith(CLASSPATH_URL_PREFIX)) {
                conf = StringUtils.substringAfter((String)conf, (String)CLASSPATH_URL_PREFIX);
                properties.load(CanalLauncher.class.getClassLoader().getResourceAsStream(conf));
            } else {
                properties.load(new FileInputStream(conf));
            }
            final CanalStarter canalStater = new CanalStarter(properties);
            String managerAddress = CanalController.getProperty(properties, "canal.admin.manager");
            if (StringUtils.isNotEmpty((String)managerAddress)) {
                PlainCanalConfigClient configClient;
                PlainCanal canalConfig;
                String registerIp;
                String user = CanalController.getProperty(properties, "canal.admin.user");
                String passwd = CanalController.getProperty(properties, "canal.admin.passwd");
                String adminPort = CanalController.getProperty(properties, "canal.admin.port", "11110");
                boolean autoRegister = BooleanUtils.toBoolean((String)CanalController.getProperty(properties, "canal.admin.register.auto"));
                String autoCluster = CanalController.getProperty(properties, "canal.admin.register.cluster");
                String name = CanalController.getProperty(properties, "canal.admin.register.name");
                if (StringUtils.isEmpty((String)name)) {
                    name = AddressUtils.getHostName();
                }
                if (StringUtils.isEmpty((String)(registerIp = CanalController.getProperty(properties, "canal.register.ip")))) {
                    registerIp = AddressUtils.getHostIp();
                }
                if ((canalConfig = (configClient = new PlainCanalConfigClient(managerAddress, user, passwd, registerIp, Integer.parseInt(adminPort), autoRegister, autoCluster, name)).findServer(null)) == null) {
                    throw new IllegalArgumentException("managerAddress:" + managerAddress + " can't not found config for [" + registerIp + ":" + adminPort + "]");
                }
                Properties managerProperties = canalConfig.getProperties();
                managerProperties.putAll((Map<?, ?>)properties);
                int scanIntervalInSecond = Integer.valueOf(CanalController.getProperty(managerProperties, "canal.auto.scan.interval", "5"));
                executor.scheduleWithFixedDelay(new Runnable(){
                    private PlainCanal lastCanalConfig;

                    @Override
                    public void run() {
                        try {
                            if (this.lastCanalConfig == null) {
                                this.lastCanalConfig = configClient.findServer(null);
                            } else {
                                PlainCanal newCanalConfig = configClient.findServer(this.lastCanalConfig.getMd5());
                                if (newCanalConfig != null) {
                                    canalStater.stop();
                                    Properties managerProperties = newCanalConfig.getProperties();
                                    managerProperties.putAll((Map<?, ?>)properties);
                                    canalStater.setProperties(managerProperties);
                                    canalStater.start();
                                    this.lastCanalConfig = newCanalConfig;
                                }
                            }
                        }
                        catch (Throwable e) {
                            logger.error("scan failed", e);
                        }
                    }
                }, 0L, scanIntervalInSecond, TimeUnit.SECONDS);
                canalStater.setProperties(managerProperties);
            } else {
                canalStater.setProperties(properties);
            }
            canalStater.start();
            runningLatch.await();
            executor.shutdownNow();
        }
        catch (Throwable e) {
            logger.error("## Something goes wrong when starting up the canal Server:", e);
        }
    }

    private static void setGlobalUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> logger.error("UnCaughtException", e));
    }
}

