/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.deployer;

import com.alibaba.otter.canal.admin.CanalAdmin;
import com.alibaba.otter.canal.admin.netty.CanalAdminWithNetty;
import com.alibaba.otter.canal.connector.core.config.MQProperties;
import com.alibaba.otter.canal.connector.core.spi.CanalMQProducer;
import com.alibaba.otter.canal.connector.core.spi.ExtensionLoader;
import com.alibaba.otter.canal.deployer.CanalController;
import com.alibaba.otter.canal.deployer.CanalLauncher;
import com.alibaba.otter.canal.deployer.admin.CanalAdminController;
import com.alibaba.otter.canal.server.CanalMQStarter;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalStarter {
    private static final Logger logger = LoggerFactory.getLogger(CanalStarter.class);
    private static final String CONNECTOR_SPI_DIR = "/plugin";
    private static final String CONNECTOR_STANDBY_SPI_DIR = "/canal/plugin";
    private CanalController controller = null;
    private CanalMQProducer canalMQProducer = null;
    private Thread shutdownThread = null;
    private CanalMQStarter canalMQStarter = null;
    private volatile Properties properties;
    private volatile boolean running = false;
    private CanalAdminWithNetty canalAdmin;

    public CanalStarter(Properties properties) {
        this.properties = properties;
    }

    public boolean isRunning() {
        return this.running;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public CanalController getController() {
        return this.controller;
    }

    public synchronized void start() throws Throwable {
        String serverMode = CanalController.getProperty(this.properties, "canal.serverMode");
        if (!"tcp".equalsIgnoreCase(serverMode)) {
            ExtensionLoader loader = ExtensionLoader.getExtensionLoader(CanalMQProducer.class);
            this.canalMQProducer = (CanalMQProducer)loader.getExtension(serverMode.toLowerCase(), CONNECTOR_SPI_DIR, CONNECTOR_STANDBY_SPI_DIR);
            if (this.canalMQProducer != null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.canalMQProducer.getClass().getClassLoader());
                this.canalMQProducer.init(this.properties);
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        if (this.canalMQProducer != null) {
            MQProperties mqProperties = this.canalMQProducer.getMqProperties();
            System.setProperty("canal.withoutNetty", "true");
            if (mqProperties.isFlatMessage()) {
                System.setProperty("canal.instance.memory.rawEntry", "false");
            }
        }
        logger.info("## start the canal server.");
        this.controller = new CanalController(this.properties);
        this.controller.start();
        logger.info("## the canal server is running now ......");
        this.shutdownThread = new Thread(() -> {
            try {
                logger.info("## stop the canal server");
                this.controller.stop();
                CanalLauncher.runningLatch.countDown();
            }
            catch (Throwable e) {
                logger.warn("##something goes wrong when stopping canal Server:", e);
            }
            finally {
                logger.info("## canal server is down.");
            }
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        if (this.canalMQProducer != null) {
            this.canalMQStarter = new CanalMQStarter(this.canalMQProducer);
            String destinations = CanalController.getProperty(this.properties, "canal.destinations");
            this.canalMQStarter.start(destinations);
            this.controller.setCanalMQStarter(this.canalMQStarter);
        }
        String port = CanalController.getProperty(this.properties, "canal.admin.port");
        if (this.canalAdmin == null && StringUtils.isNotEmpty((String)port)) {
            String user = CanalController.getProperty(this.properties, "canal.admin.user");
            String passwd = CanalController.getProperty(this.properties, "canal.admin.passwd");
            CanalAdminController canalAdmin = new CanalAdminController(this);
            canalAdmin.setUser(user);
            canalAdmin.setPasswd(passwd);
            String ip = CanalController.getProperty(this.properties, "canal.ip");
            logger.debug("canal admin port:{}, canal admin user:{}, canal admin password: {}, canal ip:{}", new Object[]{port, user, passwd, ip});
            CanalAdminWithNetty canalAdminWithNetty = CanalAdminWithNetty.instance();
            canalAdminWithNetty.setCanalAdmin((CanalAdmin)canalAdmin);
            canalAdminWithNetty.setPort(Integer.parseInt(port));
            canalAdminWithNetty.setIp(ip);
            canalAdminWithNetty.start();
            this.canalAdmin = canalAdminWithNetty;
        }
        this.running = true;
    }

    public synchronized void stop() throws Throwable {
        this.stop(false);
    }

    public synchronized void stop(boolean stopByAdmin) throws Throwable {
        if (!stopByAdmin && this.canalAdmin != null) {
            this.canalAdmin.stop();
            this.canalAdmin = null;
        }
        if (this.controller != null) {
            this.controller.stop();
            this.controller = null;
        }
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        if (this.canalMQProducer != null && this.canalMQStarter != null) {
            this.canalMQStarter.destroy();
            this.canalMQStarter = null;
            this.canalMQProducer = null;
        }
        this.running = false;
    }
}

