/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.deployer.admin;

import com.alibaba.otter.canal.admin.CanalAdmin;
import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.deployer.CanalStarter;
import com.alibaba.otter.canal.deployer.InstanceConfig;
import com.alibaba.otter.canal.deployer.monitor.InstanceAction;
import com.alibaba.otter.canal.deployer.monitor.InstanceConfigMonitor;
import com.alibaba.otter.canal.deployer.monitor.ManagerInstanceConfigMonitor;
import com.alibaba.otter.canal.deployer.monitor.SpringInstanceConfigMonitor;
import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.protocol.SecurityUtil;
import com.alibaba.otter.canal.server.embedded.CanalServerWithEmbedded;
import com.google.common.base.Joiner;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalAdminController
implements CanalAdmin {
    private static final Logger logger = LoggerFactory.getLogger(CanalAdminController.class);
    private String user;
    private String passwd;
    private CanalStarter canalStater;

    public CanalAdminController(CanalStarter canalStater) {
        this.canalStater = canalStater;
    }

    public boolean check() {
        return this.canalStater.isRunning();
    }

    public synchronized boolean start() {
        try {
            if (!this.canalStater.isRunning()) {
                this.canalStater.start();
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public synchronized boolean stop() {
        try {
            if (this.canalStater.isRunning()) {
                this.canalStater.stop(true);
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public synchronized boolean restart() {
        this.stop();
        return this.start();
    }

    public boolean auth(String user, String passwd, byte[] seed) {
        if (StringUtils.isEmpty((String)this.user) || StringUtils.equals((String)this.user, (String)user)) {
            if (StringUtils.isEmpty((String)this.passwd)) {
                return true;
            }
            if (StringUtils.isEmpty((String)passwd)) {
                return false;
            }
            try {
                byte[] passForClient = SecurityUtil.hexStr2Bytes((String)passwd);
                return SecurityUtil.scrambleServerAuth((byte[])passForClient, (byte[])SecurityUtil.hexStr2Bytes((String)this.passwd), (byte[])seed);
            }
            catch (NoSuchAlgorithmException e) {
                return false;
            }
        }
        return false;
    }

    public String getRunningInstances() {
        try {
            Map instances = CanalServerWithEmbedded.instance().getCanalInstances();
            ArrayList runningInstances = new ArrayList();
            instances.forEach((destination, instance) -> {
                if (instance.isStart()) {
                    runningInstances.add(destination);
                }
            });
            return Joiner.on((String)",").join(runningInstances);
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            return "";
        }
    }

    public boolean checkInstance(String destination) {
        Map instances = CanalServerWithEmbedded.instance().getCanalInstances();
        if (instances == null || !instances.containsKey(destination)) {
            return false;
        }
        CanalInstance instance = (CanalInstance)instances.get(destination);
        return instance.isStart();
    }

    public boolean startInstance(String destination) {
        try {
            InstanceAction instanceAction = this.getInstanceAction(destination);
            if (instanceAction != null) {
                instanceAction.start(destination);
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public boolean stopInstance(String destination) {
        try {
            InstanceAction instanceAction = this.getInstanceAction(destination);
            if (instanceAction != null) {
                instanceAction.stop(destination);
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public boolean releaseInstance(String destination) {
        try {
            InstanceAction instanceAction = this.getInstanceAction(destination);
            if (instanceAction != null) {
                instanceAction.release(destination);
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public boolean restartInstance(String destination) {
        try {
            InstanceAction instanceAction = this.getInstanceAction(destination);
            if (instanceAction != null) {
                instanceAction.reload(destination);
                return true;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        return false;
    }

    public String listCanalLog() {
        Collection files = FileUtils.listFiles((File)new File("../logs/canal/"), (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
        List names = files.stream().map(File::getName).collect(Collectors.toList());
        return Joiner.on((String)",").join(names);
    }

    public String canalLog(int lines) {
        return com.alibaba.otter.canal.common.utils.FileUtils.readFileFromOffset((String)"../logs/canal/canal.log", (int)lines, (String)"UTF-8");
    }

    public String listInstanceLog(String destination) {
        Collection files = FileUtils.listFiles((File)new File("../logs/" + destination + "/"), (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
        List names = files.stream().map(File::getName).collect(Collectors.toList());
        return Joiner.on((String)",").join(names);
    }

    public String instanceLog(String destination, String fileName, int lines) {
        if (StringUtils.isEmpty((String)fileName)) {
            fileName = destination + ".log";
        }
        return com.alibaba.otter.canal.common.utils.FileUtils.readFileFromOffset((String)("../logs/" + destination + "/" + fileName), (int)lines, (String)"UTF-8");
    }

    private InstanceAction getInstanceAction(String destination) {
        Map<String, InstanceAction> instanceActions;
        AbstractCanalLifeCycle monitor;
        Map<InstanceConfig.InstanceMode, InstanceConfigMonitor> monitors = this.canalStater.getController().getInstanceConfigMonitors();
        InstanceAction instanceAction = null;
        if (monitors.containsKey((Object)InstanceConfig.InstanceMode.SPRING)) {
            monitor = (SpringInstanceConfigMonitor)monitors.get((Object)InstanceConfig.InstanceMode.SPRING);
            instanceActions = monitor.getActions();
            instanceAction = instanceActions.get(destination);
        }
        if (instanceAction != null) {
            return instanceAction;
        }
        if (monitors.containsKey((Object)InstanceConfig.InstanceMode.MANAGER)) {
            monitor = (ManagerInstanceConfigMonitor)monitors.get((Object)InstanceConfig.InstanceMode.MANAGER);
            instanceActions = monitor.getActions();
            instanceAction = instanceActions.get(destination);
        }
        return instanceAction;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPasswd(String passwd) {
        this.passwd = passwd;
    }

    public void setCanalStater(CanalStarter canalStater) {
        this.canalStater = canalStater;
    }
}

