/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.deployer.monitor;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.CanalLifeCycle;
import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.alibaba.otter.canal.deployer.monitor.InstanceAction;
import com.alibaba.otter.canal.deployer.monitor.InstanceConfigMonitor;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanal;
import com.alibaba.otter.canal.instance.manager.plain.PlainCanalConfigClient;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MigrateMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagerInstanceConfigMonitor
extends AbstractCanalLifeCycle
implements InstanceConfigMonitor,
CanalLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(ManagerInstanceConfigMonitor.class);
    private long scanIntervalInSecond = 5L;
    private InstanceAction defaultAction = null;
    private Map<String, InstanceAction> actions = new MapMaker().makeMap();
    private Map<String, PlainCanal> configs = MigrateMap.makeComputingMap(destination -> new PlainCanal());
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("canal-instance-scan"));
    private volatile boolean isFirst = true;
    private PlainCanalConfigClient configClient;

    public void start() {
        super.start();
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.scan();
                if (this.isFirst) {
                    this.isFirst = false;
                }
            }
            catch (Throwable e) {
                logger.error("scan failed", e);
            }
        }, 0L, this.scanIntervalInSecond, TimeUnit.SECONDS);
    }

    public void stop() {
        super.stop();
        this.executor.shutdownNow();
        this.actions.clear();
    }

    @Override
    public void register(String destination, InstanceAction action) {
        if (action != null) {
            this.actions.put(destination, action);
        } else {
            this.actions.put(destination, this.defaultAction);
        }
    }

    @Override
    public void unregister(String destination) {
        this.actions.remove(destination);
    }

    private void scan() {
        String instances = this.configClient.findInstances(null);
        if (instances == null) {
            return;
        }
        ArrayList is = Lists.newArrayList((Object[])StringUtils.split((String)instances, (char)','));
        ArrayList<String> start = new ArrayList<String>();
        ArrayList stop = new ArrayList();
        ArrayList<String> restart = new ArrayList<String>();
        for (String instance2 : is) {
            if (!this.configs.containsKey(instance2)) {
                PlainCanal newPlainCanal = this.configClient.findInstance(instance2, null);
                if (newPlainCanal == null) continue;
                this.configs.put(instance2, newPlainCanal);
                start.add(instance2);
                continue;
            }
            PlainCanal plainCanal2 = this.configs.get(instance2);
            PlainCanal newPlainCanal = this.configClient.findInstance(instance2, plainCanal2.getMd5());
            if (newPlainCanal == null) continue;
            restart.add(instance2);
            this.configs.put(instance2, newPlainCanal);
        }
        this.configs.forEach((instance, plainCanal) -> {
            if (!is.contains(instance)) {
                stop.add(instance);
            }
        });
        stop.forEach(instance -> this.notifyStop((String)instance));
        restart.forEach(instance -> this.notifyReload((String)instance));
        start.forEach(instance -> this.notifyStart((String)instance));
    }

    private void notifyStart(String destination) {
        try {
            this.defaultAction.start(destination);
            this.actions.put(destination, this.defaultAction);
        }
        catch (Throwable e) {
            logger.error(String.format("scan add found[%s] but start failed", destination), e);
        }
    }

    private void notifyStop(String destination) {
        InstanceAction action = this.actions.remove(destination);
        if (action != null) {
            try {
                action.stop(destination);
                this.configs.remove(destination);
            }
            catch (Throwable e) {
                logger.error(String.format("scan delete found[%s] but stop failed", destination), e);
                this.actions.put(destination, action);
            }
        }
    }

    private void notifyReload(String destination) {
        InstanceAction action = this.actions.get(destination);
        if (action != null) {
            try {
                action.reload(destination);
            }
            catch (Throwable e) {
                logger.error(String.format("scan reload found[%s] but reload failed", destination), e);
            }
        }
    }

    public void release(String destination) {
        InstanceAction action = this.actions.remove(destination);
        if (action != null) {
            try {
                this.configs.remove(destination);
            }
            catch (Throwable e) {
                logger.error(String.format("scan delete found[%s] but stop failed", destination), e);
                this.actions.put(destination, action);
            }
        }
    }

    public void setDefaultAction(InstanceAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public void setScanIntervalInSecond(long scanIntervalInSecond) {
        this.scanIntervalInSecond = scanIntervalInSecond;
    }

    public void setConfigClient(PlainCanalConfigClient configClient) {
        this.configClient = configClient;
    }

    public Map<String, InstanceAction> getActions() {
        return this.actions;
    }
}

