/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.deployer.monitor;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.CanalLifeCycle;
import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.alibaba.otter.canal.deployer.monitor.InstanceAction;
import com.alibaba.otter.canal.deployer.monitor.InstanceConfigMonitor;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MigrateMap;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SpringInstanceConfigMonitor
extends AbstractCanalLifeCycle
implements InstanceConfigMonitor,
CanalLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(SpringInstanceConfigMonitor.class);
    private String rootConf;
    private long scanIntervalInSecond = 5L;
    private InstanceAction defaultAction = null;
    private Map<String, InstanceAction> actions = new MapMaker().makeMap();
    private Map<String, InstanceConfigFiles> lastFiles = MigrateMap.makeComputingMap(InstanceConfigFiles::new);
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory("canal-instance-scan"));
    private volatile boolean isFirst = true;

    public Map<String, InstanceAction> getActions() {
        return this.actions;
    }

    public void start() {
        super.start();
        Assert.notNull((Object)this.rootConf, (String)"root conf dir is null!");
        this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.scan();
                if (this.isFirst) {
                    this.isFirst = false;
                }
            }
            catch (Throwable e) {
                logger.error("scan failed", e);
            }
        }, 0L, this.scanIntervalInSecond, TimeUnit.SECONDS);
    }

    public void stop() {
        super.stop();
        this.executor.shutdownNow();
        this.actions.clear();
        this.lastFiles.clear();
    }

    @Override
    public void register(String destination, InstanceAction action) {
        if (action != null) {
            this.actions.put(destination, action);
        } else {
            this.actions.put(destination, this.defaultAction);
        }
    }

    @Override
    public void unregister(String destination) {
        this.actions.remove(destination);
    }

    public void setRootConf(String rootConf) {
        this.rootConf = rootConf;
    }

    private void scan() {
        File rootdir = new File(this.rootConf);
        if (!rootdir.exists()) {
            return;
        }
        File[] instanceDirs = rootdir.listFiles(pathname -> {
            String filename = pathname.getName();
            return pathname.isDirectory() && !"spring".equalsIgnoreCase(filename);
        });
        HashSet<String> currentInstanceNames = new HashSet<String>();
        for (File instanceDir : instanceDirs) {
            boolean hasChanged;
            String destination = instanceDir.getName();
            currentInstanceNames.add(destination);
            File[] instanceConfigs = instanceDir.listFiles((dir, name) -> StringUtils.equalsIgnoreCase((String)name, (String)"instance.properties"));
            if (!this.actions.containsKey(destination) && instanceConfigs.length > 0) {
                this.notifyStart(instanceDir, destination, instanceConfigs);
                continue;
            }
            if (!this.actions.containsKey(destination)) continue;
            if (instanceConfigs.length == 0) {
                this.notifyStop(destination);
                continue;
            }
            InstanceConfigFiles lastFile = this.lastFiles.get(destination);
            if (!this.isFirst && CollectionUtils.isEmpty(lastFile.getInstanceFiles())) {
                logger.error("[{}] is started, but not found instance file info.", (Object)destination);
            }
            if (hasChanged = this.judgeFileChanged(instanceConfigs, lastFile.getInstanceFiles())) {
                this.notifyReload(destination);
            }
            if (!hasChanged && !CollectionUtils.isEmpty(lastFile.getInstanceFiles())) continue;
            ArrayList<FileInfo> newFileInfo = new ArrayList<FileInfo>();
            for (File instanceConfig : instanceConfigs) {
                newFileInfo.add(new FileInfo(instanceConfig.getName(), instanceConfig.lastModified()));
            }
            lastFile.setInstanceFiles(newFileInfo);
        }
        HashSet<String> deleteInstanceNames = new HashSet<String>();
        for (String destination : this.actions.keySet()) {
            if (currentInstanceNames.contains(destination)) continue;
            deleteInstanceNames.add(destination);
        }
        for (String deleteInstanceName : deleteInstanceNames) {
            this.notifyStop(deleteInstanceName);
        }
    }

    private void notifyStart(File instanceDir, String destination, File[] instanceConfigs) {
        try {
            this.defaultAction.start(destination);
            this.actions.put(destination, this.defaultAction);
            InstanceConfigFiles lastFile = this.lastFiles.get(destination);
            ArrayList<FileInfo> newFileInfo = new ArrayList<FileInfo>();
            for (File instanceConfig : instanceConfigs) {
                newFileInfo.add(new FileInfo(instanceConfig.getName(), instanceConfig.lastModified()));
            }
            lastFile.setInstanceFiles(newFileInfo);
        }
        catch (Throwable e) {
            logger.error(String.format("scan add found[%s] but start failed", destination), e);
        }
    }

    private void notifyStop(String destination) {
        InstanceAction action = this.actions.remove(destination);
        if (action != null) {
            try {
                action.stop(destination);
                this.lastFiles.remove(destination);
            }
            catch (Throwable e) {
                logger.error(String.format("scan delete found[%s] but stop failed", destination), e);
                this.actions.put(destination, action);
            }
        }
    }

    private void notifyReload(String destination) {
        InstanceAction action = this.actions.get(destination);
        if (action != null) {
            try {
                action.reload(destination);
            }
            catch (Throwable e) {
                logger.error(String.format("scan reload found[%s] but reload failed", destination), e);
            }
        }
    }

    private boolean judgeFileChanged(File[] instanceConfigs, List<FileInfo> fileInfos) {
        boolean hasChanged = false;
        for (File instanceConfig : instanceConfigs) {
            for (FileInfo fileInfo : fileInfos) {
                if (!instanceConfig.getName().equals(fileInfo.getName()) || !(hasChanged |= instanceConfig.lastModified() != fileInfo.getLastModified())) continue;
                return hasChanged;
            }
        }
        return hasChanged;
    }

    public void setDefaultAction(InstanceAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public void setScanIntervalInSecond(long scanIntervalInSecond) {
        this.scanIntervalInSecond = scanIntervalInSecond;
    }

    public static class FileInfo {
        private String name;
        private long lastModified = 0L;

        public FileInfo(String name, long lastModified) {
            this.name = name;
            this.lastModified = lastModified;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(long lastModified) {
            this.lastModified = lastModified;
        }
    }

    public static class InstanceConfigFiles {
        private String destination;
        private List<FileInfo> springFile = new ArrayList<FileInfo>();
        private FileInfo rootFile;
        private List<FileInfo> instanceFiles = new ArrayList<FileInfo>();

        public InstanceConfigFiles(String destination) {
            this.destination = destination;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public List<FileInfo> getSpringFile() {
            return this.springFile;
        }

        public void setSpringFile(List<FileInfo> springFile) {
            this.springFile = springFile;
        }

        public FileInfo getRootFile() {
            return this.rootFile;
        }

        public void setRootFile(FileInfo rootFile) {
            this.rootFile = rootFile;
        }

        public List<FileInfo> getInstanceFiles() {
            return this.instanceFiles;
        }

        public void setInstanceFiles(List<FileInfo> instanceFiles) {
            this.instanceFiles = instanceFiles;
        }
    }
}

