/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.pulsarmq.consumer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.otter.canal.common.utils.MQUtil;
import com.alibaba.otter.canal.connector.core.consumer.CommonMessage;
import com.alibaba.otter.canal.connector.core.spi.CanalMsgConsumer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.CanalMessageSerializerUtil;
import com.alibaba.otter.canal.connector.core.util.MessageUtil;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.BatchReceivePolicy;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.Messages;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;

@SPI(value="pulsarmq")
public class CanalPulsarMQConsumer
implements CanalMsgConsumer {
    private PulsarClient pulsarClient;
    private Consumer<byte[]> pulsarMQConsumer;
    private boolean flatMessage = false;
    private String topic;
    private volatile Messages<byte[]> lastGetBatchMessage;
    private String serviceUrl;
    private String roleToken;
    private String subscriptName;
    private int batchSize = 30;
    private int getBatchTimeoutSeconds = 30;
    private long batchProcessTimeout = 60000L;
    private int redeliveryDelaySeconds = 60;
    private int ackTimeoutSeconds = 30;
    private boolean isRetry = true;
    private boolean isRetryDLQUpperCase = false;
    private int maxRedeliveryCount = 128;

    public void init(Properties properties, String topic, String groupId) {
        String maxRedeliveryCountStr;
        String isRetryDLQUpperCaseStr;
        String isRetryStr;
        String ackTimeoutSecondsStr;
        String redeliveryDelaySecondsStr;
        String batchProcessTimeoutStr;
        String getBatchTimeoutSecondsStr;
        this.topic = topic;
        String flatMessageStr = properties.getProperty("canal.mq.flatMessage");
        if (StringUtils.isNotEmpty((String)flatMessageStr)) {
            this.flatMessage = Boolean.parseBoolean(flatMessageStr);
        }
        this.serviceUrl = properties.getProperty("pulsarmq.serverUrl");
        this.roleToken = properties.getProperty("pulsarmq.roleToken");
        this.subscriptName = properties.getProperty("pulsarmq.subscriptName");
        if (StringUtils.isEmpty((String)this.subscriptName)) {
            this.subscriptName = groupId;
        }
        if (StringUtils.isEmpty((String)this.subscriptName)) {
            throw new RuntimeException("Pulsar Consumer subscriptName required");
        }
        String batchSizeStr = properties.getProperty("canal.mq.canalBatchSize");
        if (StringUtils.isNotEmpty((String)batchSizeStr)) {
            this.batchSize = Integer.parseInt(batchSizeStr);
        }
        if (StringUtils.isNotEmpty((String)(getBatchTimeoutSecondsStr = properties.getProperty("pulsarmq.getBatchTimeoutSeconds")))) {
            this.getBatchTimeoutSeconds = Integer.parseInt(getBatchTimeoutSecondsStr);
        }
        if (StringUtils.isNotEmpty((String)(batchProcessTimeoutStr = properties.getProperty("pulsarmq.batchProcessTimeout")))) {
            this.batchProcessTimeout = Integer.parseInt(batchProcessTimeoutStr);
        }
        if (StringUtils.isNotEmpty((String)(redeliveryDelaySecondsStr = properties.getProperty("pulsarmq.redeliveryDelaySeconds")))) {
            this.redeliveryDelaySeconds = Integer.parseInt(redeliveryDelaySecondsStr);
        }
        if (StringUtils.isNotEmpty((String)(ackTimeoutSecondsStr = properties.getProperty("pulsarmq.ackTimeoutSeconds")))) {
            this.ackTimeoutSeconds = Integer.parseInt(ackTimeoutSecondsStr);
        }
        if (StringUtils.isNotEmpty((String)(isRetryStr = properties.getProperty("pulsarmq.isRetry")))) {
            this.isRetry = Boolean.parseBoolean(isRetryStr);
        }
        if (StringUtils.isNotEmpty((String)(isRetryDLQUpperCaseStr = properties.getProperty("pulsarmq.isRetryDLQUpperCase")))) {
            this.isRetryDLQUpperCase = Boolean.parseBoolean(isRetryDLQUpperCaseStr);
        }
        if (StringUtils.isNotEmpty((String)(maxRedeliveryCountStr = properties.getProperty("pulsarmq.maxRedeliveryCount")))) {
            this.maxRedeliveryCount = Integer.parseInt(maxRedeliveryCountStr);
        }
    }

    public void connect() {
        Cloneable builder;
        if (this.isConsumerActive()) {
            return;
        }
        try {
            builder = PulsarClient.builder().serviceUrl(this.serviceUrl);
            if (StringUtils.isNotEmpty((String)this.roleToken)) {
                builder.authentication(AuthenticationFactory.token(this.roleToken));
            }
            this.pulsarClient = builder.build();
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
        builder = this.pulsarClient.newConsumer();
        if (MQUtil.isPatternTopic((String)this.topic)) {
            builder.topicsPattern(this.topic);
        } else {
            builder.topic(this.topic);
        }
        builder.subscriptionType(SubscriptionType.Failover);
        builder.negativeAckRedeliveryDelay(this.redeliveryDelaySeconds, TimeUnit.SECONDS).subscriptionName(this.subscriptName);
        if (this.isRetry) {
            DeadLetterPolicy.DeadLetterPolicyBuilder dlqBuilder = DeadLetterPolicy.builder().maxRedeliverCount(this.maxRedeliveryCount);
            if (!MQUtil.isPatternTag((String)this.topic)) {
                String retryTopic = this.topic + (this.isRetryDLQUpperCase ? "-RETRY" : "-retry");
                dlqBuilder.retryLetterTopic(retryTopic);
                String dlqTopic = this.topic + (this.isRetryDLQUpperCase ? "-DLQ" : "-dlq");
                dlqBuilder.deadLetterTopic(dlqTopic);
            }
            builder.enableRetry(true).deadLetterPolicy(dlqBuilder.build());
        }
        builder.ackTimeout(this.ackTimeoutSeconds, TimeUnit.SECONDS);
        builder.batchReceivePolicy(new BatchReceivePolicy.Builder().maxNumMessages(this.batchSize).timeout(this.getBatchTimeoutSeconds, TimeUnit.SECONDS).build());
        try {
            this.pulsarMQConsumer = builder.subscribe();
        }
        catch (PulsarClientException e) {
            throw new CanalClientException("Subscript pulsar consumer error", (Throwable)e);
        }
    }

    public List<CommonMessage> getMessage(Long timeout, TimeUnit unit) {
        ArrayList<CommonMessage> messageList = Lists.newArrayList();
        try {
            Messages<byte[]> messages = this.pulsarMQConsumer.batchReceive();
            if (null == messages || messages.size() == 0) {
                return messageList;
            }
            this.lastGetBatchMessage = messages;
            for (org.apache.pulsar.client.api.Message message : messages) {
                byte[] data = message.getData();
                if (!this.flatMessage) {
                    Message message2 = CanalMessageSerializerUtil.deserializer((byte[])data);
                    List list = MessageUtil.convert((Message)message2);
                    messageList.addAll(list);
                    continue;
                }
                CommonMessage commonMessage = (CommonMessage)JSON.parseObject((byte[])data, CommonMessage.class);
                messageList.add(commonMessage);
            }
        }
        catch (PulsarClientException e) {
            throw new CanalClientException("Receive pulsar batch message error", (Throwable)e);
        }
        return messageList;
    }

    public void rollback() {
        try {
            if (this.isConsumerActive() && this.hasLastMessages()) {
                this.pulsarMQConsumer.negativeAcknowledge(this.lastGetBatchMessage);
            }
        }
        finally {
            this.lastGetBatchMessage = null;
        }
    }

    public void ack() {
        try {
            if (this.isConsumerActive() && this.hasLastMessages()) {
                this.pulsarMQConsumer.acknowledge(this.lastGetBatchMessage);
            }
        }
        catch (PulsarClientException e) {
            if (this.isConsumerActive() && this.hasLastMessages()) {
                this.pulsarMQConsumer.negativeAcknowledge(this.lastGetBatchMessage);
            }
        }
        finally {
            this.lastGetBatchMessage = null;
        }
    }

    public void disconnect() {
        if (null == this.pulsarMQConsumer || !this.pulsarMQConsumer.isConnected()) {
            return;
        }
        try {
            this.pulsarClient.close();
        }
        catch (PulsarClientException e) {
            throw new CanalClientException("Disconnect pulsar consumer error", (Throwable)e);
        }
    }

    private boolean isConsumerActive() {
        return null != this.pulsarMQConsumer && this.pulsarMQConsumer.isConnected();
    }

    private boolean hasLastMessages() {
        return null != this.lastGetBatchMessage && this.lastGetBatchMessage.size() > 0;
    }
}

