/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.pulsarmq.producer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.otter.canal.common.utils.ExecutorTemplate;
import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.alibaba.otter.canal.common.utils.PropertiesUtils;
import com.alibaba.otter.canal.connector.core.producer.AbstractMQProducer;
import com.alibaba.otter.canal.connector.core.producer.MQDestination;
import com.alibaba.otter.canal.connector.core.producer.MQMessageUtils;
import com.alibaba.otter.canal.connector.core.spi.CanalMQProducer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.Callback;
import com.alibaba.otter.canal.connector.core.util.CanalMessageSerializerUtil;
import com.alibaba.otter.canal.connector.pulsarmq.config.PulsarMQProducerConfig;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.FlatMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageRouter;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.TopicMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(value="pulsarmq")
public class CanalPulsarMQProducer
extends AbstractMQProducer
implements CanalMQProducer {
    public static final String MSG_PROPERTY_PARTITION_NAME = "partitionNum";
    private static final Logger logger = LoggerFactory.getLogger(CanalPulsarMQProducer.class);
    private static final Map<String, Producer<byte[]>> PRODUCERS = new HashMap<String, Producer<byte[]>>();
    protected ThreadPoolExecutor sendPartitionExecutor;
    protected PulsarClient client;
    protected PulsarAdmin pulsarAdmin;

    public void init(Properties properties) {
        PulsarMQProducerConfig pulsarMQProducerConfig = new PulsarMQProducerConfig();
        this.mqProperties = pulsarMQProducerConfig;
        super.init(properties);
        this.loadPulsarMQProperties(properties);
        try {
            ClientBuilder builder = PulsarClient.builder().serviceUrl(pulsarMQProducerConfig.getServerUrl());
            if (StringUtils.isNotEmpty((String)pulsarMQProducerConfig.getRoleToken())) {
                builder.authentication(AuthenticationFactory.token(pulsarMQProducerConfig.getRoleToken()));
            }
            this.client = builder.build();
        }
        catch (PulsarClientException e) {
            throw new RuntimeException(e);
        }
        if (StringUtils.isNotEmpty((String)pulsarMQProducerConfig.getAdminServerUrl())) {
            try {
                this.pulsarAdmin = PulsarAdmin.builder().serviceHttpUrl(pulsarMQProducerConfig.getAdminServerUrl()).build();
            }
            catch (PulsarClientException e) {
                throw new RuntimeException(e);
            }
        }
        int parallelPartitionSendThreadSize = this.mqProperties.getParallelSendThreadSize();
        this.sendPartitionExecutor = new ThreadPoolExecutor(parallelPartitionSendThreadSize, parallelPartitionSendThreadSize, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(parallelPartitionSendThreadSize * 2), (ThreadFactory)new NamedThreadFactory("MQ-Parallel-Sender-Partition"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    private void loadPulsarMQProperties(Properties properties) {
        String adminServerUrl;
        String topicTenantPrefix;
        String roleToken;
        PulsarMQProducerConfig tmpProperties = (PulsarMQProducerConfig)this.mqProperties;
        String serverUrl = PropertiesUtils.getProperty((Properties)properties, (String)"pulsarmq.serverUrl");
        if (!StringUtils.isEmpty((String)serverUrl)) {
            tmpProperties.setServerUrl(serverUrl);
        }
        if (!StringUtils.isEmpty((String)(roleToken = PropertiesUtils.getProperty((Properties)properties, (String)"pulsarmq.roleToken")))) {
            tmpProperties.setRoleToken(roleToken);
        }
        if (!StringUtils.isEmpty((String)(topicTenantPrefix = PropertiesUtils.getProperty((Properties)properties, (String)"pulsarmq.topicTenantPrefix")))) {
            tmpProperties.setTopicTenantPrefix(topicTenantPrefix);
        }
        if (!StringUtils.isEmpty((String)(adminServerUrl = PropertiesUtils.getProperty((Properties)properties, (String)"pulsarmq.adminServerUrl")))) {
            tmpProperties.setAdminServerUrl(adminServerUrl);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Load pulsar properties ==> {}", JSON.toJSON((Object)this.mqProperties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MQDestination destination, com.alibaba.otter.canal.protocol.Message message, Callback callback) {
        ExecutorTemplate template = new ExecutorTemplate(this.sendExecutor);
        try {
            if (!StringUtils.isEmpty((String)destination.getDynamicTopic())) {
                Map messageMap = MQMessageUtils.messageTopics((com.alibaba.otter.canal.protocol.Message)message, (String)destination.getTopic(), (String)destination.getDynamicTopic());
                for (Map.Entry entry : messageMap.entrySet()) {
                    String topicName = ((String)entry.getKey()).replace('.', '_');
                    com.alibaba.otter.canal.protocol.Message messageSub = (com.alibaba.otter.canal.protocol.Message)entry.getValue();
                    template.submit(() -> {
                        try {
                            this.send(destination, topicName, messageSub);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                template.waitForResult();
            } else {
                this.send(destination, destination.getTopic(), message);
            }
            callback.commit();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            callback.rollback();
        }
        finally {
            template.clear();
        }
    }

    public void send(MQDestination destination, String topicName, com.alibaba.otter.canal.protocol.Message message) {
        Integer partitionNum = MQMessageUtils.parseDynamicTopicPartition((String)topicName, (String)destination.getDynamicTopicPartitionNum());
        if (partitionNum == null) {
            partitionNum = destination.getPartitionsNum();
        }
        if (this.pulsarAdmin != null && partitionNum != null && partitionNum > 0 && PRODUCERS.get(topicName) == null) {
            this.createMultipleTopic(topicName, partitionNum);
        }
        ExecutorTemplate template = new ExecutorTemplate(this.sendPartitionExecutor);
        MQMessageUtils.EntryRowData[] datas = MQMessageUtils.buildMessageData((com.alibaba.otter.canal.protocol.Message)message, (ThreadPoolExecutor)this.buildExecutor);
        if (!this.mqProperties.isFlatMessage()) {
            if (destination.getPartitionHash() != null && !destination.getPartitionHash().isEmpty()) {
                for (MQMessageUtils.EntryRowData r : datas) {
                    CanalEntry.Entry entry = r.entry;
                    if (null == entry) continue;
                    com.alibaba.otter.canal.protocol.Message[] messages = MQMessageUtils.messagePartition((MQMessageUtils.EntryRowData[])datas, (long)message.getId(), (Integer)partitionNum, (String)destination.getPartitionHash(), (boolean)this.mqProperties.isDatabaseHash());
                    int len = messages.length;
                    for (int i = 0; i < len; ++i) {
                        int partition = i;
                        com.alibaba.otter.canal.protocol.Message m3 = messages[i];
                        template.submit(() -> this.sendMessage(topicName, partition, m3));
                    }
                }
            } else {
                int partition = destination.getPartition() != null ? destination.getPartition() : 0;
                this.sendMessage(topicName, partition, message);
            }
        } else {
            List flatMessages = MQMessageUtils.messageConverter((MQMessageUtils.EntryRowData[])datas, (long)message.getId());
            if (destination.getPartitionHash() != null && !destination.getPartitionHash().isEmpty()) {
                ArrayList partitionFlatMessages = new ArrayList();
                int len = partitionNum;
                for (int i = 0; i < len; ++i) {
                    partitionFlatMessages.add(new ArrayList());
                }
                for (FlatMessage flatMessage : flatMessages) {
                    FlatMessage[] partitionFlatMessage = MQMessageUtils.messagePartition((FlatMessage)flatMessage, (Integer)partitionNum, (String)destination.getPartitionHash(), (boolean)this.mqProperties.isDatabaseHash());
                    int length = partitionFlatMessage.length;
                    for (int i = 0; i < length; ++i) {
                        if (partitionFlatMessage[i] == null) continue;
                        ((List)partitionFlatMessages.get(i)).add(partitionFlatMessage[i]);
                    }
                }
                for (int i = 0; i < len; ++i) {
                    List flatMessagePart = (List)partitionFlatMessages.get(i);
                    if (flatMessagePart == null || flatMessagePart.size() <= 0) continue;
                    int partition = i;
                    template.submit(() -> this.sendMessage(topicName, partition, flatMessagePart));
                }
                template.waitForResult();
            } else {
                int partition = destination.getPartition() != null ? destination.getPartition() : 0;
                this.sendMessage(topicName, partition, flatMessages);
            }
        }
    }

    private void sendMessage(String topic, int partitionNum, com.alibaba.otter.canal.protocol.Message msg) {
        Producer<byte[]> producer = this.getProducer(topic);
        byte[] msgBytes = CanalMessageSerializerUtil.serializer((com.alibaba.otter.canal.protocol.Message)msg, (boolean)this.mqProperties.isFilterTransactionEntry());
        try {
            MessageId msgResultId = producer.newMessage().property(MSG_PROPERTY_PARTITION_NAME, String.valueOf(partitionNum)).value(msgBytes).send();
            if (logger.isDebugEnabled()) {
                logger.debug("Send Message to topic:{} Result: {}", (Object)topic, (Object)msgResultId);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void sendMessage(String topic, int partition, List<FlatMessage> flatMessages) {
        Producer<byte[]> producer = this.getProducer(topic);
        for (FlatMessage f : flatMessages) {
            try {
                MessageId msgResultId = producer.newMessage().property(MSG_PROPERTY_PARTITION_NAME, String.valueOf(partition)).value(JSON.toJSONBytes((Object)f, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls})).send();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Send Messages to topic:{} Result: {}", (Object)topic, (Object)msgResultId);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createMultipleTopic(String topic, Integer partitionNum) {
        PulsarMQProducerConfig pulsarMQProperties = (PulsarMQProducerConfig)this.mqProperties;
        String prefix = pulsarMQProperties.getTopicTenantPrefix();
        String fullTopic = topic;
        if (!StringUtils.isEmpty((String)prefix)) {
            if (!prefix.endsWith("/")) {
                fullTopic = "/" + fullTopic;
            }
            fullTopic = pulsarMQProperties.getTopicTenantPrefix() + fullTopic;
        }
        try {
            this.pulsarAdmin.topics().createPartitionedTopic(fullTopic, partitionNum);
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Producer<byte[]> getProducer(String topic) {
        Producer<byte[]> producer = PRODUCERS.get(topic);
        if (null == producer || !producer.isConnected()) {
            try {
                Map<String, Producer<byte[]>> map = PRODUCERS;
                synchronized (map) {
                    producer = PRODUCERS.get(topic);
                    if (null != producer && producer.isConnected()) {
                        return producer;
                    }
                    PulsarMQProducerConfig pulsarMQProperties = (PulsarMQProducerConfig)this.mqProperties;
                    String prefix = pulsarMQProperties.getTopicTenantPrefix();
                    String fullTopic = topic;
                    if (!StringUtils.isEmpty((String)prefix)) {
                        if (!prefix.endsWith("/")) {
                            fullTopic = "/" + fullTopic;
                        }
                        fullTopic = pulsarMQProperties.getTopicTenantPrefix() + fullTopic;
                    }
                    producer = this.client.newProducer().topic(fullTopic).messageRouter(new MessageRouterImpl(topic)).create();
                    PRODUCERS.put(topic, producer);
                }
            }
            catch (PulsarClientException e) {
                logger.error("create producer failed for topic: " + topic, e);
                throw new RuntimeException(e);
            }
        }
        return producer;
    }

    public void stop() {
        logger.info("## Stop PulsarMQ producer##");
        for (Producer<byte[]> p : PRODUCERS.values()) {
            try {
                if (null == p || !p.isConnected()) continue;
                p.close();
            }
            catch (PulsarClientException e) {
                logger.warn("close producer name: {}, topic: {}, error: {}", p.getProducerName(), p.getTopic(), e.getMessage());
            }
        }
        super.stop();
    }

    private static class MessageRouterImpl
    implements MessageRouter {
        private String topicLocal;

        public MessageRouterImpl(String topicLocal) {
            this.topicLocal = topicLocal;
        }

        @Override
        public int choosePartition(Message<?> msg, TopicMetadata metadata) {
            Integer partitionNum;
            String partitionStr = msg.getProperty(CanalPulsarMQProducer.MSG_PROPERTY_PARTITION_NAME);
            int partition = 0;
            if (!StringUtils.isEmpty((String)partitionStr)) {
                try {
                    partition = Integer.parseInt(partitionStr);
                }
                catch (NumberFormatException e) {
                    logger.warn("Parse msg {} property failed for value: {}", (Object)CanalPulsarMQProducer.MSG_PROPERTY_PARTITION_NAME, (Object)partitionStr);
                }
            }
            if (null != (partitionNum = Integer.valueOf(metadata.numPartitions())) && partition >= partitionNum) {
                partition %= partitionNum.intValue();
            }
            return partition;
        }
    }
}

