/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.KeyStoreParams;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.keystoretls.KeyStoreSSLContext;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.io.netty.util.concurrent.DefaultThreadFactory;
import org.apache.pulsar.shade.javax.ws.rs.client.Client;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.BoundRequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.Response;
import org.apache.pulsar.shade.org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.apache.pulsar.shade.org.asynchttpclient.netty.ssl.JsseSslEngineFactory;
import org.apache.pulsar.shade.org.glassfish.jersey.client.ClientRequest;
import org.apache.pulsar.shade.org.glassfish.jersey.client.ClientResponse;
import org.apache.pulsar.shade.org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.apache.pulsar.shade.org.glassfish.jersey.client.spi.Connector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncHttpConnector
implements Connector {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpConnector.class);
    private static final TimeoutException READ_TIMEOUT_EXCEPTION = FutureUtil.createTimeoutException("Read timeout", AsyncHttpConnector.class, "retryOrTimeout(...)");
    private final AsyncHttpClient httpClient;
    private final Duration readTimeout;
    private final int maxRetries;
    private final PulsarServiceNameResolver serviceNameResolver;
    private final ScheduledExecutorService delayer = Executors.newScheduledThreadPool(1, new DefaultThreadFactory("delayer"));

    public AsyncHttpConnector(Client client, ClientConfigurationData conf, int autoCertRefreshTimeSeconds) {
        this((Integer)client.getConfiguration().getProperty("org.apache.pulsar.shade.jersey.config.client.connectTimeout"), (Integer)client.getConfiguration().getProperty("org.apache.pulsar.shade.jersey.config.client.readTimeout"), 300000, autoCertRefreshTimeSeconds, conf);
    }

    public AsyncHttpConnector(int connectTimeoutMs, int readTimeoutMs, int requestTimeoutMs, int autoCertRefreshTimeSeconds, ClientConfigurationData conf) {
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        confBuilder.setFollowRedirect(true);
        confBuilder.setRequestTimeout(conf.getRequestTimeoutMs());
        confBuilder.setConnectTimeout(connectTimeoutMs);
        confBuilder.setReadTimeout(readTimeoutMs);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setRequestTimeout(requestTimeoutMs);
        confBuilder.setIoThreadsCount(conf.getNumIoThreads());
        confBuilder.setKeepAliveStrategy(new DefaultKeepAliveStrategy(){

            @Override
            public boolean keepAlive(InetSocketAddress remoteAddress, Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(remoteAddress, ahcRequest, request, response);
            }
        });
        this.serviceNameResolver = new PulsarServiceNameResolver();
        if (conf != null && StringUtils.isNotBlank(conf.getServiceUrl())) {
            this.serviceNameResolver.updateServiceUrl(conf.getServiceUrl());
            if (conf.getServiceUrl().startsWith("https://")) {
                AuthenticationDataProvider authData = conf.getAuthentication().getAuthData();
                if (conf.isUseKeyStoreTls()) {
                    KeyStoreParams params = authData.hasDataForTls() ? authData.getTlsKeyStoreParams() : null;
                    SSLContext sslCtx = KeyStoreSSLContext.createClientSslContext(conf.getSslProvider(), params != null ? params.getKeyStoreType() : null, params != null ? params.getKeyStorePath() : null, params != null ? params.getKeyStorePassword() : null, conf.isTlsAllowInsecureConnection() || !conf.isTlsHostnameVerificationEnable(), conf.getTlsTrustStoreType(), conf.getTlsTrustStorePath(), conf.getTlsTrustStorePassword(), conf.getTlsCiphers(), conf.getTlsProtocols());
                    JsseSslEngineFactory sslEngineFactory = new JsseSslEngineFactory(sslCtx);
                    confBuilder.setSslEngineFactory(sslEngineFactory);
                } else {
                    SslContext sslCtx = null;
                    sslCtx = authData.hasDataForTls() ? (authData.getTlsTrustStoreStream() == null ? SecurityUtility.createAutoRefreshSslContextForClient(conf.isTlsAllowInsecureConnection() || !conf.isTlsHostnameVerificationEnable(), conf.getTlsTrustCertsFilePath(), authData.getTlsCerificateFilePath(), authData.getTlsPrivateKeyFilePath(), null, autoCertRefreshTimeSeconds, this.delayer) : SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection() || !conf.isTlsHostnameVerificationEnable(), authData.getTlsTrustStoreStream(), authData.getTlsCertificates(), authData.getTlsPrivateKey())) : SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection() || !conf.isTlsHostnameVerificationEnable(), conf.getTlsTrustCertsFilePath());
                    confBuilder.setSslContext(sslCtx);
                }
            }
        }
        this.httpClient = new DefaultAsyncHttpClient(confBuilder.build());
        this.readTimeout = Duration.ofMillis(readTimeoutMs);
        this.maxRetries = this.httpClient.getConfig().getMaxRequestRetry();
    }

    @Override
    public ClientResponse apply(ClientRequest jerseyRequest) {
        final CompletableFuture future = new CompletableFuture();
        this.apply(jerseyRequest, new AsyncConnectorCallback(){

            @Override
            public void response(ClientResponse response) {
                future.complete(response);
            }

            @Override
            public void failure(Throwable failure) {
                future.completeExceptionally(failure);
            }
        });
        try {
            return (ClientResponse)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private URI replaceWithNew(InetSocketAddress address, URI uri) {
        String originalUri = uri.toString();
        String newUri = originalUri.split(":")[0] + "://" + address.getHostName() + ":" + address.getPort() + uri.getRawPath();
        if (uri.getRawQuery() != null) {
            newUri = newUri + "?" + uri.getRawQuery();
        }
        return URI.create(newUri);
    }

    @Override
    public Future<?> apply(ClientRequest jerseyRequest, AsyncConnectorCallback callback) {
        CompletableFuture<Response> responseFuture = this.retryOrTimeOut(jerseyRequest);
        responseFuture.whenComplete((response, throwable) -> {
            if (throwable != null) {
                callback.failure((Throwable)throwable);
            } else {
                ClientResponse jerseyResponse = new ClientResponse(Response.Status.fromStatusCode(response.getStatusCode()), jerseyRequest);
                jerseyResponse.setStatusInfo(new Response.StatusType((Response)response){
                    final /* synthetic */ Response val$response;
                    {
                        this.val$response = response;
                    }

                    @Override
                    public int getStatusCode() {
                        return this.val$response.getStatusCode();
                    }

                    @Override
                    public Response.Status.Family getFamily() {
                        return Response.Status.Family.familyOf(this.val$response.getStatusCode());
                    }

                    @Override
                    public String getReasonPhrase() {
                        return this.val$response.getStatusText();
                    }
                });
                response.getHeaders().forEach(e -> jerseyResponse.header((String)e.getKey(), e.getValue()));
                if (response.hasResponseBody()) {
                    jerseyResponse.setEntityStream(response.getResponseBodyAsStream());
                }
                callback.response(jerseyResponse);
            }
        });
        return responseFuture;
    }

    private CompletableFuture<Response> retryOrTimeOut(ClientRequest request) {
        CompletableFuture resultFuture = new CompletableFuture();
        this.retryOperation(resultFuture, () -> this.oneShot(this.serviceNameResolver.resolveHost(), request), this.maxRetries);
        CompletableFuture timeoutAfter = FutureUtil.createFutureWithTimeout(this.readTimeout, this.delayer, () -> READ_TIMEOUT_EXCEPTION);
        return resultFuture.applyToEither((CompletionStage)timeoutAfter, Function.identity());
    }

    private <T> void retryOperation(CompletableFuture<T> resultFuture, Supplier<CompletableFuture<T>> operation, int retries) {
        if (!resultFuture.isDone()) {
            CompletableFuture operationFuture = operation.get();
            operationFuture.whenComplete((t, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof CancellationException) {
                        resultFuture.completeExceptionally(new RetryException("Operation future was cancelled.", (Throwable)throwable));
                    } else if (retries > 0) {
                        this.retryOperation(resultFuture, operation, retries - 1);
                    } else {
                        resultFuture.completeExceptionally(new RetryException("Could not complete the operation. Number of retries has been exhausted. Failed reason: " + throwable.getMessage(), (Throwable)throwable));
                    }
                } else {
                    resultFuture.complete(t);
                }
            });
            resultFuture.whenComplete((t, throwable) -> operationFuture.cancel(false));
        }
    }

    private CompletableFuture<Response> oneShot(InetSocketAddress host, ClientRequest request) {
        ClientRequest currentRequest = new ClientRequest(request);
        URI newUri = this.replaceWithNew(host, currentRequest.getUri());
        currentRequest.setUri(newUri);
        BoundRequestBuilder builder = this.httpClient.prepare(currentRequest.getMethod(), currentRequest.getUri().toString());
        if (currentRequest.hasEntity()) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            currentRequest.setStreamProvider(contentLength -> outStream);
            try {
                currentRequest.writeEntity();
            }
            catch (IOException e) {
                CompletableFuture<Response> r = new CompletableFuture<Response>();
                r.completeExceptionally(e);
                return r;
            }
            builder.setBody(outStream.toByteArray());
        }
        currentRequest.getHeaders().forEach((key, headers) -> {
            if (!"User-Agent".equals(key)) {
                builder.addHeader((CharSequence)key, (Iterable<?>)headers);
            }
        });
        return builder.execute().toCompletableFuture();
    }

    @Override
    public String getName() {
        return "Pulsar-Admin";
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
            this.delayer.shutdownNow();
        }
        catch (IOException e) {
            log.warn("Failed to close http client", e);
        }
    }

    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public static class RetryException
    extends Exception {
        public RetryException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

