/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.reader;

import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.org.apache.avro.AvroTypeException;
import org.apache.pulsar.shade.org.apache.commons.codec.binary.Hex;
import org.apache.pulsar.shade.org.apache.commons.lang3.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiVersionReader<T>
implements SchemaReader<T> {
    protected final SchemaReader<T> providerSchemaReader;
    protected SchemaInfoProvider schemaInfoProvider;
    LoadingCache<BytesSchemaVersion, SchemaReader<T>> readerCache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<BytesSchemaVersion, SchemaReader<T>>(){

        @Override
        public SchemaReader<T> load(BytesSchemaVersion schemaVersion) {
            return AbstractMultiVersionReader.this.loadReader(schemaVersion);
        }
    });
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractMultiVersionReader.class);

    public AbstractMultiVersionReader(SchemaReader<T> providerSchemaReader) {
        this.providerSchemaReader = providerSchemaReader;
    }

    @Override
    public T read(byte[] bytes, int offset, int length) {
        return this.providerSchemaReader.read(bytes);
    }

    @Override
    public T read(InputStream inputStream) {
        return this.providerSchemaReader.read(inputStream);
    }

    @Override
    public T read(InputStream inputStream, byte[] schemaVersion) {
        try {
            return schemaVersion == null ? this.read(inputStream) : this.getSchemaReader(schemaVersion).read(inputStream);
        }
        catch (ExecutionException e) {
            LOG.error("Can't get generic schema for topic {} schema version {}", this.schemaInfoProvider.getTopicName(), Hex.encodeHexString(schemaVersion), e);
            throw new RuntimeException("Can't get generic schema for topic " + this.schemaInfoProvider.getTopicName());
        }
    }

    public SchemaReader<T> getSchemaReader(byte[] schemaVersion) throws ExecutionException {
        return this.readerCache.get(BytesSchemaVersion.of(schemaVersion));
    }

    @Override
    public T read(byte[] bytes, byte[] schemaVersion) {
        try {
            return schemaVersion == null ? this.read(bytes) : this.getSchemaReader(schemaVersion).read(bytes);
        }
        catch (ExecutionException | AvroTypeException e) {
            if (e instanceof AvroTypeException) {
                throw new SchemaSerializationException(e);
            }
            LOG.error("Can't get generic schema for topic {} schema version {}", this.schemaInfoProvider.getTopicName(), Hex.encodeHexString(schemaVersion), e);
            throw new RuntimeException("Can't get generic schema for topic " + this.schemaInfoProvider.getTopicName());
        }
    }

    @Override
    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
    }

    protected abstract SchemaReader<T> loadReader(BytesSchemaVersion var1);

    protected SchemaInfo getSchemaInfoByVersion(byte[] schemaVersion) {
        try {
            return this.schemaInfoProvider.getSchemaByVersion(schemaVersion).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SerializationException("Interrupted at fetching schema info for " + SchemaUtils.getStringSchemaVersion(schemaVersion), e);
        }
        catch (ExecutionException e) {
            throw new SerializationException("Failed at fetching schema info for " + SchemaUtils.getStringSchemaVersion(schemaVersion), e.getCause());
        }
    }
}

