/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.pulsar.common.util.FileModifiedTimeUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustManagerProxy
extends X509ExtendedTrustManager {
    private static final Logger log = LoggerFactory.getLogger(TrustManagerProxy.class);
    private volatile X509ExtendedTrustManager trustManager;
    private FileModifiedTimeUpdater certFile;

    public TrustManagerProxy(String caCertFile, int refreshDurationSec, ScheduledExecutorService executor) {
        this.certFile = new FileModifiedTimeUpdater(caCertFile);
        try {
            this.updateTrustManager();
        }
        catch (IOException | CertificateException e) {
            log.warn("Failed to load cert {}, {}", (Object)this.certFile, (Object)e.getMessage());
            throw new IllegalArgumentException(e);
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            log.warn("Failed to init trust-store", e);
            throw new IllegalArgumentException(e);
        }
        executor.scheduleWithFixedDelay(() -> this.updateTrustManagerSafely(), refreshDurationSec, refreshDurationSec, TimeUnit.SECONDS);
    }

    private void updateTrustManagerSafely() {
        try {
            this.updateTrustManager();
        }
        catch (Exception e) {
            log.warn("Failed to init trust-store {}", (Object)this.certFile.getFileName(), (Object)e);
        }
    }

    private void updateTrustManager() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, FileNotFoundException, IOException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        try (FileInputStream inputStream = new FileInputStream(this.certFile.getFileName());){
            X509Certificate certificate = (X509Certificate)factory.generateCertificate(inputStream);
            String alias = certificate.getSubjectX500Principal().getName();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setCertificateEntry(alias, certificate);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            this.trustManager = (X509ExtendedTrustManager)trustManagerFactory.getTrustManagers()[0];
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
        this.trustManager.checkClientTrusted(x509Certificates, s2);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) throws CertificateException {
        this.trustManager.checkServerTrusted(x509Certificates, s2);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType, engine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType, engine);
    }
}

