/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.kafka.consumer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.otter.canal.common.utils.PropertiesUtils;
import com.alibaba.otter.canal.connector.core.consumer.CommonMessage;
import com.alibaba.otter.canal.connector.core.spi.CanalMsgConsumer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.MessageUtil;
import com.alibaba.otter.canal.connector.kafka.consumer.KafkaMessageDeserializer;
import com.alibaba.otter.canal.protocol.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;

@SPI(value="kafka")
public class CanalKafkaConsumer
implements CanalMsgConsumer {
    private static final String PREFIX_KAFKA_CONFIG = "kafka.";
    private KafkaConsumer<String, ?> kafkaConsumer;
    private boolean flatMessage = true;
    private String topic;
    private Map<Integer, Long> currentOffsets = new ConcurrentHashMap<Integer, Long>();
    private Properties kafkaProperties = new Properties();

    public void init(Properties properties, String topic, String groupId) {
        this.topic = topic;
        Boolean flatMessage = (Boolean)properties.get("canal.mq.flatMessage");
        if (flatMessage != null) {
            this.flatMessage = flatMessage;
        }
        for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
            String k = (String)entry2.getKey();
            Object v = entry2.getValue();
            if (!k.startsWith(PREFIX_KAFKA_CONFIG) || v == null) continue;
            v = PropertiesUtils.getProperty((Properties)properties, (String)k);
            this.kafkaProperties.put(k.substring(PREFIX_KAFKA_CONFIG.length()), v);
        }
        this.kafkaProperties.put("group.id", groupId);
        this.kafkaProperties.put("key.deserializer", StringDeserializer.class);
        this.kafkaProperties.put("client.id", UUID.randomUUID().toString().substring(0, 6));
    }

    public void connect() {
        if (this.flatMessage) {
            this.kafkaProperties.put("value.deserializer", StringDeserializer.class);
            this.kafkaConsumer = new KafkaConsumer(this.kafkaProperties);
        } else {
            this.kafkaProperties.put("value.deserializer", KafkaMessageDeserializer.class);
            this.kafkaConsumer = new KafkaConsumer(this.kafkaProperties);
        }
        this.kafkaConsumer.subscribe(Collections.singletonList(this.topic));
    }

    public List<CommonMessage> getMessage(Long timeout, TimeUnit unit) {
        if (!this.flatMessage) {
            ConsumerRecords<String, ?> records = this.kafkaConsumer.poll(unit.toMillis(timeout));
            if (!records.isEmpty()) {
                this.currentOffsets.clear();
                ArrayList<CommonMessage> messages = new ArrayList<CommonMessage>();
                for (ConsumerRecord<String, ?> consumerRecord : records) {
                    if (this.currentOffsets.get(consumerRecord.partition()) == null) {
                        this.currentOffsets.put(consumerRecord.partition(), consumerRecord.offset());
                    }
                    messages.addAll(MessageUtil.convert((Message)((Message)consumerRecord.value())));
                }
                return messages;
            }
        } else {
            ConsumerRecords<String, ?> records = this.kafkaConsumer.poll(unit.toMillis(timeout));
            if (!records.isEmpty()) {
                ArrayList<CommonMessage> messages = new ArrayList<CommonMessage>();
                this.currentOffsets.clear();
                for (ConsumerRecord<String, ?> consumerRecord : records) {
                    if (this.currentOffsets.get(consumerRecord.partition()) == null) {
                        this.currentOffsets.put(consumerRecord.partition(), consumerRecord.offset());
                    }
                    String flatMessageJson = (String)consumerRecord.value();
                    CommonMessage flatMessages = (CommonMessage)JSON.parseObject((String)flatMessageJson, CommonMessage.class);
                    messages.add(flatMessages);
                }
                return messages;
            }
        }
        return null;
    }

    public void rollback() {
        if (this.kafkaConsumer != null) {
            for (Map.Entry<Integer, Long> entry2 : this.currentOffsets.entrySet()) {
                this.kafkaConsumer.seek(new TopicPartition(this.topic, entry2.getKey()), this.currentOffsets.get(entry2.getKey()));
                this.kafkaConsumer.commitSync();
            }
        }
    }

    public void ack() {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.commitSync();
        }
    }

    public void disconnect() {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.unsubscribe();
        }
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.close();
            this.kafkaConsumer = null;
        }
    }
}

