/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.kafka.producer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.otter.canal.common.utils.ExecutorTemplate;
import com.alibaba.otter.canal.common.utils.PropertiesUtils;
import com.alibaba.otter.canal.connector.core.producer.AbstractMQProducer;
import com.alibaba.otter.canal.connector.core.producer.MQDestination;
import com.alibaba.otter.canal.connector.core.producer.MQMessageUtils;
import com.alibaba.otter.canal.connector.core.spi.CanalMQProducer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.Callback;
import com.alibaba.otter.canal.connector.core.util.CanalMessageSerializerUtil;
import com.alibaba.otter.canal.connector.kafka.config.KafkaProducerConfig;
import com.alibaba.otter.canal.connector.kafka.producer.KafkaMessageSerializer;
import com.alibaba.otter.canal.protocol.FlatMessage;
import com.alibaba.otter.canal.protocol.Message;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(value="kafka")
public class CanalKafkaProducer
extends AbstractMQProducer
implements CanalMQProducer {
    private static final Logger logger = LoggerFactory.getLogger(CanalKafkaProducer.class);
    private static final String PREFIX_KAFKA_CONFIG = "kafka.";
    private Producer<String, byte[]> producer;

    public void init(Properties properties) {
        KafkaProducerConfig kafkaProducerConfig = new KafkaProducerConfig();
        this.mqProperties = kafkaProducerConfig;
        super.init(properties);
        this.loadKafkaProperties(properties);
        Properties kafkaProperties = new Properties();
        kafkaProperties.putAll(kafkaProducerConfig.getKafkaProperties());
        kafkaProperties.put("max.in.flight.requests.per.connection", (Object)1);
        kafkaProperties.put("key.serializer", StringSerializer.class);
        if (kafkaProducerConfig.isKerberosEnabled()) {
            File krb5File = new File(kafkaProducerConfig.getKrb5File());
            File jaasFile = new File(kafkaProducerConfig.getJaasFile());
            if (krb5File.exists() && jaasFile.exists()) {
                System.setProperty("java.security.krb5.conf", krb5File.getAbsolutePath());
                System.setProperty("java.security.auth.login.config", jaasFile.getAbsolutePath());
                System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
                kafkaProperties.put("security.protocol", "SASL_PLAINTEXT");
                kafkaProperties.put("sasl.kerberos.service.name", "kafka");
            } else {
                String errorMsg = "ERROR # The kafka kerberos configuration file does not exist! please check it";
                logger.error(errorMsg);
                throw new RuntimeException(errorMsg);
            }
        }
        kafkaProperties.put("value.serializer", KafkaMessageSerializer.class);
        this.producer = new KafkaProducer<String, byte[]>(kafkaProperties);
    }

    private void loadKafkaProperties(Properties properties) {
        String jaasFile;
        String krb5File;
        KafkaProducerConfig kafkaProducerConfig = (KafkaProducerConfig)this.mqProperties;
        Map<String, Object> kafkaProperties = kafkaProducerConfig.getKafkaProperties();
        this.doMoreCompatibleConvert("canal.mq.servers", "kafka.bootstrap.servers", properties);
        this.doMoreCompatibleConvert("canal.mq.acks", "kafka.acks", properties);
        this.doMoreCompatibleConvert("canal.mq.compressionType", "kafka.compression.type", properties);
        this.doMoreCompatibleConvert("canal.mq.retries", "kafka.retries", properties);
        this.doMoreCompatibleConvert("canal.mq.batchSize", "kafka.batch.size", properties);
        this.doMoreCompatibleConvert("canal.mq.lingerMs", "kafka.linger.ms", properties);
        this.doMoreCompatibleConvert("canal.mq.maxRequestSize", "kafka.max.request.size", properties);
        this.doMoreCompatibleConvert("canal.mq.bufferMemory", "kafka.buffer.memory", properties);
        this.doMoreCompatibleConvert("canal.mq.kafka.kerberos.enable", "kafka.kerberos.enable", properties);
        this.doMoreCompatibleConvert("canal.mq.kafka.kerberos.krb5.file", "kafka.kerberos.krb5.file", properties);
        this.doMoreCompatibleConvert("canal.mq.kafka.kerberos.jaas.file", "kafka.kerberos.jaas.file", properties);
        for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
            String key = (String)entry2.getKey();
            Object value2 = entry2.getValue();
            if (!key.startsWith(PREFIX_KAFKA_CONFIG) || value2 == null) continue;
            value2 = PropertiesUtils.getProperty((Properties)properties, (String)key);
            key = key.substring(PREFIX_KAFKA_CONFIG.length());
            kafkaProperties.put(key, value2);
        }
        String kerberosEnabled = PropertiesUtils.getProperty((Properties)properties, (String)"kafka.kerberos.enable");
        if (!StringUtils.isEmpty((String)kerberosEnabled)) {
            kafkaProducerConfig.setKerberosEnabled(Boolean.parseBoolean(kerberosEnabled));
        }
        if (!StringUtils.isEmpty((String)(krb5File = PropertiesUtils.getProperty((Properties)properties, (String)"kafka.kerberos.krb5.file")))) {
            kafkaProducerConfig.setKrb5File(krb5File);
        }
        if (!StringUtils.isEmpty((String)(jaasFile = PropertiesUtils.getProperty((Properties)properties, (String)"kafka.kerberos.jaas.file")))) {
            kafkaProducerConfig.setJaasFile(jaasFile);
        }
    }

    public void stop() {
        try {
            logger.info("## stop the kafka producer");
            if (this.producer != null) {
                this.producer.close();
            }
            super.stop();
        }
        catch (Throwable e) {
            logger.warn("##something goes wrong when stopping kafka producer:", e);
        }
        finally {
            logger.info("## kafka producer is down.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MQDestination mqDestination, Message message, Callback callback) {
        ExecutorTemplate template = new ExecutorTemplate(this.sendExecutor);
        try {
            List result2;
            if (!StringUtils.isEmpty((String)mqDestination.getDynamicTopic())) {
                Map messageMap = MQMessageUtils.messageTopics((Message)message, (String)mqDestination.getTopic(), (String)mqDestination.getDynamicTopic());
                for (Map.Entry entry2 : messageMap.entrySet()) {
                    String topicName = ((String)entry2.getKey()).replace('.', '_');
                    Message messageSub = (Message)entry2.getValue();
                    template.submit(() -> {
                        try {
                            return this.send(mqDestination, topicName, messageSub, this.mqProperties.isFlatMessage());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                result2 = template.waitForResult();
            } else {
                result2 = new ArrayList<List<Future>>();
                List<Future> futures = this.send(mqDestination, mqDestination.getTopic(), message, this.mqProperties.isFlatMessage());
                result2.add(futures);
            }
            this.producer.flush();
            for (Object obj : result2) {
                List futures = (List)obj;
                for (Future future : futures) {
                    try {
                        future.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            callback.commit();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            callback.rollback();
        }
        finally {
            template.clear();
        }
    }

    private List<Future> send(MQDestination mqDestination, String topicName, Message message, boolean flat) {
        ArrayList<ProducerRecord<String, byte[]>> records = new ArrayList<ProducerRecord<String, byte[]>>();
        Integer partitionNum = MQMessageUtils.parseDynamicTopicPartition((String)topicName, (String)mqDestination.getDynamicTopicPartitionNum());
        if (partitionNum == null) {
            partitionNum = mqDestination.getPartitionsNum();
        }
        if (!flat) {
            if (mqDestination.getPartitionHash() != null && !mqDestination.getPartitionHash().isEmpty()) {
                MQMessageUtils.EntryRowData[] datas = MQMessageUtils.buildMessageData((Message)message, (ThreadPoolExecutor)this.buildExecutor);
                Message[] messages = MQMessageUtils.messagePartition((MQMessageUtils.EntryRowData[])datas, (long)message.getId(), (Integer)partitionNum, (String)mqDestination.getPartitionHash(), (boolean)this.mqProperties.isDatabaseHash());
                int length = messages.length;
                for (int i = 0; i < length; ++i) {
                    Message messagePartition = messages[i];
                    if (messagePartition == null) continue;
                    records.add(new ProducerRecord<Object, byte[]>(topicName, i, null, CanalMessageSerializerUtil.serializer((Message)messagePartition, (boolean)this.mqProperties.isFilterTransactionEntry())));
                }
            } else {
                int partition2 = mqDestination.getPartition() != null ? mqDestination.getPartition() : 0;
                records.add(new ProducerRecord<Object, byte[]>(topicName, partition2, null, CanalMessageSerializerUtil.serializer((Message)message, (boolean)this.mqProperties.isFilterTransactionEntry())));
            }
        } else {
            MQMessageUtils.EntryRowData[] datas = MQMessageUtils.buildMessageData((Message)message, (ThreadPoolExecutor)this.buildExecutor);
            List flatMessages = MQMessageUtils.messageConverter((MQMessageUtils.EntryRowData[])datas, (long)message.getId());
            for (FlatMessage flatMessage : flatMessages) {
                if (mqDestination.getPartitionHash() != null && !mqDestination.getPartitionHash().isEmpty()) {
                    FlatMessage[] partitionFlatMessage = MQMessageUtils.messagePartition((FlatMessage)flatMessage, (Integer)partitionNum, (String)mqDestination.getPartitionHash(), (boolean)this.mqProperties.isDatabaseHash());
                    int length = partitionFlatMessage.length;
                    for (int i = 0; i < length; ++i) {
                        FlatMessage flatMessagePart = partitionFlatMessage[i];
                        if (flatMessagePart == null) continue;
                        records.add(new ProducerRecord<Object, byte[]>(topicName, i, null, JSON.toJSONBytes((Object)flatMessagePart, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls})));
                    }
                    continue;
                }
                int partition3 = mqDestination.getPartition() != null ? mqDestination.getPartition() : 0;
                records.add(new ProducerRecord<Object, byte[]>(topicName, partition3, null, JSON.toJSONBytes((Object)flatMessage, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls})));
            }
        }
        return this.produce(records);
    }

    private List<Future> produce(List<ProducerRecord<String, byte[]>> records) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ProducerRecord<String, byte[]> record2 : records) {
            futures.add(this.producer.send(record2));
        }
        return futures;
    }
}

