/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.BaseJsonNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class ArrayNode
extends ContainerNode<ArrayNode> {
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory nf) {
        super(nf);
        this._children = new ArrayList<JsonNode>();
    }

    public ArrayNode(JsonNodeFactory nf, int capacity) {
        super(nf);
        this._children = new ArrayList<JsonNode>(capacity);
    }

    public ArrayNode(JsonNodeFactory nf, List<JsonNode> children2) {
        super(nf);
        this._children = children2;
    }

    @Override
    protected JsonNode _at(JsonPointer ptr) {
        return this.get(ptr.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode ret = new ArrayNode(this._nodeFactory);
        for (JsonNode element : this._children) {
            ret._children.add((JsonNode)element.deepCopy());
        }
        return ret;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int index) {
        if (index >= 0 && index < this._children.size()) {
            return this._children.get(index);
        }
        return null;
    }

    @Override
    public JsonNode get(String fieldName) {
        return null;
    }

    @Override
    public JsonNode path(String fieldName) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int index) {
        if (index >= 0 && index < this._children.size()) {
            return this._children.get(index);
        }
        return MissingNode.getInstance();
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode o) {
        if (!(o instanceof ArrayNode)) {
            return false;
        }
        ArrayNode other = (ArrayNode)o;
        int len = this._children.size();
        if (other.size() != len) {
            return false;
        }
        List<JsonNode> l1 = this._children;
        List<JsonNode> l2 = other._children;
        for (int i = 0; i < len; ++i) {
            if (l1.get(i).equals(comparator, l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator f, SerializerProvider provider) throws IOException {
        List<JsonNode> c = this._children;
        int size2 = c.size();
        f.writeStartArray(size2);
        for (int i = 0; i < size2; ++i) {
            JsonNode n = c.get(i);
            ((BaseJsonNode)n).serialize(f, provider);
        }
        f.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode n : this._children) {
            ((BaseJsonNode)n).serialize(g, provider);
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode findValue(String fieldName) {
        for (JsonNode node2 : this._children) {
            JsonNode value2 = node2.findValue(fieldName);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findValues(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public List<String> findValuesAsText(String fieldName, List<String> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findValuesAsText(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    @Override
    public ObjectNode findParent(String fieldName) {
        for (JsonNode node2 : this._children) {
            JsonNode parent = node2.findParent(fieldName);
            if (parent == null) continue;
            return (ObjectNode)parent;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String fieldName, List<JsonNode> foundSoFar) {
        for (JsonNode node2 : this._children) {
            foundSoFar = node2.findParents(fieldName, foundSoFar);
        }
        return foundSoFar;
    }

    public JsonNode set(int index, JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        if (index < 0 || index >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + index + ", array size " + this.size());
        }
        return this._children.set(index, value2);
    }

    public ArrayNode add(JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        this._add(value2);
        return this;
    }

    public ArrayNode addAll(ArrayNode other) {
        this._children.addAll(other._children);
        return this;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> nodes) {
        this._children.addAll(nodes);
        return this;
    }

    public ArrayNode insert(int index, JsonNode value2) {
        if (value2 == null) {
            value2 = this.nullNode();
        }
        this._insert(index, value2);
        return this;
    }

    public JsonNode remove(int index) {
        if (index >= 0 && index < this._children.size()) {
            return this._children.remove(index);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode n = this.arrayNode();
        this._add(n);
        return n;
    }

    public ObjectNode addObject() {
        ObjectNode n = this.objectNode();
        this._add(n);
        return n;
    }

    public ArrayNode addPOJO(Object value2) {
        if (value2 == null) {
            this.addNull();
        } else {
            this._add(this.pojoNode(value2));
        }
        return this;
    }

    public ArrayNode addRawValue(RawValue raw2) {
        if (raw2 == null) {
            this.addNull();
        } else {
            this._add(this.rawValueNode(raw2));
        }
        return this;
    }

    public ArrayNode addNull() {
        this._add(this.nullNode());
        return this;
    }

    public ArrayNode add(int v) {
        this._add(this.numberNode(v));
        return this;
    }

    public ArrayNode add(Integer value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((int)value2));
    }

    public ArrayNode add(long v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Long value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((long)value2));
    }

    public ArrayNode add(float v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Float value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(value2.floatValue()));
    }

    public ArrayNode add(double v) {
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(Double value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.numberNode((double)value2));
    }

    public ArrayNode add(BigDecimal v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(BigInteger v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.numberNode(v));
    }

    public ArrayNode add(String v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.textNode(v));
    }

    public ArrayNode add(boolean v) {
        return this._add(this.booleanNode(v));
    }

    public ArrayNode add(Boolean value2) {
        if (value2 == null) {
            return this.addNull();
        }
        return this._add(this.booleanNode(value2));
    }

    public ArrayNode add(byte[] v) {
        if (v == null) {
            return this.addNull();
        }
        return this._add(this.binaryNode(v));
    }

    public ArrayNode insertArray(int index) {
        ArrayNode n = this.arrayNode();
        this._insert(index, n);
        return n;
    }

    public ObjectNode insertObject(int index) {
        ObjectNode n = this.objectNode();
        this._insert(index, n);
        return n;
    }

    public ArrayNode insertPOJO(int index, Object value2) {
        if (value2 == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.pojoNode(value2));
    }

    public ArrayNode insertNull(int index) {
        this._insert(index, this.nullNode());
        return this;
    }

    public ArrayNode insert(int index, int v) {
        this._insert(index, this.numberNode(v));
        return this;
    }

    public ArrayNode insert(int index, Integer value2) {
        if (value2 == null) {
            this.insertNull(index);
        } else {
            this._insert(index, this.numberNode((int)value2));
        }
        return this;
    }

    public ArrayNode insert(int index, long v) {
        return this._insert(index, this.numberNode(v));
    }

    public ArrayNode insert(int index, Long value2) {
        if (value2 == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.numberNode((long)value2));
    }

    public ArrayNode insert(int index, float v) {
        return this._insert(index, this.numberNode(v));
    }

    public ArrayNode insert(int index, Float value2) {
        if (value2 == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.numberNode(value2.floatValue()));
    }

    public ArrayNode insert(int index, double v) {
        return this._insert(index, this.numberNode(v));
    }

    public ArrayNode insert(int index, Double value2) {
        if (value2 == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.numberNode((double)value2));
    }

    public ArrayNode insert(int index, BigDecimal v) {
        if (v == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.numberNode(v));
    }

    public ArrayNode insert(int index, BigInteger v) {
        if (v == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.numberNode(v));
    }

    public ArrayNode insert(int index, String v) {
        if (v == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.textNode(v));
    }

    public ArrayNode insert(int index, boolean v) {
        return this._insert(index, this.booleanNode(v));
    }

    public ArrayNode insert(int index, Boolean value2) {
        if (value2 == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.booleanNode(value2));
    }

    public ArrayNode insert(int index, byte[] v) {
        if (v == null) {
            return this.insertNull(index);
        }
        return this._insert(index, this.binaryNode(v));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)o)._children);
        }
        return false;
    }

    protected boolean _childrenEqual(ArrayNode other) {
        return this._children.equals(other._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16 + (this.size() << 4));
        sb.append('[');
        int len = this._children.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this._children.get(i).toString());
        }
        sb.append(']');
        return sb.toString();
    }

    protected ArrayNode _add(JsonNode node2) {
        this._children.add(node2);
        return this;
    }

    protected ArrayNode _insert(int index, JsonNode node2) {
        if (index < 0) {
            this._children.add(0, node2);
        } else if (index >= this._children.size()) {
            this._children.add(node2);
        } else {
            this._children.add(index, node2);
        }
        return this;
    }
}

