/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.Properties;
import java.util.Random;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtilities;
import kafka.admin.AdminUtilities$class;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$User$;
import kafka.utils.Json$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.math.Ordering$String$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class AdminUtils$
implements Logging,
AdminUtilities {
    public static final AdminUtils$ MODULE$;
    private final Random rand;
    private final String AdminClientId;
    private final String EntityConfigChangeZnodePrefix;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new AdminUtils$();
    }

    @Override
    public void changeConfigs(ZkUtils zkUtils, String entityType, String entityName, Properties configs) {
        AdminUtilities$class.changeConfigs(this, zkUtils, entityType, entityName, configs);
    }

    private Logger logger$lzycompute() {
        AdminUtils$ adminUtils$ = this;
        synchronized (adminUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Random rand() {
        return this.rand;
    }

    public String AdminClientId() {
        return this.AdminClientId;
    }

    public String EntityConfigChangeZnodePrefix() {
        return this.EntityConfigChangeZnodePrefix;
    }

    public Map<Object, Seq<Object>> assignReplicasToBrokers(Seq<BrokerMetadata> brokerMetadatas, int nPartitions, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Map<Object, Seq<Object>> map2;
        if (nPartitions <= 0) {
            throw new InvalidPartitionsException("Number of partitions must be larger than 0.");
        }
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Replication factor must be larger than 0.");
        }
        if (replicationFactor > brokerMetadatas.size()) {
            throw new InvalidReplicationFactorException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication factor: ", " larger than available brokers: ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(replicationFactor), BoxesRunTime.boxToInteger(brokerMetadatas.size())})));
        }
        if (brokerMetadatas.forall((Function1<BrokerMetadata, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BrokerMetadata x$1) {
                return x$1.rack().isEmpty();
            }
        }))) {
            map2 = this.assignReplicasToBrokersRackUnaware(nPartitions, replicationFactor, brokerMetadatas.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(BrokerMetadata x$2) {
                    return x$2.id();
                }
            }, Seq$.MODULE$.canBuildFrom()), fixedStartIndex, startPartitionId);
        } else {
            if (brokerMetadatas.exists((Function1<BrokerMetadata, Object>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(BrokerMetadata x$3) {
                    return x$3.rack().isEmpty();
                }
            }))) {
                throw new AdminOperationException("Not all brokers have rack information for replica rack aware assignment.");
            }
            map2 = this.assignReplicasToBrokersRackAware(nPartitions, replicationFactor, brokerMetadatas, fixedStartIndex, startPartitionId);
        }
        return map2;
    }

    public int assignReplicasToBrokers$default$4() {
        return -1;
    }

    public int assignReplicasToBrokers$default$5() {
        return -1;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackUnaware(int nPartitions, int replicationFactor, Seq<Object> brokerList, int fixedStartIndex, int startPartitionId) {
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        int[] brokerArray = (int[])brokerList.toArray(ClassTag$.MODULE$.Int());
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length);
        IntRef currentPartitionId = IntRef.create(package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(brokerArray.length));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(replicationFactor, ret, brokerArray, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$1;
            private final scala.collection.mutable.Map ret$1;
            public final int[] brokerArray$1;
            private final int startIndex$1;
            private final IntRef currentPartitionId$1;
            public final IntRef nextReplicaShift$1;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$1.elem > 0 && this.currentPartitionId$1.elem % this.brokerArray$1.length == 0) {
                    ++this.nextReplicaShift$1.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$1.elem + this.startIndex$1) % this.brokerArray$1.length;
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{this.brokerArray$1[firstReplicaIndex]}));
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$1 - 1).foreach(new Serializable(this, firstReplicaIndex, replicaBuffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackUnaware.1 $outer;
                    private final int firstReplicaIndex$1;
                    private final ArrayBuffer replicaBuffer$1;

                    public final ArrayBuffer<Object> apply(int j) {
                        return this.replicaBuffer$1.$plus$eq(BoxesRunTime.boxToInteger(this.$outer.brokerArray$1[AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$1, this.$outer.nextReplicaShift$1.elem, j, this.$outer.brokerArray$1.length)]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$1 = firstReplicaIndex$1;
                        this.replicaBuffer$1 = replicaBuffer$1;
                    }
                });
                this.ret$1.put(BoxesRunTime.boxToInteger(this.currentPartitionId$1.elem), replicaBuffer);
                ++this.currentPartitionId$1.elem;
            }
            {
                this.replicationFactor$1 = replicationFactor$1;
                this.ret$1 = ret$1;
                this.brokerArray$1 = brokerArray$1;
                this.startIndex$1 = startIndex$1;
                this.currentPartitionId$1 = currentPartitionId$1;
                this.nextReplicaShift$1 = nextReplicaShift$1;
            }
        }));
        return ret;
    }

    private Map<Object, Seq<Object>> assignReplicasToBrokersRackAware(int nPartitions, int replicationFactor, Seq<BrokerMetadata> brokerMetadatas, int fixedStartIndex, int startPartitionId) {
        scala.collection.immutable.Map<Object, String> brokerRackMap = ((TraversableOnce)brokerMetadatas.collect(new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends BrokerMetadata, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                void var8_10;
                A1 A1 = x1;
                if (A1 != null) {
                    int id = A1.id();
                    Option<String> option = A1.rack();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String rack = (String)some.x();
                        Tuple2<Integer, String> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(id)), rack);
                        return var8_10;
                    }
                }
                B1 B1 = function1.apply(x1);
                return var8_10;
            }

            public final boolean isDefinedAt(BrokerMetadata x1) {
                Option<String> option;
                BrokerMetadata brokerMetadata = x1;
                boolean bl = brokerMetadata != null && (option = brokerMetadata.rack()) instanceof Some;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int numRacks = brokerRackMap.values().toSet().size();
        IndexedSeq<Object> arrangedBrokerList = this.getRackAlternatedBrokerList(brokerRackMap);
        int numBrokers = arrangedBrokerList.size();
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        int startIndex = fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size());
        IntRef currentPartitionId = IntRef.create(package$.MODULE$.max(0, startPartitionId));
        IntRef nextReplicaShift = IntRef.create(fixedStartIndex >= 0 ? fixedStartIndex : this.rand().nextInt(arrangedBrokerList.size()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nPartitions).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(replicationFactor, brokerRackMap, numRacks, arrangedBrokerList, numBrokers, ret, startIndex, currentPartitionId, nextReplicaShift){
            public static final long serialVersionUID = 0L;
            private final int replicationFactor$2;
            public final scala.collection.immutable.Map brokerRackMap$1;
            public final int numRacks$1;
            public final IndexedSeq arrangedBrokerList$1;
            public final int numBrokers$1;
            private final scala.collection.mutable.Map ret$2;
            private final int startIndex$2;
            private final IntRef currentPartitionId$2;
            public final IntRef nextReplicaShift$2;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                if (this.currentPartitionId$2.elem > 0 && this.currentPartitionId$2.elem % this.arrangedBrokerList$1.size() == 0) {
                    ++this.nextReplicaShift$2.elem;
                }
                int firstReplicaIndex = (this.currentPartitionId$2.elem + this.startIndex$2) % this.arrangedBrokerList$1.size();
                int leader = BoxesRunTime.unboxToInt(this.arrangedBrokerList$1.apply(firstReplicaIndex));
                ArrayBuffer replicaBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                scala.collection.mutable.Set racksWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.brokerRackMap$1.apply(BoxesRunTime.boxToInteger(leader))}));
                scala.collection.mutable.Set brokersWithReplicas = (scala.collection.mutable.Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{leader}));
                IntRef k = IntRef.create(0);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.replicationFactor$2 - 1).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, firstReplicaIndex, replicaBuffer, racksWithReplicas, brokersWithReplicas, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.assignReplicasToBrokersRackAware.1 $outer;
                    private final int firstReplicaIndex$2;
                    private final ArrayBuffer replicaBuffer$2;
                    private final scala.collection.mutable.Set racksWithReplicas$1;
                    private final scala.collection.mutable.Set brokersWithReplicas$1;
                    private final IntRef k$1;

                    public final void apply(int _) {
                        this.apply$mcVI$sp(_);
                    }

                    public void apply$mcVI$sp(int _) {
                        boolean done = false;
                        while (!done) {
                            int broker = BoxesRunTime.unboxToInt(this.$outer.arrangedBrokerList$1.apply(AdminUtils$.MODULE$.kafka$admin$AdminUtils$$replicaIndex(this.firstReplicaIndex$2, this.$outer.nextReplicaShift$2.elem * this.$outer.numRacks$1, this.k$1.elem, this.$outer.arrangedBrokerList$1.size())));
                            String rack = (String)this.$outer.brokerRackMap$1.apply(BoxesRunTime.boxToInteger(broker));
                            if (!(this.racksWithReplicas$1.contains(rack) && this.racksWithReplicas$1.size() != this.$outer.numRacks$1 || this.brokersWithReplicas$1.contains(BoxesRunTime.boxToInteger(broker)) && this.brokersWithReplicas$1.size() != this.$outer.numBrokers$1)) {
                                this.replicaBuffer$2.$plus$eq(BoxesRunTime.boxToInteger(broker));
                                this.racksWithReplicas$1.$plus$eq(rack);
                                this.brokersWithReplicas$1.$plus$eq(BoxesRunTime.boxToInteger(broker));
                                done = true;
                            }
                            ++this.k$1.elem;
                        }
                        return;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.firstReplicaIndex$2 = firstReplicaIndex$2;
                        this.replicaBuffer$2 = replicaBuffer$2;
                        this.racksWithReplicas$1 = racksWithReplicas$1;
                        this.brokersWithReplicas$1 = brokersWithReplicas$1;
                        this.k$1 = k$1;
                    }
                }));
                this.ret$2.put(BoxesRunTime.boxToInteger(this.currentPartitionId$2.elem), replicaBuffer);
                ++this.currentPartitionId$2.elem;
            }
            {
                this.replicationFactor$2 = replicationFactor$2;
                this.brokerRackMap$1 = brokerRackMap$1;
                this.numRacks$1 = numRacks$1;
                this.arrangedBrokerList$1 = arrangedBrokerList$1;
                this.numBrokers$1 = numBrokers$1;
                this.ret$2 = ret$2;
                this.startIndex$2 = startIndex$2;
                this.currentPartitionId$2 = currentPartitionId$2;
                this.nextReplicaShift$2 = nextReplicaShift$2;
            }
        }));
        return ret;
    }

    public IndexedSeq<Object> getRackAlternatedBrokerList(Map<Object, String> brokerRackMap) {
        Map brokersIteratorByRack = this.getInverseMap(brokerRackMap).map((Function1<String, Seq<Object>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Iterator<Object>> apply(Tuple2<String, Seq<Object>> x0$1) {
                Tuple2<String, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String rack = tuple2._1();
                    Seq<Object> brokers = tuple2._2();
                    Tuple2<String, Iterator<Object>> tuple22 = new Tuple2<String, Iterator<Object>>(rack, brokers.toIterator());
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), scala.collection.Map$.MODULE$.canBuildFrom());
        String[] racks = (String[])Predef$.MODULE$.refArrayOps((Object[])brokersIteratorByRack.keys().toArray(ClassTag$.MODULE$.apply(String.class))).sorted(Ordering$String$.MODULE$);
        ArrayBuffer<Object> result2 = new ArrayBuffer<Object>();
        int rackIndex = 0;
        while (result2.size() < brokerRackMap.size()) {
            Iterator rackIterator = (Iterator)brokersIteratorByRack.apply(racks[rackIndex]);
            Object object = rackIterator.hasNext() ? result2.$plus$eq(rackIterator.next()) : BoxedUnit.UNIT;
            rackIndex = (rackIndex + 1) % racks.length;
        }
        return result2;
    }

    public Map<String, Seq<Object>> getInverseMap(Map<Object, String> brokerRackMap) {
        return ((TraversableLike)brokerRackMap.toSeq().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<Object, String> x0$2) {
                Tuple2<Object, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    int id = tuple2._1$mcI$sp();
                    String rack = tuple2._2();
                    Tuple2<String, Object> tuple22 = new Tuple2<String, Object>(rack, BoxesRunTime.boxToInteger(id));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$3) {
                Tuple2<String, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    String rack;
                    String string2 = rack = tuple2._1();
                    return string2;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1<String, scala.collection.immutable.Map<?, ?>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<String, Seq<Tuple2<String, Object>>> x0$4) {
                Tuple2<String, Seq<Tuple2<String, Object>>> tuple2 = x0$4;
                if (tuple2 != null) {
                    String rack = tuple2._1();
                    Seq<Tuple2<String, Object>> rackAndIdList = tuple2._2();
                    Tuple2<String, Seq<Object>> tuple22 = new Tuple2<String, Seq<Object>>(rack, (Seq<Object>)((SeqLike)rackAndIdList.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Tuple2<String, Object> x0$5) {
                            Tuple2<String, Object> tuple2 = x0$5;
                            if (tuple2 != null) {
                                int id;
                                int n = id = tuple2._2$mcI$sp();
                                return n;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).sorted(Ordering$Int$.MODULE$));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public Map<Object, Seq<Object>> addPartitions(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, Seq<Object>>> replicaAssignment, boolean validateOnly) {
        Seq existingAssignmentPartition0 = (Seq)((Object)existingAssignment.getOrElse(BoxesRunTime.boxToInteger(0), new Serializable(topic, existingAssignment){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Map existingAssignment$1;

            public final Nothing$ apply() {
                throw new AdminOperationException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected existing replica assignment for topic '", "', partition id 0 is missing. "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignment: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.existingAssignment$1}))).toString());
            }
            {
                this.topic$1 = topic$1;
                this.existingAssignment$1 = existingAssignment$1;
            }
        }));
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions for a topic can only be increased. "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " currently has ", " partitions, "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, BoxesRunTime.boxToInteger(existingAssignment.size())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " would not be an increase."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(numPartitions)}))).toString());
        }
        replicaAssignment.foreach(new Serializable(allBrokers, existingAssignmentPartition0){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$1;
            private final Seq existingAssignmentPartition0$1;

            public final void apply(Map<Object, Seq<Object>> proposedReplicaAssignment) {
                AdminUtils$.MODULE$.kafka$admin$AdminUtils$$validateReplicaAssignment(proposedReplicaAssignment, this.existingAssignmentPartition0$1, ((TraversableOnce)this.allBrokers$1.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(BrokerMetadata x$4) {
                        return x$4.id();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet());
            }
            {
                this.allBrokers$1 = allBrokers$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
            }
        });
        Map<Object, Seq<Object>> proposedAssignmentForNewPartitions = replicaAssignment.getOrElse(new Serializable(existingAssignment, allBrokers, existingAssignmentPartition0, partitionsToAdd){
            public static final long serialVersionUID = 0L;
            private final Map existingAssignment$1;
            private final Seq allBrokers$1;
            public final Seq existingAssignmentPartition0$1;
            private final int partitionsToAdd$1;

            public final Map<Object, Seq<Object>> apply() {
                int startIndex = package$.MODULE$.max(0, this.allBrokers$1.indexWhere(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;

                    public final boolean apply(BrokerMetadata x$5) {
                        return x$5.id() >= BoxesRunTime.unboxToInt(this.$outer.existingAssignmentPartition0$1.head());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                return AdminUtils$.MODULE$.assignReplicasToBrokers(this.allBrokers$1, this.partitionsToAdd$1, this.existingAssignmentPartition0$1.size(), startIndex, this.existingAssignment$1.size());
            }
            {
                this.existingAssignment$1 = existingAssignment$1;
                this.allBrokers$1 = allBrokers$1;
                this.existingAssignmentPartition0$1 = existingAssignmentPartition0$1;
                this.partitionsToAdd$1 = partitionsToAdd$1;
            }
        });
        Map<Object, Seq<Object>> proposedAssignment = existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        if (!validateOnly) {
            this.info((Function0<String>)((Object)new Serializable(topic, partitionsToAdd, proposedAssignmentForNewPartitions){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partitionsToAdd$1;
                private final Map proposedAssignmentForNewPartitions$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating ", " partitions for '", "' with the following replica assignment: "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.partitionsToAdd$1), this.topic$1}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.proposedAssignmentForNewPartitions$1}))).toString();
                }
                {
                    this.topic$1 = topic$1;
                    this.partitionsToAdd$1 = partitionsToAdd$1;
                    this.proposedAssignmentForNewPartitions$1 = proposedAssignmentForNewPartitions$1;
                }
            }));
            ZkUtils x$12 = zkUtils;
            String x$13 = topic;
            Map<Object, Seq<Object>> x$14 = proposedAssignment;
            boolean x$15 = true;
            Properties x$16 = this.createOrUpdateTopicPartitionAssignmentPathInZK$default$4();
            this.createOrUpdateTopicPartitionAssignmentPathInZK(x$12, x$13, x$14, x$16, x$15);
        }
        return proposedAssignment;
    }

    public int addPartitions$default$5() {
        return 1;
    }

    public Option<Map<Object, Seq<Object>>> addPartitions$default$6() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$7() {
        return false;
    }

    public Map<Object, Seq<Object>> parseReplicaAssignment(String replicaAssignmentsString, int startPartitionId) {
        String[] assignmentStrings = replicaAssignmentsString.split(",");
        scala.collection.mutable.Map assignmentMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        IntRef partitionId = IntRef.create(startPartitionId);
        Predef$.MODULE$.refArrayOps((Object[])assignmentStrings).foreach(new Serializable(assignmentMap, partitionId){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map assignmentMap$1;
            private final IntRef partitionId$1;

            public final void apply(String assignmentString) {
                Seq<A> brokerIds = Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])assignmentString.split(":")).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(String x$6) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$6.trim())).toInt();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSeq();
                this.assignmentMap$1.put(BoxesRunTime.boxToInteger(this.partitionId$1.elem), brokerIds);
                ++this.partitionId$1.elem;
            }
            {
                this.assignmentMap$1 = assignmentMap$1;
                this.partitionId$1 = partitionId$1;
            }
        });
        return assignmentMap;
    }

    public void kafka$admin$AdminUtils$$validateReplicaAssignment(Map<Object, Seq<Object>> replicaAssignment, Seq<Object> existingAssignmentPartition0, Set<Object> availableBrokerIds) {
        replicaAssignment.foreach(new Serializable(availableBrokerIds){
            public static final long serialVersionUID = 0L;
            private final Set availableBrokerIds$1;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Seq<Object>> x0$6) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$6;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    Seq<Object> replicas = tuple2._2();
                    if (replicas.isEmpty()) {
                        throw new InvalidReplicaAssignmentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot have replication factor of 0 for partition id ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                    }
                    if (replicas.size() != replicas.toSet().size()) {
                        throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate brokers not allowed in replica assignment: "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " for partition id ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicas.mkString(", "), BoxesRunTime.boxToInteger(partitionId)}))).toString());
                    }
                    if (replicas.toSet().subsetOf(this.availableBrokerIds$1)) {
                        Tuple2<Object, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partitionId)), BoxesRunTime.boxToInteger(replicas.size()));
                        return tuple22;
                    }
                    throw new BrokerNotAvailableException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some brokers specified for partition id ", " are not available. "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specified brokers: ", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{replicas.mkString(", ")}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"available brokers: ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.availableBrokerIds$1.mkString(", ")}))).toString());
                }
                throw new MatchError(tuple2);
            }
            {
                this.availableBrokerIds$1 = availableBrokerIds$1;
            }
        });
        Map badRepFactors = replicaAssignment.collect((PartialFunction<Object, Seq<Object>>)((Object)new Serializable(existingAssignmentPartition0){
            public static final long serialVersionUID = 0L;
            private final Seq existingAssignmentPartition0$2;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, Seq<Object>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                void var6_8;
                A1 A1 = x2;
                if (A1 != null) {
                    int partition2 = A1._1$mcI$sp();
                    Seq<Object> replicas = A1._2();
                    if (replicas.size() != this.existingAssignmentPartition0$2.size()) {
                        Tuple2<Integer, Integer> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(partition2)), BoxesRunTime.boxToInteger(replicas.size()));
                        return var6_8;
                    }
                }
                B1 B1 = function1.apply(x2);
                return var6_8;
            }

            public final boolean isDefinedAt(Tuple2<Object, Seq<Object>> x2) {
                Seq<Object> replicas;
                Tuple2<Object, Seq<Object>> tuple2 = x2;
                boolean bl = tuple2 != null && (replicas = tuple2._2()).size() != this.existingAssignmentPartition0$2.size();
                return bl;
            }
            {
                this.existingAssignmentPartition0$2 = existingAssignmentPartition0$2;
            }
        }), scala.collection.Map$.MODULE$.canBuildFrom());
        if (badRepFactors.nonEmpty()) {
            Seq sortedBadRepFactors = (Seq)badRepFactors.toSeq().sortBy(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$7) {
                    Tuple2<Object, Object> tuple2 = x0$7;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Ordering$Int$.MODULE$);
            Seq partitions = sortedBadRepFactors.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$8) {
                    Tuple2<Object, Object> tuple2 = x0$8;
                    if (tuple2 != null) {
                        int partitionId;
                        int n = partitionId = tuple2._1$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Seq repFactors = sortedBadRepFactors.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Object> x0$9) {
                    Tuple2<Object, Object> tuple2 = x0$9;
                    if (tuple2 != null) {
                        int rf;
                        int n = rf = tuple2._2$mcI$sp();
                        return n;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom());
            throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Inconsistent replication factor between partitions, "})).s(Nil$.MODULE$)).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partition 0 has ", " while partitions [", "] have "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(existingAssignmentPartition0.size()), partitions.mkString(", ")}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"replication factors [", "], respectively."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{repFactors.mkString(", ")}))).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteTopic(ZkUtils zkUtils, String topic) {
        if (!this.topicExists(zkUtils, topic)) throw new UnknownTopicOrPartitionException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic `", "` to delete does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        try {
            zkUtils.createPersistentPath(ZkUtils$.MODULE$.getDeleteTopicPath(topic), zkUtils.createPersistentPath$default$2(), zkUtils.createPersistentPath$default$3());
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable);
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicAlreadyMarkedForDeletionException(new StringOps(Predef$.MODULE$.augmentString("topic %s is already marked for deletion")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    public boolean isConsumerGroupActive(ZkUtils zkUtils, String group) {
        return zkUtils.getConsumersInGroup(group).nonEmpty();
    }

    public boolean deleteConsumerGroupInZK(ZkUtils zkUtils, String group) {
        boolean bl;
        if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupDirs dir = new ZKGroupDirs(group);
            zkUtils.deletePathRecursive(dir.consumerGroupDir());
            bl = true;
        }
        return bl;
    }

    public boolean deleteConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String group, String topic) {
        boolean bl;
        Seq<String> topics;
        Seq<String> seq = topics = zkUtils.getTopicsByConsumerGroup(group);
        Object CC = Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        if (!(seq != null ? !seq.equals(CC) : CC != null)) {
            bl = this.deleteConsumerGroupInZK(zkUtils, group);
        } else if (this.isConsumerGroupActive(zkUtils, group)) {
            bl = false;
        } else {
            ZKGroupTopicDirs dir = new ZKGroupTopicDirs(group, topic);
            zkUtils.deletePathRecursive(dir.consumerOwnerDir());
            zkUtils.deletePathRecursive(dir.consumerOffsetDir());
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> deleteAllConsumerGroupInfoForTopicInZK(ZkUtils zkUtils, String topic) {
        void var3_3;
        Set<String> groups = zkUtils.getAllConsumerGroupsForTopic(topic);
        groups.foreach(new Serializable(zkUtils, topic){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final String topic$2;

            public final boolean apply(String group) {
                return AdminUtils$.MODULE$.deleteConsumerGroupInfoForTopicInZK(this.zkUtils$1, group, this.topic$2);
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.topic$2 = topic$2;
            }
        });
        return var3_3;
    }

    public boolean topicExists(ZkUtils zkUtils, String topic) {
        return zkUtils.pathExists(ZkUtils$.MODULE$.getTopicPath(topic));
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(ZkUtils zkUtils, RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        RackAwareMode rackAwareMode2;
        Seq<Broker> allBrokers = zkUtils.getAllBrokersInCluster();
        Seq<Broker> brokers = brokerList.map(new Serializable(allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply(Seq<Object> brokerIds) {
                return (Seq)this.allBrokers$2.filter(new Serializable(this, brokerIds){
                    public static final long serialVersionUID = 0L;
                    private final Seq brokerIds$1;

                    public final boolean apply(Broker b) {
                        return this.brokerIds$1.contains(BoxesRunTime.boxToInteger(b.id()));
                    }
                    {
                        this.brokerIds$1 = brokerIds$1;
                    }
                });
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        }).getOrElse(new Serializable(allBrokers){
            public static final long serialVersionUID = 0L;
            private final Seq allBrokers$2;

            public final Seq<Broker> apply() {
                return this.allBrokers$2;
            }
            {
                this.allBrokers$2 = allBrokers$2;
            }
        });
        Seq brokersWithRack = (Seq)brokers.filter((Function1<Broker, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Broker x$7) {
                return x$7.rack().nonEmpty();
            }
        }));
        RackAwareMode rackAwareMode3 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (!(rackAwareMode3 != null ? !rackAwareMode3.equals(rackAwareMode$Enforced$) : rackAwareMode$Enforced$ != null)) {
            if (brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
                throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
            }
        }
        Seq<BrokerMetadata> seq = RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode2 = rackAwareMode) ? brokers.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode2) && brokersWithRack.size() < brokers.size() ? brokers.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), None$.MODULE$);
            }
        }, Seq$.MODULE$.canBuildFrom()) : brokers.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerMetadata apply(Broker broker) {
                return new BrokerMetadata(broker.id(), broker.rack());
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Seq<BrokerMetadata> brokerMetadatas = seq;
        return (Seq)brokerMetadatas.sortBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerMetadata x$8) {
                return x$8.id();
            }
        }, Ordering$Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$2() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$3() {
        return None$.MODULE$;
    }

    public void createTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(zkUtils, rackAwareMode, this.getBrokerMetadatas$default$3());
        Map<Object, Seq<Object>> replicaAssignment = this.assignReplicasToBrokers(brokerMetadatas, partitions, replicationFactor, this.assignReplicasToBrokers$default$4(), this.assignReplicasToBrokers$default$5());
        this.createOrUpdateTopicPartitionAssignmentPathInZK(zkUtils, topic, replicaAssignment, topicConfig, this.createOrUpdateTopicPartitionAssignmentPathInZK$default$5());
    }

    public Properties createTopic$default$5() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$6() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public void validateCreateOrUpdateTopic(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update2) {
        Topic.validate(topic);
        if (!update2) {
            if (this.topicExists(zkUtils, topic)) {
                throw new TopicExistsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
            }
            if (Topic.hasCollisionChars(topic)) {
                Seq<String> allTopics = zkUtils.getAllTopics();
                if (allTopics.contains(topic)) {
                    throw new TopicExistsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
                }
                Seq collidingTopics = (Seq)allTopics.filter((Function1<String, Object>)((Object)new Serializable(topic){
                    public static final long serialVersionUID = 0L;
                    private final String topic$3;

                    public final boolean apply(String x$9) {
                        return Topic.hasCollision(this.topic$3, x$9);
                    }
                    {
                        this.topic$3 = topic$3;
                    }
                }));
                if (collidingTopics.nonEmpty()) {
                    throw new InvalidTopicException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' collides with existing topics: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic, collidingTopics.mkString(", ")})));
                }
            }
        }
        if (((TraversableOnce)partitionReplicaAssignment.values().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Seq<Object> x$10) {
                return x$10.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        partitionReplicaAssignment.values().foreach(new Serializable(partitionReplicaAssignment){
            public static final long serialVersionUID = 0L;
            private final Map partitionReplicaAssignment$1;

            public final void apply(Seq<Object> reps) {
                if (reps.size() != reps.toSet().size()) {
                    throw new InvalidReplicaAssignmentException(new StringBuilder().append((Object)"Duplicate replica assignment found: ").append(this.partitionReplicaAssignment$1).toString());
                }
            }
            {
                this.partitionReplicaAssignment$1 = partitionReplicaAssignment$1;
            }
        });
        if (!update2) {
            LogConfig$.MODULE$.validate(config);
        }
    }

    public void createOrUpdateTopicPartitionAssignmentPathInZK(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, Properties config, boolean update2) {
        this.validateCreateOrUpdateTopic(zkUtils, topic, partitionReplicaAssignment, config, update2);
        if (!update2) {
            this.writeEntityConfig(zkUtils, ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic), config);
        }
        this.writeTopicPartitionAssignment(zkUtils, topic, partitionReplicaAssignment, update2);
    }

    public Properties createOrUpdateTopicPartitionAssignmentPathInZK$default$4() {
        return new Properties();
    }

    public boolean createOrUpdateTopicPartitionAssignmentPathInZK$default$5() {
        return false;
    }

    private void writeTopicPartitionAssignment(ZkUtils zkUtils, String topic, Map<Object, Seq<Object>> replicaAssignment, boolean update2) {
        try {
            String zkPath = ZkUtils$.MODULE$.getTopicPath(topic);
            String jsonPartitionData = zkUtils.replicaAssignmentZkData(replicaAssignment.map((Function1<Object, Seq<Object>>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Seq<Object>> apply(Tuple2<Object, Seq<Object>> e) {
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((Object)BoxesRunTime.boxToInteger(e._1$mcI$sp())).toString()), e._2());
                }
            }), scala.collection.Map$.MODULE$.canBuildFrom()));
            if (update2) {
                this.info((Function0<String>)((Object)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic update ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                }));
                zkUtils.updatePersistentPath(zkPath, jsonPartitionData, zkUtils.updatePersistentPath$default$3());
            } else {
                this.info((Function0<String>)((Object)new Serializable(jsonPartitionData){
                    public static final long serialVersionUID = 0L;
                    private final String jsonPartitionData$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Topic creation ").append((Object)this.jsonPartitionData$1.toString()).toString();
                    }
                    {
                        this.jsonPartitionData$1 = jsonPartitionData$1;
                    }
                }));
                zkUtils.createPersistentPath(zkPath, jsonPartitionData, zkUtils.createPersistentPath$default$3());
            }
            this.debug((Function0<String>)((Object)new Serializable(zkPath, jsonPartitionData){
                public static final long serialVersionUID = 0L;
                private final String zkPath$1;
                private final String jsonPartitionData$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.zkPath$1, this.jsonPartitionData$1}));
                }
                {
                    this.zkPath$1 = zkPath$1;
                    this.jsonPartitionData$1 = jsonPartitionData$1;
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            throw new TopicExistsException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic '", "' already exists."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
        }
    }

    @Override
    public void changeClientIdConfig(ZkUtils zkUtils, String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.kafka$admin$AdminUtils$$changeEntityConfig(zkUtils, ConfigType$.MODULE$.Client(), sanitizedClientId, configs);
    }

    @Override
    public void changeUserOrUserClientIdConfig(ZkUtils zkUtils, String sanitizedEntityName, Properties configs) {
        String string2 = sanitizedEntityName;
        String string3 = ConfigEntityName$.MODULE$.Default();
        java.util.Map<String, Object> map2 = !(string2 == null ? string3 != null : !string2.equals(string3)) || sanitizedEntityName.contains("/clients") ? DynamicConfig$Client$.MODULE$.validate(configs) : DynamicConfig$User$.MODULE$.validate(configs);
        this.kafka$admin$AdminUtils$$changeEntityConfig(zkUtils, ConfigType$.MODULE$.User(), sanitizedEntityName, configs);
    }

    public void validateTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        Topic.validate(topic);
        if (this.topicExists(zkUtils, topic)) {
            LogConfig$.MODULE$.validate(configs);
            return;
        }
        throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic \"%s\" does not exist.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic})));
    }

    @Override
    public void changeTopicConfig(ZkUtils zkUtils, String topic, Properties configs) {
        this.validateTopicConfig(zkUtils, topic, configs);
        this.kafka$admin$AdminUtils$$changeEntityConfig(zkUtils, ConfigType$.MODULE$.Topic(), topic, configs);
    }

    @Override
    public void changeBrokerConfig(ZkUtils zkUtils, Seq<Object> brokers, Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
        brokers.foreach(new Serializable(zkUtils, configs){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;
            private final Properties configs$1;

            public final void apply(int broker) {
                this.apply$mcVI$sp(broker);
            }

            public void apply$mcVI$sp(int broker) {
                AdminUtils$.MODULE$.kafka$admin$AdminUtils$$changeEntityConfig(this.zkUtils$2, ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger(broker)).toString(), this.configs$1);
            }
            {
                this.zkUtils$2 = zkUtils$2;
                this.configs$1 = configs$1;
            }
        });
    }

    public void kafka$admin$AdminUtils$$changeEntityConfig(ZkUtils zkUtils, String rootEntityType, String fullSanitizedEntityName, Properties configs) {
        String sanitizedEntityPath = new StringBuilder().append((Object)rootEntityType).append(BoxesRunTime.boxToCharacter('/')).append((Object)fullSanitizedEntityName).toString();
        String entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, fullSanitizedEntityName);
        this.writeEntityConfig(zkUtils, entityConfigPath, configs);
        String seqNode = new StringBuilder().append((Object)ZkUtils$.MODULE$.ConfigChangesPath()).append((Object)"/").append((Object)this.EntityConfigChangeZnodePrefix()).toString();
        String content = Json$.MODULE$.legacyEncodeAsString(this.getConfigChangeZnodeData(sanitizedEntityPath));
        zkUtils.createSequentialPersistentPath(seqNode, content, zkUtils.createSequentialPersistentPath$default$3());
    }

    public Map<String, Object> getConfigChangeZnodeData(String sanitizedEntityPath) {
        return (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(2)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("entity_path"), sanitizedEntityPath)}));
    }

    private void writeEntityConfig(ZkUtils zkUtils, String entityPath, Properties config) {
        Map map2 = (Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("version"), BoxesRunTime.boxToInteger(1)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("config"), JavaConverters$.MODULE$.propertiesAsScalaMapConverter(config).asScala())}));
        zkUtils.updatePersistentPath(entityPath, Json$.MODULE$.legacyEncodeAsString(map2), zkUtils.updatePersistentPath$default$3());
    }

    @Override
    public Properties fetchEntityConfig(ZkUtils zkUtils, String rootEntityType, String sanitizedEntityName) {
        String entityConfigPath = ZkUtils$.MODULE$.getEntityConfigPath(rootEntityType, sanitizedEntityName);
        String str = (String)zkUtils.readDataMaybeNull(entityConfigPath)._1().orNull(Predef$.MODULE$.$conforms());
        Properties props = new Properties();
        if (str != null) {
            Json$.MODULE$.parseFull(str).foreach(new Serializable(entityConfigPath, str, props){
                public static final long serialVersionUID = 0L;
                public final String entityConfigPath$1;
                public final String str$1;
                public final Properties props$1;

                public final void apply(JsonValue jsValue) {
                    JsonObject jsObject = (JsonObject)((Object)jsValue.asJsonObjectOption().getOrElse(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.fetchEntityConfig.1 $outer;

                        public final Nothing$ apply() {
                            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected value in config: ", ", entity_config_path: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.str$1, this.$outer.entityConfigPath$1})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    Predef$.MODULE$.require(BoxesRunTime.unboxToInt(jsObject.apply("version").to(DecodeJson$DecodeInt$.MODULE$)) == 1);
                    JsonObject config = (JsonObject)((Object)jsObject.get("config").flatMap(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Option<JsonObject> apply(JsonValue x$11) {
                            return x$11.asJsonObjectOption();
                        }
                    }).getOrElse(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.fetchEntityConfig.1 $outer;

                        public final Nothing$ apply() {
                            throw new IllegalArgumentException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid ", " config: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.entityConfigPath$1, this.$outer.str$1})));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    config.iterator().foreach(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.fetchEntityConfig.1 $outer;

                        public final Object apply(Tuple2<String, JsonValue> x0$10) {
                            Tuple2<String, JsonValue> tuple2 = x0$10;
                            if (tuple2 != null) {
                                String k = tuple2._1();
                                JsonValue v = tuple2._2();
                                Object object = this.$outer.props$1.setProperty(k, v.to(DecodeJson$DecodeString$.MODULE$));
                                return object;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.entityConfigPath$1 = entityConfigPath$1;
                    this.str$1 = str$1;
                    this.props$1 = props$1;
                }
            });
        }
        return props;
    }

    public Map<String, Properties> fetchAllTopicConfigs(ZkUtils zkUtils) {
        return ((TraversableOnce)zkUtils.getAllTopics().map(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$3;

            public final Tuple2<String, Properties> apply(String topic) {
                return new Tuple2<String, Properties>(topic, AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$3, ConfigType$.MODULE$.Topic(), topic));
            }
            {
                this.zkUtils$3 = zkUtils$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllEntityConfigs(ZkUtils zkUtils, String entityType) {
        return ((TraversableOnce)zkUtils.getAllEntitiesWithConfig(entityType).map(new Serializable(zkUtils, entityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$4;
            private final String entityType$1;

            public final Tuple2<String, Properties> apply(String entity) {
                return new Tuple2<String, Properties>(entity, AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$4, this.entityType$1, entity));
            }
            {
                this.zkUtils$4 = zkUtils$4;
                this.entityType$1 = entityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(ZkUtils zkUtils, String rootEntityType, String childEntityType) {
        return ((TraversableOnce)((TraversableLike)this.kafka$admin$AdminUtils$$entityPaths$1(zkUtils, None$.MODULE$, rootEntityType).flatMap(new Serializable(zkUtils, rootEntityType, childEntityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final String rootEntityType$1;
            private final String childEntityType$1;

            public final Seq<String> apply(String entity) {
                return AdminUtils$.MODULE$.kafka$admin$AdminUtils$$entityPaths$1(this.zkUtils$5, new Some<String>(new StringBuilder().append((Object)entity).append(BoxesRunTime.boxToCharacter('/')).append((Object)this.childEntityType$1).toString()), this.rootEntityType$1);
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.rootEntityType$1 = rootEntityType$1;
                this.childEntityType$1 = childEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map(new Serializable(zkUtils, rootEntityType){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$5;
            private final String rootEntityType$1;

            public final Tuple2<String, Properties> apply(String entityPath) {
                return new Tuple2<String, Properties>(entityPath, AdminUtils$.MODULE$.fetchEntityConfig(this.zkUtils$5, this.rootEntityType$1, entityPath));
            }
            {
                this.zkUtils$5 = zkUtils$5;
                this.rootEntityType$1 = rootEntityType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public int kafka$admin$AdminUtils$$replicaIndex(int firstReplicaIndex, int secondReplicaShift, int replicaIndex, int nBrokers) {
        int shift = 1 + (secondReplicaShift + replicaIndex) % (nBrokers - 1);
        return (firstReplicaIndex + shift) % nBrokers;
    }

    public final Seq kafka$admin$AdminUtils$$entityPaths$1(ZkUtils zkUtils, Option rootPath, String rootEntityType$1) {
        Option option;
        block4: {
            Option option2;
            block7: {
                Seq<String> seq;
                block6: {
                    Seq<String> entityNames2;
                    block5: {
                        String string2;
                        block3: {
                            block2: {
                                option = rootPath;
                                if (!(option instanceof Some)) break block2;
                                Some some = (Some)option;
                                String path = (String)some.x();
                                string2 = new StringBuilder().append((Object)rootEntityType$1).append(BoxesRunTime.boxToCharacter('/')).append((Object)path).toString();
                                break block3;
                            }
                            if (!None$.MODULE$.equals(option)) break block4;
                            string2 = rootEntityType$1;
                        }
                        String root = string2;
                        entityNames2 = zkUtils.getAllEntitiesWithConfig(root);
                        option2 = rootPath;
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String path = (String)some.x();
                        seq = entityNames2.map(new Serializable(path){
                            public static final long serialVersionUID = 0L;
                            private final String path$1;

                            public final String apply(String entityName) {
                                return new StringBuilder().append((Object)this.path$1).append(BoxesRunTime.boxToCharacter('/')).append((Object)entityName).toString();
                            }
                            {
                                this.path$1 = path$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    seq = entityNames2;
                }
                return seq;
            }
            throw new MatchError(option2);
        }
        throw new MatchError(option);
    }

    private AdminUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        AdminUtilities$class.$init$(this);
        this.rand = new Random();
        this.AdminClientId = "__admin_client";
        this.EntityConfigChangeZnodePrefix = "config_change_";
    }
}

