/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.common.Node;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0005\u000f\tqQK\\:f]R\u0014V-];fgR\u001c(BA\u0002\u0005\u0003\u0019\u0019w.\\7p]*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\rC\u0003\u0010\u0001\u0011\u0005\u0001#\u0001\u0004=S:LGO\u0010\u000b\u0002#A\u0011!\u0003A\u0007\u0002\u0005!9A\u0003\u0001b\u0001\n\u0013)\u0012AB;og\u0016tG/F\u0001\u0017!\u00119BD\b\u0015\u000e\u0003aQ!!\u0007\u000e\u0002\tU$\u0018\u000e\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002DA\u0004ICNDW*\u00199\u0011\u0005}1S\"\u0001\u0011\u000b\u0005\r\t#BA\u0003#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001d\u0002#\u0001\u0002(pI\u0016\u00042aF\u0015,\u0013\tQ\u0003D\u0001\u0006BeJ\f\u0017\u0010R3rk\u0016\u0004\"\u0001L\u0018\u000e\u00035R!AL\u0011\u0002\u000f\rd\u0017.\u001a8ug&\u0011\u0001'\f\u0002\u000e\u00072LWM\u001c;SKF,Xm\u001d;\t\rI\u0002\u0001\u0015!\u0003\u0017\u0003\u001d)hn]3oi\u0002BQ\u0001\u000e\u0001\u0005\u0002U\n1\u0001];u)\r1\u0014h\u000f\t\u0003\u0013]J!\u0001\u000f\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006uM\u0002\rAH\u0001\u0005]>$W\rC\u0003=g\u0001\u00071&A\u0004sKF,Xm\u001d;\t\u000by\u0002A\u0011A \u0002+I,Wn\u001c<f\u000bb\u0004\u0018N]3e%\u0016\fX/Z:ugR\u0019\u0001i\u0011%\u0011\u0007]\t5&\u0003\u0002C1\tQ1i\u001c7mK\u000e$\u0018n\u001c8\t\u000b\u0011k\u0004\u0019A#\u0002\u00079|w\u000f\u0005\u0002\n\r&\u0011qI\u0003\u0002\u0005\u0019>tw\rC\u0003J{\u0001\u0007Q)\u0001\bv]N,g\u000e^#ya&\u0014\u00180T:\t\u000b-\u0003A\u0011\u0001'\u0002\u000b\rdW-\u00198\u0015\u0003YBQA\u0014\u0001\u0005\u0002=\u000b\u0001\"\u001b;fe\u0006$xN\u001d\u000b\u0002!B\u0019q#U*\n\u0005IC\"\u0001C%uKJ\fGo\u001c:\u0011\tQsf\u0004\u000b\b\u0003+rs!AV.\u000f\u0005]SV\"\u0001-\u000b\u0005e3\u0011A\u0002\u001fs_>$h(C\u0001\u001c\u0013\tI\"$\u0003\u0002^1\u0005\u0019Q*\u00199\n\u0005}\u0003'!B#oiJL(BA/\u0019\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003=\u0011X-];fgRLE/\u001a:bi>\u0014HC\u00013f!\r9\u0012k\u000b\u0005\u0006u\u0005\u0004\rA\b\u0005\u0006O\u0002!\t\u0001[\u0001\u0006]>$Wm]\u000b\u0002SB\u0019qC\u001b\u0010\n\u0005-D\"aA*fi\u0002")
public class UnsentRequests {
    private final HashMap<Node, ArrayDeque<ClientRequest>> unsent = new HashMap();

    private HashMap<Node, ArrayDeque<ClientRequest>> unsent() {
        return this.unsent;
    }

    public void put(Node node2, ClientRequest request) {
        java.io.Serializable serializable;
        ArrayDeque<ClientRequest> requests = this.unsent().get(node2);
        if (requests == null) {
            requests = new ArrayDeque();
            serializable = this.unsent().put(node2, requests);
        } else {
            serializable = BoxedUnit.UNIT;
        }
        requests.add(request);
    }

    public Collection<ClientRequest> removeExpiredRequests(long now, long unsentExpiryMs) {
        ArrayList<ClientRequest> expiredRequests = new ArrayList<ClientRequest>();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.unsent().values()).asScala()).foreach(new Serializable(this, now, unsentExpiryMs, expiredRequests){
            public static final long serialVersionUID = 0L;
            private final long now$5;
            private final long unsentExpiryMs$1;
            private final ArrayList expiredRequests$1;

            public final void apply(ArrayDeque<ClientRequest> requests) {
                Iterator<ClientRequest> requestIterator = requests.iterator();
                boolean foundExpiredRequest = false;
                while (requestIterator.hasNext() && !foundExpiredRequest) {
                    ClientRequest request = requestIterator.next();
                    if (request.createdTimeMs() >= this.now$5 - this.unsentExpiryMs$1) continue;
                    this.expiredRequests$1.add(request);
                    requestIterator.remove();
                    foundExpiredRequest = true;
                }
            }
            {
                this.now$5 = now$5;
                this.unsentExpiryMs$1 = unsentExpiryMs$1;
                this.expiredRequests$1 = expiredRequests$1;
            }
        });
        return expiredRequests;
    }

    public void clean() {
        Iterator<ArrayDeque<ClientRequest>> iterator2 = this.unsent().values().iterator();
        while (iterator2.hasNext()) {
            ArrayDeque<ClientRequest> requests = iterator2.next();
            if (!requests.isEmpty()) continue;
            iterator2.remove();
        }
    }

    public Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator() {
        return this.unsent().entrySet().iterator();
    }

    public Iterator<ClientRequest> requestIterator(Node node2) {
        ArrayDeque<ClientRequest> requests = this.unsent().get(node2);
        return requests == null ? Collections.emptyIterator() : requests.iterator();
    }

    public Set<Node> nodes() {
        return this.unsent().keySet();
    }
}

