/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import kafka.common.ZkNodeChangeNotificationListener;
import kafka.common.ZkNodeChangeNotificationListener$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.CreateTokenResult;
import kafka.server.DelegationTokenManager$;
import kafka.server.DelegationTokenManager$TokenChangedNotificationHandler$;
import kafka.server.KafkaConfig;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging$class;
import kafka.zk.DelegationTokenChangeNotificationSequenceZNode$;
import kafka.zk.DelegationTokenChangeNotificationZNode$;
import kafka.zk.DelegationTokensZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramFormatter;
import org.apache.kafka.common.security.scram.ScramMechanism;
import org.apache.kafka.common.security.token.delegation.DelegationToken;
import org.apache.kafka.common.security.token.delegation.DelegationTokenCache;
import org.apache.kafka.common.security.token.delegation.TokenInformation;
import org.apache.kafka.common.utils.Base64;
import org.apache.kafka.common.utils.Time;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r=t!B\u0001\u0003\u0011\u00039\u0011A\u0006#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011a\u0003R3mK\u001e\fG/[8o)>\\WM\\'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\u0002]\tA\u0003R3gCVdG\u000fS7bG\u0006cwm\u001c:ji\"lW#\u0001\r\u0011\u0005eqR\"\u0001\u000e\u000b\u0005ma\u0012\u0001\u00027b]\u001eT\u0011!H\u0001\u0005U\u00064\u0018-\u0003\u0002 5\t11\u000b\u001e:j]\u001eDa!I\u0005!\u0002\u0013A\u0012!\u0006#fM\u0006,H\u000e\u001e%nC\u000e\fEnZ8sSRDW\u000e\t\u0005\bG%\u0011\r\u0011\"\u0001\u0018\u0003!yuO\\3s\u0017\u0016L\bBB\u0013\nA\u0003%\u0001$A\u0005Po:,'oS3zA!9q%\u0003b\u0001\n\u00039\u0012a\u0003*f]\u0016<XM]:LKfDa!K\u0005!\u0002\u0013A\u0012\u0001\u0004*f]\u0016<XM]:LKf\u0004\u0003bB\u0016\n\u0005\u0004%\taF\u0001\u0012\u0013N\u001cX/\u001a+j[\u0016\u001cH/Y7q\u0017\u0016L\bBB\u0017\nA\u0003%\u0001$\u0001\nJgN,X\rV5nKN$\u0018-\u001c9LKf\u0004\u0003bB\u0018\n\u0005\u0004%\taF\u0001\u0010\u001b\u0006DH+[7fgR\fW\u000e]&fs\"1\u0011'\u0003Q\u0001\na\t\u0001#T1y)&lWm\u001d;b[B\\U-\u001f\u0011\t\u000fMJ!\u0019!C\u0001/\u0005\u0011R\t\u001f9jef$\u0016.\\3ti\u0006l\u0007oS3z\u0011\u0019)\u0014\u0002)A\u00051\u0005\u0019R\t\u001f9jef$\u0016.\\3ti\u0006l\u0007oS3zA!9q'\u0003b\u0001\n\u00039\u0012A\u0003+pW\u0016t\u0017\nZ&fs\"1\u0011(\u0003Q\u0001\na\t1\u0002V8lK:LEmS3zA!91(\u0003b\u0001\n\u00039\u0012A\u0003,feNLwN\\&fs\"1Q(\u0003Q\u0001\na\t1BV3sg&|gnS3zA!9q(\u0003b\u0001\n\u0003\u0001\u0015AD\"veJ,g\u000e\u001e,feNLwN\\\u000b\u0002\u0003B\u0011QBQ\u0005\u0003\u0007:\u00111!\u00138u\u0011\u0019)\u0015\u0002)A\u0005\u0003\u0006y1)\u001e:sK:$h+\u001a:tS>t\u0007\u0005C\u0004H\u0013\t\u0007I\u0011\u0001!\u0002\u001d\u0015\u0013(o\u001c:US6,7\u000f^1na\"1\u0011*\u0003Q\u0001\n\u0005\u000bq\"\u0012:s_J$\u0016.\\3ti\u0006l\u0007\u000f\t\u0005\u0006\u0017&!\t\u0001T\u0001\u000bGJ,\u0017\r^3I[\u0006\u001cGcA'T7B\u0019QB\u0014)\n\u0005=s!!B!se\u0006L\bCA\u0007R\u0013\t\u0011fB\u0001\u0003CsR,\u0007\"\u0002+K\u0001\u0004)\u0016a\u0002;pW\u0016t\u0017\n\u001a\t\u0003-fs!!D,\n\u0005as\u0011A\u0002)sK\u0012,g-\u0003\u0002 5*\u0011\u0001L\u0004\u0005\u00069*\u0003\r!V\u0001\ng\u0016\u001c'/\u001a;LKfDQAX\u0005\u0005\u0002}\u000bqb\u0019:fCR,7+Z2sKR\\U-\u001f\u000b\u0003A\"\u0004\"!\u00194\u000e\u0003\tT!a\u00193\u0002\r\r\u0014\u0018\u0010\u001d;p\u0015\u0005)\u0017!\u00026bm\u0006D\u0018BA4c\u0005%\u0019Vm\u0019:fi.+\u0017\u0010C\u0003j;\u0002\u0007Q*\u0001\u0005lKf\u0014\u0017\u0010^3t\u0011\u0015Y\u0017\u0002\"\u0001m\u0003A\u0019'/Z1uK\n\u000b7/\u001a\u001c5\u00116\u000b5\tF\u0002V[:DQ\u0001\u00166A\u0002UCQ\u0001\u00186A\u0002\u0001DQaS\u0005\u0005\u0002A$2!T9s\u0011\u0015!v\u000e1\u0001V\u0011\u0015av\u000e1\u0001a\u0011\u0015!\u0018\u0002\"\u0001v\u0003M!xNS:p]\u000e{W\u000e]1uS\ndW-T1q)\t1H\u0010\u0005\u0003WoVK\u0018B\u0001=[\u0005\ri\u0015\r\u001d\t\u0003\u001biL!a\u001f\b\u0003\u0007\u0005s\u0017\u0010C\u0003~g\u0002\u0007a0A\u0003u_.,g\u000eE\u0002\u0000\u00033i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u000bI\u0016dWmZ1uS>t'bA?\u0002\b)!\u0011\u0011BA\u0006\u0003!\u0019XmY;sSRL(\u0002BA\u0007\u0003\u001f\taaY8n[>t'bA\u0003\u0002\u0012)!\u00111CA\u000b\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qC\u0001\u0004_J<\u0017\u0002BA\u000e\u0003\u0003\u0011q\u0002R3mK\u001e\fG/[8o)>\\WM\u001c\u0005\b\u0003?IA\u0011AA\u0011\u0003%1'o\\7CsR,7\u000f\u0006\u0003\u0002$\u0005=\u0002#B\u0007\u0002&\u0005%\u0012bAA\u0014\u001d\t1q\n\u001d;j_:\u00042a`A\u0016\u0013\u0011\ti#!\u0001\u0003!Q{7.\u001a8J]\u001a|'/\\1uS>t\u0007bBA\u0019\u0003;\u0001\r!T\u0001\u0006Ef$Xm\u001d\u0005\b\u0003kIA\u0011AA\u001c\u0003-1\u0017\u000e\u001c;feR{7.\u001a8\u0015\u0015\u0005e\u0012qHA(\u0003[\ny\u0007E\u0002\u000e\u0003wI1!!\u0010\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0011\u00024\u0001\u0007\u00111I\u0001\u0013e\u0016\fX/Z:uK\u0012\u0004&/\u001b8dSB\fG\u000e\u0005\u0003\u0002F\u0005-SBAA$\u0015\u0011\tI%a\u0002\u0002\t\u0005,H\u000f[\u0005\u0005\u0003\u001b\n9E\u0001\bLC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197\t\u0011\u0005E\u00131\u0007a\u0001\u0003'\naa\\<oKJ\u001c\b#B\u0007\u0002&\u0005U\u0003CBA,\u0003O\n\u0019E\u0004\u0003\u0002Z\u0005\rd\u0002BA.\u0003Cj!!!\u0018\u000b\u0007\u0005}c!\u0001\u0004=e>|GOP\u0005\u0002\u001f%\u0019\u0011Q\r\b\u0002\u000fA\f7m[1hK&!\u0011\u0011NA6\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005\u0015d\u0002C\u0004~\u0003g\u0001\r!!\u000b\t\u0011\u0005E\u00141\u0007a\u0001\u0003g\na\"Y;uQ>\u0014\u0018N_3U_.,g\u000e\u0005\u0004\u000e\u0003k*\u0016\u0011H\u0005\u0004\u0003or!!\u0003$v]\u000e$\u0018n\u001c82\r\u0015Q!\u0001AA>'\u001d\tI\bDA?\u0003\u0013\u0003B!a \u0002\u00066\u0011\u0011\u0011\u0011\u0006\u0004\u0003\u0007#\u0011!B;uS2\u001c\u0018\u0002BAD\u0003\u0003\u0013q\u0001T8hO&tw\r\u0005\u0003\u0002\f\u0006EUBAAG\u0015\r\ty\tB\u0001\b[\u0016$(/[2t\u0013\u0011\t\u0019*!$\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000fC\u0006\u0002\u0018\u0006e$Q1A\u0005\u0002\u0005e\u0015AB2p]\u001aLw-\u0006\u0002\u0002\u001cB\u0019\u0001\"!(\n\u0007\u0005}%AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007bCAR\u0003s\u0012\t\u0011)A\u0005\u00037\u000bqaY8oM&<\u0007\u0005C\u0006\u0002(\u0006e$Q1A\u0005\u0002\u0005%\u0016A\u0003;pW\u0016t7)Y2iKV\u0011\u00111\u0016\t\u0004\u007f\u00065\u0016\u0002BAX\u0003\u0003\u0011A\u0003R3mK\u001e\fG/[8o)>\\WM\\\"bG\",\u0007bCAZ\u0003s\u0012\t\u0011)A\u0005\u0003W\u000b1\u0002^8lK:\u001c\u0015m\u00195fA!Y\u0011qWA=\u0005\u000b\u0007I\u0011AA]\u0003\u0011!\u0018.\\3\u0016\u0005\u0005m\u0006\u0003BA_\u0003\u0003l!!a0\u000b\t\u0005\r\u00151B\u0005\u0005\u0003\u0007\fyL\u0001\u0003US6,\u0007bCAd\u0003s\u0012\t\u0011)A\u0005\u0003w\u000bQ\u0001^5nK\u0002B1\"a3\u0002z\t\u0015\r\u0011\"\u0001\u0002N\u0006A!p[\"mS\u0016tG/\u0006\u0002\u0002PB!\u0011\u0011[Al\u001b\t\t\u0019NC\u0002\u0002V\u0012\t!A_6\n\t\u0005e\u00171\u001b\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\t\u0017\u0005u\u0017\u0011\u0010B\u0001B\u0003%\u0011qZ\u0001\nu.\u001cE.[3oi\u0002BqaEA=\t\u0003\t\t\u000f\u0006\u0006\u0002d\u0006\u0015\u0018q]Au\u0003W\u00042\u0001CA=\u0011!\t9*a8A\u0002\u0005m\u0005\u0002CAT\u0003?\u0004\r!a+\t\u0011\u0005]\u0016q\u001ca\u0001\u0003wC\u0001\"a3\u0002`\u0002\u0007\u0011qZ\u0003\b\u0003_\fI\bAAy\u0005Y\u0019%/Z1uKJ+7\u000f]8og\u0016\u001c\u0015\r\u001c7cC\u000e\\\u0007cB\u0007\u0002v\u0005M\u0018\u0011 \t\u0004\u0011\u0005U\u0018bAA|\u0005\t\t2I]3bi\u0016$vn[3o%\u0016\u001cX\u000f\u001c;\u0011\u00075\tY0C\u0002\u0002~:\u0011A!\u00168ji\u00169!\u0011AA=\u0001\t\r!!\u0006*f]\u0016<(+Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\n\u001b\t\u0015!\u0011\u0002B\u000b\u0003sL1Aa\u0002\u000f\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0003\f\tEQB\u0001B\u0007\u0015\u0011\u0011y!a\u0003\u0002\u0011A\u0014x\u000e^8d_2LAAa\u0005\u0003\u000e\t1QI\u001d:peN\u00042!\u0004B\f\u0013\r\u0011IB\u0004\u0002\u0005\u0019>tw-B\u0004\u0003\u001e\u0005e\u0004Aa\u0001\u0003-\u0015C\b/\u001b:f%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.,qA!\t\u0002z\u0001\u0011\u0019C\u0001\rEKN\u001c'/\u001b2f%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004\u0012\"\u0004B\u0003\u0005\u0013\u0011)#!?\u0011\u000b\u0005]\u0013q\r@\t\u0013q\u000bIH1A\u0005\u0002\t%R#\u00011\t\u0011\t5\u0012\u0011\u0010Q\u0001\n\u0001\f!b]3de\u0016$8*Z=!\u0011)\u0011\t$!\u001fC\u0002\u0013\u0005!1G\u0001\u0011i>\\WM\\'bq2Kg-\u001a;j[\u0016,\"A!\u0006\t\u0013\t]\u0012\u0011\u0010Q\u0001\n\tU\u0011!\u0005;pW\u0016tW*\u0019=MS\u001a,G/[7fA!Q!1HA=\u0005\u0004%\tAa\r\u0002+\u0011,g-Y;miR{7.\u001a8SK:,w\u000fV5nK\"I!qHA=A\u0003%!QC\u0001\u0017I\u00164\u0017-\u001e7u)>\\WM\u001c*f]\u0016<H+[7fA!Q!1IA=\u0005\u0004%\tAa\r\u00021Q|7.\u001a8SK6|g/\u001a:TG\u0006t\u0017J\u001c;feZ\fG\u000eC\u0005\u0003H\u0005e\u0004\u0015!\u0003\u0003\u0016\u0005IBo\\6f]J+Wn\u001c<feN\u001b\u0017M\\%oi\u0016\u0014h/\u00197!\u0011)\u0011Y%!\u001fC\u0002\u0013%!QJ\u0001\u0005Y>\u001c7.\u0006\u0002\u0003PA\u0019\u0011D!\u0015\n\u0007\tM#D\u0001\u0004PE*,7\r\u001e\u0005\n\u0005/\nI\b)A\u0005\u0005\u001f\nQ\u0001\\8dW\u0002B!Ba\u0017\u0002z\u0001\u0007I\u0011\u0002B/\u0003M!xn[3o\u0007\"\fgnZ3MSN$XM\\3s+\t\u0011y\u0006\u0005\u0003\u0003b\t\u0015TB\u0001B2\u0015\r\ti\u0001B\u0005\u0005\u0005O\u0012\u0019G\u0001\u0011[W:{G-Z\"iC:<WMT8uS\u001aL7-\u0019;j_:d\u0015n\u001d;f]\u0016\u0014\bB\u0003B6\u0003s\u0002\r\u0011\"\u0003\u0003n\u00059Bo\\6f]\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe~#S-\u001d\u000b\u0005\u0003s\u0014y\u0007\u0003\u0006\u0003r\t%\u0014\u0011!a\u0001\u0005?\n1\u0001\u001f\u00132\u0011%\u0011)(!\u001f!B\u0013\u0011y&\u0001\u000bu_.,gn\u00115b]\u001e,G*[:uK:,'\u000f\t\u0005\t\u0005s\nI\b\"\u0001\u0003|\u000591\u000f^1siV\u0004HCAA}\u0011!\u0011y(!\u001f\u0005\u0002\tm\u0014\u0001C:ikR$wn\u001e8\t\u0011\t\r\u0015\u0011\u0010C\u0005\u0005w\n\u0011\u0002\\8bI\u000e\u000b7\r[3\t\u0011\t\u001d\u0015\u0011\u0010C\u0005\u0005\u0013\u000babZ3u)>\\WM\u001c$s_6T6\u000e\u0006\u0003\u0003\f\n5\u0005\u0003B\u0007\u0002&yDa\u0001\u0016BC\u0001\u0004)\u0006\u0002\u0003BI\u0003s\"IAa%\u0002\u0017U\u0004H-\u0019;f\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0003s\u0014)\n\u0003\u0004~\u0005\u001f\u0003\rA \u0005\t\u00053\u000bI\b\"\u0003\u0003\u001c\u00069\u0002O]3qCJ,7k\u0019:b[\u000e\u0013X\rZ3oi&\fGn\u001d\u000b\u0005\u0005;\u0013Y\u000bE\u0003WoV\u0013y\n\u0005\u0003\u0003\"\n\u001dVB\u0001BR\u0015\u0011\u0011)+a\u0002\u0002\u000bM\u001c'/Y7\n\t\t%&1\u0015\u0002\u0010'\u000e\u0014\u0018-\\\"sK\u0012,g\u000e^5bY\"9!Q\u0016BL\u0001\u0004)\u0016A\u00035nC\u000e\u001cFO]5oO\"A!\u0011WA=\t\u0003\u0011\u0019,A\u0006de\u0016\fG/\u001a+pW\u0016tGCCA}\u0005k\u0013IL!0\u0003B\"A!q\u0017BX\u0001\u0004\t\u0019%A\u0003po:,'\u000f\u0003\u0005\u0003<\n=\u0006\u0019AA+\u0003!\u0011XM\\3xKJ\u001c\b\u0002\u0003B`\u0005_\u0003\rA!\u0006\u0002\u001b5\f\u0007\u0010T5gKRKW.Z't\u0011!\u0011\u0019Ma,A\u0002\t\u0015\u0017\u0001\u0005:fgB|gn]3DC2d'-Y2l!\u0011\u00119-!<\u000e\u0005\u0005e\u0004\u0002\u0003Bf\u0003s\"\tA!4\u0002\u0015I,g.Z<U_.,g\u000e\u0006\u0006\u0002z\n='1\u001bBr\u0005OD\u0001B!5\u0003J\u0002\u0007\u00111I\u0001\naJLgnY5qC2D\u0001B!6\u0003J\u0002\u0007!q[\u0001\u0005Q6\f7\r\u0005\u0003\u0003Z\n}WB\u0001Bn\u0015\r\u0011i\u000eH\u0001\u0004]&|\u0017\u0002\u0002Bq\u00057\u0014!BQ=uK\n+hMZ3s\u0011!\u0011)O!3A\u0002\tU\u0011a\u0004:f]\u0016<H*\u001b4f)&lW-T:\t\u0011\t%(\u0011\u001aa\u0001\u0005W\fQB]3oK^\u001c\u0015\r\u001c7cC\u000e\\\u0007\u0003\u0002Bd\u0003\u007fD\u0001Ba<\u0002z\u0011%!\u0011_\u0001\fkB$\u0017\r^3U_.,g\u000e\u0006\u0003\u0002z\nM\bBB?\u0003n\u0002\u0007a\u0010\u0003\u0005\u0003x\u0006eD\u0011\u0002B}\u0003!9W\r\u001e+pW\u0016tG\u0003\u0002BF\u0005wD\u0001B!6\u0003v\u0002\u0007!q\u001b\u0005\t\u0005\u007f\fI\b\"\u0003\u0004\u0002\u0005q\u0011\r\u001c7po\u0016$Gk\u001c*f]\u0016<HCBA\u001d\u0007\u0007\u0019)\u0001\u0003\u0005\u0003R\nu\b\u0019AA\"\u0011!\u00199A!@A\u0002\u0005%\u0012!\u0003;pW\u0016t\u0017J\u001c4p\u0011!\u001190!\u001f\u0005\u0002\r-A\u0003\u0002BF\u0007\u001bAa\u0001VB\u0005\u0001\u0004)\u0006\u0002\u0003B|\u0003s\"Ia!\u0005\u0015\u0007y\u001c\u0019\u0002\u0003\u0005\u0004\b\r=\u0001\u0019AA\u0015\u0011!\u00199\"!\u001f\u0005\u0002\re\u0011aC3ya&\u0014X\rV8lK:$\"\"!?\u0004\u001c\ru1qDB\u0012\u0011!\u0011\tn!\u0006A\u0002\u0005\r\u0003\u0002\u0003Bk\u0007+\u0001\rAa6\t\u0011\r\u00052Q\u0003a\u0001\u0005+\t\u0001#\u001a=qSJ,G*\u001b4f)&lW-T:\t\u0011\r\u00152Q\u0003a\u0001\u0007O\ta#\u001a=qSJ,'+Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0005\u0005\u000f\u0014Y\u0002\u0003\u0005\u0004,\u0005eD\u0011BB\u0017\u0003-\u0011X-\\8wKR{7.\u001a8\u0015\t\u0005e8q\u0006\u0005\u0007)\u000e%\u0002\u0019A+\t\u0011\rM\u0012\u0011\u0010C\u0005\u0007k\t1B]3n_Z,7)Y2iKR!\u0011\u0011`B\u001c\u0011\u0019!6\u0011\u0007a\u0001+\"A11HA=\t\u0003\u0011Y(\u0001\u0007fqBL'/\u001a+pW\u0016t7\u000f\u0003\u0005\u0004@\u0005eD\u0011AB!\u0003Y9W\r^!mYR{7.\u001a8J]\u001a|'/\\1uS>tGCAB\"!\u0019\t9&a\u001a\u0002*!A1qIA=\t\u0003\u0019I%A\u0005hKR$vn[3ogR!!QEB&\u0011!\t)d!\u0012A\u0002\r5\u0003cB\u0007\u0002v\u0005%\u0012\u0011H\u0004\t\u0007#\nI\b#\u0001\u0004T\u0005yBk\\6f]\u000eC\u0017M\\4fI:{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0011\t\t\u001d7Q\u000b\u0004\t\u0007/\nI\b#\u0001\u0004Z\tyBk\\6f]\u000eC\u0017M\\4fI:{G/\u001b4jG\u0006$\u0018n\u001c8IC:$G.\u001a:\u0014\u000b\rUCba\u0017\u0011\t\t\u00054QL\u0005\u0005\u0007?\u0012\u0019GA\nO_RLg-[2bi&|g\u000eS1oI2,'\u000fC\u0004\u0014\u0007+\"\taa\u0019\u0015\u0005\rM\u0003\u0002CB4\u0007+\"\te!\u001b\u0002'A\u0014xnY3tg:{G/\u001b4jG\u0006$\u0018n\u001c8\u0015\t\u0005e81\u000e\u0005\b\u0007[\u001a)\u00071\u0001N\u00031!xn[3o\u0013\u0012\u0014\u0015\u0010^3t\u0001")
public class DelegationTokenManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final DelegationTokenCache tokenCache;
    private final Time time;
    private final KafkaZkClient zkClient;
    private final SecretKey secretKey;
    private final long tokenMaxLifetime;
    private final long defaultTokenRenewTime;
    private final long tokenRemoverScanInterval;
    private final Object kafka$server$DelegationTokenManager$$lock;
    private ZkNodeChangeNotificationListener tokenChangeListener;
    private volatile DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$module;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static boolean filterToken(KafkaPrincipal kafkaPrincipal, Option<List<KafkaPrincipal>> option, TokenInformation tokenInformation, Function1<String, Object> function1) {
        return DelegationTokenManager$.MODULE$.filterToken(kafkaPrincipal, option, tokenInformation, function1);
    }

    public static Option<TokenInformation> fromBytes(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.fromBytes(byArray);
    }

    public static scala.collection.immutable.Map<String, Object> toJsonCompatibleMap(DelegationToken delegationToken) {
        return DelegationTokenManager$.MODULE$.toJsonCompatibleMap(delegationToken);
    }

    public static byte[] createHmac(String string2, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createHmac(string2, secretKey);
    }

    public static String createBase64HMAC(String string2, SecretKey secretKey) {
        return DelegationTokenManager$.MODULE$.createBase64HMAC(string2, secretKey);
    }

    public static SecretKey createSecretKey(byte[] byArray) {
        return DelegationTokenManager$.MODULE$.createSecretKey(byArray);
    }

    public static byte[] createHmac(String string2, String string3) {
        return DelegationTokenManager$.MODULE$.createHmac(string2, string3);
    }

    public static int ErrorTimestamp() {
        return DelegationTokenManager$.MODULE$.ErrorTimestamp();
    }

    public static int CurrentVersion() {
        return DelegationTokenManager$.MODULE$.CurrentVersion();
    }

    public static String VersionKey() {
        return DelegationTokenManager$.MODULE$.VersionKey();
    }

    public static String TokenIdKey() {
        return DelegationTokenManager$.MODULE$.TokenIdKey();
    }

    public static String ExpiryTimestampKey() {
        return DelegationTokenManager$.MODULE$.ExpiryTimestampKey();
    }

    public static String MaxTimestampKey() {
        return DelegationTokenManager$.MODULE$.MaxTimestampKey();
    }

    public static String IssueTimestampKey() {
        return DelegationTokenManager$.MODULE$.IssueTimestampKey();
    }

    public static String RenewersKey() {
        return DelegationTokenManager$.MODULE$.RenewersKey();
    }

    public static String OwnerKey() {
        return DelegationTokenManager$.MODULE$.OwnerKey();
    }

    public static String DefaultHmacAlgorithm() {
        return DelegationTokenManager$.MODULE$.DefaultHmacAlgorithm();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler$lzycompute() {
        DelegationTokenManager delegationTokenManager = this;
        synchronized (delegationTokenManager) {
            if (this.TokenChangedNotificationHandler$module != null) return this.TokenChangedNotificationHandler$module;
            this.TokenChangedNotificationHandler$module = new DelegationTokenManager$TokenChangedNotificationHandler$(this);
            return this.TokenChangedNotificationHandler$module;
        }
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        DelegationTokenManager delegationTokenManager = this;
        synchronized (delegationTokenManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    public DelegationTokenCache tokenCache() {
        return this.tokenCache;
    }

    public Time time() {
        return this.time;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public SecretKey secretKey() {
        return this.secretKey;
    }

    public long tokenMaxLifetime() {
        return this.tokenMaxLifetime;
    }

    public long defaultTokenRenewTime() {
        return this.defaultTokenRenewTime;
    }

    public long tokenRemoverScanInterval() {
        return this.tokenRemoverScanInterval;
    }

    public Object kafka$server$DelegationTokenManager$$lock() {
        return this.kafka$server$DelegationTokenManager$$lock;
    }

    private ZkNodeChangeNotificationListener tokenChangeListener() {
        return this.tokenChangeListener;
    }

    private void tokenChangeListener_$eq(ZkNodeChangeNotificationListener x$1) {
        this.tokenChangeListener = x$1;
    }

    public void startup() {
        if (this.config().tokenAuthEnabled()) {
            this.zkClient().createDelegationTokenPaths();
            this.loadCache();
            this.tokenChangeListener_$eq(new ZkNodeChangeNotificationListener(this.zkClient(), DelegationTokenChangeNotificationZNode$.MODULE$.path(), DelegationTokenChangeNotificationSequenceZNode$.MODULE$.SequenceNumberPrefix(), this.TokenChangedNotificationHandler(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$5(), ZkNodeChangeNotificationListener$.MODULE$.$lessinit$greater$default$6()));
            this.tokenChangeListener().init();
        }
    }

    public void shutdown() {
        if (this.config().tokenAuthEnabled() && this.tokenChangeListener() != null) {
            this.tokenChangeListener().close();
        }
    }

    private void loadCache() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Seq<String> tokens = this.zkClient().getChildren(DelegationTokensZNode$.MODULE$.path());
            this.info((Function0<String>)((Object)new Serializable(this, tokens){
                public static final long serialVersionUID = 0L;
                private final Seq tokens$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading the token cache. Total token count : "})).s(Nil$.MODULE$)).append(BoxesRunTime.boxToInteger(this.tokens$1.size())).toString();
                }
                {
                    this.tokens$1 = tokens$1;
                }
            }));
            tokens.foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelegationTokenManager $outer;

                public final void apply(String tokenId) {
                    block4: {
                        try {
                            Option<DelegationToken> option = this.$outer.kafka$server$DelegationTokenManager$$getTokenFromZk(tokenId);
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                DelegationToken token = (DelegationToken)some.x();
                                this.$outer.kafka$server$DelegationTokenManager$$updateCache(token);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            if (None$.MODULE$.equals(option)) {
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block4;
                            }
                            throw new MatchError(option);
                        }
                        catch (Throwable throwable) {
                            this.$outer.error((Function0<String>)((Object)new Serializable(this, tokenId){
                                public static final long serialVersionUID = 0L;
                                private final String tokenId$3;

                                public final String apply() {
                                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while getting Token for tokenId :", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.tokenId$3}));
                                }
                                {
                                    this.tokenId$3 = tokenId$3;
                                }
                            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                                public static final long serialVersionUID = 0L;
                                private final Throwable ex$1;

                                public final Throwable apply() {
                                    return this.ex$1;
                                }
                                {
                                    this.ex$1 = ex$1;
                                }
                            }));
                        }
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public Option<DelegationToken> kafka$server$DelegationTokenManager$$getTokenFromZk(String tokenId) {
        Option<TokenInformation> option;
        block4: {
            Option option2;
            block3: {
                block2: {
                    option = this.zkClient().getDelegationTokenInfo(tokenId);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    TokenInformation tokenInformation = (TokenInformation)some.x();
                    byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
                    option2 = new Some<DelegationToken>(new DelegationToken(tokenInformation, hmac));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                option2 = None$.MODULE$;
            }
            return option2;
        }
        throw new MatchError(option);
    }

    public void kafka$server$DelegationTokenManager$$updateCache(DelegationToken token) {
        String hmacString = token.hmacAsBase64String();
        scala.collection.immutable.Map<String, ScramCredential> scramCredentialMap = this.prepareScramCredentials(hmacString);
        this.tokenCache().updateCache(token, JavaConverters$.MODULE$.mapAsJavaMapConverter(scramCredentialMap).asJava());
    }

    private scala.collection.immutable.Map<String, ScramCredential> prepareScramCredentials(String hmacString) {
        scala.collection.mutable.Map scramCredentialMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()).foreach(new Serializable(this, hmacString, scramCredentialMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManager $outer;
            private final String hmacString$1;
            private final scala.collection.mutable.Map scramCredentialMap$1;

            public final void apply(ScramMechanism mechanism) {
                this.scramCredentialMap$1.update(mechanism.mechanismName(), this.$outer.kafka$server$DelegationTokenManager$$scramCredential$1(mechanism, this.hmacString$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hmacString$1 = hmacString$1;
                this.scramCredentialMap$1 = scramCredentialMap$1;
            }
        });
        return scramCredentialMap.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createToken(KafkaPrincipal owner2, List<KafkaPrincipal> renewers, long maxLifeTimeMs, Function1<CreateTokenResult, BoxedUnit> responseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            responseCallback.apply(new CreateTokenResult(-1L, -1L, -1L, "", (byte[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Byte()), Errors.DELEGATION_TOKEN_AUTH_DISABLED));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            String tokenId = CoreUtils$.MODULE$.generateUuidAsBase64();
            long issueTimeStamp = this.time().milliseconds();
            long maxLifeTime = maxLifeTimeMs <= 0L ? this.tokenMaxLifetime() : Math.min(maxLifeTimeMs, this.tokenMaxLifetime());
            long maxLifeTimeStamp = issueTimeStamp + maxLifeTime;
            long expiryTimeStamp = Math.min(maxLifeTimeStamp, issueTimeStamp + this.defaultTokenRenewTime());
            TokenInformation tokenInfo = new TokenInformation(tokenId, owner2, (Collection<KafkaPrincipal>)JavaConverters$.MODULE$.seqAsJavaListConverter(renewers).asJava(), issueTimeStamp, maxLifeTimeStamp, expiryTimeStamp);
            byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenId, this.secretKey());
            DelegationToken token = new DelegationToken(tokenInfo, hmac);
            this.updateToken(token);
            this.info((Function0<String>)((Object)new Serializable(this, owner2, tokenId){
                public static final long serialVersionUID = 0L;
                private final KafkaPrincipal owner$1;
                private final String tokenId$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Created a delegation token : ", " for owner : ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.tokenId$1, this.owner$1}));
                }
                {
                    this.owner$1 = owner$1;
                    this.tokenId$1 = tokenId$1;
                }
            }));
            responseCallback.apply(new CreateTokenResult(issueTimeStamp, expiryTimeStamp, maxLifeTimeStamp, tokenId, hmac, Errors.NONE));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renewToken(KafkaPrincipal principal, ByteBuffer hmac, long renewLifeTimeMs, Function2<Errors, Object, BoxedUnit> renewCallback) {
        if (!this.config().tokenAuthEnabled()) {
            renewCallback.apply(Errors.DELEGATION_TOKEN_AUTH_DISABLED, BoxesRunTime.boxToLong(-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            Option<DelegationToken> option = this.getToken(hmac);
            if (option instanceof Some) {
                BoxedUnit boxedUnit;
                Some some = (Some)option;
                DelegationToken token = (DelegationToken)some.x();
                long now = this.time().milliseconds();
                TokenInformation tokenInfo = token.tokenInfo();
                if (this.allowedToRenew(principal, tokenInfo)) {
                    if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                        boxedUnit = renewCallback.apply(Errors.DELEGATION_TOKEN_EXPIRED, BoxesRunTime.boxToLong(-1L));
                    } else {
                        long renewLifeTime = renewLifeTimeMs < 0L ? this.defaultTokenRenewTime() : renewLifeTimeMs;
                        long renewTimeStamp = now + renewLifeTime;
                        long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), renewTimeStamp);
                        tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                        this.updateToken(token);
                        this.info((Function0<String>)((Object)new Serializable(this, tokenInfo){
                            public static final long serialVersionUID = 0L;
                            private final TokenInformation tokenInfo$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation token renewed for token : "})).s(Nil$.MODULE$)).append((Object)this.tokenInfo$1.tokenId()).append((Object)" for owner :").append(this.tokenInfo$1.owner()).toString();
                            }
                            {
                                this.tokenInfo$1 = tokenInfo$1;
                            }
                        }));
                        boxedUnit = renewCallback.apply(Errors.NONE, BoxesRunTime.boxToLong(expiryTimeStamp));
                    }
                } else {
                    boxedUnit = renewCallback.apply(Errors.DELEGATION_TOKEN_OWNER_MISMATCH, BoxesRunTime.boxToLong(-1L));
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                BoxedUnit boxedUnit = renewCallback.apply(Errors.DELEGATION_TOKEN_NOT_FOUND, BoxesRunTime.boxToLong(-1L));
            }
            return;
        }
    }

    private void updateToken(DelegationToken token) {
        this.zkClient().setOrCreateDelegationToken(token);
        this.kafka$server$DelegationTokenManager$$updateCache(token);
        this.zkClient().createTokenChangeNotification(token.tokenInfo().tokenId());
    }

    private Option<DelegationToken> getToken(ByteBuffer hmac) {
        Option option;
        try {
            byte[] byteArray = new byte[hmac.remaining()];
            hmac.get(byteArray);
            String base64Pwd = Base64.encoder().encodeToString(byteArray);
            TokenInformation tokenInfo = this.tokenCache().tokenForHmac(base64Pwd);
            option = tokenInfo == null ? None$.MODULE$ : new Some<DelegationToken>(new DelegationToken(tokenInfo, byteArray));
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception while getting token for hmac";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
            option = None$.MODULE$;
        }
        return option;
    }

    private boolean allowedToRenew(KafkaPrincipal principal, TokenInformation tokenInfo) {
        return principal.equals(tokenInfo.owner()) || ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tokenInfo.renewers()).asScala()).toList().contains(principal);
    }

    public Option<DelegationToken> getToken(String tokenId) {
        TokenInformation tokenInfo = this.tokenCache().token(tokenId);
        return tokenInfo == null ? None$.MODULE$ : new Some<DelegationToken>(this.kafka$server$DelegationTokenManager$$getToken(tokenInfo));
    }

    public DelegationToken kafka$server$DelegationTokenManager$$getToken(TokenInformation tokenInfo) {
        byte[] hmac = DelegationTokenManager$.MODULE$.createHmac(tokenInfo.tokenId(), this.secretKey());
        return new DelegationToken(tokenInfo, hmac);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void expireToken(KafkaPrincipal principal, ByteBuffer hmac, long expireLifeTimeMs, Function2<Errors, Object, BoxedUnit> expireResponseCallback) {
        if (!this.config().tokenAuthEnabled()) {
            expireResponseCallback.apply(Errors.DELEGATION_TOKEN_AUTH_DISABLED, BoxesRunTime.boxToLong(-1L));
            return;
        }
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            block11: {
                Option<DelegationToken> option;
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        block10: {
                            option = this.getToken(hmac);
                            if (!(option instanceof Some)) break block9;
                            Some some = (Some)option;
                            DelegationToken token = (DelegationToken)some.x();
                            TokenInformation tokenInfo = token.tokenInfo();
                            long now = this.time().milliseconds();
                            if (!this.allowedToRenew(principal, tokenInfo)) break block10;
                            if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                                boxedUnit = expireResponseCallback.apply(Errors.DELEGATION_TOKEN_EXPIRED, BoxesRunTime.boxToLong(-1L));
                                break block8;
                            } else if (expireLifeTimeMs < 0L) {
                                this.kafka$server$DelegationTokenManager$$removeToken(tokenInfo.tokenId());
                                this.info((Function0<String>)((Object)new Serializable(this, tokenInfo){
                                    public static final long serialVersionUID = 0L;
                                    private final TokenInformation tokenInfo$2;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Token expired for token : "})).s(Nil$.MODULE$)).append((Object)this.tokenInfo$2.tokenId()).append((Object)" for owner :").append(this.tokenInfo$2.owner()).toString();
                                    }
                                    {
                                        this.tokenInfo$2 = tokenInfo$2;
                                    }
                                }));
                                boxedUnit = expireResponseCallback.apply(Errors.NONE, BoxesRunTime.boxToLong(now));
                                break block8;
                            } else {
                                long expiryTimeStamp = Math.min(tokenInfo.maxTimestamp(), now + expireLifeTimeMs);
                                tokenInfo.setExpiryTimestamp(expiryTimeStamp);
                                this.updateToken(token);
                                this.info((Function0<String>)((Object)new Serializable(this, tokenInfo){
                                    public static final long serialVersionUID = 0L;
                                    private final TokenInformation tokenInfo$2;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated expiry time for token : "})).s(Nil$.MODULE$)).append((Object)this.tokenInfo$2.tokenId()).append((Object)" for owner :").append(this.tokenInfo$2.owner()).toString();
                                    }
                                    {
                                        this.tokenInfo$2 = tokenInfo$2;
                                    }
                                }));
                                boxedUnit = expireResponseCallback.apply(Errors.NONE, BoxesRunTime.boxToLong(expiryTimeStamp));
                            }
                            break block8;
                        }
                        boxedUnit = expireResponseCallback.apply(Errors.DELEGATION_TOKEN_OWNER_MISMATCH, BoxesRunTime.boxToLong(-1L));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block11;
                }
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                BoxedUnit boxedUnit = expireResponseCallback.apply(Errors.DELEGATION_TOKEN_NOT_FOUND, BoxesRunTime.boxToLong(-1L));
            }
            return;
        }
    }

    public void kafka$server$DelegationTokenManager$$removeToken(String tokenId) {
        this.zkClient().deleteDelegationToken(tokenId);
        this.kafka$server$DelegationTokenManager$$removeCache(tokenId);
        this.zkClient().createTokenChangeNotification(tokenId);
    }

    public void kafka$server$DelegationTokenManager$$removeCache(String tokenId) {
        this.tokenCache().removeCache(tokenId);
    }

    public void expireTokens() {
        Object object = this.kafka$server$DelegationTokenManager$$lock();
        synchronized (object) {
            this.getAllTokenInformation().foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DelegationTokenManager $outer;

                public final void apply(TokenInformation tokenInfo) {
                    long now = this.$outer.time().milliseconds();
                    if (tokenInfo.maxTimestamp() < now || tokenInfo.expiryTimestamp() < now) {
                        this.$outer.info((Function0<String>)((Object)new Serializable(this, tokenInfo){
                            public static final long serialVersionUID = 0L;
                            private final TokenInformation tokenInfo$3;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delegation token expired for token : "})).s(Nil$.MODULE$)).append((Object)this.tokenInfo$3.tokenId()).append((Object)" for owner :").append(this.tokenInfo$3.owner()).toString();
                            }
                            {
                                this.tokenInfo$3 = tokenInfo$3;
                            }
                        }));
                        this.$outer.kafka$server$DelegationTokenManager$$removeToken(tokenInfo.tokenId());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
    }

    public List<TokenInformation> getAllTokenInformation() {
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.tokenCache().tokens()).asScala()).toList();
    }

    public List<DelegationToken> getTokens(Function1<TokenInformation, Object> filterToken) {
        return ((List)this.getAllTokenInformation().filter((Function1)filterToken)).map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DelegationTokenManager $outer;

            public final DelegationToken apply(TokenInformation token) {
                return this.$outer.kafka$server$DelegationTokenManager$$getToken(token);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public DelegationTokenManager$TokenChangedNotificationHandler$ TokenChangedNotificationHandler() {
        return this.TokenChangedNotificationHandler$module == null ? this.TokenChangedNotificationHandler$lzycompute() : this.TokenChangedNotificationHandler$module;
    }

    public final ScramCredential kafka$server$DelegationTokenManager$$scramCredential$1(ScramMechanism mechanism, String hmacString$1) {
        return new ScramFormatter(mechanism).generateCredential(hmacString$1, mechanism.minIterations());
    }

    public DelegationTokenManager(KafkaConfig config, DelegationTokenCache tokenCache, Time time, KafkaZkClient zkClient) {
        this.config = config;
        this.tokenCache = tokenCache;
        this.time = time;
        this.zkClient = zkClient;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Token Manager on Broker ").append(BoxesRunTime.boxToInteger(config.brokerId())).append((Object)"]: ").toString());
        byte[] keyBytes = config.tokenAuthEnabled() ? config.delegationTokenMasterKey().value().getBytes(StandardCharsets.UTF_8) : null;
        this.secretKey = keyBytes == null || keyBytes.length == 0 ? null : DelegationTokenManager$.MODULE$.createSecretKey(keyBytes);
        this.tokenMaxLifetime = Predef$.MODULE$.Long2long(config.delegationTokenMaxLifeMs());
        this.defaultTokenRenewTime = Predef$.MODULE$.Long2long(config.delegationTokenExpiryTimeMs());
        this.tokenRemoverScanInterval = Predef$.MODULE$.Long2long(config.delegationTokenExpiryCheckIntervalMs());
        this.kafka$server$DelegationTokenManager$$lock = new Object();
        this.tokenChangeListener = null;
    }
}

