/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.LeaderEpochCache;
import kafka.zk.AdminZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Equals;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\r\re\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\r\u0002\t9\fW.\u001a\t\u0003\u001fUq!\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\ta\u0001\u0015:fI\u00164\u0017B\u0001\f\u0018\u0005\u0019\u0019FO]5oO*\u0011A#E\u0005\u0003\u001beI!AG\u000e\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u00039\u0011\tQ!\u001e;jYND\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\"I1\u0005\u0001B\u0001B\u0003%AEK\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\tqa\u00197vgR,'/\u0003\u0002*M\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018BA\u0012\u000b\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0005/\u0013\ty#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002\ng%\u0011AG\u0001\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0011!1\u0004A!A!\u0002\u00139\u0014aB7fiJL7m\u001d\t\u0003q\u0005k\u0011!\u000f\u0006\u0003miR!a\u000f\u001f\u0002\r\r|W.\\8o\u0015\t)QH\u0003\u0002?\u007f\u00051\u0011\r]1dQ\u0016T\u0011\u0001Q\u0001\u0004_J<\u0017B\u0001\":\u0005\u001diU\r\u001e:jGND\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\u0005i&lW\r\u0005\u0002G\u00116\tqI\u0003\u0002\u001du%\u0011\u0011j\u0012\u0002\u0005)&lW\r\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003M\u0003\u0015\tXo\u001c;b!\tIQ*\u0003\u0002O\u0005\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM\u001d\u0005\t!\u0002\u0011\t\u0011)A\u0005#\u0006QB.Z1eKJ,e\u000e\u001a9pS:$(\t\\8dW&twmU3oIB\u0019\u0001C\u0015+\n\u0005M\u000b\"AB(qi&|g\u000e\u0005\u0002\n+&\u0011aK\u0001\u0002\r\u00052|7m[5oON+g\u000e\u001a\u0005\u00061\u0002!\t!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015i[F,\u00180`A\u0006\u00147\r\u0005\u0002\n\u0001!)Qb\u0016a\u0001\u001d!)ad\u0016a\u0001?!)1e\u0016a\u0001I!)Af\u0016a\u0001[!)\u0011g\u0016a\u0001e!)ag\u0016a\u0001o!)Ai\u0016a\u0001\u000b\")1j\u0016a\u0001\u0019\"9\u0001k\u0016I\u0001\u0002\u0004\tV\u0001B3\u0001\u0001\u0019\u00141AU#R!\t9\u0017P\u0004\u0002i_:\u0011\u0011N\u001c\b\u0003U6l\u0011a\u001b\u0006\u0003Y\u001a\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\r!q!\u00029\u0003\u0011\u0003\t\u0018\u0001\u0006*fa2L7-\u0019$fi\u000eDWM\u001d+ie\u0016\fG\r\u0005\u0002\ne\u001a)\u0011A\u0001E\u0001gN\u0011!\u000f\u001e\t\u0003!UL!A^\t\u0003\r\u0005s\u0017PU3g\u0011\u0015A&\u000f\"\u0001y)\u0005\th!\u0002>s\u0001\tY(\u0001\u0004$fi\u000eD'+Z9vKN$8cA=uyB\u0019Q0!\u0001\u000f\u0005%q\u0018BA@\u0003\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012L1A_A\u0002\u0015\ty(\u0001\u0003\u0006\u0002\be\u0014)\u0019!C\u0001\u0003\u0013\tAb]3tg&|g\u000eU1siN,\"!a\u0003\u0011\u0011\u00055\u0011qCA\u000e\u0003Gi!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005kRLGN\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u001e\u0005}Q\"\u0001\u001e\n\u0007\u0005\u0005\"H\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005\u0015\u0012\u0011\u0007\b\u0005\u0003O\ti#\u0004\u0002\u0002*)\u0019\u00111\u0006\u001e\u0002\u0011I,\u0017/^3tiNLA!a\f\u0002*\u0005aa)\u001a;dQJ+\u0017/^3ti&!\u00111GA\u001b\u00055\u0001\u0016M\u001d;ji&|g\u000eR1uC*!\u0011qFA\u0015\u0011)\tI$\u001fB\u0001B\u0003%\u00111B\u0001\u000eg\u0016\u001c8/[8o!\u0006\u0014Ho\u001d\u0011\t\u0015\u0005u\u0012P!b\u0001\n\u0003\ty$\u0001\u0006v]\u0012,'\u000f\\=j]\u001e,\"!!\u0011\u0011\t\u0005\u0015\u00121I\u0005\u0005\u0003\u000b\n)DA\u0004Ck&dG-\u001a:\t\u0015\u0005%\u0013P!A!\u0002\u0013\t\t%A\u0006v]\u0012,'\u000f\\=j]\u001e\u0004\u0003B\u0002-z\t\u0003\ti\u0005\u0006\u0004\u0002P\u0005M\u0013Q\u000b\t\u0004\u0003#JX\"\u0001:\t\u0011\u0005\u001d\u00111\na\u0001\u0003\u0017A\u0001\"!\u0010\u0002L\u0001\u0007\u0011\u0011\t\u0005\b\u00033JH\u0011AA.\u0003\u0019ygMZ:fiR!\u0011QLA2!\r\u0001\u0012qL\u0005\u0004\u0003C\n\"\u0001\u0002'p]\u001eD\u0001\"!\u001a\u0002X\u0001\u0007\u00111D\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tI'\u001fC!\u0003W\nq![:F[B$\u00180\u0006\u0002\u0002nA\u0019\u0001#a\u001c\n\u0007\u0005E\u0014CA\u0004C_>dW-\u00198\t\u000f\u0005U\u0014\u0010\"\u0011\u0002x\u0005AAo\\*ue&tw\r\u0006\u0002\u0002zA!\u00111PAA\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005M\u0011\u0001\u00027b]\u001eL1AFA?\r\u001d\t\u0019D\u001d\u0001\u0003\u0003\u000b\u001bR!a!u\u0003\u000f\u00032!`AE\u0013\u0011\t\u0019$a\u0001\t\u0017\u0005u\u00121\u0011BC\u0002\u0013\u0005\u0011QR\u000b\u0003\u0003\u001f\u0003B!!%\u0002\u0018:!\u0011qEAJ\u0013\u0011\t)*!\u000b\u0002\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0013\u0011\t\u0019$!'\u000b\t\u0005U\u0015\u0011\u0006\u0005\f\u0003\u0013\n\u0019I!A!\u0002\u0013\ty\tC\u0004Y\u0003\u0007#\t!a(\u0015\t\u0005\u0005\u00161\u0015\t\u0005\u0003#\n\u0019\t\u0003\u0005\u0002>\u0005u\u0005\u0019AAH\u0011!\t9+a!\u0005\u0002\u0005%\u0016!B3se>\u0014XCAAV!\u0011\ti+a-\u000e\u0005\u0005=&bAAYu\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u00026\u0006=&AB#se>\u00148\u000f\u0003\u0005\u0002:\u0006\rE\u0011AA^\u0003%!xNU3d_J$7/\u0006\u0002\u0002>B!\u0011qXAc\u001b\t\t\tMC\u0002\u0002Dj\naA]3d_J$\u0017\u0002BAd\u0003\u0003\u0014Q\"T3n_JL(+Z2pe\u0012\u001c\b\u0002CAf\u0003\u0007#\t!!4\u0002\u001b!Lw\r[,bi\u0016\u0014X.\u0019:l+\t\ti\u0006\u0003\u0005\u0002R\u0006\rE\u0011AAg\u00039awnZ*uCJ$xJ\u001a4tKRD\u0001\"!6\u0002\u0004\u0012\u0005\u0011q[\u0001\nKb\u001cW\r\u001d;j_:,\"!!7\u0011\tA\u0011\u00161\u001c\t\u0005\u0003;\f9O\u0004\u0003\u0002`\u0006\rhb\u00016\u0002b&\t!#C\u0002\u0002fF\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002j\u0006-(!\u0003+ie><\u0018M\u00197f\u0015\r\t)/\u0005\u0005\t\u0003k\n\u0019\t\"\u0011\u0002x!I\u0011\u0011\u001f:\u0012\u0002\u0013\u0005\u00111_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\u0005U(fA)\u0002x.\u0012\u0011\u0011 \t\u0005\u0003w\u0014)!\u0004\u0002\u0002~*!\u0011q B\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0004E\t!\"\u00198o_R\fG/[8o\u0013\u0011\u00119!!@\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0002\u0004\u0003\f\u0001\u0001!Q\u0002\u0002\u0003!\u0012\u00032aZAB\u0011%\u0011\t\u0002\u0001b\u0001\n\u0013\u0011\u0019\"A\u0005sKBd\u0017nY1JIV\tq\u0004C\u0004\u0003\u0018\u0001\u0001\u000b\u0011B\u0010\u0002\u0015I,\u0007\u000f\\5dC&#\u0007\u0005C\u0005\u0003\u001c\u0001\u0011\r\u0011\"\u0003\u0003\u001e\u0005QAn\\4D_:$X\r\u001f;\u0016\u0005\t}\u0001c\u0001$\u0003\"%\u0019!1E$\u0003\u00151{wmQ8oi\u0016DH\u000f\u0003\u0005\u0003(\u0001\u0001\u000b\u0011\u0002B\u0010\u0003-awnZ\"p]R,\u0007\u0010\u001e\u0011\t\u0013\t-\u0002A1A\u0005\n\t5\u0012A\u00047fC\u0012,'/\u00128ea>Lg\u000e^\u000b\u0002)\"9!\u0011\u0007\u0001!\u0002\u0013!\u0016a\u00047fC\u0012,'/\u00128ea>Lg\u000e\u001e\u0011\t\u0013\tU\u0002A1A\u0005\n\t]\u0012a\u00054fi\u000eD'+Z9vKN$h+\u001a:tS>tWC\u0001B\u001d!\r\u0001\"1H\u0005\u0004\u0005{\t\"!B*i_J$\b\u0002\u0003B!\u0001\u0001\u0006IA!\u000f\u0002)\u0019,Go\u00195SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8!\u0011%\u0011)\u0005\u0001b\u0001\n\u0013\tY'\u0001\fgKR\u001c\u0007.T3uC\u0012\fG/Y*vaB|'\u000f^3e\u0011!\u0011I\u0005\u0001Q\u0001\n\u00055\u0014a\u00064fi\u000eDW*\u001a;bI\u0006$\u0018mU;qa>\u0014H/\u001a3!\u0011%\u0011i\u0005\u0001b\u0001\n\u0013\u0011y%A\u0004nCb<\u0016-\u001b;\u0016\u0005\tE\u0003\u0003BA>\u0005'JAA!\u0016\u0002~\t9\u0011J\u001c;fO\u0016\u0014\b\u0002\u0003B-\u0001\u0001\u0006IA!\u0015\u0002\u00115\f\u0007pV1ji\u0002B\u0011B!\u0018\u0001\u0005\u0004%IAa\u0014\u0002\u00115LgNQ=uKND\u0001B!\u0019\u0001A\u0003%!\u0011K\u0001\n[&t')\u001f;fg\u0002B\u0011B!\u001a\u0001\u0005\u0004%IAa\u0014\u0002\u00115\f\u0007PQ=uKND\u0001B!\u001b\u0001A\u0003%!\u0011K\u0001\n[\u0006D()\u001f;fg\u0002B\u0011B!\u001c\u0001\u0005\u0004%IAa\u0014\u0002\u0013\u0019,Go\u00195TSj,\u0007\u0002\u0003B9\u0001\u0001\u0006IA!\u0015\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0005\u0003v\u0001\u0011\r\u0011\"\u0003\u0002l\u0005a2\u000f[8vY\u0012\u001cVM\u001c3MK\u0006$WM]#q_\u000eD'+Z9vKN$\b\u0002\u0003B=\u0001\u0001\u0006I!!\u001c\u0002;MDw.\u001e7e'\u0016tG\rT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\u0002B\u0011B! \u0001\u0005\u0004%IAa \u0002'\u0019,Go\u00195TKN\u001c\u0018n\u001c8IC:$G.\u001a:\u0016\u0005\t\u0005\u0005\u0003\u0002BB\u0005\u0013k!A!\"\u000b\u0007\t\u001dE(A\u0004dY&,g\u000e^:\n\t\t-%Q\u0011\u0002\u0014\r\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM\u001d\u0005\t\u0005\u001f\u0003\u0001\u0015!\u0003\u0003\u0002\u0006!b-\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7fe\u0002BqAa%\u0001\t\u0013\u0011)*A\u0007fa>\u001c\u0007nQ1dQ\u0016|\u0005\u000f\u001e\u000b\u0005\u0005/\u0013)\u000b\u0005\u0003\u0011%\ne\u0005\u0003\u0002BN\u0005Ck!A!(\u000b\u0007\t}%!A\u0003fa>\u001c\u0007.\u0003\u0003\u0003$\nu%\u0001\u0005'fC\u0012,'/\u00129pG\"\u001c\u0015m\u00195f\u0011!\u00119K!%A\u0002\u0005m\u0011A\u0001;q\u0011\u001d\u0011Y\u000b\u0001C!\u0005[\u000b\u0001#\u001b8ji&\fG/Z*ikR$wn\u001e8\u0015\u0005\u00055\u0004b\u0002BY\u0001\u0011\u0005!1W\u0001\u0015aJ|7-Z:t!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u0015\u0011\tU&1\u0018B_\u0005\u0003\u00042\u0001\u0005B\\\u0013\r\u0011I,\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002f\t=\u0006\u0019AA\u000e\u0011!\u0011yLa,A\u0002\u0005u\u0013a\u00034fi\u000eDwJ\u001a4tKRD\u0001Ba1\u00030\u0002\u0007!QB\u0001\u000ea\u0006\u0014H/\u001b;j_:$\u0015\r^1\t\u000f\t\u001d\u0007\u0001\"\u0001\u0003J\u0006YR.Y=cK^\u000b'O\\%g\u001fZ,'o]5{K\u0012\u0014VmY8sIN$bA!.\u0003L\n=\u0007\u0002\u0003Bg\u0005\u000b\u0004\r!!0\u0002\u000fI,7m\u001c:eg\"A\u0011Q\rBc\u0001\u0004\tY\u0002C\u0004\u0003T\u0002!\tA!6\u0002-!\fg\u000e\u001a7f\u001f\u001a47/\u001a;PkR|eMU1oO\u0016$B!!\u0018\u0003X\"A\u0011Q\rBi\u0001\u0004\tY\u0002C\u0004\u0003\\\u0002!\tA!8\u00025!\fg\u000e\u001a7f!\u0006\u0014H/\u001b;j_:\u001cx+\u001b;i\u000bJ\u0014xN]:\u0015\t\tU&q\u001c\u0005\t\u0005C\u0014I\u000e1\u0001\u0003d\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\r\u0005u'Q]A\u000e\u0013\u0011\u00119/a;\u0003\u0011%#XM]1cY\u0016DqAa;\u0001\t#\u0011i/A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u0003p\nm\bCBAo\u0005c\u0014)0\u0003\u0003\u0003t\u0006-(aA*fcB9\u0001Ca>\u0002\u001c\t5\u0011b\u0001B}#\t1A+\u001e9mKJBqA!@\u0003j\u0002\u0007a-\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000fC\u0004\u0004\u0002\u0001!Iaa\u0001\u0002-\u0015\f'\u000f\\5fgR|%\u000fT1uKN$xJ\u001a4tKR$b!!\u0018\u0004\u0006\r\u001d\u0001\u0002CA3\u0005\u007f\u0004\r!a\u0007\t\u0011\r%!q a\u0001\u0003;\n\u0001#Z1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;\t\u000f\r5\u0001\u0001\"\u0011\u0004\u0010\u0005\t\"-^5mI\u001a+Go\u00195SKF,Xm\u001d;\u0015\t\rE1q\u0003\t\u0005{\u000eMa-\u0003\u0003\u0004\u0016\u0005\r!\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7\u000f\u0003\u0005\u0004\u001a\r-\u0001\u0019AB\u000e\u00031\u0001\u0018M\u001d;ji&|g.T1q!\u0019\tiN!=\u0004\u001eA9\u0001Ca>\u0002\u001c\r}\u0001cA\u0005\u0004\"%\u001911\u0005\u0002\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\t\u000f\r\u001d\u0002\u0001\"\u0011\u0004*\u0005iQ.Y=cKR\u0013XO\\2bi\u0016$Baa\u000b\u00048A)Qpa\u0005\u0004.AA1qFB\u001b\u00037\ti&\u0004\u0002\u00042)\u001911G\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\rE\u0002\u0002CB\u001d\u0007K\u0001\raa\u000f\u0002\u001b\u0019,Go\u00195fI\u0016\u0003xn\u00195t!!\u0019yc!\u000e\u0002\u001c\ru\u0002\u0003BA\u0014\u0007\u007fIAa!\u0011\u0002*\tqQ\t]8dQ\u0016sGm\u00144gg\u0016$\bbBB#\u0001\u0011\u00053qI\u0001\u0018EVLG\u000e\u001a'fC\u0012,'/\u00129pG\"\u0014V-];fgR$Ba!\u0013\u0004NA)Qpa\u0005\u0004LA91qFB\u001b\u00037y\u0002\u0002CB(\u0007\u0007\u0002\raa\u0007\u0002\u001b\u0005dG\u000eU1si&$\u0018n\u001c8t\u0011\u001d\u0019\u0019\u0006\u0001C!\u0007+\nQCZ3uG\",\u0005o\\2ig\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0003\u0004<\r]\u0003\u0002\u0003Bq\u0007#\u0002\raa\u0013\t\u000f\rm\u0003\u0001\"\u0003\u0004^\u0005aAn\\4F]\u0012|eMZ:fiR1\u0011QLB0\u0007SB\u0001b!\u0019\u0004Z\u0001\u000711M\u0001\be\u0016\u0004H.[2b!\r)3QM\u0005\u0004\u0007O2#a\u0002*fa2L7-\u0019\u0005\t\u0007W\u001aI\u00061\u0001\u0004>\u0005YQ\r]8dQ>3gm]3u\u0011\u001d\u0019y\u0007\u0001C\u0005\u0007c\nac\u001d5pk2$gi\u001c7m_^,'\u000f\u00165s_R$H.\u001a\u000b\u0007\u0003[\u001a\u0019ha\u001f\t\u000f-\u001bi\u00071\u0001\u0004vA\u0019\u0011ba\u001e\n\u0007\re$A\u0001\u0007SKBd\u0017nY1Rk>$\u0018\r\u0003\u0005\u0002f\r5\u0004\u0019AA\u000e\u00115\u0019y\b\u0001I\u0001\u0004\u0003\u0005I\u0011BBAU\u0005\u00112/\u001e9fe\u0012\u001ax.\u001e:dK\n\u0013xn[3s+\u0005!\u0003")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final int kafka$server$ReplicaFetcherThread$$fetcherId;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    public final ReplicaManager kafka$server$ReplicaFetcherThread$$replicaMgr;
    public final Metrics kafka$server$ReplicaFetcherThread$$metrics;
    public final Time kafka$server$ReplicaFetcherThread$$time;
    public final ReplicationQuotaManager kafka$server$ReplicaFetcherThread$$quota;
    private final int kafka$server$ReplicaFetcherThread$$replicaId;
    private final LogContext kafka$server$ReplicaFetcherThread$$logContext;
    private final BlockingSend leaderEndpoint;
    private final short fetchRequestVersion;
    private final boolean fetchMetadataSupported;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer kafka$server$ReplicaFetcherThread$$fetchSize;
    private final boolean shouldSendLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$9() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$9();
    }

    public /* synthetic */ BrokerEndPoint kafka$server$ReplicaFetcherThread$$super$sourceBroker() {
        return super.sourceBroker();
    }

    public int kafka$server$ReplicaFetcherThread$$replicaId() {
        return this.kafka$server$ReplicaFetcherThread$$replicaId;
    }

    public LogContext kafka$server$ReplicaFetcherThread$$logContext() {
        return this.kafka$server$ReplicaFetcherThread$$logContext;
    }

    private BlockingSend leaderEndpoint() {
        return this.leaderEndpoint;
    }

    private short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    private boolean fetchMetadataSupported() {
        return this.fetchMetadataSupported;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer kafka$server$ReplicaFetcherThread$$fetchSize() {
        return this.kafka$server$ReplicaFetcherThread$$fetchSize;
    }

    private boolean shouldSendLeaderEpochRequest() {
        return this.shouldSendLeaderEpochRequest;
    }

    private FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    public Option<LeaderEpochCache> kafka$server$ReplicaFetcherThread$$epochCacheOpt(TopicPartition tp) {
        return this.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplica(tp).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LeaderEpochCache apply(Replica x$1) {
                return x$1.epochs().get();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            this.leaderEndpoint().close();
        }
        return (boolean)var1_1;
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(topicPartition);
        Partition partition2 = this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(topicPartition).get();
        MemoryRecords records = partitionData.toRecords();
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != replica.logEndOffset().messageOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(replica.logEndOffset().messageOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)((Object)new Serializable(this, topicPartition, partitionData, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final PartitionData partitionData$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.replica$1.logEndOffset().messageOffset()), this.topicPartition$1, BoxesRunTime.boxToInteger(this.records$1.sizeInBytes()), BoxesRunTime.boxToLong(this.partitionData$1.highWatermark())}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.partitionData$1 = partitionData$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            }));
        }
        partition2.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)((Object)new Serializable(this, topicPartition, replica, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final Replica replica$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.replica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger(this.records$1.sizeInBytes()), this.topicPartition$1}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.replica$1 = replica$1;
                    this.records$1 = records$1;
                }
            }));
        }
        long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.highWatermark());
        long leaderLogStartOffset = partitionData.logStartOffset();
        replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
        replica.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)((Object)new Serializable(this, topicPartition, followerHighWatermark){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final long followerHighWatermark$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower set replica high watermark for partition ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong(this.followerHighWatermark$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.followerHighWatermark$1 = followerHighWatermark$1;
                }
            }));
        }
        if (this.kafka$server$ReplicaFetcherThread$$quota.isThrottled(topicPartition)) {
            this.kafka$server$ReplicaFetcherThread$$quota.record(records.sizeInBytes());
        }
        this.kafka$server$ReplicaFetcherThread$$replicaMgr.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)((Object)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$2}))).append((Object)"This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append((Object)"message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append((Object)"equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            }));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica replica = this.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(topicPartition);
        Partition partition2 = this.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(topicPartition).get();
        long leaderEndOffset = this.earliestOrLatestOffset(topicPartition, -1L);
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            AdminZkClient adminZkClient = new AdminZkClient(this.kafka$server$ReplicaFetcherThread$$replicaMgr.zkClient());
            if (Predef$.MODULE$.Boolean2boolean(LogConfig$.MODULE$.fromProps(this.kafka$server$ReplicaFetcherThread$$brokerConfig.originals(), adminZkClient.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topicPartition.topic())).uncleanLeaderElectionEnable())) {
                this.warn((Function0<String>)((Object)new Serializable(this, topicPartition, replica, leaderEndOffset){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$3;
                    private final Replica replica$2;
                    private final long leaderEndOffset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset fetch offset for partition ", " from ", " to current "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3, BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader's latest offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.leaderEndOffset$1)}))).toString();
                    }
                    {
                        this.topicPartition$3 = topicPartition$3;
                        this.replica$2 = replica$2;
                        this.leaderEndOffset$1 = leaderEndOffset$1;
                    }
                }));
                partition2.truncateTo(leaderEndOffset, false);
                this.kafka$server$ReplicaFetcherThread$$replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId(), topicPartition, leaderEndOffset);
                l = leaderEndOffset;
                return l;
            }
            this.fatal((Function0<String>)((Object)new Serializable(this, topicPartition, replica, leaderEndOffset){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$3;
                private final Replica replica$2;
                private final long leaderEndOffset$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exiting because log truncation is not allowed for partition ", ", current leader's "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"latest offset ", " is less than replica's latest offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.leaderEndOffset$1), BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset())}))).toString();
                }
                {
                    this.topicPartition$3 = topicPartition$3;
                    this.replica$2 = replica$2;
                    this.leaderEndOffset$1 = leaderEndOffset$1;
                }
            }));
            throw new FatalExitError();
        }
        long leaderStartOffset = this.earliestOrLatestOffset(topicPartition, -2L);
        this.warn((Function0<String>)((Object)new Serializable(this, topicPartition, replica, leaderStartOffset){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$3;
            private final Replica replica$2;
            private final long leaderStartOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reset fetch offset for partition ", " from ", " to current "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3, BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"leader's start offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.leaderStartOffset$1)}))).toString();
            }
            {
                this.topicPartition$3 = topicPartition$3;
                this.replica$2 = replica$2;
                this.leaderStartOffset$1 = leaderStartOffset$1;
            }
        }));
        long offsetToFetch = Math.max(leaderStartOffset, replica.logEndOffset().messageOffset());
        if (leaderStartOffset > replica.logEndOffset().messageOffset()) {
            partition2.truncateFullyAndStartAt(leaderStartOffset, false);
        }
        l = offsetToFetch;
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        if (partitions.nonEmpty()) {
            this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.kafka$server$ReplicaFetcherThread$$brokerConfig.replicaFetchBackoffMs()));
        }
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        try {
            ClientResponse clientResponse = this.leaderEndpoint().sendRequest(fetchRequest.underlying());
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            return this.fetchSessionHandler().handleResponse(fetchResponse) ? ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchResponse.responseData()).asScala()).toSeq().map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, PartitionData> apply(Tuple2<TopicPartition, FetchResponse.PartitionData> x0$1) {
                    Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x0$1;
                    if (tuple2 != null) {
                        TopicPartition key = tuple2._1();
                        FetchResponse.PartitionData value2 = tuple2._2();
                        Tuple2<TopicPartition, PartitionData> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), new PartitionData(value2));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom()) : Nil$.MODULE$;
        }
        catch (Throwable throwable) {
            this.fetchSessionHandler().handleError(throwable);
            throw throwable;
        }
    }

    private long earliestOrLatestOffset(TopicPartition topicPartition, long earliestOrLatest) {
        ListOffsetRequest.Builder builder;
        if (this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
            Map partitions = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), Predef$.MODULE$.long2Long(earliestOrLatest))}));
            builder = ListOffsetRequest.Builder.forReplica((short)1, this.kafka$server$ReplicaFetcherThread$$replicaId()).setTargetTimes(JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        } else {
            Map partitions = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), new ListOffsetRequest.PartitionData(earliestOrLatest, 1))}));
            builder = ListOffsetRequest.Builder.forReplica((short)0, this.kafka$server$ReplicaFetcherThread$$replicaId()).setOffsetData(JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava());
        }
        ListOffsetRequest.Builder requestBuilder = builder;
        ClientResponse clientResponse = this.leaderEndpoint().sendRequest(requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData partitionData = response.responseData().get(topicPartition);
        Errors errors = partitionData.error;
        if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            long l = this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(partitionData.offset) : Predef$.MODULE$.Long2long(partitionData.offsets.get(0));
            return l;
        }
        throw errors.exception();
    }

    public AbstractFetcherThread.ResultWithPartitions<FetchRequest> buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        Set partitionsWithError = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder();
        partitionMap.foreach(new Serializable(this, partitionsWithError, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final Set partitionsWithError$1;
            private final FetchSessionHandler.Builder builder$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$2) {
                Object object;
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                TopicPartition topicPartition = tuple2._1();
                PartitionFetchState partitionFetchState = tuple2._2();
                if (partitionFetchState.isReadyForFetch() && !this.$outer.kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(this.$outer.kafka$server$ReplicaFetcherThread$$quota, topicPartition)) {
                    try {
                        long logStartOffset2 = this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(topicPartition).logStartOffset();
                        this.builder$1.add(topicPartition, new FetchRequest.PartitionData(partitionFetchState.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.$outer.kafka$server$ReplicaFetcherThread$$fetchSize())));
                        object = BoxedUnit.UNIT;
                        return object;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        object = this.partitionsWithError$1.$plus$eq(topicPartition);
                    }
                    return object;
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsWithError$1 = partitionsWithError$1;
                this.builder$1 = builder$1;
            }
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica(this.fetchRequestVersion(), this.kafka$server$ReplicaFetcherThread$$replicaId(), Predef$.MODULE$.Integer2int(this.maxWait()), Predef$.MODULE$.Integer2int(this.minBytes()), fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget());
        Object object = this.fetchMetadataSupported() ? requestBuilder.metadata(fetchData.metadata()) : BoxedUnit.UNIT;
        return new AbstractFetcherThread.ResultWithPartitions<FetchRequest>(new FetchRequest(fetchData.sessionPartitions(), requestBuilder), partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> maybeTruncate(Map<TopicPartition, EpochEndOffset> fetchedEpochs) {
        GenMap fetchOffsets2 = HashMap$.MODULE$.empty();
        Set partitionsWithError = (Set)Set$.MODULE$.apply(Nil$.MODULE$);
        fetchedEpochs.foreach(new Serializable(this, (HashMap)fetchOffsets2, partitionsWithError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final HashMap fetchOffsets$1;
            private final Set partitionsWithError$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<TopicPartition, EpochEndOffset> x0$3) {
                Equals equals2;
                Tuple2<TopicPartition, EpochEndOffset> tuple2 = x0$3;
                if (tuple2 == null) throw new MatchError(tuple2);
                TopicPartition tp = tuple2._1();
                EpochEndOffset epochOffset = tuple2._2();
                try {
                    Replica replica = this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.getReplicaOrException(tp);
                    Partition partition2 = this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.getPartition(tp).get();
                    if (epochOffset.hasError()) {
                        this.$outer.info((Function0<String>)((Object)new Serializable(this, epochOffset, replica){
                            public static final long serialVersionUID = 0L;
                            private final EpochEndOffset epochOffset$1;
                            private final Replica replica$3;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying leaderEpoch request for partition ", " as the leader reported an error: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.replica$3.topicPartition(), this.epochOffset$1.error()}));
                            }
                            {
                                this.epochOffset$1 = epochOffset$1;
                                this.replica$3 = replica$3;
                            }
                        }));
                        equals2 = this.partitionsWithError$2.$plus$eq(tp);
                        return equals2;
                    } else {
                        long l;
                        if (epochOffset.endOffset() == -1L) {
                            this.$outer.warn((Function0<String>)((Object)new Serializable(this, tp, replica){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$maybeTruncate$1 $outer;
                                private final TopicPartition tp$1;
                                private final Replica replica$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an unknown offset in ", ". "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.replica$3.topicPartition()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The initial fetch offset ", " will be used for truncation."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$server$ReplicaFetcherThread$$anonfun$$$outer().partitionStates().stateValue(this.tp$1).fetchOffset())}))).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.tp$1 = tp$1;
                                    this.replica$3 = replica$3;
                                }
                            }));
                            l = this.$outer.partitionStates().stateValue(tp).fetchOffset();
                        } else {
                            l = epochOffset.endOffset() >= replica.logEndOffset().messageOffset() ? this.$outer.kafka$server$ReplicaFetcherThread$$logEndOffset(replica, epochOffset) : epochOffset.endOffset();
                        }
                        long fetchOffset = l;
                        partition2.truncateTo(fetchOffset, false);
                        this.$outer.kafka$server$ReplicaFetcherThread$$replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId(), tp, fetchOffset);
                        equals2 = this.fetchOffsets$1.put(tp, BoxesRunTime.boxToLong(fetchOffset));
                    }
                    return equals2;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, tp){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition tp$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to truncate ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.tp$1}));
                        }
                        {
                            this.tp$1 = tp$1;
                        }
                    }), (Function0<Throwable>)((Object)new Serializable(this, kafkaStorageException){
                        public static final long serialVersionUID = 0L;
                        private final KafkaStorageException e$1;

                        public final KafkaStorageException apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    }));
                    equals2 = this.partitionsWithError$2.$plus$eq(tp);
                }
                return equals2;
            }

            public /* synthetic */ ReplicaFetcherThread kafka$server$ReplicaFetcherThread$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetchOffsets$1 = fetchOffsets$1;
                this.partitionsWithError$2 = partitionsWithError$2;
            }
        });
        return new AbstractFetcherThread.ResultWithPartitions<GenMap>(fetchOffsets2, partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>> buildLeaderEpochRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> allPartitions) {
        scala.collection.immutable.Map partitionEpochOpts = ((TraversableOnce)((TraversableLike)allPartitions.filter((Function1<Tuple2<TopicPartition, PartitionFetchState>, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, PartitionFetchState> x0$4) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$4;
                if (tuple2 != null) {
                    PartitionFetchState state = tuple2._2();
                    boolean bl = state.isTruncatingLog();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }))).map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;

            public final Tuple2<TopicPartition, Option<LeaderEpochCache>> apply(Tuple2<TopicPartition, PartitionFetchState> x0$5) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicPartition tp = tuple2._1();
                    Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), this.$outer.kafka$server$ReplicaFetcherThread$$epochCacheOpt(tp));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple2 = partitionEpochOpts.partition(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Option<LeaderEpochCache>> x0$6) {
                Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple2 = x0$6;
                if (tuple2 != null) {
                    Option<LeaderEpochCache> epochCacheOpt2 = tuple2._2();
                    boolean bl = epochCacheOpt2.nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 != null) {
            Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map> tuple22;
            scala.collection.immutable.Map partitionsWithEpoch = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map partitionsWithoutEpoch = (scala.collection.immutable.Map)tuple2._2();
            Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map> tuple23 = tuple22 = new Tuple2<scala.collection.immutable.Map, scala.collection.immutable.Map>(partitionsWithEpoch, partitionsWithoutEpoch);
            scala.collection.immutable.Map partitionsWithEpoch2 = tuple23._1();
            scala.collection.immutable.Map partitionsWithoutEpoch2 = tuple23._2();
            this.debug((Function0<String>)((Object)new Serializable(this, partitionsWithEpoch2){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map partitionsWithEpoch$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Build leaderEpoch request ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionsWithEpoch$1}));
                }
                {
                    this.partitionsWithEpoch$1 = partitionsWithEpoch$1;
                }
            }));
            scala.collection.immutable.Map result2 = partitionsWithEpoch2.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicPartition, Option<LeaderEpochCache>> x0$7) {
                    Tuple2<TopicPartition, Option<LeaderEpochCache>> tuple2 = x0$7;
                    if (tuple2 != null) {
                        TopicPartition tp = tuple2._1();
                        Option<LeaderEpochCache> epochCacheOpt2 = tuple2._2();
                        Tuple2<TopicPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToInteger(epochCacheOpt2.get().latestEpoch()));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
            return new AbstractFetcherThread.ResultWithPartitions<Map<TopicPartition, Object>>(result2, partitionsWithoutEpoch2.keys().toSet());
        }
        throw new MatchError(tuple2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochsFromLeader(Map<TopicPartition, Object> partitions) {
        ObjectRef<Object> result2 = ObjectRef.create(null);
        if (!this.shouldSendLeaderEpochRequest()) {
            result2.elem = partitions.map((Function1<TopicPartition, Object>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, Object> x0$10) {
                    Tuple2<TopicPartition, Object> tuple2 = x0$10;
                    if (tuple2 != null) {
                        TopicPartition tp = tuple2._1();
                        Tuple2<TopicPartition, EpochEndOffset> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new EpochEndOffset(Errors.NONE, -1L));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }), Map$.MODULE$.canBuildFrom());
            return (Map)result2.elem;
        }
        java.util.Map<TopicPartition, Integer> partitionsAsJava = JavaConverters$.MODULE$.mapAsJavaMapConverter(((TraversableOnce)partitions.map((Function1<TopicPartition, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, Integer> apply(Tuple2<TopicPartition, Object> x0$8) {
                Tuple2<TopicPartition, Object> tuple2 = x0$8;
                if (tuple2 != null) {
                    TopicPartition tp = tuple2._1();
                    int epoch = tuple2._2$mcI$sp();
                    Tuple2<TopicPartition, Integer> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), BoxesRunTime.boxToInteger(epoch));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        OffsetsForLeaderEpochRequest.Builder epochRequest = new OffsetsForLeaderEpochRequest.Builder(partitionsAsJava);
        try {
            ClientResponse response = this.leaderEndpoint().sendRequest(epochRequest);
            result2.elem = JavaConverters$.MODULE$.mapAsScalaMapConverter(((OffsetsForLeaderEpochResponse)response.responseBody()).responses()).asScala();
            this.debug((Function0<String>)((Object)new Serializable(this, result2){
                public static final long serialVersionUID = 0L;
                private final ObjectRef result$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Receive leaderEpoch response ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{(Map)this.result$1.elem}));
                }
                {
                    this.result$1 = result$1;
                }
            }));
            return (Map)result2.elem;
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)((Object)new Serializable(this, partitions){
                public static final long serialVersionUID = 0L;
                private final Map partitions$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when sending leader epoch request for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitions$1}));
                }
                {
                    this.partitions$1 = partitions$1;
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            }));
            result2.elem = partitions.map((Function1<TopicPartition, Object>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, Object> x0$9) {
                    Tuple2<TopicPartition, Object> tuple2 = x0$9;
                    if (tuple2 != null) {
                        TopicPartition tp = tuple2._1();
                        Tuple2<TopicPartition, EpochEndOffset> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), new EpochEndOffset(Errors.forException(this.t$1), -1L));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.t$1 = t$1;
                }
            }), Map$.MODULE$.canBuildFrom());
        }
        return (Map)result2.elem;
    }

    /*
     * WARNING - void declaration
     */
    public long kafka$server$ReplicaFetcherThread$$logEndOffset(Replica replica, EpochEndOffset epochOffset) {
        void var3_3;
        long logEndOffset2 = replica.logEndOffset().messageOffset();
        this.info((Function0<String>)((Object)new Serializable(this, replica, epochOffset, logEndOffset2){
            public static final long serialVersionUID = 0L;
            private final Replica replica$4;
            private final EpochEndOffset epochOffset$2;
            private final long logEndOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Based on follower's leader epoch, leader replied with an offset ", " >= the "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.epochOffset$2.endOffset())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"follower's log end offset ", " in ", ". No truncation needed."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.logEndOffset$1), this.replica$4.topicPartition()}))).toString();
            }
            {
                this.replica$4 = replica$4;
                this.epochOffset$2 = epochOffset$2;
                this.logEndOffset$1 = logEndOffset$1;
            }
        }));
        return (long)var3_3;
    }

    public boolean kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition.topic(), topicPartition.partition());
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig2, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicationQuotaManager quota, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.kafka$server$ReplicaFetcherThread$$fetcherId = fetcherId;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig2;
        this.kafka$server$ReplicaFetcherThread$$replicaMgr = replicaMgr;
        this.kafka$server$ReplicaFetcherThread$$metrics = metrics;
        this.kafka$server$ReplicaFetcherThread$$time = time;
        this.kafka$server$ReplicaFetcherThread$$quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig2.replicaFetchBackoffMs()), false, true);
        this.kafka$server$ReplicaFetcherThread$$replicaId = brokerConfig2.brokerId();
        this.kafka$server$ReplicaFetcherThread$$logContext = new LogContext(new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaFetcher replicaId=", ", leaderId=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger(super.sourceBroker().id())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetcherId=", "] "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(fetcherId)}))).toString());
        this.logIdent_$eq(this.kafka$server$ReplicaFetcherThread$$logContext().logPrefix());
        this.leaderEndpoint = leaderEndpointBlockingSend.getOrElse(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;

            public final ReplicaFetcherBlockingSend apply() {
                return new ReplicaFetcherBlockingSend(this.$outer.kafka$server$ReplicaFetcherThread$$super$sourceBroker(), this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig, this.$outer.kafka$server$ReplicaFetcherThread$$metrics, this.$outer.kafka$server$ReplicaFetcherThread$$time, this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId)})), this.$outer.kafka$server$ReplicaFetcherThread$$logContext());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.fetchRequestVersion = (short)(brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0))))));
        this.fetchMetadataSupported = brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$);
        this.maxWait = brokerConfig2.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig2.replicaFetchMinBytes();
        this.maxBytes = brokerConfig2.replicaFetchResponseMaxBytes();
        this.kafka$server$ReplicaFetcherThread$$fetchSize = brokerConfig2.replicaFetchMaxBytes();
        this.shouldSendLeaderEpochRequest = brokerConfig2.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.kafka$server$ReplicaFetcherThread$$logContext(), super.sourceBroker().id());
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts;
        private final FetchRequest.Builder underlying;

        public java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts() {
            return this.sessionParts;
        }

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return this.sessionParts().get((Object)topicPartition).fetchOffset;
        }

        @Override
        public boolean isEmpty() {
            return this.sessionParts().isEmpty() && this.underlying().toForget().isEmpty();
        }

        public String toString() {
            return this.underlying().toString();
        }

        public FetchRequest(java.util.Map<TopicPartition, FetchRequest.PartitionData> sessionParts, FetchRequest.Builder underlying) {
            this.sessionParts = sessionParts;
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public Errors error() {
            return this.underlying().error;
        }

        @Override
        public MemoryRecords toRecords() {
            return (MemoryRecords)this.underlying().records;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        public long logStartOffset() {
            return this.underlying().logStartOffset;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = this.error();
            Option option = ((Object)((Object)Errors.NONE)).equals((Object)errors) ? None$.MODULE$ : new Some<ApiException>(errors.exception());
            return option;
        }

        public String toString() {
            return this.underlying().toString();
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

