/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.security.CredentialProvider;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.QuotaConfigHandler;
import kafka.server.QuotaFactory;
import org.apache.kafka.common.utils.Sanitizer;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u000f\t\tRk]3s\u0007>tg-[4IC:$G.\u001a:\u000b\u0005\r!\u0011AB:feZ,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\r!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\nRk>$\u0018mQ8oM&<\u0007*\u00198eY\u0016\u0014\bCA\u0005\u000e\u0013\tq!AA\u0007D_:4\u0017n\u001a%b]\u0012dWM\u001d\u0005\t!\u0001\u0011)\u0019!C\u0005#\u0005i\u0011/^8uC6\u000bg.Y4feN,\u0012A\u0005\t\u0003'uq!\u0001F\u000e\u000f\u0005UQbB\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0007\u0003\u0019a$o\\8u}%\tQ!\u0003\u0002\u0004\t%\u0011ADA\u0001\r#V|G/\u0019$bGR|'/_\u0005\u0003=}\u0011Q\"U;pi\u0006l\u0015M\\1hKJ\u001c(B\u0001\u000f\u0003\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0012AD9v_R\fW*\u00198bO\u0016\u00148\u000f\t\u0005\tG\u0001\u0011)\u0019!C\u0001I\u0005\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s+\u0005)\u0003C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0005\u0003!\u0019XmY;sSRL\u0018B\u0001\u0016(\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\t\u00111\u0002!\u0011!Q\u0001\n\u0015\n1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BQA\f\u0001\u0005\u0002=\na\u0001P5oSRtDc\u0001\u00192eA\u0011\u0011\u0002\u0001\u0005\u0006!5\u0002\rA\u0005\u0005\u0006G5\u0002\r!\n\u0005\u0006i\u0001!\t!N\u0001\u0015aJ|7-Z:t\u0007>tg-[4DQ\u0006tw-Z:\u0015\u0007YbT\t\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0003V]&$\b\"B\u001f4\u0001\u0004q\u0014aD9v_R\fWI\u001c;jif\u0004\u0016\r\u001e5\u0011\u0005}\u0012eBA\u001cA\u0013\t\t\u0005(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!9\u0011\u001515\u00071\u0001H\u0003\u0019\u0019wN\u001c4jOB\u0011\u0001*T\u0007\u0002\u0013*\u0011!jS\u0001\u0005kRLGNC\u0001M\u0003\u0011Q\u0017M^1\n\u00059K%A\u0003)s_B,'\u000f^5fg\u0002")
public class UserConfigHandler
extends QuotaConfigHandler
implements ConfigHandler {
    private final QuotaFactory.QuotaManagers quotaManagers;
    private final CredentialProvider credentialProvider;

    private QuotaFactory.QuotaManagers quotaManagers() {
        return this.quotaManagers;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    @Override
    public void processConfigChanges(String quotaEntityPath, Properties config) {
        String[] entities = quotaEntityPath.split("/");
        if (entities.length != 1 && entities.length != 3) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid quota entity path: ").append((Object)quotaEntityPath).toString());
        }
        String sanitizedUser = entities[0];
        Option sanitizedClientId = entities.length == 3 ? new Some<String>(entities[2]) : None$.MODULE$;
        this.updateQuotaConfig(new Some<String>(sanitizedUser), sanitizedClientId, config);
        if (!sanitizedClientId.isDefined()) {
            String string2 = sanitizedUser;
            String string3 = ConfigEntityName$.MODULE$.Default();
            if (string2 == null ? string3 != null : !string2.equals(string3)) {
                this.credentialProvider().updateCredentials(Sanitizer.desanitize(sanitizedUser), config);
            }
        }
    }

    public UserConfigHandler(QuotaFactory.QuotaManagers quotaManagers, CredentialProvider credentialProvider) {
        this.quotaManagers = quotaManagers;
        this.credentialProvider = credentialProvider;
        super(quotaManagers);
    }
}

