/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StickyAssignor
extends AbstractPartitionAssignor {
    private static final Logger log = LoggerFactory.getLogger(StickyAssignor.class);
    private static final String TOPIC_PARTITIONS_KEY_NAME = "previous_assignment";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private static final Schema TOPIC_ASSIGNMENT = new Schema(new Field("topic", Type.STRING), new Field("partitions", new ArrayOf(Type.INT32)));
    private static final Schema STICKY_ASSIGNOR_USER_DATA = new Schema(new Field("previous_assignment", new ArrayOf(TOPIC_ASSIGNMENT)));
    private List<TopicPartition> memberAssignment = null;
    private PartitionMovements partitionMovements;

    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, PartitionAssignor.Subscription> subscriptions) {
        HashMap<String, List<TopicPartition>> currentAssignment = new HashMap<String, List<TopicPartition>>();
        this.partitionMovements = new PartitionMovements();
        this.prepopulateCurrentAssignments(subscriptions, currentAssignment);
        boolean isFreshAssignment = currentAssignment.isEmpty();
        HashMap<TopicPartition, List<String>> partition2AllPotentialConsumers = new HashMap<TopicPartition, List<String>>();
        HashMap<String, List<TopicPartition>> consumer2AllPotentialPartitions = new HashMap<String, List<TopicPartition>>();
        for (Map.Entry<String, Integer> entry2 : partitionsPerTopic.entrySet()) {
            for (int i = 0; i < entry2.getValue(); ++i) {
                partition2AllPotentialConsumers.put(new TopicPartition(entry2.getKey(), i), new ArrayList());
            }
        }
        for (Map.Entry<String, Object> entry3 : subscriptions.entrySet()) {
            String string2 = entry3.getKey();
            consumer2AllPotentialPartitions.put(string2, new ArrayList());
            for (String topic : ((PartitionAssignor.Subscription)entry3.getValue()).topics()) {
                for (int i = 0; i < partitionsPerTopic.get(topic); ++i) {
                    TopicPartition topicPartition = new TopicPartition(topic, i);
                    ((List)consumer2AllPotentialPartitions.get(string2)).add(topicPartition);
                    ((List)partition2AllPotentialConsumers.get(topicPartition)).add(string2);
                }
            }
            if (currentAssignment.containsKey(string2)) continue;
            currentAssignment.put(string2, new ArrayList());
        }
        HashMap<TopicPartition, String> currentPartitionConsumer = new HashMap<TopicPartition, String>();
        for (Map.Entry entry4 : currentAssignment.entrySet()) {
            for (TopicPartition topicPartition : (List)entry4.getValue()) {
                currentPartitionConsumer.put(topicPartition, (String)entry4.getKey());
            }
        }
        List<TopicPartition> list2 = this.sortPartitions(currentAssignment, isFreshAssignment, partition2AllPotentialConsumers, consumer2AllPotentialPartitions);
        ArrayList<TopicPartition> arrayList = new ArrayList<TopicPartition>(list2);
        Iterator it = currentAssignment.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry4 = it.next();
            if (!subscriptions.containsKey(entry4.getKey())) {
                for (TopicPartition topicPartition : (List)entry4.getValue()) {
                    currentPartitionConsumer.remove(topicPartition);
                }
                it.remove();
                continue;
            }
            Iterator partitionIter = ((List)entry4.getValue()).iterator();
            while (partitionIter.hasNext()) {
                TopicPartition partition2 = (TopicPartition)partitionIter.next();
                if (!partition2AllPotentialConsumers.containsKey(partition2)) {
                    partitionIter.remove();
                    currentPartitionConsumer.remove(partition2);
                    continue;
                }
                if (!subscriptions.get(entry4.getKey()).topics().contains(partition2.topic())) {
                    partitionIter.remove();
                    continue;
                }
                arrayList.remove(partition2);
            }
        }
        TreeSet<String> sortedCurrentSubscriptions = new TreeSet<String>(new SubscriptionComparator(currentAssignment));
        sortedCurrentSubscriptions.addAll(currentAssignment.keySet());
        this.balance(currentAssignment, list2, arrayList, sortedCurrentSubscriptions, consumer2AllPotentialPartitions, partition2AllPotentialConsumers, currentPartitionConsumer);
        return currentAssignment;
    }

    private void prepopulateCurrentAssignments(Map<String, PartitionAssignor.Subscription> subscriptions, Map<String, List<TopicPartition>> currentAssignment) {
        for (Map.Entry<String, PartitionAssignor.Subscription> subscriptionEntry : subscriptions.entrySet()) {
            ByteBuffer userData = subscriptionEntry.getValue().userData();
            if (userData == null || !userData.hasRemaining()) continue;
            currentAssignment.put(subscriptionEntry.getKey(), StickyAssignor.deserializeTopicPartitionAssignment(userData));
        }
    }

    @Override
    public void onAssignment(PartitionAssignor.Assignment assignment) {
        this.memberAssignment = assignment.partitions();
    }

    @Override
    public PartitionAssignor.Subscription subscription(Set<String> topics) {
        if (this.memberAssignment == null) {
            return new PartitionAssignor.Subscription(new ArrayList<String>(topics));
        }
        return new PartitionAssignor.Subscription(new ArrayList<String>(topics), StickyAssignor.serializeTopicPartitionAssignment(this.memberAssignment));
    }

    @Override
    public String name() {
        return "sticky";
    }

    private boolean isBalanced(Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> allSubscriptions) {
        int max2;
        int min2 = currentAssignment.get(sortedCurrentSubscriptions.first()).size();
        if (min2 >= (max2 = currentAssignment.get(sortedCurrentSubscriptions.last()).size()) - 1) {
            return true;
        }
        HashMap<TopicPartition, String> allPartitions = new HashMap<TopicPartition, String>();
        Set<Map.Entry<String, List<TopicPartition>>> assignments = currentAssignment.entrySet();
        for (Map.Entry<String, List<TopicPartition>> entry2 : assignments) {
            List<TopicPartition> topicPartitions = entry2.getValue();
            for (TopicPartition topicPartition : topicPartitions) {
                if (allPartitions.containsKey(topicPartition)) {
                    log.error(topicPartition + " is assigned to more than one consumer.");
                }
                allPartitions.put(topicPartition, entry2.getKey());
            }
        }
        for (String consumer : sortedCurrentSubscriptions) {
            List<TopicPartition> consumerPartitions = currentAssignment.get(consumer);
            int consumerPartitionCount = consumerPartitions.size();
            if (consumerPartitionCount == allSubscriptions.get(consumer).size()) continue;
            List<TopicPartition> potentialTopicPartitions = allSubscriptions.get(consumer);
            for (TopicPartition topicPartition : potentialTopicPartitions) {
                String otherConsumer;
                int otherConsumerPartitionCount;
                if (currentAssignment.get(consumer).contains(topicPartition) || consumerPartitionCount >= (otherConsumerPartitionCount = currentAssignment.get(otherConsumer = (String)allPartitions.get(topicPartition)).size())) continue;
                log.debug(topicPartition + " can be moved from consumer " + otherConsumer + " to consumer " + consumer + " for a more balanced assignment.");
                return false;
            }
        }
        return true;
    }

    private int getBalanceScore(Map<String, List<TopicPartition>> assignment) {
        int score = 0;
        HashMap<String, Integer> consumer2AssignmentSize = new HashMap<String, Integer>();
        for (Map.Entry<String, List<TopicPartition>> entry2 : assignment.entrySet()) {
            consumer2AssignmentSize.put(entry2.getKey(), entry2.getValue().size());
        }
        Iterator it = consumer2AssignmentSize.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<TopicPartition>> entry2;
            entry2 = it.next();
            int consumerAssignmentSize = (Integer)((Object)entry2.getValue());
            it.remove();
            for (Map.Entry otherEntry : consumer2AssignmentSize.entrySet()) {
                score += Math.abs(consumerAssignmentSize - (Integer)otherEntry.getValue());
            }
        }
        return score;
    }

    private List<TopicPartition> sortPartitions(Map<String, List<TopicPartition>> currentAssignment, boolean isFreshAssignment, Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions) {
        ArrayList<TopicPartition> sortedPartitions = new ArrayList<TopicPartition>();
        if (!isFreshAssignment && this.areSubscriptionsIdentical(partition2AllPotentialConsumers, consumer2AllPotentialPartitions)) {
            Map<String, List<TopicPartition>> assignments = this.deepCopy(currentAssignment);
            for (Map.Entry<String, List<TopicPartition>> entry2 : assignments.entrySet()) {
                ArrayList<TopicPartition> toRemove = new ArrayList<TopicPartition>();
                for (TopicPartition partition2 : entry2.getValue()) {
                    if (partition2AllPotentialConsumers.keySet().contains(partition2)) continue;
                    toRemove.add(partition2);
                }
                for (TopicPartition partition2 : toRemove) {
                    entry2.getValue().remove(partition2);
                }
            }
            TreeSet<String> sortedConsumers = new TreeSet<String>(new SubscriptionComparator(assignments));
            sortedConsumers.addAll(assignments.keySet());
            while (!sortedConsumers.isEmpty()) {
                String consumer = sortedConsumers.pollLast();
                List<TopicPartition> remainingPartitions = assignments.get(consumer);
                if (remainingPartitions.isEmpty()) continue;
                sortedPartitions.add(remainingPartitions.remove(0));
                sortedConsumers.add(consumer);
            }
            for (TopicPartition partition3 : partition2AllPotentialConsumers.keySet()) {
                if (sortedPartitions.contains(partition3)) continue;
                sortedPartitions.add(partition3);
            }
        } else {
            TreeSet<TopicPartition> sortedAllPartitions = new TreeSet<TopicPartition>(new PartitionComparator(partition2AllPotentialConsumers));
            sortedAllPartitions.addAll(partition2AllPotentialConsumers.keySet());
            while (!sortedAllPartitions.isEmpty()) {
                sortedPartitions.add(sortedAllPartitions.pollFirst());
            }
        }
        return sortedPartitions;
    }

    private boolean areSubscriptionsIdentical(Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions) {
        if (!this.hasIdenticalListElements(partition2AllPotentialConsumers.values())) {
            return false;
        }
        return this.hasIdenticalListElements(consumer2AllPotentialPartitions.values());
    }

    private String assignPartition(TopicPartition partition2, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> currentAssignment, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, String> currentPartitionConsumer) {
        for (String consumer : sortedCurrentSubscriptions) {
            if (!consumer2AllPotentialPartitions.get(consumer).contains(partition2)) continue;
            sortedCurrentSubscriptions.remove(consumer);
            currentAssignment.get(consumer).add(partition2);
            currentPartitionConsumer.put(partition2, consumer);
            sortedCurrentSubscriptions.add(consumer);
            return consumer;
        }
        return null;
    }

    private boolean canParticipateInReassignment(TopicPartition partition2, Map<TopicPartition, List<String>> partition2AllPotentialConsumers) {
        return partition2AllPotentialConsumers.get(partition2).size() >= 2;
    }

    private boolean canParticipateInReassignment(String consumer, Map<String, List<TopicPartition>> currentAssignment, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, List<String>> partition2AllPotentialConsumers) {
        int maxAssignmentSize;
        List<TopicPartition> currentPartitions = currentAssignment.get(consumer);
        int currentAssignmentSize = currentPartitions.size();
        if (currentAssignmentSize > (maxAssignmentSize = consumer2AllPotentialPartitions.get(consumer).size())) {
            log.error("The consumer " + consumer + " is assigned more partitions than the maximum possible.");
        }
        if (currentAssignmentSize < maxAssignmentSize) {
            return true;
        }
        for (TopicPartition partition2 : currentPartitions) {
            if (!this.canParticipateInReassignment(partition2, partition2AllPotentialConsumers)) continue;
            return true;
        }
        return false;
    }

    private void balance(Map<String, List<TopicPartition>> currentAssignment, List<TopicPartition> sortedPartitions, List<TopicPartition> unassignedPartitions, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<TopicPartition, String> currentPartitionConsumer) {
        boolean initializing = currentAssignment.get(sortedCurrentSubscriptions.last()).isEmpty();
        boolean reassignmentPerformed = false;
        for (TopicPartition topicPartition : unassignedPartitions) {
            if (partition2AllPotentialConsumers.get(topicPartition).isEmpty()) continue;
            this.assignPartition(topicPartition, sortedCurrentSubscriptions, currentAssignment, consumer2AllPotentialPartitions, currentPartitionConsumer);
        }
        HashSet<TopicPartition> fixedPartitions = new HashSet<TopicPartition>();
        for (TopicPartition topicPartition : partition2AllPotentialConsumers.keySet()) {
            if (this.canParticipateInReassignment(topicPartition, partition2AllPotentialConsumers)) continue;
            fixedPartitions.add(topicPartition);
        }
        sortedPartitions.removeAll(fixedPartitions);
        HashMap<String, List<TopicPartition>> hashMap = new HashMap<String, List<TopicPartition>>();
        for (String consumer : consumer2AllPotentialPartitions.keySet()) {
            if (this.canParticipateInReassignment(consumer, currentAssignment, consumer2AllPotentialPartitions, partition2AllPotentialConsumers)) continue;
            sortedCurrentSubscriptions.remove(consumer);
            hashMap.put(consumer, currentAssignment.remove(consumer));
        }
        Map<String, List<TopicPartition>> map2 = this.deepCopy(currentAssignment);
        HashMap<TopicPartition, String> preBalancePartitionConsumers = new HashMap<TopicPartition, String>(currentPartitionConsumer);
        reassignmentPerformed = this.performReassignments(sortedPartitions, currentAssignment, sortedCurrentSubscriptions, consumer2AllPotentialPartitions, partition2AllPotentialConsumers, currentPartitionConsumer);
        if (!initializing && reassignmentPerformed && this.getBalanceScore(currentAssignment) >= this.getBalanceScore(map2)) {
            this.deepCopy(map2, currentAssignment);
            currentPartitionConsumer.clear();
            currentPartitionConsumer.putAll(preBalancePartitionConsumers);
        }
        for (Map.Entry entry2 : hashMap.entrySet()) {
            String consumer = (String)entry2.getKey();
            currentAssignment.put(consumer, (List<TopicPartition>)entry2.getValue());
            sortedCurrentSubscriptions.add(consumer);
        }
        hashMap.clear();
    }

    private boolean performReassignments(List<TopicPartition> reassignablePartitions, Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions, Map<TopicPartition, List<String>> partition2AllPotentialConsumers, Map<TopicPartition, String> currentPartitionConsumer) {
        boolean modified;
        boolean reassignmentPerformed = false;
        do {
            modified = false;
            Iterator<TopicPartition> partitionIterator = reassignablePartitions.iterator();
            block1: while (partitionIterator.hasNext() && !this.isBalanced(currentAssignment, sortedCurrentSubscriptions, consumer2AllPotentialPartitions)) {
                String consumer;
                TopicPartition partition2 = partitionIterator.next();
                if (partition2AllPotentialConsumers.get(partition2).size() <= 1) {
                    log.error("Expected more than one potential consumer for partition '" + partition2 + "'");
                }
                if ((consumer = currentPartitionConsumer.get(partition2)) == null) {
                    log.error("Expected partition '" + partition2 + "' to be assigned to a consumer");
                }
                for (String otherConsumer : partition2AllPotentialConsumers.get(partition2)) {
                    if (currentAssignment.get(consumer).size() <= currentAssignment.get(otherConsumer).size() + 1) continue;
                    this.reassignPartition(partition2, currentAssignment, sortedCurrentSubscriptions, currentPartitionConsumer, consumer2AllPotentialPartitions);
                    reassignmentPerformed = true;
                    modified = true;
                    continue block1;
                }
            }
        } while (modified);
        return reassignmentPerformed;
    }

    private void reassignPartition(TopicPartition partition2, Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<TopicPartition, String> currentPartitionConsumer, Map<String, List<TopicPartition>> consumer2AllPotentialPartitions) {
        String consumer = currentPartitionConsumer.get(partition2);
        String newConsumer = null;
        for (String anotherConsumer : sortedCurrentSubscriptions) {
            if (!consumer2AllPotentialPartitions.get(anotherConsumer).contains(partition2)) continue;
            newConsumer = anotherConsumer;
            break;
        }
        assert (newConsumer != null);
        TopicPartition partitionToBeMoved = this.partitionMovements.getTheActualPartitionToBeMoved(partition2, consumer, newConsumer);
        this.processPartitionMovement(partitionToBeMoved, newConsumer, currentAssignment, sortedCurrentSubscriptions, currentPartitionConsumer);
    }

    private void processPartitionMovement(TopicPartition partition2, String newConsumer, Map<String, List<TopicPartition>> currentAssignment, TreeSet<String> sortedCurrentSubscriptions, Map<TopicPartition, String> currentPartitionConsumer) {
        String oldConsumer = currentPartitionConsumer.get(partition2);
        sortedCurrentSubscriptions.remove(oldConsumer);
        sortedCurrentSubscriptions.remove(newConsumer);
        this.partitionMovements.movePartition(partition2, oldConsumer, newConsumer);
        currentAssignment.get(oldConsumer).remove(partition2);
        currentAssignment.get(newConsumer).add(partition2);
        currentPartitionConsumer.put(partition2, newConsumer);
        sortedCurrentSubscriptions.add(newConsumer);
        sortedCurrentSubscriptions.add(oldConsumer);
    }

    boolean isSticky() {
        return this.partitionMovements.isSticky();
    }

    static ByteBuffer serializeTopicPartitionAssignment(List<TopicPartition> partitions) {
        Struct struct = new Struct(STICKY_ASSIGNOR_USER_DATA);
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        for (Map.Entry<String, List<Integer>> topicEntry : CollectionUtils.groupDataByTopic(partitions).entrySet()) {
            Struct topicAssignment = new Struct(TOPIC_ASSIGNMENT);
            topicAssignment.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            topicAssignment.set(PARTITIONS_KEY_NAME, (Object)topicEntry.getValue().toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(STICKY_ASSIGNOR_USER_DATA.sizeOf(struct));
        STICKY_ASSIGNOR_USER_DATA.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    private static List<TopicPartition> deserializeTopicPartitionAssignment(ByteBuffer buffer) {
        Struct struct = STICKY_ASSIGNOR_USER_DATA.read(buffer);
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (Object structObj : struct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
            Struct assignment = (Struct)structObj;
            String topic = assignment.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : assignment.getArray(PARTITIONS_KEY_NAME)) {
                Integer partition2 = (Integer)partitionObj;
                partitions.add(new TopicPartition(topic, partition2));
            }
        }
        return partitions;
    }

    private <T> boolean hasIdenticalListElements(Collection<List<T>> col) {
        Iterator<List<T>> it = col.iterator();
        List<T> cur = it.next();
        while (it.hasNext()) {
            List<T> next2 = it.next();
            if (!cur.containsAll(next2) || !next2.containsAll(cur)) {
                return false;
            }
            cur = next2;
        }
        return true;
    }

    private void deepCopy(Map<String, List<TopicPartition>> source, Map<String, List<TopicPartition>> dest) {
        dest.clear();
        for (Map.Entry<String, List<TopicPartition>> entry2 : source.entrySet()) {
            dest.put(entry2.getKey(), new ArrayList(entry2.getValue()));
        }
    }

    private Map<String, List<TopicPartition>> deepCopy(Map<String, List<TopicPartition>> assignment) {
        HashMap<String, List<TopicPartition>> copy2 = new HashMap<String, List<TopicPartition>>();
        this.deepCopy(assignment, copy2);
        return copy2;
    }

    private static class ConsumerPair {
        private final String srcMemberId;
        private final String dstMemberId;

        ConsumerPair(String srcMemberId, String dstMemberId) {
            this.srcMemberId = srcMemberId;
            this.dstMemberId = dstMemberId;
        }

        public String toString() {
            return this.srcMemberId + "->" + this.dstMemberId;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.srcMemberId == null ? 0 : this.srcMemberId.hashCode());
            result2 = 31 * result2 + (this.dstMemberId == null ? 0 : this.dstMemberId.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            ConsumerPair otherPair = (ConsumerPair)obj;
            return this.srcMemberId.equals(otherPair.srcMemberId) && this.dstMemberId.equals(otherPair.dstMemberId);
        }

        private boolean in(Set<ConsumerPair> pairs) {
            for (ConsumerPair pair : pairs) {
                if (!this.equals(pair)) continue;
                return true;
            }
            return false;
        }
    }

    private static class PartitionMovements {
        private Map<String, Map<ConsumerPair, Set<TopicPartition>>> partitionMovementsByTopic = new HashMap<String, Map<ConsumerPair, Set<TopicPartition>>>();
        private Map<TopicPartition, ConsumerPair> partitionMovements = new HashMap<TopicPartition, ConsumerPair>();

        private PartitionMovements() {
        }

        private ConsumerPair removeMovementRecordOfPartition(TopicPartition partition2) {
            ConsumerPair pair = this.partitionMovements.remove(partition2);
            String topic = partition2.topic();
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic);
            partitionMovementsForThisTopic.get(pair).remove(partition2);
            if (partitionMovementsForThisTopic.get(pair).isEmpty()) {
                partitionMovementsForThisTopic.remove(pair);
            }
            if (this.partitionMovementsByTopic.get(topic).isEmpty()) {
                this.partitionMovementsByTopic.remove(topic);
            }
            return pair;
        }

        private void addPartitionMovementRecord(TopicPartition partition2, ConsumerPair pair) {
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic;
            this.partitionMovements.put(partition2, pair);
            String topic = partition2.topic();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                this.partitionMovementsByTopic.put(topic, new HashMap());
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(pair)) {
                partitionMovementsForThisTopic.put(pair, new HashSet());
            }
            partitionMovementsForThisTopic.get(pair).add(partition2);
        }

        private void movePartition(TopicPartition partition2, String oldConsumer, String newConsumer) {
            ConsumerPair pair = new ConsumerPair(oldConsumer, newConsumer);
            if (this.partitionMovements.containsKey(partition2)) {
                ConsumerPair existingPair = this.removeMovementRecordOfPartition(partition2);
                assert (existingPair.dstMemberId.equals(oldConsumer));
                if (!existingPair.srcMemberId.equals(newConsumer)) {
                    this.addPartitionMovementRecord(partition2, new ConsumerPair(existingPair.srcMemberId, newConsumer));
                }
            } else {
                this.addPartitionMovementRecord(partition2, pair);
            }
        }

        private TopicPartition getTheActualPartitionToBeMoved(TopicPartition partition2, String oldConsumer, String newConsumer) {
            ConsumerPair reversePair;
            Map<ConsumerPair, Set<TopicPartition>> partitionMovementsForThisTopic;
            String topic = partition2.topic();
            if (!this.partitionMovementsByTopic.containsKey(topic)) {
                return partition2;
            }
            if (this.partitionMovements.containsKey(partition2)) {
                assert (oldConsumer.equals(this.partitionMovements.get(partition2).dstMemberId));
                oldConsumer = this.partitionMovements.get(partition2).srcMemberId;
            }
            if (!(partitionMovementsForThisTopic = this.partitionMovementsByTopic.get(topic)).containsKey(reversePair = new ConsumerPair(newConsumer, oldConsumer))) {
                return partition2;
            }
            return partitionMovementsForThisTopic.get(reversePair).iterator().next();
        }

        private boolean isLinked(String src, String dst, Set<ConsumerPair> pairs, List<String> currentPath) {
            if (src.equals(dst)) {
                return false;
            }
            if (pairs.isEmpty()) {
                return false;
            }
            if (new ConsumerPair(src, dst).in(pairs)) {
                currentPath.add(src);
                currentPath.add(dst);
                return true;
            }
            for (ConsumerPair pair : pairs) {
                if (!pair.srcMemberId.equals(src)) continue;
                HashSet<ConsumerPair> reducedSet = new HashSet<ConsumerPair>(pairs);
                reducedSet.remove(pair);
                currentPath.add(pair.srcMemberId);
                return this.isLinked(pair.dstMemberId, dst, reducedSet, currentPath);
            }
            return false;
        }

        private boolean in(List<String> cycle, Set<List<String>> cycles) {
            ArrayList<String> superCycle = new ArrayList<String>(cycle);
            superCycle.remove(superCycle.size() - 1);
            superCycle.addAll(cycle);
            for (List<String> foundCycle : cycles) {
                if (foundCycle.size() != cycle.size() || Collections.indexOfSubList(superCycle, foundCycle) == -1) continue;
                return true;
            }
            return false;
        }

        private boolean hasCycles(Set<ConsumerPair> pairs) {
            HashSet<List<String>> cycles = new HashSet<List<String>>();
            for (ConsumerPair consumerPair : pairs) {
                HashSet<ConsumerPair> reducedPairs = new HashSet<ConsumerPair>(pairs);
                reducedPairs.remove(consumerPair);
                ArrayList<String> path = new ArrayList<String>(Collections.singleton(consumerPair.srcMemberId));
                if (!this.isLinked(consumerPair.dstMemberId, consumerPair.srcMemberId, reducedPairs, path) || this.in(path, cycles)) continue;
                cycles.add(new ArrayList<String>(path));
                log.error("A cycle of length " + (path.size() - 1) + " was found: " + ((Object)path).toString());
            }
            for (List list2 : cycles) {
                if (list2.size() != 3) continue;
                return true;
            }
            return false;
        }

        private boolean isSticky() {
            for (Map.Entry<String, Map<ConsumerPair, Set<TopicPartition>>> topicMovements : this.partitionMovementsByTopic.entrySet()) {
                Set<ConsumerPair> topicMovementPairs = topicMovements.getValue().keySet();
                if (!this.hasCycles(topicMovementPairs)) continue;
                log.error("Stickiness is violated for topic " + topicMovements.getKey() + "\nPartition movements for this topic occurred among the following consumer pairs:" + "\n" + topicMovements.getValue().toString());
                return false;
            }
            return true;
        }
    }

    private static class SubscriptionComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, List<TopicPartition>> map;

        SubscriptionComparator(Map<String, List<TopicPartition>> map2) {
            this.map = map2;
        }

        @Override
        public int compare(String o1, String o2) {
            int ret = this.map.get(o1).size() - this.map.get(o2).size();
            if (ret == 0) {
                ret = o1.compareTo(o2);
            }
            return ret;
        }
    }

    private static class PartitionComparator
    implements Comparator<TopicPartition>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Map<TopicPartition, List<String>> map;

        PartitionComparator(Map<TopicPartition, List<String>> map2) {
            this.map = map2;
        }

        @Override
        public int compare(TopicPartition o1, TopicPartition o2) {
            int ret = this.map.get(o1).size() - this.map.get(o2).size();
            if (ret == 0 && (ret = o1.topic().compareTo(o2.topic())) == 0) {
                ret = o1.partition() - o2.partition();
            }
            return ret;
        }
    }
}

