/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class ConsumerNetworkClient
implements Closeable {
    private static final int MAX_POLL_TIMEOUT_MS = 5000;
    private final Logger log;
    private final KafkaClient client;
    private final UnsentRequests unsent = new UnsentRequests();
    private final Metadata metadata;
    private final Time time;
    private final long retryBackoffMs;
    private final int maxPollTimeoutMs;
    private final long unsentExpiryMs;
    private final AtomicBoolean wakeupDisabled = new AtomicBoolean();
    private final ReentrantLock lock = new ReentrantLock(true);
    private final ConcurrentLinkedQueue<RequestFutureCompletionHandler> pendingCompletion = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Node> pendingDisconnects = new ConcurrentLinkedQueue();
    private final AtomicBoolean wakeup = new AtomicBoolean(false);

    public ConsumerNetworkClient(LogContext logContext, KafkaClient client, Metadata metadata, Time time, long retryBackoffMs, long requestTimeoutMs, int maxPollTimeoutMs) {
        this.log = logContext.logger(ConsumerNetworkClient.class);
        this.client = client;
        this.metadata = metadata;
        this.time = time;
        this.retryBackoffMs = retryBackoffMs;
        this.maxPollTimeoutMs = Math.min(maxPollTimeoutMs, 5000);
        this.unsentExpiryMs = requestTimeoutMs;
    }

    public RequestFuture<ClientResponse> send(Node node2, AbstractRequest.Builder<?> requestBuilder) {
        long now = this.time.milliseconds();
        RequestFutureCompletionHandler completionHandler = new RequestFutureCompletionHandler();
        ClientRequest clientRequest = this.client.newClientRequest(node2.idString(), requestBuilder, now, true, completionHandler);
        this.unsent.put(node2, clientRequest);
        this.client.wakeup();
        return completionHandler.future;
    }

    public Node leastLoadedNode() {
        this.lock.lock();
        try {
            Node node2 = this.client.leastLoadedNode(this.time.milliseconds());
            return node2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasReadyNodes() {
        this.lock.lock();
        try {
            boolean bl = this.client.hasReadyNodes();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void awaitMetadataUpdate() {
        this.awaitMetadataUpdate(Long.MAX_VALUE);
    }

    public boolean awaitMetadataUpdate(long timeout) {
        long startMs = this.time.milliseconds();
        int version = this.metadata.requestUpdate();
        do {
            this.poll(timeout);
            AuthenticationException ex = this.metadata.getAndClearAuthenticationException();
            if (ex == null) continue;
            throw ex;
        } while (this.metadata.version() == version && this.time.milliseconds() - startMs < timeout);
        return this.metadata.version() > version;
    }

    public void ensureFreshMetadata() {
        if (this.metadata.updateRequested() || this.metadata.timeToNextUpdate(this.time.milliseconds()) == 0L) {
            this.awaitMetadataUpdate();
        }
    }

    public void wakeup() {
        this.log.debug("Received user wakeup");
        this.wakeup.set(true);
        this.client.wakeup();
    }

    public void poll(RequestFuture<?> future) {
        while (!future.isDone()) {
            this.poll(Long.MAX_VALUE, this.time.milliseconds(), future);
        }
    }

    public boolean poll(RequestFuture<?> future, long timeout) {
        long begin = this.time.milliseconds();
        long remaining = timeout;
        long now = begin;
        do {
            this.poll(remaining, now, future);
            now = this.time.milliseconds();
            long elapsed = now - begin;
            remaining = timeout - elapsed;
        } while (!future.isDone() && remaining > 0L);
        return future.isDone();
    }

    public void poll(long timeout) {
        this.poll(timeout, this.time.milliseconds(), null);
    }

    public void poll(long timeout, long now, PollCondition pollCondition) {
        this.poll(timeout, now, pollCondition, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll(long timeout, long now, PollCondition pollCondition, boolean disableWakeup) {
        this.firePendingCompletedRequests();
        this.lock.lock();
        try {
            this.handlePendingDisconnects();
            this.trySend(now);
            if (this.pendingCompletion.isEmpty() && (pollCondition == null || pollCondition.shouldBlock())) {
                if (this.client.inFlightRequestCount() == 0) {
                    timeout = Math.min(timeout, this.retryBackoffMs);
                }
                this.client.poll(Math.min((long)this.maxPollTimeoutMs, timeout), now);
                now = this.time.milliseconds();
            } else {
                this.client.poll(0L, now);
            }
            this.checkDisconnects(now);
            if (!disableWakeup) {
                this.maybeTriggerWakeup();
            }
            this.maybeThrowInterruptException();
            this.trySend(now);
            this.failExpiredRequests(now);
            this.unsent.clean();
        }
        finally {
            this.lock.unlock();
        }
        this.firePendingCompletedRequests();
    }

    public void pollNoWakeup() {
        this.poll(0L, this.time.milliseconds(), null, true);
    }

    public boolean awaitPendingRequests(Node node2, long timeoutMs) {
        long startMs = this.time.milliseconds();
        long remainingMs = timeoutMs;
        while (this.hasPendingRequests(node2) && remainingMs > 0L) {
            this.poll(remainingMs);
            remainingMs = timeoutMs - (this.time.milliseconds() - startMs);
        }
        return !this.hasPendingRequests(node2);
    }

    public int pendingRequestCount(Node node2) {
        this.lock.lock();
        try {
            int n = this.unsent.requestCount(node2) + this.client.inFlightRequestCount(node2.idString());
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasPendingRequests(Node node2) {
        if (this.unsent.hasRequests(node2)) {
            return true;
        }
        this.lock.lock();
        try {
            boolean bl = this.client.hasInFlightRequests(node2.idString());
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int pendingRequestCount() {
        this.lock.lock();
        try {
            int n = this.unsent.requestCount() + this.client.inFlightRequestCount();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean hasPendingRequests() {
        if (this.unsent.hasRequests()) {
            return true;
        }
        this.lock.lock();
        try {
            boolean bl = this.client.hasInFlightRequests();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void firePendingCompletedRequests() {
        RequestFutureCompletionHandler completionHandler;
        boolean completedRequestsFired = false;
        while ((completionHandler = this.pendingCompletion.poll()) != null) {
            completionHandler.fireCompletion();
            completedRequestsFired = true;
        }
        if (completedRequestsFired) {
            this.client.wakeup();
        }
    }

    private void checkDisconnects(long now) {
        for (Node node2 : this.unsent.nodes()) {
            if (!this.client.connectionFailed(node2)) continue;
            Collection<ClientRequest> requests = this.unsent.remove(node2);
            for (ClientRequest request : requests) {
                RequestFutureCompletionHandler handler = (RequestFutureCompletionHandler)request.callback();
                AuthenticationException authenticationException = this.client.authenticationException(node2);
                if (authenticationException != null) {
                    handler.onFailure(authenticationException);
                    continue;
                }
                handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), request.callback(), request.destination(), request.createdTimeMs(), now, true, null, null));
            }
        }
    }

    private void handlePendingDisconnects() {
        this.lock.lock();
        try {
            Node node2;
            while ((node2 = this.pendingDisconnects.poll()) != null) {
                this.failUnsentRequests(node2, DisconnectException.INSTANCE);
                this.client.disconnect(node2.idString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void disconnectAsync(Node node2) {
        this.pendingDisconnects.offer(node2);
        this.client.wakeup();
    }

    private void failExpiredRequests(long now) {
        Collection<ClientRequest> expiredRequests = this.unsent.removeExpiredRequests(now, this.unsentExpiryMs);
        for (ClientRequest request : expiredRequests) {
            RequestFutureCompletionHandler handler = (RequestFutureCompletionHandler)request.callback();
            handler.onFailure(new TimeoutException("Failed to send request after " + this.unsentExpiryMs + " ms."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failUnsentRequests(Node node2, RuntimeException e) {
        this.lock.lock();
        try {
            Collection<ClientRequest> unsentRequests = this.unsent.remove(node2);
            for (ClientRequest unsentRequest : unsentRequests) {
                RequestFutureCompletionHandler handler = (RequestFutureCompletionHandler)unsentRequest.callback();
                handler.onFailure(e);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean trySend(long now) {
        boolean requestsSent = false;
        for (Node node2 : this.unsent.nodes()) {
            Iterator<ClientRequest> iterator2 = this.unsent.requestIterator(node2);
            while (iterator2.hasNext()) {
                ClientRequest request = iterator2.next();
                if (!this.client.ready(node2, now)) continue;
                this.client.send(request, now);
                iterator2.remove();
                requestsSent = true;
            }
        }
        return requestsSent;
    }

    public void maybeTriggerWakeup() {
        if (!this.wakeupDisabled.get() && this.wakeup.get()) {
            this.log.debug("Raising WakeupException in response to user wakeup");
            this.wakeup.set(false);
            throw new WakeupException();
        }
    }

    private void maybeThrowInterruptException() {
        if (Thread.interrupted()) {
            throw new InterruptException(new InterruptedException());
        }
    }

    public void disableWakeups() {
        this.wakeupDisabled.set(true);
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.client.close();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean connectionFailed(Node node2) {
        this.lock.lock();
        try {
            boolean bl = this.client.connectionFailed(node2);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void tryConnect(Node node2) {
        this.lock.lock();
        try {
            this.client.ready(node2, this.time.milliseconds());
        }
        finally {
            this.lock.unlock();
        }
    }

    private static final class UnsentRequests {
        private final ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> unsent = new ConcurrentHashMap<Node, ConcurrentLinkedQueue<ClientRequest>>();

        private UnsentRequests() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void put(Node node2, ClientRequest request) {
            ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> concurrentMap = this.unsent;
            synchronized (concurrentMap) {
                ConcurrentLinkedQueue<ClientRequest> requests = (ConcurrentLinkedQueue<ClientRequest>)this.unsent.get(node2);
                if (requests == null) {
                    requests = new ConcurrentLinkedQueue<ClientRequest>();
                    this.unsent.put(node2, requests);
                }
                requests.add(request);
            }
        }

        public int requestCount(Node node2) {
            ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.get(node2);
            return requests == null ? 0 : requests.size();
        }

        public int requestCount() {
            int total2 = 0;
            for (ConcurrentLinkedQueue requests : this.unsent.values()) {
                total2 += requests.size();
            }
            return total2;
        }

        public boolean hasRequests(Node node2) {
            ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.get(node2);
            return requests != null && !requests.isEmpty();
        }

        public boolean hasRequests() {
            for (ConcurrentLinkedQueue requests : this.unsent.values()) {
                if (requests.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Collection<ClientRequest> removeExpiredRequests(long now, long unsentExpiryMs) {
            ArrayList<ClientRequest> expiredRequests = new ArrayList<ClientRequest>();
            for (ConcurrentLinkedQueue requests : this.unsent.values()) {
                ClientRequest request;
                Iterator requestIterator = requests.iterator();
                while (requestIterator.hasNext() && (request = (ClientRequest)requestIterator.next()).createdTimeMs() < now - unsentExpiryMs) {
                    expiredRequests.add(request);
                    requestIterator.remove();
                }
            }
            return expiredRequests;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clean() {
            ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> concurrentMap = this.unsent;
            synchronized (concurrentMap) {
                Iterator iterator2 = this.unsent.values().iterator();
                while (iterator2.hasNext()) {
                    ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)iterator2.next();
                    if (!requests.isEmpty()) continue;
                    iterator2.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<ClientRequest> remove(Node node2) {
            ConcurrentMap<Node, ConcurrentLinkedQueue<ClientRequest>> concurrentMap = this.unsent;
            synchronized (concurrentMap) {
                ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.remove(node2);
                return requests == null ? Collections.emptyList() : requests;
            }
        }

        public Iterator<ClientRequest> requestIterator(Node node2) {
            ConcurrentLinkedQueue requests = (ConcurrentLinkedQueue)this.unsent.get(node2);
            return requests == null ? Collections.emptyIterator() : requests.iterator();
        }

        public Collection<Node> nodes() {
            return this.unsent.keySet();
        }
    }

    public static interface PollCondition {
        public boolean shouldBlock();
    }

    private class RequestFutureCompletionHandler
    implements RequestCompletionHandler {
        private final RequestFuture<ClientResponse> future = new RequestFuture();
        private ClientResponse response;
        private RuntimeException e;

        private RequestFutureCompletionHandler() {
        }

        public void fireCompletion() {
            if (this.e != null) {
                this.future.raise(this.e);
            } else if (this.response.wasDisconnected()) {
                RequestHeader requestHeader = this.response.requestHeader();
                int correlation = requestHeader.correlationId();
                ConsumerNetworkClient.this.log.debug("Cancelled {} request {} with correlation id {} due to node {} being disconnected", new Object[]{requestHeader.apiKey(), requestHeader, correlation, this.response.destination()});
                this.future.raise(DisconnectException.INSTANCE);
            } else if (this.response.versionMismatch() != null) {
                this.future.raise(this.response.versionMismatch());
            } else {
                this.future.complete(this.response);
            }
        }

        public void onFailure(RuntimeException e) {
            this.e = e;
            ConsumerNetworkClient.this.pendingCompletion.add(this);
        }

        @Override
        public void onComplete(ClientResponse response) {
            this.response = response;
            ConsumerNetworkClient.this.pendingCompletion.add(this);
        }
    }
}

