/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Checksum;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.InvalidRecordException;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Checksums;
import org.apache.kafka.common.utils.Crc32C;
import org.apache.kafka.common.utils.Utils;

public class DefaultRecord
implements Record {
    public static final int MAX_RECORD_OVERHEAD = 21;
    private static final int NULL_VARINT_SIZE_BYTES = ByteUtils.sizeOfVarint(-1);
    private final int sizeInBytes;
    private final byte attributes;
    private final long offset;
    private final long timestamp;
    private final int sequence;
    private final ByteBuffer key;
    private final ByteBuffer value;
    private final Header[] headers;

    private DefaultRecord(int sizeInBytes2, byte attributes, long offset2, long timestamp2, int sequence2, ByteBuffer key, ByteBuffer value2, Header[] headers) {
        this.sizeInBytes = sizeInBytes2;
        this.attributes = attributes;
        this.offset = offset2;
        this.timestamp = timestamp2;
        this.sequence = sequence2;
        this.key = key;
        this.value = value2;
        this.headers = headers;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public int sequence() {
        return this.sequence;
    }

    @Override
    public int sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public byte attributes() {
        return this.attributes;
    }

    @Override
    public Long checksumOrNull() {
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void ensureValid() {
    }

    @Override
    public int keySize() {
        return this.key == null ? -1 : this.key.remaining();
    }

    @Override
    public int valueSize() {
        return this.value == null ? -1 : this.value.remaining();
    }

    @Override
    public boolean hasKey() {
        return this.key != null;
    }

    @Override
    public ByteBuffer key() {
        return this.key == null ? null : this.key.duplicate();
    }

    @Override
    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public ByteBuffer value() {
        return this.value == null ? null : this.value.duplicate();
    }

    @Override
    public Header[] headers() {
        return this.headers;
    }

    public static int writeTo(DataOutputStream out, int offsetDelta, long timestampDelta, ByteBuffer key, ByteBuffer value2, Header[] headers) throws IOException {
        int sizeInBytes2 = DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, key, value2, headers);
        ByteUtils.writeVarint(sizeInBytes2, out);
        int attributes = 0;
        out.write(attributes);
        ByteUtils.writeVarlong(timestampDelta, out);
        ByteUtils.writeVarint(offsetDelta, out);
        if (key == null) {
            ByteUtils.writeVarint(-1, out);
        } else {
            int keySize = key.remaining();
            ByteUtils.writeVarint(keySize, out);
            Utils.writeTo(out, key, keySize);
        }
        if (value2 == null) {
            ByteUtils.writeVarint(-1, out);
        } else {
            int valueSize = value2.remaining();
            ByteUtils.writeVarint(valueSize, out);
            Utils.writeTo(out, value2, valueSize);
        }
        if (headers == null) {
            throw new IllegalArgumentException("Headers cannot be null");
        }
        ByteUtils.writeVarint(headers.length, out);
        for (Header header : headers) {
            String headerKey = header.key();
            if (headerKey == null) {
                throw new IllegalArgumentException("Invalid null header key found in headers");
            }
            byte[] utf8Bytes = Utils.utf8(headerKey);
            ByteUtils.writeVarint(utf8Bytes.length, out);
            out.write(utf8Bytes);
            byte[] headerValue = header.value();
            if (headerValue == null) {
                ByteUtils.writeVarint(-1, out);
                continue;
            }
            ByteUtils.writeVarint(headerValue.length, out);
            out.write(headerValue);
        }
        return ByteUtils.sizeOfVarint(sizeInBytes2) + sizeInBytes2;
    }

    @Override
    public boolean hasMagic(byte magic) {
        return magic >= 2;
    }

    @Override
    public boolean isCompressed() {
        return false;
    }

    @Override
    public boolean hasTimestampType(TimestampType timestampType) {
        return false;
    }

    public String toString() {
        return String.format("DefaultRecord(offset=%d, timestamp=%d, key=%d bytes, value=%d bytes)", this.offset, this.timestamp, this.key == null ? 0 : this.key.limit(), this.value == null ? 0 : this.value.limit());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRecord that = (DefaultRecord)o;
        return this.sizeInBytes == that.sizeInBytes && this.attributes == that.attributes && this.offset == that.offset && this.timestamp == that.timestamp && this.sequence == that.sequence && (this.key == null ? that.key == null : this.key.equals(that.key)) && (this.value == null ? that.value == null : this.value.equals(that.value)) && Arrays.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result2 = this.sizeInBytes;
        result2 = 31 * result2 + this.attributes;
        result2 = 31 * result2 + (int)(this.offset ^ this.offset >>> 32);
        result2 = 31 * result2 + (int)(this.timestamp ^ this.timestamp >>> 32);
        result2 = 31 * result2 + this.sequence;
        result2 = 31 * result2 + (this.key != null ? this.key.hashCode() : 0);
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 31 * result2 + Arrays.hashCode(this.headers);
        return result2;
    }

    public static DefaultRecord readFrom(DataInput input2, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) throws IOException {
        int sizeOfBodyInBytes = ByteUtils.readVarint(input2);
        ByteBuffer recordBuffer = ByteBuffer.allocate(sizeOfBodyInBytes);
        input2.readFully(recordBuffer.array(), 0, sizeOfBodyInBytes);
        int totalSizeInBytes = ByteUtils.sizeOfVarint(sizeOfBodyInBytes) + sizeOfBodyInBytes;
        return DefaultRecord.readFrom(recordBuffer, totalSizeInBytes, sizeOfBodyInBytes, baseOffset, baseTimestamp, baseSequence, logAppendTime);
    }

    public static DefaultRecord readFrom(ByteBuffer buffer, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) {
        int sizeOfBodyInBytes = ByteUtils.readVarint(buffer);
        if (buffer.remaining() < sizeOfBodyInBytes) {
            return null;
        }
        int totalSizeInBytes = ByteUtils.sizeOfVarint(sizeOfBodyInBytes) + sizeOfBodyInBytes;
        return DefaultRecord.readFrom(buffer, totalSizeInBytes, sizeOfBodyInBytes, baseOffset, baseTimestamp, baseSequence, logAppendTime);
    }

    private static DefaultRecord readFrom(ByteBuffer buffer, int sizeInBytes2, int sizeOfBodyInBytes, long baseOffset, long baseTimestamp, int baseSequence, Long logAppendTime) {
        try {
            int numHeaders;
            int recordStart = buffer.position();
            byte attributes = buffer.get();
            long timestampDelta = ByteUtils.readVarlong(buffer);
            long timestamp2 = baseTimestamp + timestampDelta;
            if (logAppendTime != null) {
                timestamp2 = logAppendTime;
            }
            int offsetDelta = ByteUtils.readVarint(buffer);
            long offset2 = baseOffset + (long)offsetDelta;
            int sequence2 = baseSequence >= 0 ? DefaultRecordBatch.incrementSequence(baseSequence, offsetDelta) : -1;
            ByteBuffer key = null;
            int keySize = ByteUtils.readVarint(buffer);
            if (keySize >= 0) {
                key = buffer.slice();
                key.limit(keySize);
                buffer.position(buffer.position() + keySize);
            }
            ByteBuffer value2 = null;
            int valueSize = ByteUtils.readVarint(buffer);
            if (valueSize >= 0) {
                value2 = buffer.slice();
                value2.limit(valueSize);
                buffer.position(buffer.position() + valueSize);
            }
            if ((numHeaders = ByteUtils.readVarint(buffer)) < 0) {
                throw new InvalidRecordException("Found invalid number of record headers " + numHeaders);
            }
            Header[] headers = numHeaders == 0 ? Record.EMPTY_HEADERS : DefaultRecord.readHeaders(buffer, numHeaders);
            if (buffer.position() - recordStart != sizeOfBodyInBytes) {
                throw new InvalidRecordException("Invalid record size: expected to read " + sizeOfBodyInBytes + " bytes in record payload, but instead read " + (buffer.position() - recordStart));
            }
            return new DefaultRecord(sizeInBytes2, attributes, offset2, timestamp2, sequence2, key, value2, headers);
        }
        catch (IllegalArgumentException | BufferUnderflowException e) {
            throw new InvalidRecordException("Found invalid record structure", e);
        }
    }

    private static Header[] readHeaders(ByteBuffer buffer, int numHeaders) {
        Header[] headers = new Header[numHeaders];
        for (int i = 0; i < numHeaders; ++i) {
            int headerKeySize = ByteUtils.readVarint(buffer);
            if (headerKeySize < 0) {
                throw new InvalidRecordException("Invalid negative header key size " + headerKeySize);
            }
            String headerKey = Utils.utf8(buffer, headerKeySize);
            buffer.position(buffer.position() + headerKeySize);
            ByteBuffer headerValue = null;
            int headerValueSize = ByteUtils.readVarint(buffer);
            if (headerValueSize >= 0) {
                headerValue = buffer.slice();
                headerValue.limit(headerValueSize);
                buffer.position(buffer.position() + headerValueSize);
            }
            headers[i] = new RecordHeader(headerKey, headerValue);
        }
        return headers;
    }

    public static int sizeInBytes(int offsetDelta, long timestampDelta, ByteBuffer key, ByteBuffer value2, Header[] headers) {
        int bodySize = DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, key, value2, headers);
        return bodySize + ByteUtils.sizeOfVarint(bodySize);
    }

    public static int sizeInBytes(int offsetDelta, long timestampDelta, int keySize, int valueSize, Header[] headers) {
        int bodySize = DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, keySize, valueSize, headers);
        return bodySize + ByteUtils.sizeOfVarint(bodySize);
    }

    private static int sizeOfBodyInBytes(int offsetDelta, long timestampDelta, ByteBuffer key, ByteBuffer value2, Header[] headers) {
        int keySize = key == null ? -1 : key.remaining();
        int valueSize = value2 == null ? -1 : value2.remaining();
        return DefaultRecord.sizeOfBodyInBytes(offsetDelta, timestampDelta, keySize, valueSize, headers);
    }

    private static int sizeOfBodyInBytes(int offsetDelta, long timestampDelta, int keySize, int valueSize, Header[] headers) {
        int size2 = 1;
        size2 += ByteUtils.sizeOfVarint(offsetDelta);
        size2 += ByteUtils.sizeOfVarlong(timestampDelta);
        return size2 += DefaultRecord.sizeOf(keySize, valueSize, headers);
    }

    private static int sizeOf(int keySize, int valueSize, Header[] headers) {
        int size2 = 0;
        size2 = keySize < 0 ? (size2 += NULL_VARINT_SIZE_BYTES) : (size2 += ByteUtils.sizeOfVarint(keySize) + keySize);
        size2 = valueSize < 0 ? (size2 += NULL_VARINT_SIZE_BYTES) : (size2 += ByteUtils.sizeOfVarint(valueSize) + valueSize);
        if (headers == null) {
            throw new IllegalArgumentException("Headers cannot be null");
        }
        size2 += ByteUtils.sizeOfVarint(headers.length);
        for (Header header : headers) {
            String headerKey = header.key();
            if (headerKey == null) {
                throw new IllegalArgumentException("Invalid null header key found in headers");
            }
            int headerKeySize = Utils.utf8Length(headerKey);
            size2 += ByteUtils.sizeOfVarint(headerKeySize) + headerKeySize;
            byte[] headerValue = header.value();
            if (headerValue == null) {
                size2 += NULL_VARINT_SIZE_BYTES;
                continue;
            }
            size2 += ByteUtils.sizeOfVarint(headerValue.length) + headerValue.length;
        }
        return size2;
    }

    static int recordSizeUpperBound(ByteBuffer key, ByteBuffer value2, Header[] headers) {
        int keySize = key == null ? -1 : key.remaining();
        int valueSize = value2 == null ? -1 : value2.remaining();
        return 21 + DefaultRecord.sizeOf(keySize, valueSize, headers);
    }

    public static long computePartialChecksum(long timestamp2, int serializedKeySize, int serializedValueSize) {
        Checksum checksum = Crc32C.create();
        Checksums.updateLong(checksum, timestamp2);
        Checksums.updateInt(checksum, serializedKeySize);
        Checksums.updateInt(checksum, serializedValueSize);
        return checksum.getValue();
    }
}

