/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ConvertedRecords;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordBatchIterator;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryRecords
extends AbstractRecords {
    private static final Logger log = LoggerFactory.getLogger(MemoryRecords.class);
    public static final MemoryRecords EMPTY = MemoryRecords.readableRecords(ByteBuffer.allocate(0));
    private final ByteBuffer buffer;
    private final Iterable<MutableRecordBatch> batches = new Iterable<MutableRecordBatch>(){

        @Override
        public Iterator<MutableRecordBatch> iterator() {
            return new RecordBatchIterator<MutableRecordBatch>(new ByteBufferLogInputStream(MemoryRecords.this.buffer.duplicate(), Integer.MAX_VALUE));
        }
    };
    private int validBytes = -1;

    private MemoryRecords(ByteBuffer buffer) {
        Objects.requireNonNull(buffer, "buffer should not be null");
        this.buffer = buffer;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.limit();
    }

    @Override
    public long writeTo(GatheringByteChannel channel, long position, int length) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position should not be greater than Integer.MAX_VALUE: " + position);
        }
        if (position + (long)length > (long)this.buffer.limit()) {
            throw new IllegalArgumentException("position+length should not be greater than buffer.limit(), position: " + position + ", length: " + length + ", buffer.limit(): " + this.buffer.limit());
        }
        int pos = (int)position;
        ByteBuffer dup = this.buffer.duplicate();
        dup.position(pos);
        dup.limit(pos + length);
        return channel.write(dup);
    }

    public int writeFullyTo(GatheringByteChannel channel) throws IOException {
        int written;
        this.buffer.mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer)) {
        }
        this.buffer.reset();
        return written;
    }

    public int validBytes() {
        if (this.validBytes >= 0) {
            return this.validBytes;
        }
        int bytes2 = 0;
        for (RecordBatch recordBatch : this.batches()) {
            bytes2 += recordBatch.sizeInBytes();
        }
        this.validBytes = bytes2;
        return bytes2;
    }

    public ConvertedRecords<MemoryRecords> downConvert(byte toMagic, long firstOffset, Time time) {
        return this.downConvert(this.batches(), toMagic, firstOffset, time);
    }

    public FilterResult filterTo(TopicPartition partition2, RecordFilter filter2, ByteBuffer destinationBuffer, int maxRecordBatchSize, BufferSupplier decompressionBufferSupplier) {
        return MemoryRecords.filterTo(partition2, this.batches(), filter2, destinationBuffer, maxRecordBatchSize, decompressionBufferSupplier);
    }

    private static FilterResult filterTo(TopicPartition partition2, Iterable<MutableRecordBatch> batches, RecordFilter filter2, ByteBuffer destinationBuffer, int maxRecordBatchSize, BufferSupplier decompressionBufferSupplier) {
        long maxTimestamp = -1L;
        long maxOffset = -1L;
        long shallowOffsetOfMaxTimestamp = -1L;
        int messagesRead = 0;
        int bytesRead = 0;
        int messagesRetained = 0;
        int bytesRetained = 0;
        ByteBufferOutputStream bufferOutputStream = new ByteBufferOutputStream(destinationBuffer);
        for (MutableRecordBatch batch : batches) {
            ByteBuffer outputBuffer;
            bytesRead += batch.sizeInBytes();
            RecordFilter.BatchRetention batchRetention = filter2.checkBatchRetention(batch);
            if (batchRetention == RecordFilter.BatchRetention.DELETE) continue;
            byte batchMagic = batch.magic();
            boolean writeOriginalBatch = true;
            ArrayList<Record> retainedRecords = new ArrayList<Record>();
            try (CloseableIterator<Record> iterator2 = batch.streamingIterator(decompressionBufferSupplier);){
                while (iterator2.hasNext()) {
                    Record record2 = (Record)iterator2.next();
                    ++messagesRead;
                    if (filter2.shouldRetainRecord(batch, record2)) {
                        if (!record2.hasMagic(batchMagic)) {
                            writeOriginalBatch = false;
                        }
                        if (record2.offset() > maxOffset) {
                            maxOffset = record2.offset();
                        }
                        retainedRecords.add(record2);
                        continue;
                    }
                    writeOriginalBatch = false;
                }
            }
            if (!retainedRecords.isEmpty()) {
                if (writeOriginalBatch) {
                    batch.writeTo(bufferOutputStream);
                    messagesRetained += retainedRecords.size();
                    bytesRetained += batch.sizeInBytes();
                    if (batch.maxTimestamp() > maxTimestamp) {
                        maxTimestamp = batch.maxTimestamp();
                        shallowOffsetOfMaxTimestamp = batch.lastOffset();
                    }
                } else {
                    MemoryRecordsBuilder builder = MemoryRecords.buildRetainedRecordsInto(batch, retainedRecords, bufferOutputStream);
                    MemoryRecords records = builder.build();
                    int filteredBatchSize = records.sizeInBytes();
                    messagesRetained += retainedRecords.size();
                    bytesRetained += filteredBatchSize;
                    if (filteredBatchSize > batch.sizeInBytes() && filteredBatchSize > maxRecordBatchSize) {
                        log.warn("Record batch from {} with last offset {} exceeded max record batch size {} after cleaning (new size is {}). Consumers with version earlier than 0.10.1.0 may need to increase their fetch sizes.", partition2, batch.lastOffset(), maxRecordBatchSize, filteredBatchSize);
                    }
                    MemoryRecordsBuilder.RecordsInfo info2 = builder.info();
                    if (info2.maxTimestamp > maxTimestamp) {
                        maxTimestamp = info2.maxTimestamp;
                        shallowOffsetOfMaxTimestamp = info2.shallowOffsetOfMaxTimestamp;
                    }
                }
            } else if (batchRetention == RecordFilter.BatchRetention.RETAIN_EMPTY) {
                if (batchMagic < 2) {
                    throw new IllegalStateException("Empty batches are only supported for magic v2 and above");
                }
                bufferOutputStream.ensureRemaining(61);
                DefaultRecordBatch.writeEmptyHeader(bufferOutputStream.buffer(), batchMagic, batch.producerId(), batch.producerEpoch(), batch.baseSequence(), batch.baseOffset(), batch.lastOffset(), batch.partitionLeaderEpoch(), batch.timestampType(), batch.maxTimestamp(), batch.isTransactional(), batch.isControlBatch());
            }
            if ((outputBuffer = bufferOutputStream.buffer()) == destinationBuffer) continue;
            return new FilterResult(outputBuffer, messagesRead, bytesRead, messagesRetained, bytesRetained, maxOffset, maxTimestamp, shallowOffsetOfMaxTimestamp);
        }
        return new FilterResult(destinationBuffer, messagesRead, bytesRead, messagesRetained, bytesRetained, maxOffset, maxTimestamp, shallowOffsetOfMaxTimestamp);
    }

    private static MemoryRecordsBuilder buildRetainedRecordsInto(RecordBatch originalBatch, List<Record> retainedRecords, ByteBufferOutputStream bufferOutputStream) {
        byte magic = originalBatch.magic();
        TimestampType timestampType = originalBatch.timestampType();
        long logAppendTime = timestampType == TimestampType.LOG_APPEND_TIME ? originalBatch.maxTimestamp() : -1L;
        long baseOffset = magic >= 2 ? originalBatch.baseOffset() : retainedRecords.get(0).offset();
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(bufferOutputStream, magic, originalBatch.compressionType(), timestampType, baseOffset, logAppendTime, originalBatch.producerId(), originalBatch.producerEpoch(), originalBatch.baseSequence(), originalBatch.isTransactional(), originalBatch.isControlBatch(), originalBatch.partitionLeaderEpoch(), bufferOutputStream.limit());
        for (Record record2 : retainedRecords) {
            builder.append(record2);
        }
        if (magic >= 2) {
            builder.overrideLastOffset(originalBatch.lastOffset());
        }
        return builder;
    }

    public ByteBuffer buffer() {
        return this.buffer.duplicate();
    }

    public Iterable<MutableRecordBatch> batches() {
        return this.batches;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<MutableRecordBatch> batchIterator = this.batches.iterator();
        while (batchIterator.hasNext()) {
            RecordBatch batch = batchIterator.next();
            try (CloseableIterator<Record> recordsIterator = batch.streamingIterator(BufferSupplier.create());){
                while (recordsIterator.hasNext()) {
                    Record record2 = (Record)recordsIterator.next();
                    this.appendRecordToStringBuilder(builder, record2.toString());
                    if (!recordsIterator.hasNext()) continue;
                    builder.append(", ");
                }
            }
            catch (KafkaException e) {
                this.appendRecordToStringBuilder(builder, "CORRUPTED");
            }
            if (!batchIterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
        return builder.toString();
    }

    private void appendRecordToStringBuilder(StringBuilder builder, String recordAsString) {
        builder.append('(').append("record=").append(recordAsString).append(")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryRecords that = (MemoryRecords)o;
        return this.buffer.equals(that.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public static MemoryRecords readableRecords(ByteBuffer buffer) {
        return new MemoryRecords(buffer);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, TimestampType timestampType, long baseOffset) {
        return MemoryRecords.builder(buffer, (byte)2, compressionType, timestampType, baseOffset);
    }

    public static MemoryRecordsBuilder idempotentBuilder(ByteBuffer buffer, CompressionType compressionType, long baseOffset, long producerId, short producerEpoch, int baseSequence) {
        return MemoryRecords.builder(buffer, (byte)2, compressionType, TimestampType.CREATE_TIME, baseOffset, System.currentTimeMillis(), producerId, producerEpoch, baseSequence);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType, baseOffset, logAppendTime, -1L, (short)-1, -1, false, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset) {
        long logAppendTime = -1L;
        if (timestampType == TimestampType.LOG_APPEND_TIME) {
            logAppendTime = System.currentTimeMillis();
        }
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType, baseOffset, logAppendTime, -1L, (short)-1, -1, false, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime, int partitionLeaderEpoch) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType, baseOffset, logAppendTime, -1L, (short)-1, -1, false, partitionLeaderEpoch);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, long baseOffset, long producerId, short producerEpoch, int baseSequence, boolean isTransactional) {
        return MemoryRecords.builder(buffer, (byte)2, compressionType, TimestampType.CREATE_TIME, baseOffset, -1L, producerId, producerEpoch, baseSequence, isTransactional, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, false, -1);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, int partitionLeaderEpoch) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, false, partitionLeaderEpoch);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, boolean isControlBatch, int partitionLeaderEpoch) {
        return new MemoryRecordsBuilder(buffer, magic, compressionType, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, isControlBatch, partitionLeaderEpoch, buffer.remaining());
    }

    public static MemoryRecords withRecords(CompressionType compressionType, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, compressionType, records);
    }

    public static MemoryRecords withRecords(CompressionType compressionType, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, 0L, compressionType, TimestampType.CREATE_TIME, -1L, (short)-1, -1, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withRecords(byte magic, CompressionType compressionType, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, 0L, compressionType, TimestampType.CREATE_TIME, records);
    }

    public static MemoryRecords withRecords(long initialOffset, CompressionType compressionType, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, initialOffset, compressionType, TimestampType.CREATE_TIME, records);
    }

    public static MemoryRecords withRecords(long initialOffset, CompressionType compressionType, Integer partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, initialOffset, compressionType, TimestampType.CREATE_TIME, -1L, (short)-1, -1, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withIdempotentRecords(CompressionType compressionType, long producerId, short producerEpoch, int baseSequence, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, 0L, compressionType, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, -1, false, records);
    }

    public static MemoryRecords withIdempotentRecords(byte magic, long initialOffset, CompressionType compressionType, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, initialOffset, compressionType, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withIdempotentRecords(long initialOffset, CompressionType compressionType, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, initialOffset, compressionType, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, false, records);
    }

    public static MemoryRecords withTransactionalRecords(CompressionType compressionType, long producerId, short producerEpoch, int baseSequence, SimpleRecord ... records) {
        return MemoryRecords.withRecords((byte)2, 0L, compressionType, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, -1, true, records);
    }

    public static MemoryRecords withTransactionalRecords(byte magic, long initialOffset, CompressionType compressionType, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, initialOffset, compressionType, TimestampType.CREATE_TIME, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, true, records);
    }

    public static MemoryRecords withTransactionalRecords(long initialOffset, CompressionType compressionType, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, SimpleRecord ... records) {
        return MemoryRecords.withTransactionalRecords((byte)2, initialOffset, compressionType, producerId, producerEpoch, baseSequence, partitionLeaderEpoch, records);
    }

    public static MemoryRecords withRecords(byte magic, long initialOffset, CompressionType compressionType, TimestampType timestampType, SimpleRecord ... records) {
        return MemoryRecords.withRecords(magic, initialOffset, compressionType, timestampType, -1L, (short)-1, -1, -1, false, records);
    }

    public static MemoryRecords withRecords(byte magic, long initialOffset, CompressionType compressionType, TimestampType timestampType, long producerId, short producerEpoch, int baseSequence, int partitionLeaderEpoch, boolean isTransactional, SimpleRecord ... records) {
        if (records.length == 0) {
            return EMPTY;
        }
        int sizeEstimate = AbstractRecords.estimateSizeInBytes(magic, compressionType, Arrays.asList(records));
        ByteBufferOutputStream bufferStream = new ByteBufferOutputStream(sizeEstimate);
        long logAppendTime = -1L;
        if (timestampType == TimestampType.LOG_APPEND_TIME) {
            logAppendTime = System.currentTimeMillis();
        }
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(bufferStream, magic, compressionType, timestampType, initialOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, false, partitionLeaderEpoch, sizeEstimate);
        for (SimpleRecord record2 : records) {
            builder.append(record2);
        }
        return builder.build();
    }

    public static MemoryRecords withEndTransactionMarker(long producerId, short producerEpoch, EndTransactionMarker marker) {
        return MemoryRecords.withEndTransactionMarker(0L, System.currentTimeMillis(), -1, producerId, producerEpoch, marker);
    }

    public static MemoryRecords withEndTransactionMarker(long timestamp2, long producerId, short producerEpoch, EndTransactionMarker marker) {
        return MemoryRecords.withEndTransactionMarker(0L, timestamp2, -1, producerId, producerEpoch, marker);
    }

    public static MemoryRecords withEndTransactionMarker(long initialOffset, long timestamp2, int partitionLeaderEpoch, long producerId, short producerEpoch, EndTransactionMarker marker) {
        int endTxnMarkerBatchSize = 61 + EndTransactionMarker.CURRENT_END_TXN_SCHEMA_RECORD_SIZE;
        ByteBuffer buffer = ByteBuffer.allocate(endTxnMarkerBatchSize);
        MemoryRecords.writeEndTransactionalMarker(buffer, initialOffset, timestamp2, partitionLeaderEpoch, producerId, producerEpoch, marker);
        buffer.flip();
        return MemoryRecords.readableRecords(buffer);
    }

    public static void writeEndTransactionalMarker(ByteBuffer buffer, long initialOffset, long timestamp2, int partitionLeaderEpoch, long producerId, short producerEpoch, EndTransactionMarker marker) {
        boolean isTransactional = true;
        boolean isControlBatch = true;
        MemoryRecordsBuilder builder = new MemoryRecordsBuilder(buffer, 2, CompressionType.NONE, TimestampType.CREATE_TIME, initialOffset, timestamp2, producerId, producerEpoch, -1, isTransactional, isControlBatch, partitionLeaderEpoch, buffer.capacity());
        builder.appendEndTxnMarker(timestamp2, marker);
        builder.close();
    }

    public static class FilterResult {
        public final ByteBuffer output;
        public final int messagesRead;
        public final int bytesRead;
        public final int messagesRetained;
        public final int bytesRetained;
        public final long maxOffset;
        public final long maxTimestamp;
        public final long shallowOffsetOfMaxTimestamp;

        public FilterResult(ByteBuffer output, int messagesRead, int bytesRead, int messagesRetained, int bytesRetained, long maxOffset, long maxTimestamp, long shallowOffsetOfMaxTimestamp) {
            this.output = output;
            this.messagesRead = messagesRead;
            this.bytesRead = bytesRead;
            this.messagesRetained = messagesRetained;
            this.bytesRetained = bytesRetained;
            this.maxOffset = maxOffset;
            this.maxTimestamp = maxTimestamp;
            this.shallowOffsetOfMaxTimestamp = shallowOffsetOfMaxTimestamp;
        }
    }

    public static abstract class RecordFilter {
        protected abstract BatchRetention checkBatchRetention(RecordBatch var1);

        protected abstract boolean shouldRetainRecord(RecordBatch var1, Record var2);

        public static enum BatchRetention {
            DELETE,
            RETAIN_EMPTY,
            DELETE_EMPTY;

        }
    }
}

