/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

public enum RecordFormat {
    V0(0),
    V1(1),
    V2(2);

    public final byte value;

    private RecordFormat(int value2) {
        this.value = (byte)value2;
    }

    public static RecordFormat lookup(byte version) {
        switch (version) {
            case 0: {
                return V0;
            }
            case 1: {
                return V1;
            }
            case 2: {
                return V2;
            }
        }
        throw new IllegalArgumentException("Unknown format version: " + version);
    }

    public static RecordFormat current() {
        return V2;
    }
}

