/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.ErosaConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.AbstractMysqlEventParser;
import com.alibaba.otter.canal.parse.inbound.mysql.LocalBinLogConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.LogEventConvert;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.TableMetaCache;
import com.alibaba.otter.canal.parse.inbound.mysql.tsdb.DatabaseTableMeta;
import com.alibaba.otter.canal.parse.index.CanalLogPositionManager;
import com.alibaba.otter.canal.parse.support.AuthenticationInfo;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class LocalBinlogEventParser
extends AbstractMysqlEventParser
implements CanalEventParser {
    protected AuthenticationInfo masterInfo;
    protected EntryPosition masterPosition;
    protected MysqlConnection metaConnection;
    protected TableMetaCache tableMetaCache;
    protected String directory;
    protected boolean needWait = false;
    protected int bufferSize = 16384;

    @Override
    protected ErosaConnection buildErosaConnection() {
        return this.buildLocalBinLogConnection();
    }

    @Override
    protected void preDump(ErosaConnection connection) {
        this.metaConnection = this.buildMysqlConnection();
        try {
            this.metaConnection.connect();
        }
        catch (IOException e) {
            throw new CanalParseException(e);
        }
        if (this.tableMetaTSDB != null && this.tableMetaTSDB instanceof DatabaseTableMeta) {
            ((DatabaseTableMeta)this.tableMetaTSDB).setConnection(this.metaConnection);
            ((DatabaseTableMeta)this.tableMetaTSDB).setFilter(this.eventFilter);
            ((DatabaseTableMeta)this.tableMetaTSDB).setBlackFilter(this.eventBlackFilter);
            ((DatabaseTableMeta)this.tableMetaTSDB).setSnapshotInterval(this.tsdbSnapshotInterval);
            ((DatabaseTableMeta)this.tableMetaTSDB).setSnapshotExpire(this.tsdbSnapshotExpire);
            ((DatabaseTableMeta)this.tableMetaTSDB).init(this.destination);
        }
        this.tableMetaCache = new TableMetaCache(this.metaConnection, this.tableMetaTSDB);
        ((LogEventConvert)this.binlogParser).setTableMetaCache(this.tableMetaCache);
    }

    @Override
    protected void afterDump(ErosaConnection connection) {
        if (this.metaConnection != null) {
            try {
                this.metaConnection.disconnect();
            }
            catch (IOException e) {
                this.logger.error("ERROR # disconnect meta connection for address:{}", (Object)this.metaConnection.getConnector().getAddress(), (Object)e);
            }
        }
    }

    @Override
    public void start() throws CanalParseException {
        if (this.runningInfo == null) {
            this.runningInfo = this.masterInfo;
        }
        super.start();
    }

    @Override
    public void stop() {
        if (this.metaConnection != null) {
            try {
                this.metaConnection.disconnect();
            }
            catch (IOException e) {
                this.logger.error("ERROR # disconnect meta connection for address:{}", (Object)this.metaConnection.getConnector().getAddress(), (Object)e);
            }
        }
        if (this.tableMetaCache != null) {
            this.tableMetaCache.clearTableMeta();
        }
        super.stop();
    }

    private ErosaConnection buildLocalBinLogConnection() {
        LocalBinLogConnection connection = new LocalBinLogConnection();
        connection.setBufferSize(this.bufferSize);
        connection.setDirectory(this.directory);
        connection.setNeedWait(this.needWait);
        return connection;
    }

    private MysqlConnection buildMysqlConnection() {
        MysqlConnection connection = new MysqlConnection(this.runningInfo.getAddress(), this.runningInfo.getUsername(), this.runningInfo.getPassword(), this.connectionCharsetNumber, this.runningInfo.getDefaultDatabaseName());
        connection.getConnector().setReceiveBufferSize(65536);
        connection.getConnector().setSendBufferSize(65536);
        connection.getConnector().setSoTimeout(30000);
        connection.setCharset(this.connectionCharset);
        return connection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected EntryPosition findStartPosition(ErosaConnection connection) {
        LogPosition logPosition = this.logPositionManager.getLatestIndexBy(this.destination);
        if (logPosition != null) return logPosition.getPostion();
        EntryPosition entryPosition = this.masterPosition;
        if (StringUtils.isEmpty((String)entryPosition.getJournalName())) {
            if (entryPosition.getTimestamp() == null) return null;
            return new EntryPosition(entryPosition.getTimestamp());
        }
        if (entryPosition.getPosition() == null) return new EntryPosition(entryPosition.getTimestamp());
        return entryPosition;
    }

    @Override
    public void setLogPositionManager(CanalLogPositionManager logPositionManager) {
        this.logPositionManager = logPositionManager;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setMasterPosition(EntryPosition masterPosition) {
        this.masterPosition = masterPosition;
    }

    public void setMasterInfo(AuthenticationInfo masterInfo) {
        this.masterInfo = masterInfo;
    }

    public boolean isNeedWait() {
        return this.needWait;
    }

    public void setNeedWait(boolean needWait) {
        this.needWait = needWait;
    }
}

