/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql;

import com.alibaba.otter.canal.common.AbstractCanalLifeCycle;
import com.alibaba.otter.canal.common.utils.NamedThreadFactory;
import com.alibaba.otter.canal.parse.driver.mysql.packets.GTIDSet;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.inbound.ErosaConnection;
import com.alibaba.otter.canal.parse.inbound.EventTransactionBuffer;
import com.alibaba.otter.canal.parse.inbound.MultiStageCoprocessor;
import com.alibaba.otter.canal.parse.inbound.TableMeta;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.dbsync.LogEventConvert;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.lmax.disruptor.BatchEventProcessor;
import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.LifecycleAware;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.WorkerPool;
import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogContext;
import com.taobao.tddl.dbsync.binlog.LogDecoder;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.DeleteRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.RowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.UpdateRowsLogEvent;
import com.taobao.tddl.dbsync.binlog.event.WriteRowsLogEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;

public class MysqlMultiStageCoprocessor
extends AbstractCanalLifeCycle
implements MultiStageCoprocessor {
    private static final int maxFullTimes = 10;
    private LogEventConvert logEventConvert;
    private EventTransactionBuffer transactionBuffer;
    private ErosaConnection connection;
    private int parserThreadCount;
    private int ringBufferSize;
    private RingBuffer<MessageEvent> disruptorMsgBuffer;
    private ExecutorService parserExecutor;
    private ExecutorService stageExecutor;
    private String destination;
    private volatile CanalParseException exception;
    private AtomicLong eventsPublishBlockingTime;
    private GTIDSet gtidSet;
    private WorkerPool<MessageEvent> workerPool;
    private BatchEventProcessor<MessageEvent> simpleParserStage;
    private BatchEventProcessor<MessageEvent> sinkStoreStage;
    private LogContext logContext;
    protected boolean filterDmlInsert = false;
    protected boolean filterDmlUpdate = false;
    protected boolean filterDmlDelete = false;

    public MysqlMultiStageCoprocessor(int ringBufferSize, int parserThreadCount, LogEventConvert logEventConvert, EventTransactionBuffer transactionBuffer, String destination, boolean filterDmlInsert, boolean filterDmlUpdate, boolean filterDmlDelete) {
        this.ringBufferSize = ringBufferSize;
        this.parserThreadCount = parserThreadCount;
        this.logEventConvert = logEventConvert;
        this.transactionBuffer = transactionBuffer;
        this.destination = destination;
        this.filterDmlInsert = filterDmlInsert;
        this.filterDmlUpdate = filterDmlUpdate;
        this.filterDmlDelete = filterDmlDelete;
    }

    public void start() {
        super.start();
        this.exception = null;
        this.disruptorMsgBuffer = RingBuffer.createSingleProducer((EventFactory)new MessageEventFactory(), (int)this.ringBufferSize, (WaitStrategy)new BlockingWaitStrategy());
        int tc = this.parserThreadCount > 0 ? this.parserThreadCount : 1;
        this.parserExecutor = Executors.newFixedThreadPool(tc, (ThreadFactory)new NamedThreadFactory("MultiStageCoprocessor-Parser-" + this.destination));
        this.stageExecutor = Executors.newFixedThreadPool(2, (ThreadFactory)new NamedThreadFactory("MultiStageCoprocessor-other-" + this.destination));
        SequenceBarrier sequenceBarrier = this.disruptorMsgBuffer.newBarrier(new Sequence[0]);
        SimpleFatalExceptionHandler exceptionHandler = new SimpleFatalExceptionHandler();
        this.logContext = new LogContext();
        this.simpleParserStage = new BatchEventProcessor(this.disruptorMsgBuffer, sequenceBarrier, (EventHandler)new SimpleParserStage(this.logContext));
        this.simpleParserStage.setExceptionHandler((ExceptionHandler)exceptionHandler);
        this.disruptorMsgBuffer.addGatingSequences(new Sequence[]{this.simpleParserStage.getSequence()});
        SequenceBarrier dmlParserSequenceBarrier = this.disruptorMsgBuffer.newBarrier(new Sequence[]{this.simpleParserStage.getSequence()});
        WorkHandler[] workHandlers = new DmlParserStage[tc];
        for (int i = 0; i < tc; ++i) {
            workHandlers[i] = new DmlParserStage();
        }
        this.workerPool = new WorkerPool(this.disruptorMsgBuffer, dmlParserSequenceBarrier, (ExceptionHandler)exceptionHandler, workHandlers);
        Sequence[] sequence = this.workerPool.getWorkerSequences();
        this.disruptorMsgBuffer.addGatingSequences(sequence);
        SequenceBarrier sinkSequenceBarrier = this.disruptorMsgBuffer.newBarrier(sequence);
        this.sinkStoreStage = new BatchEventProcessor(this.disruptorMsgBuffer, sinkSequenceBarrier, (EventHandler)new SinkStoreStage());
        this.sinkStoreStage.setExceptionHandler((ExceptionHandler)exceptionHandler);
        this.disruptorMsgBuffer.addGatingSequences(new Sequence[]{this.sinkStoreStage.getSequence()});
        this.stageExecutor.submit((Runnable)this.simpleParserStage);
        this.stageExecutor.submit((Runnable)this.sinkStoreStage);
        this.workerPool.start((Executor)this.parserExecutor);
    }

    public void setBinlogChecksum(int binlogChecksum) {
        if (binlogChecksum != 0) {
            this.logContext.setFormatDescription(new FormatDescriptionLogEvent(4, binlogChecksum));
        }
    }

    public void stop() {
        this.workerPool.halt();
        this.simpleParserStage.halt();
        this.sinkStoreStage.halt();
        try {
            this.parserExecutor.shutdownNow();
            while (!(this.parserExecutor.awaitTermination(1L, TimeUnit.SECONDS) || this.parserExecutor.isShutdown() || this.parserExecutor.isTerminated())) {
                this.parserExecutor.shutdownNow();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.stageExecutor.shutdownNow();
            while (!(this.stageExecutor.awaitTermination(1L, TimeUnit.SECONDS) || this.stageExecutor.isShutdown() || this.stageExecutor.isTerminated())) {
                this.stageExecutor.shutdownNow();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.stop();
    }

    @Override
    public boolean publish(LogBuffer buffer) {
        return this.publish(buffer, null);
    }

    @Override
    public boolean publish(LogEvent event) {
        return this.publish(null, event);
    }

    private boolean publish(LogBuffer buffer, LogEvent event) {
        if (!this.isStart()) {
            if (this.exception != null) {
                throw this.exception;
            }
            return false;
        }
        boolean interupted = false;
        long blockingStart = 0L;
        int fullTimes = 0;
        while (true) {
            if (this.exception != null) {
                throw this.exception;
            }
            try {
                long next = this.disruptorMsgBuffer.tryNext();
                MessageEvent data = (MessageEvent)this.disruptorMsgBuffer.get(next);
                if (buffer != null) {
                    data.setBuffer(buffer);
                } else {
                    data.setEvent(event);
                }
                this.disruptorMsgBuffer.publish(next);
                if (fullTimes <= 0) break;
                this.eventsPublishBlockingTime.addAndGet(System.nanoTime() - blockingStart);
            }
            catch (InsufficientCapacityException e) {
                if (fullTimes == 0) {
                    blockingStart = System.nanoTime();
                }
                this.applyWait(++fullTimes);
                interupted = Thread.interrupted();
                if (fullTimes % 1000 != 0) continue;
                long nextStart = System.nanoTime();
                this.eventsPublishBlockingTime.addAndGet(nextStart - blockingStart);
                blockingStart = nextStart;
                if (!interupted && this.isStart()) continue;
            }
            break;
        }
        return this.isStart();
    }

    private void applyWait(int fullTimes) {
        int newFullTimes;
        int n = newFullTimes = fullTimes > 10 ? 10 : fullTimes;
        if (fullTimes <= 3) {
            Thread.yield();
        } else {
            LockSupport.parkNanos(100000L * (long)newFullTimes);
        }
    }

    public void setLogEventConvert(LogEventConvert logEventConvert) {
        this.logEventConvert = logEventConvert;
    }

    public void setTransactionBuffer(EventTransactionBuffer transactionBuffer) {
        this.transactionBuffer = transactionBuffer;
    }

    public void setConnection(ErosaConnection connection) {
        this.connection = connection;
    }

    public void setEventsPublishBlockingTime(AtomicLong eventsPublishBlockingTime) {
        this.eventsPublishBlockingTime = eventsPublishBlockingTime;
    }

    public void setGtidSet(GTIDSet gtidSet) {
        this.gtidSet = gtidSet;
    }

    static class MessageEventFactory
    implements EventFactory<MessageEvent> {
        MessageEventFactory() {
        }

        public MessageEvent newInstance() {
            return new MessageEvent();
        }
    }

    static class SimpleFatalExceptionHandler
    implements ExceptionHandler {
        SimpleFatalExceptionHandler() {
        }

        public void handleEventException(Throwable ex, long sequence, Object event) {
            throw new CanalParseException(ex);
        }

        public void handleOnStartException(Throwable ex) {
        }

        public void handleOnShutdownException(Throwable ex) {
        }
    }

    static class MessageEvent {
        private LogBuffer buffer;
        private CanalEntry.Entry entry;
        private boolean needDmlParse = false;
        private TableMeta table;
        private LogEvent event;

        MessageEvent() {
        }

        public LogBuffer getBuffer() {
            return this.buffer;
        }

        public void setBuffer(LogBuffer buffer) {
            this.buffer = buffer;
        }

        public LogEvent getEvent() {
            return this.event;
        }

        public void setEvent(LogEvent event) {
            this.event = event;
        }

        public CanalEntry.Entry getEntry() {
            return this.entry;
        }

        public void setEntry(CanalEntry.Entry entry) {
            this.entry = entry;
        }

        public boolean isNeedDmlParse() {
            return this.needDmlParse;
        }

        public void setNeedDmlParse(boolean needDmlParse) {
            this.needDmlParse = needDmlParse;
        }

        public TableMeta getTable() {
            return this.table;
        }

        public void setTable(TableMeta table) {
            this.table = table;
        }
    }

    private class SinkStoreStage
    implements EventHandler<MessageEvent>,
    LifecycleAware {
        private SinkStoreStage() {
        }

        public void onEvent(MessageEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                if (event.getEntry() != null) {
                    MysqlMultiStageCoprocessor.this.transactionBuffer.add(event.getEntry());
                }
                LogEvent logEvent = event.getEvent();
                if (MysqlMultiStageCoprocessor.this.connection instanceof MysqlConnection && logEvent.getSemival() == 1) {
                    ((MysqlConnection)MysqlMultiStageCoprocessor.this.connection).sendSemiAck(logEvent.getHeader().getLogFileName(), logEvent.getHeader().getLogPos());
                }
                event.setBuffer(null);
                event.setEvent(null);
                event.setTable(null);
                event.setEntry(null);
                event.setNeedDmlParse(false);
            }
            catch (Throwable e) {
                MysqlMultiStageCoprocessor.this.exception = new CanalParseException(e);
                throw MysqlMultiStageCoprocessor.this.exception;
            }
        }

        public void onStart() {
        }

        public void onShutdown() {
        }
    }

    private class DmlParserStage
    implements WorkHandler<MessageEvent>,
    LifecycleAware {
        private DmlParserStage() {
        }

        public void onEvent(MessageEvent event) throws Exception {
            try {
                if (event.isNeedDmlParse()) {
                    int eventType = event.getEvent().getHeader().getType();
                    CanalEntry.Entry entry = null;
                    switch (eventType) {
                        case 29: {
                            entry = MysqlMultiStageCoprocessor.this.logEventConvert.parse(event.getEvent(), false);
                            break;
                        }
                        default: {
                            entry = MysqlMultiStageCoprocessor.this.logEventConvert.parseRowsEvent((RowsLogEvent)event.getEvent(), event.getTable());
                        }
                    }
                    event.setEntry(entry);
                }
            }
            catch (Throwable e) {
                MysqlMultiStageCoprocessor.this.exception = new CanalParseException(e);
                throw MysqlMultiStageCoprocessor.this.exception;
            }
        }

        public void onStart() {
        }

        public void onShutdown() {
        }
    }

    private class SimpleParserStage
    implements EventHandler<MessageEvent>,
    LifecycleAware {
        private LogDecoder decoder = new LogDecoder(0, 165);
        private LogContext context;

        public SimpleParserStage(LogContext context) {
            this.context = context;
            if (MysqlMultiStageCoprocessor.this.gtidSet != null) {
                context.setGtidSet(MysqlMultiStageCoprocessor.this.gtidSet);
            }
        }

        public void onEvent(MessageEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                LogEvent logEvent = event.getEvent();
                if (logEvent == null) {
                    LogBuffer buffer = event.getBuffer();
                    logEvent = this.decoder.decode(buffer, this.context);
                    event.setEvent(logEvent);
                }
                int eventType = logEvent.getHeader().getType();
                TableMeta tableMeta = null;
                boolean needDmlParse = false;
                switch (eventType) {
                    case 23: 
                    case 30: {
                        if (MysqlMultiStageCoprocessor.this.filterDmlInsert) break;
                        tableMeta = MysqlMultiStageCoprocessor.this.logEventConvert.parseRowsEventForTableMeta((RowsLogEvent)((WriteRowsLogEvent)logEvent));
                        needDmlParse = true;
                        break;
                    }
                    case 24: 
                    case 31: 
                    case 39: {
                        if (MysqlMultiStageCoprocessor.this.filterDmlUpdate) break;
                        tableMeta = MysqlMultiStageCoprocessor.this.logEventConvert.parseRowsEventForTableMeta((RowsLogEvent)((UpdateRowsLogEvent)logEvent));
                        needDmlParse = true;
                        break;
                    }
                    case 25: 
                    case 32: {
                        if (MysqlMultiStageCoprocessor.this.filterDmlDelete) break;
                        tableMeta = MysqlMultiStageCoprocessor.this.logEventConvert.parseRowsEventForTableMeta((RowsLogEvent)((DeleteRowsLogEvent)logEvent));
                        needDmlParse = true;
                        break;
                    }
                    case 29: {
                        needDmlParse = true;
                        break;
                    }
                    default: {
                        CanalEntry.Entry entry = MysqlMultiStageCoprocessor.this.logEventConvert.parse(event.getEvent(), false);
                        event.setEntry(entry);
                    }
                }
                event.setNeedDmlParse(needDmlParse);
                event.setTable(tableMeta);
            }
            catch (Throwable e) {
                MysqlMultiStageCoprocessor.this.exception = new CanalParseException(e);
                throw MysqlMultiStageCoprocessor.this.exception;
            }
        }

        public void onStart() {
        }

        public void onShutdown() {
        }
    }
}

