/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.rds;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    protected static final Logger logger = LoggerFactory.getLogger(HttpHelper.class);

    public static byte[] getBytes(String url, int timeout) throws Exception {
        long start = System.currentTimeMillis();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnPerRoute(50);
        builder.setMaxConnTotal(100);
        CloseableHttpClient httpclient = builder.build();
        URI uri = new URIBuilder(url).build();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        HttpGet httpGet = new HttpGet(uri);
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(config);
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet, (HttpContext)context);){
            int statusCode = response.getStatusLine().getStatusCode();
            long end = System.currentTimeMillis();
            long cost = end - start;
            if (logger.isWarnEnabled()) {
                logger.warn("post " + url + ", cost : " + cost);
            }
            if (statusCode == 200) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            String errorMsg = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new RuntimeException("requestGet remote error, url=" + uri.toString() + ", code=" + statusCode + ", error msg=" + errorMsg);
        }
        finally {
            httpGet.releaseConnection();
        }
    }

    public static String get(String url, int timeout) {
        if ((url = url.trim()).startsWith("https")) {
            return HttpHelper.getIgnoreCerf(url, null, null, timeout);
        }
        long start = System.currentTimeMillis();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnPerRoute(50);
        builder.setMaxConnTotal(100);
        CloseableHttpClient httpclient = builder.build();
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        try {
            URI uri = new URIBuilder(url).build();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpGet = new HttpGet(uri);
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(config);
            response = httpclient.execute((HttpUriRequest)httpGet, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            try {
                String errorMsg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new RuntimeException("requestGet remote error, url=" + uri.toString() + ", code=" + statusCode + ", error msg=" + errorMsg);
            }
            catch (Throwable t) {
                long end = System.currentTimeMillis();
                long cost = end - start;
                String curlRequest = HttpHelper.getCurlRequest(url, null, null, cost);
                throw new RuntimeException("requestGet remote error, request : " + curlRequest, t);
            }
        }
        finally {
            long end = System.currentTimeMillis();
            long cost = end - start;
            HttpHelper.printCurlRequest(url, null, null, cost);
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            httpGet.releaseConnection();
        }
    }

    private static String getIgnoreCerf(String url, CookieStore cookieStore, Map<String, String> params, int timeout) {
        long start = System.currentTimeMillis();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnPerRoute(50);
        builder.setMaxConnTotal(100);
        HttpGet httpGet = null;
        CloseableHttpResponse response = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509Certificates, s) -> true).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLContext(sslContext).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build())).build();
            URI uri = new URIBuilder(url).build();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpGet = new HttpGet(uri);
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(config);
            response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            try {
                String errorMsg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new RuntimeException("requestGet remote error, url=" + uri.toString() + ", code=" + statusCode + ", error msg=" + errorMsg);
            }
            catch (Throwable t) {
                long end = System.currentTimeMillis();
                long cost = end - start;
                String curlRequest = HttpHelper.getCurlRequest(url, cookieStore, params, cost);
                throw new RuntimeException("requestPost(Https) remote error, request : " + curlRequest, t);
            }
        }
        finally {
            long end = System.currentTimeMillis();
            long cost = end - start;
            HttpHelper.printCurlRequest(url, null, null, cost);
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    private static String postIgnoreCerf(String url, CookieStore cookieStore, Map<String, String> params, int timeout) {
        long start = System.currentTimeMillis();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnPerRoute(50);
        builder.setMaxConnTotal(100);
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509Certificates, s) -> true).build();
            CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLContext(sslContext).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build())).build();
            URI uri = new URIBuilder(url).build();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost = new HttpPost(uri);
            ArrayList parameters = Lists.newArrayList();
            for (String key : params.keySet()) {
                BasicNameValuePair nameValuePair = new BasicNameValuePair(key, params.get(key));
                parameters.add(nameValuePair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)parameters, Charset.forName("UTF-8")));
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(config);
            context.setCookieStore(cookieStore);
            response = httpClient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                long end = System.currentTimeMillis();
                long cost = end - start;
                HttpHelper.printCurlRequest(url, cookieStore, params, cost);
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            try {
                long end = System.currentTimeMillis();
                long cost = end - start;
                String curlRequest = HttpHelper.getCurlRequest(url, cookieStore, params, cost);
                throw new RuntimeException("requestPost(Https) remote error, request : " + curlRequest + ", statusCode=" + statusCode + "");
            }
            catch (Throwable t) {
                long end = System.currentTimeMillis();
                long cost = end - start;
                String curlRequest = HttpHelper.getCurlRequest(url, cookieStore, params, cost);
                throw new RuntimeException("requestPost(Https) remote error, request : " + curlRequest, t);
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
    }

    public static String post(String url, CookieStore cookieStore, Map<String, String> params, int timeout) {
        if ((url = url.trim()).startsWith("https")) {
            return HttpHelper.postIgnoreCerf(url, cookieStore, params, timeout);
        }
        long start = System.currentTimeMillis();
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnPerRoute(50);
        builder.setMaxConnTotal(100);
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpclient = builder.build();
            URI uri = new URIBuilder(url).build();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost = new HttpPost(uri);
            ArrayList parameters = Lists.newArrayList();
            for (String key : params.keySet()) {
                BasicNameValuePair nameValuePair = new BasicNameValuePair(key, params.get(key));
                parameters.add(nameValuePair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)parameters, Charset.forName("UTF-8")));
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(config);
            context.setCookieStore(cookieStore);
            response = httpclient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                long end = System.currentTimeMillis();
                long cost = end - start;
                HttpHelper.printCurlRequest(url, cookieStore, params, cost);
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            try {
                long end = System.currentTimeMillis();
                long cost = end - start;
                String curlRequest = HttpHelper.getCurlRequest(url, cookieStore, params, cost);
                throw new RuntimeException("requestPost remote error, request : " + curlRequest + ", statusCode=" + statusCode + ";" + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (Throwable t) {
                long end = System.currentTimeMillis();
                long cost = end - start;
                String curlRequest = HttpHelper.getCurlRequest(url, cookieStore, params, cost);
                throw new RuntimeException("requestPost remote error, request : " + curlRequest, t);
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
    }

    public static void printCurlRequest(String url, CookieStore cookieStore, Map<String, String> params, long cost) {
        logger.warn(HttpHelper.getCurlRequest(url, cookieStore, params, cost));
    }

    private static String getCurlRequest(String url, CookieStore cookieStore, Map<String, String> params, long cost) {
        if (params == null) {
            return "curl '" + url + "'\ncost : " + cost;
        }
        StringBuilder paramsStr = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            paramsStr.append(entry.getKey() + "=" + entry.getValue());
            if (!iterator.hasNext()) continue;
            paramsStr.append("&");
        }
        if (cookieStore == null) {
            return "curl '" + url + "' -d '" + paramsStr.toString() + "'\ncost : " + cost;
        }
        StringBuilder cookieStr = new StringBuilder();
        List cookies = cookieStore.getCookies();
        Iterator iteratorCookie = cookies.iterator();
        while (iteratorCookie.hasNext()) {
            Cookie cookie = (Cookie)iteratorCookie.next();
            cookieStr.append(cookie.getName() + "=" + cookie.getValue());
            if (!iteratorCookie.hasNext()) continue;
            cookieStr.append(";");
        }
        return "curl '" + url + "' -b '" + cookieStr + "' -d '" + paramsStr.toString() + "'\ncost : " + cost;
    }
}

