/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.rds;

import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.exception.CanalParseException;
import com.alibaba.otter.canal.parse.exception.PositionNotFoundException;
import com.alibaba.otter.canal.parse.exception.ServerIdNotMatchException;
import com.alibaba.otter.canal.parse.inbound.ErosaConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.LocalBinLogConnection;
import com.alibaba.otter.canal.parse.inbound.mysql.LocalBinlogEventParser;
import com.alibaba.otter.canal.parse.inbound.mysql.rds.BinlogDownloadQueue;
import com.alibaba.otter.canal.parse.inbound.mysql.rds.RdsBinlogOpenApi;
import com.alibaba.otter.canal.parse.inbound.mysql.rds.data.BinlogFile;
import com.alibaba.otter.canal.protocol.position.EntryPosition;
import com.alibaba.otter.canal.protocol.position.LogPosition;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.springframework.util.Assert;

public class RdsLocalBinlogEventParser
extends LocalBinlogEventParser
implements CanalEventParser,
LocalBinLogConnection.FileParserListener {
    private String url;
    private String accesskey;
    private String secretkey;
    private String instanceId;
    private Long startTime;
    private Long endTime;
    private BinlogDownloadQueue binlogDownloadQueue;
    private ParseFinishListener finishListener;
    private int batchFileSize;

    @Override
    public void start() throws CanalParseException {
        try {
            EntryPosition entryPosition;
            Assert.notNull((Object)this.accesskey);
            Assert.notNull((Object)this.secretkey);
            Assert.notNull((Object)this.instanceId);
            Assert.notNull((Object)this.url);
            Assert.notNull((Object)this.directory);
            if (this.endTime == null) {
                this.endTime = System.currentTimeMillis();
            }
            if ((entryPosition = this.findStartPosition(null)) == null) {
                throw new PositionNotFoundException("position not found!");
            }
            Long startTimeInMill = entryPosition.getTimestamp();
            if (startTimeInMill == null || startTimeInMill <= 0L) {
                throw new PositionNotFoundException("position timestamp is empty!");
            }
            this.startTime = startTimeInMill;
            List<BinlogFile> binlogFiles = RdsBinlogOpenApi.listBinlogFiles(this.url, this.accesskey, this.secretkey, this.instanceId, new Date(this.startTime), new Date(this.endTime));
            if (binlogFiles.isEmpty()) {
                throw new CanalParseException("start timestamp : " + startTimeInMill + " binlog files is empty");
            }
            this.binlogDownloadQueue = new BinlogDownloadQueue(binlogFiles, this.batchFileSize, this.directory);
            this.binlogDownloadQueue.silenceDownload();
            this.needWait = true;
            this.binlogDownloadQueue.tryOne();
        }
        catch (Throwable e) {
            this.logger.error("download binlog failed", e);
            throw new CanalParseException(e);
        }
        this.setParserExceptionHandler(this::handleMysqlParserException);
        super.start();
    }

    private void handleMysqlParserException(Throwable throwable) {
        if (throwable instanceof ServerIdNotMatchException) {
            this.logger.error("server id not match, try download another rds binlog!");
            this.binlogDownloadQueue.notifyNotMatch();
            try {
                this.binlogDownloadQueue.cleanDir();
                this.binlogDownloadQueue.tryOne();
                this.binlogDownloadQueue.prepare();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            try {
                this.binlogDownloadQueue.execute(() -> {
                    RdsLocalBinlogEventParser.super.stop();
                    RdsLocalBinlogEventParser.super.start();
                });
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected ErosaConnection buildErosaConnection() {
        ErosaConnection connection = super.buildErosaConnection();
        if (connection instanceof LocalBinLogConnection) {
            LocalBinLogConnection localBinLogConnection = (LocalBinLogConnection)connection;
            localBinLogConnection.setNeedWait(true);
            localBinLogConnection.setServerId(this.serverId);
            localBinLogConnection.setParserListener(this);
            localBinLogConnection.setRdsOssMode(true);
        }
        return connection;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        if (StringUtils.isNotEmpty((String)url)) {
            this.url = url;
        }
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setSecretkey(String secretkey) {
        this.secretkey = secretkey;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Override
    public void onFinish(String fileName) {
        try {
            this.binlogDownloadQueue.downOne();
            File needDeleteFile = new File(this.directory + File.separator + fileName);
            if (needDeleteFile.exists()) {
                needDeleteFile.delete();
            }
            LogPosition logPosition = this.logPositionManager.getLatestIndexBy(this.destination);
            Long timestamp = 0L;
            if (logPosition != null && logPosition.getPostion() != null) {
                timestamp = logPosition.getPostion().getTimestamp();
                EntryPosition position = logPosition.getPostion();
                LogPosition newLogPosition = new LogPosition();
                String journalName = position.getJournalName();
                int sepIdx = journalName.indexOf(".");
                String fileIndex = journalName.substring(sepIdx + 1);
                int index = NumberUtils.toInt((String)fileIndex) + 1;
                String newJournalName = journalName.substring(0, sepIdx) + "." + StringUtils.leftPad((String)String.valueOf(index), (int)fileIndex.length(), (String)"0");
                newLogPosition.setPostion(new EntryPosition(newJournalName, Long.valueOf(4L), position.getTimestamp(), position.getServerId()));
                newLogPosition.setIdentity(logPosition.getIdentity());
                this.logPositionManager.persistLogPosition(this.destination, newLogPosition);
            }
            if (this.binlogDownloadQueue.isLastFile(fileName)) {
                this.logger.warn("last file : " + fileName + " , timestamp : " + timestamp + " , all file parse complete, switch to mysql parser!");
                this.finishListener.onFinish();
                return;
            }
            this.logger.warn("parse local binlog file : " + fileName + " , timestamp : " + timestamp + " , try the next binlog !");
            this.binlogDownloadQueue.prepare();
        }
        catch (Exception e) {
            this.logger.error("prepare download binlog file failed!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        this.binlogDownloadQueue.release();
        super.stop();
    }

    public void setFinishListener(ParseFinishListener finishListener) {
        this.finishListener = finishListener;
    }

    public void setBatchFileSize(int batchFileSize) {
        this.batchFileSize = batchFileSize;
    }

    public static interface ParseFinishListener {
        public void onFinish();
    }
}

