/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.rabbitmq.consumer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.otter.canal.common.utils.PropertiesUtils;
import com.alibaba.otter.canal.connector.core.consumer.CommonMessage;
import com.alibaba.otter.canal.connector.core.spi.CanalMsgConsumer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.CanalMessageSerializerUtil;
import com.alibaba.otter.canal.connector.core.util.MessageUtil;
import com.alibaba.otter.canal.connector.rabbitmq.consumer.ConsumerBatchMessage;
import com.alibaba.otter.canal.connector.rabbitmq.producer.AliyunCredentialsProvider;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(value="rabbitmq")
public class CanalRabbitMQConsumer
implements CanalMsgConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CanalRabbitMQConsumer.class);
    private String nameServer;
    private String vhost;
    private String queueName;
    private String accessKey;
    private String secretKey;
    private Long resourceOwnerId;
    private String username;
    private String password;
    private boolean flatMessage;
    private Connection connect;
    private Channel channel;
    private long batchProcessTimeout = 60000L;
    private BlockingQueue<ConsumerBatchMessage<CommonMessage>> messageBlockingQueue;
    private volatile ConsumerBatchMessage<CommonMessage> lastGetBatchMessage = null;

    public void init(Properties properties, String topic, String groupId) {
        this.nameServer = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.host");
        this.vhost = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.virtual.host");
        this.queueName = topic;
        this.accessKey = PropertiesUtils.getProperty((Properties)properties, (String)"canal.aliyun.accessKey");
        this.secretKey = PropertiesUtils.getProperty((Properties)properties, (String)"canal.aliyun.secretKey");
        this.username = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.username");
        this.password = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.password");
        Long resourceOwnerIdPro = (Long)properties.get("rabbitmq.rabbitmq.resource.ownerId");
        if (resourceOwnerIdPro != null) {
            this.resourceOwnerId = resourceOwnerIdPro;
        }
        this.flatMessage = (Boolean)properties.get("canal.mq.flatMessage");
        this.messageBlockingQueue = new LinkedBlockingQueue<ConsumerBatchMessage<CommonMessage>>(1024);
    }

    public void connect() {
        ConnectionFactory factory = new ConnectionFactory();
        if (this.accessKey.length() > 0 && this.secretKey.length() > 0) {
            factory.setCredentialsProvider(new AliyunCredentialsProvider(this.accessKey, this.secretKey, this.resourceOwnerId));
        } else {
            factory.setUsername(this.username);
            factory.setPassword(this.password);
        }
        if (this.nameServer != null && this.nameServer.contains(":")) {
            String[] serverHostAndPort = this.nameServer.split(":");
            factory.setHost(serverHostAndPort[0]);
            factory.setPort(Integer.parseInt(serverHostAndPort[1]));
        } else {
            factory.setHost(this.nameServer);
        }
        factory.setAutomaticRecoveryEnabled(true);
        factory.setNetworkRecoveryInterval(5000);
        factory.setVirtualHost(this.vhost);
        try {
            this.connect = factory.newConnection();
            this.channel = this.connect.createChannel();
        }
        catch (IOException | TimeoutException e) {
            throw new CanalClientException("Start RabbitMQ producer error", (Throwable)e);
        }
        if (this.connect == null) {
            this.connect();
        }
        DefaultConsumer consumer = new DefaultConsumer(this.channel){

            @Override
            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                if (body != null) {
                    CanalRabbitMQConsumer.this.channel.basicAck(envelope.getDeliveryTag(), CanalRabbitMQConsumer.this.process(body));
                }
            }
        };
        try {
            this.channel.basicConsume(this.queueName, false, consumer);
        }
        catch (IOException e) {
            throw new CanalClientException("error", (Throwable)e);
        }
    }

    private boolean process(byte[] messageData) {
        boolean isCompleted;
        if (logger.isDebugEnabled()) {
            logger.debug("Get Message: {}", (Object)new String(messageData));
        }
        ArrayList<CommonMessage> messageList = new ArrayList<CommonMessage>();
        if (!this.flatMessage) {
            Message message = CanalMessageSerializerUtil.deserializer((byte[])messageData);
            messageList.addAll(MessageUtil.convert((Message)message));
        } else {
            CommonMessage commonMessage = (CommonMessage)JSON.parseObject((byte[])messageData, CommonMessage.class);
            messageList.add(commonMessage);
        }
        ConsumerBatchMessage batchMessage = new ConsumerBatchMessage(messageList);
        try {
            this.messageBlockingQueue.put(batchMessage);
        }
        catch (InterruptedException e) {
            logger.error("Put message to queue error", e);
            throw new RuntimeException(e);
        }
        try {
            isCompleted = batchMessage.waitFinish(this.batchProcessTimeout);
        }
        catch (InterruptedException e) {
            logger.error("Interrupted when waiting messages to be finished.", e);
            throw new RuntimeException(e);
        }
        boolean isSuccess = batchMessage.isSuccess();
        return isCompleted && isSuccess;
    }

    public List<CommonMessage> getMessage(Long timeout, TimeUnit unit) {
        try {
            if (this.lastGetBatchMessage != null) {
                throw new CanalClientException("mq get/ack not support concurrent & async ack");
            }
            ConsumerBatchMessage<CommonMessage> batchMessage = this.messageBlockingQueue.poll(timeout, unit);
            if (batchMessage != null) {
                this.lastGetBatchMessage = batchMessage;
                return batchMessage.getData();
            }
        }
        catch (InterruptedException ex) {
            logger.warn("Get message timeout", ex);
            throw new CanalClientException("Failed to fetch the data after: " + timeout);
        }
        return null;
    }

    public void rollback() {
        try {
            if (this.lastGetBatchMessage != null) {
                this.lastGetBatchMessage.fail();
            }
        }
        finally {
            this.lastGetBatchMessage = null;
        }
    }

    public void ack() {
        try {
            if (this.lastGetBatchMessage != null) {
                this.lastGetBatchMessage.ack();
            }
        }
        catch (Throwable e) {
            if (this.lastGetBatchMessage != null) {
                this.lastGetBatchMessage.fail();
            }
        }
        finally {
            this.lastGetBatchMessage = null;
        }
    }

    public void disconnect() {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException | TimeoutException e) {
                throw new CanalClientException("stop channel error", (Throwable)e);
            }
        }
        if (this.connect != null) {
            try {
                this.connect.close();
            }
            catch (IOException e) {
                throw new CanalClientException("stop connect error", (Throwable)e);
            }
        }
    }
}

