/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.connector.rabbitmq.producer;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.otter.canal.common.CanalException;
import com.alibaba.otter.canal.common.utils.ExecutorTemplate;
import com.alibaba.otter.canal.common.utils.PropertiesUtils;
import com.alibaba.otter.canal.connector.core.producer.AbstractMQProducer;
import com.alibaba.otter.canal.connector.core.producer.MQDestination;
import com.alibaba.otter.canal.connector.core.producer.MQMessageUtils;
import com.alibaba.otter.canal.connector.core.spi.CanalMQProducer;
import com.alibaba.otter.canal.connector.core.spi.SPI;
import com.alibaba.otter.canal.connector.core.util.Callback;
import com.alibaba.otter.canal.connector.core.util.CanalMessageSerializerUtil;
import com.alibaba.otter.canal.connector.rabbitmq.config.RabbitMQProducerConfig;
import com.alibaba.otter.canal.connector.rabbitmq.producer.AliyunCredentialsProvider;
import com.alibaba.otter.canal.protocol.FlatMessage;
import com.alibaba.otter.canal.protocol.Message;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SPI(value="rabbitmq")
public class CanalRabbitMQProducer
extends AbstractMQProducer
implements CanalMQProducer {
    private static final Logger logger = LoggerFactory.getLogger(CanalRabbitMQProducer.class);
    private Connection connect;
    private Channel channel;

    public void init(Properties properties) {
        RabbitMQProducerConfig rabbitMQProperties = new RabbitMQProducerConfig();
        this.mqProperties = rabbitMQProperties;
        super.init(properties);
        this.loadRabbitMQProperties(properties);
        ConnectionFactory factory = new ConnectionFactory();
        String servers = rabbitMQProperties.getHost();
        if (servers.contains(":")) {
            String[] serverHostAndPort = servers.split(":");
            factory.setHost(serverHostAndPort[0]);
            factory.setPort(Integer.parseInt(serverHostAndPort[1]));
        } else {
            factory.setHost(servers);
        }
        if (this.mqProperties.getAliyunAccessKey().length() > 0 && this.mqProperties.getAliyunSecretKey().length() > 0 && this.mqProperties.getAliyunUid() > 0) {
            factory.setCredentialsProvider(new AliyunCredentialsProvider(this.mqProperties.getAliyunAccessKey(), this.mqProperties.getAliyunSecretKey(), this.mqProperties.getAliyunUid()));
        } else {
            factory.setUsername(rabbitMQProperties.getUsername());
            factory.setPassword(rabbitMQProperties.getPassword());
        }
        factory.setVirtualHost(rabbitMQProperties.getVirtualHost());
        try {
            this.connect = factory.newConnection();
            this.channel = this.connect.createChannel();
        }
        catch (IOException | TimeoutException ex) {
            throw new CanalException("Start RabbitMQ producer error", (Throwable)ex);
        }
    }

    private void loadRabbitMQProperties(Properties properties) {
        String password;
        String username;
        String exchange;
        String vhost;
        RabbitMQProducerConfig rabbitMQProperties = (RabbitMQProducerConfig)this.mqProperties;
        this.doMoreCompatibleConvert("canal.mq.servers", "rabbitmq.host", properties);
        String host = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.host");
        if (!StringUtils.isEmpty((String)host)) {
            rabbitMQProperties.setHost(host);
        }
        if (!StringUtils.isEmpty((String)(vhost = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.virtual.host")))) {
            rabbitMQProperties.setVirtualHost(vhost);
        }
        if (!StringUtils.isEmpty((String)(exchange = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.exchange")))) {
            rabbitMQProperties.setExchange(exchange);
        }
        if (!StringUtils.isEmpty((String)(username = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.username")))) {
            rabbitMQProperties.setUsername(username);
        }
        if (!StringUtils.isEmpty((String)(password = PropertiesUtils.getProperty((Properties)properties, (String)"rabbitmq.password")))) {
            rabbitMQProperties.setPassword(password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MQDestination destination, Message message, Callback callback) {
        ExecutorTemplate template = new ExecutorTemplate(this.sendExecutor);
        try {
            if (!StringUtils.isEmpty((String)destination.getDynamicTopic())) {
                Map messageMap = MQMessageUtils.messageTopics((Message)message, (String)destination.getTopic(), (String)destination.getDynamicTopic());
                for (Map.Entry entry : messageMap.entrySet()) {
                    String topicName = ((String)entry.getKey()).replace('.', '_');
                    Message messageSub = (Message)entry.getValue();
                    template.submit(() -> this.send(destination, topicName, messageSub));
                }
                template.waitForResult();
            } else {
                this.send(destination, destination.getTopic(), message);
            }
            callback.commit();
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            callback.rollback();
        }
        finally {
            template.clear();
        }
    }

    private void send(MQDestination canalDestination, String topicName, Message messageSub) {
        if (!this.mqProperties.isFlatMessage()) {
            byte[] message = CanalMessageSerializerUtil.serializer((Message)messageSub, (boolean)this.mqProperties.isFilterTransactionEntry());
            if (logger.isDebugEnabled()) {
                logger.debug("send message:{} to destination:{}", (Object)message, (Object)canalDestination.getCanalDestination());
            }
            this.sendMessage(topicName, message);
        } else {
            MQMessageUtils.EntryRowData[] datas = MQMessageUtils.buildMessageData((Message)messageSub, (ThreadPoolExecutor)this.buildExecutor);
            List flatMessages = MQMessageUtils.messageConverter((MQMessageUtils.EntryRowData[])datas, (long)messageSub.getId());
            for (FlatMessage flatMessage : flatMessages) {
                byte[] message = JSON.toJSONBytes((Object)flatMessage, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteNulls});
                if (logger.isDebugEnabled()) {
                    logger.debug("send message:{} to destination:{}", (Object)message, (Object)canalDestination.getCanalDestination());
                }
                this.sendMessage(topicName, message);
            }
        }
    }

    private void sendMessage(String queueName, byte[] message) {
        try {
            RabbitMQProducerConfig rabbitMQProperties = (RabbitMQProducerConfig)this.mqProperties;
            this.channel.basicPublish(rabbitMQProperties.getExchange(), queueName, null, message);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        logger.info("## Stop RabbitMQ producer##");
        try {
            this.channel.close();
            this.connect.close();
            super.stop();
        }
        catch (AlreadyClosedException ex) {
            logger.error("Connection is already closed", ex);
        }
        catch (IOException | TimeoutException ex) {
            throw new CanalException("Stop RabbitMQ producer error", (Throwable)ex);
        }
        super.stop();
    }
}

