/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;
import com.taobao.tddl.dbsync.binlog.event.StartLogEventV3;
import java.io.IOException;

public final class FormatDescriptionLogEvent
extends StartLogEventV3 {
    public static final int LOG_EVENT_TYPES = 164;
    public static final int ST_COMMON_HEADER_LEN_OFFSET = 56;
    public static final int OLD_HEADER_LEN = 13;
    public static final int LOG_EVENT_HEADER_LEN = 19;
    public static final int LOG_EVENT_MINIMAL_HEADER_LEN = 19;
    public static final int STOP_HEADER_LEN = 0;
    public static final int LOAD_HEADER_LEN = 18;
    public static final int SLAVE_HEADER_LEN = 0;
    public static final int START_V3_HEADER_LEN = 56;
    public static final int ROTATE_HEADER_LEN = 8;
    public static final int INTVAR_HEADER_LEN = 0;
    public static final int CREATE_FILE_HEADER_LEN = 4;
    public static final int APPEND_BLOCK_HEADER_LEN = 4;
    public static final int EXEC_LOAD_HEADER_LEN = 4;
    public static final int DELETE_FILE_HEADER_LEN = 4;
    public static final int NEW_LOAD_HEADER_LEN = 18;
    public static final int RAND_HEADER_LEN = 0;
    public static final int USER_VAR_HEADER_LEN = 0;
    public static final int FORMAT_DESCRIPTION_HEADER_LEN = 221;
    public static final int XID_HEADER_LEN = 0;
    public static final int BEGIN_LOAD_QUERY_HEADER_LEN = 4;
    public static final int ROWS_HEADER_LEN_V1 = 8;
    public static final int TABLE_MAP_HEADER_LEN = 8;
    public static final int EXECUTE_LOAD_QUERY_EXTRA_HEADER_LEN = 13;
    public static final int EXECUTE_LOAD_QUERY_HEADER_LEN = 26;
    public static final int INCIDENT_HEADER_LEN = 2;
    public static final int HEARTBEAT_HEADER_LEN = 0;
    public static final int IGNORABLE_HEADER_LEN = 0;
    public static final int ROWS_HEADER_LEN_V2 = 10;
    public static final int TRANSACTION_CONTEXT_HEADER_LEN = 18;
    public static final int VIEW_CHANGE_HEADER_LEN = 52;
    public static final int XA_PREPARE_HEADER_LEN = 0;
    public static final int ANNOTATE_ROWS_HEADER_LEN = 0;
    public static final int BINLOG_CHECKPOINT_HEADER_LEN = 4;
    public static final int GTID_HEADER_LEN = 19;
    public static final int GTID_LIST_HEADER_LEN = 4;
    public static final int START_ENCRYPTION_HEADER_LEN = 0;
    public static final int POST_HEADER_LENGTH = 11;
    public static final int BINLOG_CHECKSUM_ALG_DESC_LEN = 1;
    public static final int[] checksumVersionSplit = new int[]{5, 6, 1};
    public static final long checksumVersionProduct = (checksumVersionSplit[0] * 256 + checksumVersionSplit[1]) * 256 + checksumVersionSplit[2];
    protected final int commonHeaderLen;
    protected int numberOfEventTypes;
    protected final short[] postHeaderLen;
    protected int[] serverVersionSplit = new int[3];
    public static final FormatDescriptionLogEvent FORMAT_DESCRIPTION_EVENT_5_x = new FormatDescriptionLogEvent(4);
    public static final FormatDescriptionLogEvent FORMAT_DESCRIPTION_EVENT_4_0_x = new FormatDescriptionLogEvent(3);
    public static final FormatDescriptionLogEvent FORMAT_DESCRIPTION_EVENT_3_23 = new FormatDescriptionLogEvent(1);

    public FormatDescriptionLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) throws IOException {
        super(header, buffer, descriptionEvent);
        buffer.position(75);
        this.commonHeaderLen = buffer.getUint8();
        if (this.commonHeaderLen < 13) {
            throw new IOException("Format Description event header length is too short");
        }
        this.numberOfEventTypes = buffer.limit() - 76;
        this.postHeaderLen = new short[this.numberOfEventTypes];
        for (int i = 0; i < this.numberOfEventTypes; ++i) {
            this.postHeaderLen[i] = (short)buffer.getUint8();
        }
        this.calcServerVersionSplit();
        long calc = this.getVersionProduct();
        if (calc >= checksumVersionProduct) {
            --this.numberOfEventTypes;
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("common_header_len= " + this.commonHeaderLen + ", number_of_event_types= " + this.numberOfEventTypes));
        }
    }

    public static FormatDescriptionLogEvent getFormatDescription(int binlogVersion) throws IOException {
        switch (binlogVersion) {
            case 4: {
                return FORMAT_DESCRIPTION_EVENT_5_x;
            }
            case 3: {
                return FORMAT_DESCRIPTION_EVENT_4_0_x;
            }
            case 1: {
                return FORMAT_DESCRIPTION_EVENT_3_23;
            }
        }
        throw new IOException("Unknown binlog version: " + binlogVersion);
    }

    public FormatDescriptionLogEvent(int binlogVersion, int binlogChecksum) {
        this(binlogVersion);
        this.header.checksumAlg = binlogChecksum;
    }

    public FormatDescriptionLogEvent(int binlogVersion) {
        this.binlogVersion = binlogVersion;
        this.postHeaderLen = new short[165];
        switch (binlogVersion) {
            case 4: {
                this.serverVersion = "5.0";
                this.commonHeaderLen = 19;
                this.numberOfEventTypes = 164;
                this.postHeaderLen[0] = 56;
                this.postHeaderLen[1] = 13;
                this.postHeaderLen[2] = 0;
                this.postHeaderLen[3] = 8;
                this.postHeaderLen[4] = 0;
                this.postHeaderLen[5] = 18;
                this.postHeaderLen[6] = 0;
                this.postHeaderLen[7] = 4;
                this.postHeaderLen[8] = 4;
                this.postHeaderLen[9] = 4;
                this.postHeaderLen[10] = 4;
                this.postHeaderLen[11] = 18;
                this.postHeaderLen[12] = 0;
                this.postHeaderLen[13] = 0;
                this.postHeaderLen[14] = 221;
                this.postHeaderLen[15] = 0;
                this.postHeaderLen[16] = 4;
                this.postHeaderLen[17] = 26;
                this.postHeaderLen[18] = 8;
                this.postHeaderLen[22] = 8;
                this.postHeaderLen[23] = 8;
                this.postHeaderLen[24] = 8;
                this.postHeaderLen[26] = 0;
                this.postHeaderLen[27] = 0;
                this.postHeaderLen[28] = 0;
                this.postHeaderLen[29] = 10;
                this.postHeaderLen[30] = 10;
                this.postHeaderLen[31] = 10;
                this.postHeaderLen[32] = 11;
                this.postHeaderLen[33] = 11;
                this.postHeaderLen[34] = 0;
                this.postHeaderLen[35] = 18;
                this.postHeaderLen[36] = 52;
                this.postHeaderLen[37] = 0;
                this.postHeaderLen[38] = 10;
                this.postHeaderLen[159] = 0;
                this.postHeaderLen[160] = 4;
                this.postHeaderLen[161] = 19;
                this.postHeaderLen[162] = 4;
                this.postHeaderLen[163] = 0;
                break;
            }
            case 3: {
                this.serverVersion = "4.0";
                this.commonHeaderLen = 19;
                this.numberOfEventTypes = 14;
                this.postHeaderLen[0] = 56;
                this.postHeaderLen[1] = 11;
                this.postHeaderLen[3] = 8;
                this.postHeaderLen[5] = 18;
                this.postHeaderLen[7] = 4;
                this.postHeaderLen[8] = 4;
                this.postHeaderLen[9] = 4;
                this.postHeaderLen[10] = 4;
                this.postHeaderLen[11] = this.postHeaderLen[5];
                break;
            }
            case 1: {
                this.serverVersion = "3.23";
                this.commonHeaderLen = 13;
                this.numberOfEventTypes = 14;
                this.postHeaderLen[0] = 56;
                this.postHeaderLen[1] = 11;
                this.postHeaderLen[5] = 18;
                this.postHeaderLen[7] = 4;
                this.postHeaderLen[8] = 4;
                this.postHeaderLen[9] = 4;
                this.postHeaderLen[10] = 4;
                this.postHeaderLen[11] = this.postHeaderLen[5];
                break;
            }
            default: {
                this.numberOfEventTypes = 0;
                this.commonHeaderLen = 0;
            }
        }
    }

    public void calcServerVersionSplit() {
        FormatDescriptionLogEvent.doServerVersionSplit(this.serverVersion, this.serverVersionSplit);
    }

    public long getVersionProduct() {
        return FormatDescriptionLogEvent.versionProduct(this.serverVersionSplit);
    }

    public boolean isVersionBeforeChecksum() {
        return this.getVersionProduct() < checksumVersionProduct;
    }

    public static void doServerVersionSplit(String serverVersion, int[] versionSplit) {
        String[] split = serverVersion.split("\\.");
        if (split.length < 3) {
            versionSplit[0] = 0;
            versionSplit[1] = 0;
            versionSplit[2] = 0;
        } else {
            int j = 0;
            for (int i = 0; i <= 2; ++i) {
                String str = split[i];
                for (j = 0; j < str.length() && Character.isDigit(str.charAt(j)); ++j) {
                }
                if (j > 0) {
                    versionSplit[i] = Integer.valueOf(str.substring(0, j), 10);
                    continue;
                }
                versionSplit[0] = 0;
                versionSplit[1] = 0;
                versionSplit[2] = 0;
            }
        }
    }

    public static long versionProduct(int[] versionSplit) {
        return (versionSplit[0] * 256 + versionSplit[1]) * 256 + versionSplit[2];
    }

    public final int getCommonHeaderLen() {
        return this.commonHeaderLen;
    }

    public final short[] getPostHeaderLen() {
        return this.postHeaderLen;
    }
}

