/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"MessagePack::ExtensionValue"})
public class ExtensionValue
extends RubyObject {
    private static final long serialVersionUID = 8451274621449322492L;
    private final Encoding binaryEncoding;
    private RubyFixnum type;
    private RubyString payload;

    public ExtensionValue(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
        this.binaryEncoding = ruby.getEncodingService().getAscii8bitEncoding();
    }

    public static ExtensionValue newExtensionValue(Ruby ruby, int n, byte[] byArray) {
        ExtensionValue extensionValue = new ExtensionValue(ruby, ruby.getModule("MessagePack").getClass("ExtensionValue"));
        ByteList byteList = new ByteList(byArray, ruby.getEncodingService().getAscii8bitEncoding());
        extensionValue.initialize(ruby.getCurrentContext(), (IRubyObject)ruby.newFixnum(n), (IRubyObject)ruby.newString(byteList));
        return extensionValue;
    }

    @JRubyMethod(name={"initialize"}, required=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        this.type = (RubyFixnum)iRubyObject;
        this.payload = (RubyString)iRubyObject2;
        return this;
    }

    @JRubyMethod(name={"to_s", "inspect"})
    public IRubyObject to_s() {
        IRubyObject iRubyObject = this.payload.callMethod(this.getRuntime().getCurrentContext(), "inspect");
        return this.getRuntime().newString(String.format("#<MessagePack::ExtensionValue @type=%d, @payload=%s>", this.type.getLongValue(), iRubyObject));
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        long l = (long)this.payload.hashCode() ^ this.type.getLongValue() << 56;
        return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (long)l);
    }

    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        if (this == iRubyObject) {
            return ruby.getTrue();
        }
        if (iRubyObject instanceof ExtensionValue) {
            ExtensionValue extensionValue = (ExtensionValue)iRubyObject;
            if (!this.type.eql_p((IRubyObject)extensionValue.type).isTrue()) {
                return ruby.getFalse();
            }
            return this.payload.str_eql_p(threadContext, (IRubyObject)extensionValue.payload);
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        if (this == iRubyObject) {
            return ruby.getTrue();
        }
        if (iRubyObject instanceof ExtensionValue) {
            ExtensionValue extensionValue = (ExtensionValue)iRubyObject;
            if (!this.type.op_equal(threadContext, (IRubyObject)extensionValue.type).isTrue()) {
                return ruby.getFalse();
            }
            return this.payload.op_equal(threadContext, (IRubyObject)extensionValue.payload);
        }
        return ruby.getFalse();
    }

    @JRubyMethod(name={"type"})
    public IRubyObject get_type() {
        return this.type;
    }

    @JRubyMethod
    public IRubyObject payload() {
        return this.payload;
    }

    @JRubyMethod(name={"type="}, required=1)
    public IRubyObject set_type(IRubyObject iRubyObject) {
        this.type = (RubyFixnum)iRubyObject;
        return iRubyObject;
    }

    @JRubyMethod(name={"payload="}, required=1)
    public IRubyObject set_payload(IRubyObject iRubyObject) {
        this.payload = (RubyString)iRubyObject;
        return iRubyObject;
    }

    public static class ExtensionValueAllocator
    implements ObjectAllocator {
        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new ExtensionValue(ruby, rubyClass);
        }
    }
}

